

#ifndef zz_pXFactoring__H
#define zz_pXFactoring__H

#include "zz_p.h"
#include "zz_pX.h"
#include "pair_zz_pX_long.h"
#include "ZZ.h"




/************************************************************

                      factorization routines 

************************************************************/





void SquareFreeDecomp(vector(pair(zz_pX,long))& u, const zz_pX& f);

// Performs square-free decomposition.
// f must be monic.
// If f = prod_i g_i^i, then u is set to a lest of pairs (g_i, i).
// The list is is increasing order of i, with trivial terms
// (i.e., g_i = 1) deleted.



void FindRoots(vector(zz_p)& x, const zz_pX& f);

// f is monic, and has deg(f) distinct roots.
// returns the list of roots

void FindRoot(zz_p& root, const zz_pX& f);

// finds a single root of ff.
// assumes that f is monic and splits into distinct linear factors


void SFBerlekamp(vector(zz_pX)& factors, const zz_pX& f, long verbose=0);

// Assumes f is square-free and monic.
// returns list of factors of f.
// Uses "Berlekamp" appraoch.


void berlekamp(vector(pair(zz_pX,long))& factors, const zz_pX& f, long verbose=0);

// returns a list of factors, with multiplicities.
// f must be monic.
// Uses "Berlekamp" appraoch.





extern long zz_pX_BlockingFactor;
// Controls GCD blocking for DDF.


void DDF(vector(pair(zz_pX,long))& factors, const zz_pX& f, const zz_pX& h,
         long verbose=0);

// Performs distinct-degree factorization.
// Assumes f is monic and square-free,  and h  = X^p mod f
// Obsolete: see NewDDF, below.


extern long zz_pX_GCDTableSize; /* = 4 */
// Controls GCD blocking for NewDDF


void NewDDF(vector(pair(zz_pX,long))& factors, const zz_pX& f, const zz_pX& h,
         long verbose=0);

// same as above, but uses baby-step/giant-step method


void EDF(vector(zz_pX)& factors, const zz_pX& f, const zz_pX& b,
         long d, long verbose=0);

// Performs equal-degree factorization.
// f is monic, square-free, and all irreducible factors have same degree.
// b = X^p mod f.
// d = degree of irreducible factors of f
// Space for the trace-map computation can be controlled via ComposeBound.



void RootEDF(vector(zz_pX)& factors, const zz_pX& f, long verbose=0);

// EDF for d==1

void SFCanZass(vector(zz_pX)& factors, const zz_pX& f, long verbose=0);

// Assumes f is square-free.
// returns list of factors of f.
// Uses "Cantor/Zassenhaus" approach.



void SFCanZass1(vector(pair(zz_pX,long))& u, zz_pX& h, const zz_pX& f, 
                long verbose=0);

// Not intended for general use.

void SFCanZass2(vector(zz_pX)& factors, const vector(pair(zz_pX,long))& u,
                const zz_pX& h, long verbose=0);

// Not intended for general use.


void CanZass(vector(pair(zz_pX,long))& factors, const zz_pX& f, long verbose=0);

// returns a list of factors, with multiplicities.
// f must be monic.
// Uses "Cantor/Zassenhaus" approach.




void mul(zz_pX& f, const vector(pair(zz_pX,long))& v);

// multiplies polynomials, with multiplicities


/*************************************************************

            irreducible poly's:  tests and constructions

**************************************************************/

long ProbIrredTest(const zz_pX& f, long iter=1);

// performs a fast, probabilistic irreduciblity test
// the test can err only if f is reducible, and the
// error probability is bounded by p^{-iter}.

long DetIrredTest(const zz_pX& f);

// performs a recursive deterministic irreducibility test
// fast in the worst-case (when input is irreducible).

long IterIrredTest(const zz_pX& f);

// performs an iterative deterministic irreducibility test,
// based on DDF.  Fast on average (when f has a small factor).

void BuildIrred(zz_pX& f, long n);

// Build a monic irreducible poly of degree n.

void BuildRandomIrred(zz_pX& f, const zz_pX& g);

// g is a monic irreducible polynomial.
// constructs a random monic irreducible polynomial f of the same degree.


long ComputeDegree(const zz_pX& h, const zz_pXModulus& F);

// f = F.f is assumed to be an "equal degree" polynomial
// h = X^p mod f
// the common degree of the irreducible factors of f is computed
// This routine is useful in counting points on elliptic curves

long ProbComputeDegree(const zz_pX& h, const zz_pXModulus& F);

// same as above, but uses a slightly faster probabilistic algorithm
// the return value may be 0 or may be too big, but for large p
// (relative to n), this happens with very low probability.



void TraceMap(zz_pX& w, const zz_pX& a, long d, const zz_pXModulus& F,
              const zz_pX& b);

// w = a+a^q+...+^{q^{d-1}} mod f;
// it is assumed that d >= 0, and b = X^q mod f, q a power of p
// Space allocation can be controlled via ComposeBound (see "zz_pX.h")



void PowerCompose(zz_pX& w, const zz_pX& a, long d, const zz_pXModulus& F);

// w = X^{q^d} mod f;
// it is assumed that d >= 0, and b = X^q mod f, q a power of p
// Space allocation can be controlled via ComposeBound (see "zz_pX.h")


#endif
