;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  The main edit loop
;;;
(declare
   (lambda editor)
   (localf insert_character delete_character erase_character
	   delete_character yank_from_buffer  cuu cud irm
	   dch  next_command last_command  replace_inchar_prompt )
   (special    right left dot hist_list hist_dot greek poport ptport
                piport ptport replace_mode kill **current-window** **screen
		m_left m_middle m_right greek_list wfile **dump_number**))

(cfasl '//user//vaxima//young//devdep//dump.r '_dump 'sdump "c-function")
(eval-when (load) (setq **dump_number** 0))
(defun next-file-name ()
   (setq **dump_number** (1+ **dump_number**))
   (strcat(concat "//user//vaxima//young//sdump//dumpfile" **dump_number**)))
(defun editor (display_flag)
   (prog (inlines oldright oldleft olddot  l-par r-par l-brac r-brac
		  odot colm  event inchar caps  resp st )
      (drain piport)
      (cond ((boundp ptport) (setq wfile ptport ptport nil)))
      (setq  inlines nil oldright nil
	     oldleft nil olddot nil
	     l-par 0 r-par 0 l-brac 0 r-brac 0 kill nil )
      (setq  caps nil hist_dot -1 greek nil)
      (defvar replace_mode nil)
      (irm t)
      redo	  (setq dot 0 odot 0 colm 0
			right nil left nil)
      (event_enable)
      (terminal_enable nil)
      (if display_flag then (yank_from_buffer st)(drain poport))
      (tyo 7)
      cmdloop
      (setq event (eget_next))
      (cond((equal 3 (eget_type event))
	    (setq inchar (eget_param event))
	    (go editmode))
		   ((and(equal 4 (eget_type event))
			       (equal 136. (eget_param event)))
		    (setq caps nil)(go cmdloop))
		   ((and(equal 4 (eget_type event))
			       (equal 137. (eget_param event)))
		    (setq greek nil)(go cmdloop))
		   (t(go cmdloop)))
      editmode
      (caseq inchar
	 (13.  (terminal_enable t)
	       (go final))
	 (138. (go ctrlcode))
	 (27. (go escapes))
	 (136. (setq caps t))
	 (137. (setq greek t))
	 (130. (event_disable ) (IRM nil)(terminal_enable t)
	       (setq resp (process_mouse m_left))
	       (event_enable )
	       (cond((equal resp 'refresh)(go exit))
			    (t(IRM t)(terminal_enable nil)
				   (yank_from_buffer resp))))
	 (129. (event_disable )(IRM nil)
	       (terminal_enable t)
	       (process_mouse m_middle)
	       (terminal_enable nil)
	       (IRM t)(event_enable))
	 (128. (event_disable )(IRM nil)
	       (terminal_enable t)
	       (process_mouse m_right)
	       (terminal_enable nil)
	       (IRM t)(event_enable ))
	 (201. (last_command))
	 (202. (next_command))
	 (203.  (event_disable ) (IRM nil)(terminal_enable t)
	        (sdump (form->addr **screen)(next-file-name))
	       (terminal_enable nil)
	       (IRM t)(event_enable))		
	 (61.  (cond(caps
		       (insert_character 43.))
		       (t(insert_character 61.))))
	 (91.  (cond(caps
		       (insert_character 128.))
		       (t(insert_character 91.))))
	 (93.  (cond(caps
		       (insert_character 125.))
		       (t(insert_character 93.))))
	 (59.  (cond(caps
		       (insert_character 58.))
		       (t(insert_character 59.))))
	 (92. (cond(caps
		      (insert_character 92.))
		      (t(insert_character 96.))))
	 (39.  (cond(caps
		       (insert_character 34.))
		       (t(insert_character 39.))))
	 (46.  (cond(caps
		       (insert_character 62.))
		       (t(insert_character 46.))))
	 (44.  (cond(caps
		       (insert_character 60.))
		       (t(insert_character 44.))))
	 (124.  (cond(caps
			(insert_character 126.))
			(t(insert_character 124.))))
	 (45.  (cond(caps
		       (insert_character 95.))
		       (t(insert_character 45.))))
	 (47.  (cond(caps
		       (insert_character 63.))
		       (t(insert_character 47.))))
	 (48.  (cond(caps
		       (insert_character 41. ))
		       (t(insert_character 48.))))
	 (49.  (cond(caps
		       (insert_character 33. ))
		       (t(insert_character 49.))))
	 (50.  (cond(caps
		       (insert_character 64. ))
		       (t(insert_character 50.))))
	 (51.  (cond(caps
		       (insert_character 35. ))
		       (t(insert_character 51.))))
	 (52.  (cond(caps
		       (insert_character 36. ))
		       (t(insert_character 52.))))
	 (53.  (cond(caps
		       (insert_character 37. ))
		       (t(insert_character 53.))))
	 (54.  (cond(caps
		       (insert_character 94. ))
		       (t(insert_character 54.))))
	 (55.  (cond(caps
		       (insert_character 38. ))
		       (t(insert_character 55.))))
	 (56.  (cond(caps
		       (insert_character 42. ))
		       (t(insert_character 56.))))
	 (57.  (cond(caps
		       (insert_character 40. ))
		       (t(insert_character 57.))))
	 (97.  (cond(greek
		       (yank_from_buffer '(#/a #/l #/p #/h #/a)))
		       (t(insert_character 97.))))
	 (98.  (cond(greek
		       (yank_from_buffer '(#/b #/e #/t #/a )))
		       (t(insert_character 98.))))
	 (t   (cond((and caps (<= 97. inchar 122.))
		    (setq inchar (- inchar 32.))))
	      (insert_character inchar)))
      (drain poport)
      (go cmdloop)
      ;
      ;   CTRL CODES SECTION
      ;
      ctrlcode
      (do ((event (eget_next)(eget_next))
	   (event_type (eget_type event)(eget_type event))
	   (inchar (eget_param event)(eget_param event)))
	  ((and (= event_type 4)(= 138. inchar))t)
	  (cond((= event_type 3)
		(caseq inchar
		   (#/c   (irm nil)(terminal_enable t)(break)(irm t))
		   (#/d   (delete_character))
		   (#/f   (forward_character))
		   (#/b   (backward_character))
		   (#/a   (beginning_of_line))
		   (#/e   (end_of_line))
		   (#/g   (terminal_enable t)(irm nil)(drain piport)(break)(irm t))
		   (#/h   (erase_character))
		   (#/q   (event_disable)(print_help_menu)(event_enable ))
		   (#/u   (undo))
		   (#/k   (delete_to_eol))
		   (#/y   (yank_from_buffer kill))
		   (#/i   (irm t)(setq replace_mode nil))
		   (#/r   (irm nil)(setq replace_mode t))
		   (#/z   (irm nil)(terminal_enable t)(pause_vaxima))
		   )))
	  (drain poport))
      (drain poport)
      (go cmdloop)
      ;
      ;    ESCAPE CODES SECTION
      ;
      escapes
      (do ((event (eget_next)(eget_next))
	   (event_type (eget_type event)(eget_type event))
	   (inchar (eget_param event)(eget_param event)))
	  ((and (= event_type 4)(= 27. inchar))t)
	  (cond((= event_type 3)
		(caseq inchar
		   (#/h   (event_disable )(print_help_menu)(event_enable ))
		   )))
	  (drain poport))
      (drain poport)
      (go cmdloop)
      final
      (drain)
      ;;;
      ;;; combine the string back into st
      ;;;

      (setq st (append (reverse right) left ) hist_dot -1)
      (push_on_hist st)
      ;;;
      ;;; strip trailing blanks
      ;;;
      (do ((char (car st)(car st)))
	  ((and(not(= 32. char)) (not (= 10. char))))
	  (setq st (cdr st)))
      exit
      (cond((not (equal (car st) #/;))(setq st (cons #/;  st))))
      (cond ((boundp ptport)(setq ptport wfile)))
      (irm nil)(terminal_enable t)
      (return st)))

   (defun end_of_line nil
	  (prog nil
	     (cond ((or (= 10. (car right))(null right))(tyo 7)(return)))
	     (save_state)
	     (do ((n 0 (1+ n))(char (car right)(car right)))
	           ((null right) t)
                   (cuf)
		  (setq left (cons char left) 
		        right (cdr right) 
			dot (1+ dot)))))



   (defun beginning_of_line nil
	  (prog nil
	     (cond ((or (= 10. (car left))(null left))(tyo 7)(return)))
	     (save_state)
	     (do ((n 0 (1+ n))(char (car left)(car left)))
	           ((null left) t)
                    (cub)
		  (setq right (cons char right) 
		        left (cdr left) 
			dot (1- dot)))))


   (defun forward_character nil
	  (prog (char)
	     (cond ((null (setq char (car right)))(tyo 7)(return)))
	     (setq  dot (1+ dot) 
	           left (cons char left) 
		   right (cdr right))
	     (cuf)))


   (defun backward_character nil
	  (prog (char len)
	     (cond ((null (setq char (car left)))(tyo 7)(return)))
	     (setq  dot (1- dot) right (cons char right) 
	           left (cdr left))
	     (cub)))

   (defun insert_character (char)
	  (cond(replace_mode (setq right (cdr right))))
	  (cond ((and (lessp  char 127.)(lessp 31. char))
                 (tyo char)
       		 (setq  dot (1+ dot) left (cons char left))
		)))

   (defun delete_character nil
	  (cond ((null right)(tyo 7))
		(t (save_state)
		   (setq right (cdr right))
                   (msg "[P")
)))

   (defun erase_character nil
	  (cond ((null left)(tyo 7))
		(t (save_state)
		   (backward_character)
		(delete_character))))
      
   (defun delete_to_eol nil
	  (cond ((null right)(tyo 7))
		(t (el)(save_state)
		   (setq kill right)
		   (setq right nil))))
   (defun yank_from_buffer (buff)
	  (cond((null buff)(tyo 7))
		(t(setq right (append right buff) ll (length buff))
		  (save_state)
                  (do ((char (car buff)(car buff))
		       (buff (cdr buff)(cdr buff)))
		      ((null char)(cub ll) t)
		      (tyo char)))))
   
   (defun bounce_forward_to_paren () ())
   (defun bounce_backward_to_paren () ())
   (defun bounce_backward_to_bracket () ())
   (defun bounce_forward_to_bracket () ())

   (defun save_state() ())
;	  (cond((>= (length olddot) 5)
;		(setq olddot (reverse (cdr (reverse olddot))))
;		(setq oldleft (reverse (cdr (reverse oldleft))))
;		(setq oldright (reverse (cdr (reverse oldright))))))
;	  (push dot olddot)(push right oldright)(push left oldleft))
;   (defun undo () (tyo 7))
; 
;  Cursor Backward
; 
   (defun cub (&optional rows)
	  (if rows then (msg "[" rows "D")
	  else (msg "[D")) t)
;
; Cursor Forward
; 
   (defun cuf (&optional col)
	  (if col then (msg "[" col "C")
	  else (msg "[C")) t)
;
;  Cursor Up
; 
   (defun cuu ()
	  (msg "[A"))
;
;  Cursor Down
; 
   (defun cud ()
	  (msg "[B"))
;
;  Insert Replacement Mode
; 
   (defun irm (I)
	  (if I then (msg "[4h")
	     else (msg "[4l")))
;
; Delete Character
; 
  (defun dch ()
          (msg "[P") t)
;
;  Erase In Line 0 = from dot to eol, 2 = entire line
   (defun el (&optional arg)
	   (if arg then (msg "[" arg "k")
	    else  (msg "[K")) t)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: NEXT_COMMAND
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Jan 25 19:40:09 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun next_command  ( )
   (prog ()
      (cond((not(boundp '**current-window**))(return))
			((> 0 hist_dot)(tyo 7)
			 (beginning_of_line)(delete_to_eol))
			(t(setq hist_dot (1- hist_dot))
				(beginning_of_line)(delete_to_eol)
				(yank_from_buffer (nth  hist_dot
							(get **current-window** 'hist))
						  ))))
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: LAST_COMMAND
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Jan 25 19:40:36 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun last_command  ( )
   (prog ()
      (cond((not (boundp '**current-window**))(return nil))
		 ((or(> hist_dot 30.)
			(> hist_dot
			   (length (get **current-window** 'hist))))(tyo 7))
		 (t(setq hist_dot (1+ hist_dot))
			 (beginning_of_line)(delete_to_eol)
			 (yank_from_buffer
			    (nth  hist_dot (get **current-window** 'hist))))))

   )  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PUSH_ON_HIST
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Thu Jan 30 01:37:56 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun push_on_hist  (cmd)
   (prog ()
      (cond((or (not(boundp '**current-window**))(null cmd))(return))
		((null (get **current-window** 'hist)))
		((> (length (get **current-window** 'hist)) 30.)
		 (putprop **current-window**
			  (reverse (cdr (reverse
					   (get **current-window** 'hist))))
			  'hist)))
      (setq hist_dot -1)
      (putprop **current-window** (push (reverse cmd)
					(get **current-window** 'hist)) 'hist)
      ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: REPLACE_INCHAR_PROMPT
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sun Feb 02 00:37:31 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun replace_inchar_prompt  ( )
   (clear-text-region)
   (printlabel)
 )
