;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   This file contains the pop up menu functions
;;;   A menu is created with make-menu 
;;;      example: (setq *menu* (make-menu '(("String" (function1))
;;;                                         ("String" (function2))))
;;;   The menu is invoked with:
;;;               (setq result (menu-choose *menu* :title "Menu Title"))
;;;   The function returned by the menu can then be eval'd
;;;                (eval result)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(eval-when (compile) (require  '//user//vaxima//young//devdep//gelib))
(declare (macros t)
          (special **graphrect **textrect **visrect **copyform
	           **window_list** **fromcopybb **tocopybb **drawbb
		   **erasebb **maxrect **texterasebb **prev-dstate
		   **current-window** **cursors **oldrow** **oldcol**
		   **top-level-menu** **select-menu** tefont **font
		   **verify-delete-menu** $outchar lg-character-x
		   **win_number** **prompt-area**)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   function: menu-border
;;;   
;;;      purpose: 
;;;   
;;;      written by: douglas a. young
;;;      date: tue jan 21 22:57:23 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun menu-border (menu-form &key (title-bar nil))
   (let* ((ww  (form->w menu-form))
	  (hh (form->h menu-form))
	  (bb (make-bbcom destform menu-form
			  destrect (make-rect x 0 y 0 w 1 h 1)
			  cliprect **maxrect
			  rule bbsord))
	  (pt (make-point x 0 y (sub1 hh))))
      (paint_line bb pt)
      (setf (point->x pt) (sub1 ww))
      (setf (point->y pt) 0)
      (paint_line bb pt)
      (setf (bbcom->destrect.x bb) (sub1 ww))
      (setf (bbcom->destrect.y bb) (sub1 hh))
      (paint_line bb pt)
      (setf (point->y pt) (sub1 hh))
      (setf (point->x pt) 0)
      (paint_line bb pt)
      (if title-bar then
	  (setf (bbcom->destrect.x bb) 0)
	  (setf (bbcom->destrect.y bb) title-bar)
	  (setf (point->y pt) title-bar)
	  (setf (point->x pt) (sub1 ww))
	  (paint_line bb pt))) t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   function: menu-location
;;;   
;;;      purpose: 
;;;   
;;;      written by: douglas a. young
;;;      date: tue jan 21 22:57:05 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun menu-location (xx yy w h cliprect)
   ; changes  xx and/or yy, if necessary, so that the menu will be located
   ; in the visible region of the screen bitmap, or the graphics region
   ; if one is defined
   (if (null cliprect) then (setq cliprect **visrect))
   (let* ((width (rect->w cliprect))
	  (height (rect->h cliprect))
	  (min-x (rect->x cliprect))
	  (min-y (rect->y cliprect))
	  (max-x (+ min-x width))
	  (max-y (+ min-y height))
	  changedp)
      (if (< xx min-x)
	 then (setq xx min-x)
	      (setq changedp t)
       elseif (> (+ xx w) max-x)
	 then (setq xx (- max-x w))
	      (setq changedp t))
      (if (< yy min-y)
	 then (setq yy min-y)
	      (setq changedp t)
       elseif (> (+ yy h) max-y)
	 then (setq yy (- max-y h))
	      (setq changedp t))
      (if changedp then (list xx yy) else nil)))

(defun stringsize (str font)
   (* 8 (flatsize str)))
   
(defun string-pixel-size (item font)
   (if (stringp item)
      then (stringsize item font)
      else (stringsize (get_pname item) font)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   function: menu-width
;;;   
;;;      purpose: 
;;;   
;;;      written by: douglas a. young
;;;      date: tue jan 21 22:56:38 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun menu-width (item-list font)
   ; returns a list with length of longest item as car,
   ;   and list of item widths as cdr
   (do (widths item item-width
	       (max-width 0)
	       (items item-list (cdr items)))
       ((null items) (list max-width widths))
       (setq item (if (listp (car items)) then (caar items)
		     else (car items)))
       (setq item-width (string-pixel-size item font)); attach,nreverse
       (setq widths (append1 widths item-width))
       (if (> item-width max-width)
	  then (setq max-width item-width))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   function: make-menu
;;;   
;;;      purpose: 
;;;   
;;;      written by: douglas a. young
;;;      date: tue jan 21 22:56:22 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun make-menu (item-list &key (selector m_any)
			    (cliprect-var '**graphrect) (title nil))
   ; returns a menu object, with menu attributes as properties
   ; each item in item-list is a single string or symbol, or a list with
   ;   a string or symbol as car
   ; if single string or symbol, then this is the value both displayed
   ;   and returned if selected
   ; if list, then car is displayed and cadr is returned
   (if title then (setq item-list (cons (list title) item-list)))
   (let* ((centerp t)
	  (screen-loc nil)
	  (prev-item t)
	  (font **font)
	  (width-info (menu-width item-list font))
	  (interior-width (+ 6 (car width-info)))
	  (width-list (cadr width-info))
	  (item-height (add1 (font->header.chheight font)))
	  (interior-height (* item-height (length item-list)))
	  (rect (make-rect x 1 y 1 w  interior-width h  interior-height))
	  (width (+ 2 interior-width))
	  (height (+ 2 interior-height))
	  (base-pt (make-point))
	  (item-string nil)
	  (menu-form (form_create width height))
	  (menu (gensym 'm)))
      (putprop menu title ':title)
      (if title (menu-border menu-form :title-bar (1+ item-height))
	  (menu-border menu-form ))
      (do ((items item-list (cdr items))
	   (widths width-list (cdr widths))
	   (top-y 1 (+ top-y item-height))
	   (base-y 2 (+ base-y item-height))
	   item)
	  ((null items) menu-form)
	  (setf (point->x base-pt)
		(if centerp
		   then (+ 4 (// (- (car width-info) (car widths)) 2))
		   else 4))
	  (setf (point->y base-pt) base-y)
	  (setq item (if (listp (car items))
			then (caar items) else (car items)))
	  (paint-string
	     (point->x base-pt) (point->y base-pt)
	     (if (stringp item) then item else (get_pname item))
	     :font font
	     :rule 6
	     :destform menu-form))
      (putprop menu item-list ':menu-items)
      (putprop menu cliprect-var ':cliprect)
      (setf (rect->h rect) item-height)
      (putprop menu rect ':item-rect)
      (putprop menu (make-bbcom
		       srcform menu-form
		       destform **screen
		       destrect (make-rect x 0 y 0 w width h height)
		       cliprect **maxrect
		       rule bbs)
	       ':menu-bb)
      (putprop menu (make-bbcom
		       destform **screen
		       destrect (make-rect x 1 y 1
					   w interior-width h item-height)
		       cliprect **maxrect
		       rule bbdn)
	       ':item-bb)
      (putprop menu (make-bbcom
		       srcform **screen
		       destrect (make-rect x 0 y 0 w width h height)
		       cliprect **maxrect
		       rule bbs)
	       ':save-bb)
      (putprop menu (make-bbcom
		       destform **screen
		       destrect (make-rect x 0 y 0 w width h height)
		       cliprect **maxrect
		       rule bbs)
	       ':restore-bb)
      (putprop menu item-height ':item-height)
      (putprop menu screen-loc ':screen-loc)
      (putprop menu selector ':selector)
      (putprop menu prev-item ':prev-item)
      menu))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   function: menu-choose
;;;   
;;;      purpose: 
;;;   
;;;      written by: douglas a. young
;;;      date: tue jan 21 22:56:03 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun menu-choose (menu)
   ; menu is structure created with make-menu
   ; returns value of item as specified in item-list,
   ;   or nil if no item selected
   (let* ((menu-bb (get menu ':menu-bb))
	  (item-bb (get menu ':item-bb))
	  (save-bb (get menu ':save-bb))
	  (title (get menu ':title))
	  (restore-bb (get menu ':restore-bb))
	  (menu-items (get menu ':menu-items))
	  (selector (get menu ':selector))
	  (prev-item (get menu ':prev-item))
	  (item-height (get menu ':item-height))
	  (cliprect (get menu ':cliprect))
	  (m-width (bbcom->destrect.w menu-bb))
	  (m-height (bbcom->destrect.h menu-bb))
	  (save-form (form_create m-width m-height))
	  (mouse-loc (get_mposition (make-point)))
	  (mouse-x (point->x mouse-loc))
	  (mouse-y (point->y mouse-loc))
	  (y-offset (if (and (fixp prev-item) (plusp prev-item))
		       then (- (* item-height prev-item)
			       (// item-height 2))
		       else (// m-height 2)))
	  (x-offset (// m-width 2))
	  (temp-m-left (- mouse-x x-offset))
	  (temp-m-top (- mouse-y y-offset))
	  (newxy (menu-location temp-m-left temp-m-top m-width m-height
				(eval cliprect)))
	  (m-left (if newxy then (car newxy) else temp-m-left))
	  (m-top (if newxy then (cadr newxy) else temp-m-top))
	  (m-right (+ m-left (sub1 m-width)))
	  (m-bottom (+ m-top (sub1 m-height)))
	  (item-rect (get menu ':item-rect))
	  (x1 (+ m-left (rect->x item-rect)))
	  (y1 (+ m-top (rect->y item-rect)))
	  )
      (setf (bbcom->destrect.x item-bb) x1)
      (setf (bbcom->destrect.y item-bb) y1)
      (setf (bbcom->destform save-bb) save-form)
      (setf (bbcom->srcpoint save-bb) (make-point x m-left y m-top))
      (bit_blt save-bb)
      (if newxy then (set_mposition (make-point x (+ m-left x-offset)
					       y (+ m-top y-offset))))
      (setf (bbcom->destrect.x menu-bb) m-left)
      (setf (bbcom->destrect.y menu-bb) m-top)
      (bit_blt menu-bb)
      (setf (bbcom->srcform restore-bb) save-form)
      (setf (bbcom->destrect.x restore-bb) m-left)
      (setf (bbcom->destrect.y restore-bb) m-top)
      (do* ((cursor **cursor)
	    (offsetw (form->offsetw cursor))
	    (offseth (form->offseth cursor))
	    (point (make-point))
	    (mouse-loc (get_mposition point) (get_mposition point))
	    (buttons (get_buttons) (get_buttons))
	    mouse-x mouse-y previous current
	    )
	   ((and previous (zerop buttons))
	    (let ((item (nth (sub1 previous) menu-items))
		  )
	       (bit_blt restore-bb)
	       (if prev-item then (putprop menu previous ':prev-item))
	       (if (listp item) then (cadr item) else item)))
	   (setq mouse-x (+ offsetw (point->x mouse-loc)))
	   (setq mouse-y (+ offseth (point->y mouse-loc)))
	   (setq current
		 (if (or (equal selector buttons)
			 (and (plusp buttons) (equal selector m_any)))
		    then (if (and (lessp m-left mouse-x m-right)
				  (lessp m-top mouse-y m-bottom))
			    then (add1 (*quo (- mouse-y y1) item-height))
			    else 0)
		    else nil))
;;;   
;;;    Temp for screen dump
;;;   
	   (if (equal buttons 3) then 
	       (sdump (form->addr **screen) (next-file-name)))
;;;   
;;;   
;;;   
	   
	   (if (not (equal current previous))
	      then (if (and (fixp previous)
			    (plusp (if title (1- previous) previous)))
		      then (bit_blt item-bb))	; turn off previous selection
		   (if (and (fixp current)
			    (plusp (if title (1- current) current)))
		      then (setf (bbcom->destrect.y item-bb)
				 (+ y1 (* item-height (sub1 current))))
			   (bit_blt item-bb))	; turn on current selection
		   (setq previous current)))))

;;;
;;;    set up the menus for the mouse
;;;
(defvar **top-level-items**
   '(("Create Window" (make-window))
     ("Plot Function" (mouse_plot))
     ("Curve Package" (curve-fit))
     ("Move Window " (move-window **current-window**))
     ("Shrink Window " (shrink-window **current-window**))
     ("Delete Window " (delete-window **current-window**))
     ("Change Window Size" (change-window-size **current-window**))
     ("Redraw Window" (redimension-window ))
     ("Set Window Value" (set-window-value **current-window**))  
     ("Help "  (print_help_menu))))

(defvar **top-level-menu** 
          (make-menu  **top-level-items** :title "Main Menu"))

(defvar **yes-no-menu** '((" Yes " t)(" No " nil)))

(defvar **verify-delete-menu** 
            (make-menu **yes-no-menu** :title "Delete Window?"))

   
(defvar **help-menu-list**
   '(( "Editing Functions " (describe-edit-functions))
     ( "Manipulating Windows " (describe-window-functions))
     ( "Selecting Expressions " (describe-selection-functions))
     ( "Plotting Functions" (describe-plot-functions))
     ( "Exit Help Menu " )))

(defvar **help-menu** (make-menu **help-menu-list** :title "Help Menu"))
   
