module grational;  % Support for Gaussian Rationals  i.e. Q(i).

% Author: Alan Barnes <barnesa@mail.aston.ac.uk>.

global '(domainlist!*);

domainlist!* := union ('(!:grn!:), domainlist!*);

switch complex!_rational;

put('complex!_rational, 'tag, '!:grn!:);
put('!:grn!:, 'dname, 'complex!_rational);
put('complex!_rational, 'switchid, '!*complex!_rational);
put('!:grn!:, 'i2d, '!*i2grn);
put('!:grn!:, 'minusp, 'grnminusp!:);
put('!:grn!:, 'zerop, 'grnzerop!:);
put('!:grn!:, 'onep, 'grnonep!:);
put('!:grn!:, 'plus, 'grnplus!:);
put('!:grn!:, 'difference, 'grndifference!:);
put('!:grn!:, 'times, 'grntimes!:);
put('!:grn!:, 'quotient, 'grnquotient!:);
put('!:grn!:, 'rationalizefn, 'girationalize!:);
put('!:grn!:, 'prepfn, 'grnprep!:);
put('!:grn!:, 'intequivfn, 'grnintequiv!:);
put('!:grn!:, 'prifn, 'grnprn!:);
put('!:grn!:, 'cmpxfn, 'mkgrn);
put('!:grn!:, 'realtype, '!:rn!:);
put('!:grn!:, 'ivalue, 'mkdgrn);

% put('!:grn!:, '!:rn!:, 'grn2rn);
% put('!:grn!:, '!:ft!:, 'grn2ft);
% put('!:grn!:, '!:bf!:, 'grn2bf);
put('!:grn!:, '!:gf!:, 'grn2gf);
put('!:grn!:, '!:gbf!:, 'grn2gbf);
% put('!:grn!:, '!:gi!:, 'grn2gi);

put('!:rn!:, 'cmpxtype ,list '!:grn!:);
put('!:rn!:, 'intequivfn, 'rnintequiv!:);

put('!:bf!:, '!:rn!:, '!*bf2rn);
% put('!:gbf!:, '!:rn!:, 'gbf2rn);

put('!:mod!:, '!:grn!:, 'modconv);
put('!:rn!:, '!:grn!:, 'rn2grn);
put('!:ft!:, '!:grn!:, 'ft2grn);
put('!:bf!:, '!:grn!:, 'bf2grn);
put('!:gi!:, '!:grn!:, 'gi2grn);
put('!:gf!:, '!:grn!:, 'gf2grn);
put('!:gbf!:, '!:grn!:, 'gbf2grn);

flag('(!:grn!:), 'ratmode);
flag('(!:grn!:), 'field);

symbolic procedure mkgrn (re,im);
        '!:grn!: . (re . im);

symbolic procedure mkdgrn u;
        ('!:grn!: . (('!:rn!: . (0 .1)) . ('!:rn!: . (1 . 1)))) ./ 1;

symbolic procedure !*i2grn u;
        '!:grn!: . (!*i2rn u . !*i2rn 0);

symbolic procedure grnminusp!: u;
        if rnzerop!: cadr u then rnminusp!: cddr u
                else rnminusp!: cadr u;

symbolic procedure grnzerop!: u;
        rnzerop!: cadr u and rnzerop!: cddr u;

symbolic procedure grnonep!: u;
        rnzerop!: cddr u and rnonep!: cadr u;

symbolic procedure grnplus!: (u,v);
        mkgrn(rnplus!: (cadr u, cadr v), rnplus!:(cddr u, cddr v));

symbolic procedure grndifference!: (u,v);
        mkgrn(rndifference!: (cadr u, cadr v),
              rndifference!:(cddr u, cddr v));
        

symbolic procedure grntimes!: (u,v);
  mkgrn(rndifference!:(rntimes!:(cadr u, cadr v),
                       rntimes!:(cddr u, cddr v)),
        rnplus!:(rntimes!:(cadr u, cddr v), rntimes!:(cddr u, cadr v)));

symbolic procedure grnquotient!: (u,v);
  begin scalar r1,r2,i1,i2,d,rr,ii;
        r1 := cadr u; i1 := cddr u;
        r2 := cadr v; i2 := cddr v;
        rr := rnplus!:(rntimes!:(r1, r2), rntimes!:(i1,i2));
        ii := rndifference!:(rntimes!:(i1,r2), rntimes!:(r1,i2));
        d  := rnplus!:(rntimes!:(r2,r2), rntimes!:(i2,i2));
        return mkgrn(rnquotient!:(rr,d), rnquotient!:(ii,d))
  end;

symbolic procedure grnintequiv!: u;
        if rnzerop!: cddr u then rnintequiv!: cadr u else nil;

symbolic procedure rnintequiv!: u;
        if cddr u = 1 then cadr u else nil;

symbolic procedure grnprep!: u; grnprep1 cdr u;

% symbolic procedure grnprep1 u;
%        if rnzerop!: cdr u then if rnonep!: car u then 1
%                                else rnprep!: car u
%          else if rnzerop!: car u then if rnonep!: cdr u then 'i
%                                else list ('times, rnprep!: cdr u, 'i)
%          else list('plus, rnprep!: car u, if rnonep!: cdr u then 'i
%                                else list ('times, rnprep!: cdr u,'i));

symbolic procedure grnprep1 u;
        if rnzerop!: cdr u then if rnonep!: car u then 1
                                else rnprep!: car u
          else if rnzerop!: car u then grnprep1!: cdr u
          else list('plus, rnprep!: car u, 
                     if rnminusp!:(u := cdr u) 
                        then list('minus,
                                  grnprep1!: rntimes!:(mkrn(-1,1),u))
                        else grnprep1!: u);


symbolic procedure grnprep1!: u;
        if rnonep!: u then 'i
                        else list('times, rnprep!: u, 'i);

symbolic procedure grnprn!: u;
        (lambda v; if atom v or car v  eq 'times 
                        or car v memq domainlist!* then maprin v
                   else  <<prin2!* "("; maprin v; prin2!* ")">>)
         grnprep1 u;
% Could be changed to use rnprin??;

symbolic procedure rn2grn u; mkgrn(u, !*i2rn 0);

symbolic procedure ft2grn u; mkgrn(!*ft2rn u, !*i2rn 0);

symbolic procedure bf2grn u; mkgrn(!*bf2rn u, !*i2rn 0);

symbolic procedure !*bf2rn u;
  if cddr u < 0 then mkrn(cadr u,expt(10, minus cddr u))
        else mkrn(expt(10,cddr u)*cadr u, 1);
%Not defined in bigfloat.red;

symbolic procedure gi2grn u; mkgrn(!*i2rn cadr u, !*i2rn cddr u);

symbolic procedure gf2grn u;
        mkgrn(!*ft2rn('!:ft!: . cadr u), !*ft2rn('!:ft!: . cddr u));

symbolic procedure gbf2grn u;
        mkgrn(!*bf2rn('!:bf!: . cadr u), !*bf2rn('!:bf!: . cddr u));

symbolic procedure grn2gf u;
        mkgf(cdr !*rn2ft cadr u,  cdr !*rn2ft cddr u);

symbolic procedure grn2gbf u;
        mkgbf(!*rn2bf cadr u, !*rn2bf cddr u);

symbolic procedure grn2ft u;
        if rnzerop!: cddr u then !*rn2ft cadr u
        else rederr "Conversion to float requires zero imaginary part";

symbolic procedure grn2bf u;
        if rnzerop!: cddr u then !*rn2bf cadr u
        else rederr
           "Conversion to bigfloat requires zero imaginary part";

symbolic procedure grn2rn u;
        if rnzerop!: cddr u then  cadr u
        else rederr
           "Conversion to rational requires zero imaginary part";

symbolic procedure gbf2rn u;
        if bfzerop!: cddr u then !*bf2rn cadr u
        else rederr
           "Conversion to rational requires zero imaginary part";
% not defined in bfloat.red;

symbolic procedure grn2gi u;
        if rnintequiv!: cadr u and rnintequiv!: cddr u
                then mkgi(cadadr u, caddr u)
                else rederr
 "Conversion to Gaussian integer requires integer real and imag parts";

initdmode 'complex!_rational;

put ('rn,'simpfn,function simprn);
put ('grn,'simpfn,function simpgrn);

symbolic procedure simprn u;
  !*f2q mkrn(ieval car u, ieval carx(cdr u,'rn));

symbolic procedure simpgrn u;
  !*f2q mkgrn(mkrn(ieval car u,ieval cadr u),
              mkrn(ieval caddr u, ieval carx(cdddr u,'grn)));

endmodule;

end;
