module exprio;

% Author: Richard Liska
% Date:   April 10, 1992
% Version 0.1 for REDUCE 3.4
% The author thanks Herbert Melenk for useful suggestions.

% This minipackage defines two new operators SAVE_EX and LOAD_EX
% for fast saving/loading of algebraic expressions to/from a file.
% This operators are much faster than using IN and OUT (with OFF NAT)
% statements and allow one to save and load larger expressions. These
% operators are especially  useful for saving and loading very large
% polynomials and rational functions.
%
% The syntax of the operators is:
%     SAVE_EX(<file>,<expression>)
%     LOAD_EX(<file>)
% where
%     <file>       ::=  identifier - the name of file
%     <expression> ::=  anay algebraic expression
%
% The operator SAVE_EX opens the file <file> and writes the
% algebraic value of <expression> to it in a special internal
% REDUCE format. The operator returns the value of <expression>.
% The file <file> is not human readable.
%
% The operator LOAD_EX opens the file <file>, which has been
% created by the operator SAVE_EX, and reads from it an algebraic
% expression. The operator returns the value of this expression.

put('mat,'rtypefn,'quotematrix);
defautoload(quotematrix,'(matrix),expr,1);

global '(!*sqvar!*);

procedure save_ex u;
begin
  scalar n;
  n := length u;
  if not n=2 then rerror('exprio,1,
                    "SAVE_EX called with wrong number of arguments")
    else return
      begin
        scalar file,chan,ochan,sqvar;
        file:=mkfil car u;
        chan:=open(file,'output);
        ochan:=wrs chan;
        prin2 '!&!&exprio!&!&;
        terpri();
        u:=aeval cadr u;
        sqvar:=car !*sqvar!*;
        rplaca(!*sqvar!*,nil);
        sprint u;
        terpri();
        rplaca(!*sqvar!*,sqvar);
        wrs ochan;
        close chan;
        return u
      end
end;

fluid'(posn!*, linelength!*, maxn!*, maxnm1!*);

procedure sprint (u);
begin
  scalar posn!*;
  posn!* := 0;
  linelength!*:=linelength nil - 2;
  maxn!*:=10^(linelength!*-3);
  maxnm1!*:=maxn!*-1;
  print maxn!*;
  pprint u;
end;

procedure pprint (u);
if fixp u and abs(u)>maxnm1!* then pprint explode_bigint u
  else if atom u then pprin(u,t)
  else begin
         pprin('!(,nil);
       a:if car u eq '!:rd!: and floatp cdr u then
                  u:=('!:rd!: . cdr read!:num cdr u);
         pprint car u;
         u:=cdr u;
         if not null u then pprin('! ,nil);
         if null u then pprin('!),nil)
           else if atom u then
             <<pprin('! ,nil);
               pprin('!.,nil);
               pprin('! ,nil);
               pprint u;
               pprin('!),nil) >>
           else go to a
       end;

procedure pprin(u,b);
begin
  integer m,n;
  n:=if b then length explode u
       else lengthc u;
  m:=posn!* + n;
  if m<linelength!* then posn!* := m
    else << terpri(); posn!* := n >>;
  if b then prin1 u
    else prin2 u
end;

procedure explode_bigint u;
begin
  scalar l,r;
  while abs(u)>maxnm1!* do
    <<r:=remainder(u,maxn!*);
      l:=r . l;
      u:=(u-r)/maxn!* >>;
  l:=u . l;
  return ('!&bigint!& . l)
end;

procedure compress_bigint u;
begin
  scalar n;
  n:=0;
  while u do
    <<n:=n*maxn!* + car u;
      u:=cdr u>>;
  return n
end;

put('save_ex,'psopfn,'save_ex);

procedure load_ex u;
begin
  scalar n;
  n := length u;
  if not n=1 then rerror('exprio,2,
                    "LOAD_EX called with wrong number of arguments")
    else return
      begin
        scalar file,val,chan,ochan,!*echo;
        file:=mkfil car u;
        chan:=open(file,'input);
        ochan:=rds chan;
        if not readch() eq '!& then go to er;
        if not readch() eq '!& then go to er;
        if not readch() eq 'e then go to er;
        if not readch() eq 'x then go to er;
        if not readch() eq 'p then go to er;
        if not readch() eq 'r then go to er;
        if not readch() eq 'i then go to er;
        if not readch() eq 'o then go to er;
        if not readch() eq '!& then go to er;
        if not readch() eq '!& then go to er;
        maxn!*:=read();
        if not fixp maxn!* then go to er;
        val:=read();
        go to c;
     er:msgpri("File ",file," has not been created by SAVE_EX",nil,'hold);
      c:rds(ochan);
        close chan;
        if eqcar(val,'!&bigint!&) then val:=compress_bigint cdr val
          else trans_unikern_bigint val;
        val:=aeval val;
        return val
      end
end;

put('load_ex,'psopfn,'load_ex);

procedure trans_unikern_bigint u;
if atom u then t
  else if eqcar(u,'!*sq) then tub_sq cadr u
  else
    <<if atom car u then t
        else if eqcar(car u,'!&bigint!&) then
            rplaca(u,compress_bigint cdar u)
        else trans_unikern_bigint car u;
      if atom cdr u then t
        else if eqcar(cdr u,'!&bigint!&) then
            rplacd(u,compress_bigint cddr u)
        else trans_unikern_bigint cdr u>>;

procedure tub_sq u;
<<if atom car u then t
    else if eqcar(car u,'!&bigint!&) then
        rplaca(u,compress_bigint cdar u)
    else tub_sf car u;
  if atom cdr u then t
    else if eqcar(cdr u,'!&bigint!&) then
        rplacd(u,compress_bigint cddr u)
    else tub_sf cdr u>>;

procedure tub_sf u;
if flagp(car u,'numbertag) then t
  else
    <<if atom red u then t
        else if eqcar(red u,'!&bigint!&) then
            rplacd(u,compress_bigint cdr red u)
        else tub_sf red u;
      if atom lc u then t
        else if eqcar(lc u,'!&bigint!&) then
            rplacd(lt u,compress_bigint cdr lc u)
        else tub_sf lc u;
      if atom ldeg u then t
        else if eqcar(ldeg u,'!&bigint!&) then
            rplacd(lpow u,compress_bigint cdr ldeg u);
      if atom mvar u then t
        else
          <<trans_unikern_bigint mvar u;
            rplaca(lpow u,car fkern mvar u)>> >>;

endmodule;

end;
