#include "def.h"
#include "macro.h"
/* AK  291288 */
typedef struct node {
	char * _key; /* dies enthaelt ein object */
	struct node * _l, * _r;
	char _rtag;
} Node;

#define KEY(p) ((p) -> _key)
#define L(p) ((p) -> _l)
#define R(p) ((p) -> _r)
#define RTAG(p) ((p) -> _rtag)


/* TSEARCH(3C) */
typedef enum {
	preorder, postorder, endorder, leaf }
VISIT;


static INT twalk();
static void tfree();
static char ** tsearch();
static void walk();

static void freeself_bintree_action(a,type) OP *a; VISIT type;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if ((type==postorder)||  (type==leaf)) freeall(*a);
#endif /*BINTREETRUE*/
}

#ifdef BINTREETRUE
INT freeself_bintree(a) OP a;
/* AK 050891 V1.3 */
{
	void freeself_bintree_action();
	OBJECTSELF d ;
	d = S_O_S(a);
	tfree(& d.ob_charpointer,freeself_bintree_action,NULL,NULL,NULL);
	C_O_K(a,EMPTY);
	return OK; /* AK 050891 */
}
#endif /*BINTREETRUE*/


#ifdef BINTREETRUE
INT init_bintree(a) OP a;
/* AK 050891 V1.3 */
{
	OBJECTSELF d;
	C_O_K(a,BINTREE);
	d.ob_charpointer = (char *) NULL;
	C_O_S(a,d);
	return(OK);
}
#endif /*BINTREETRUE*/

static void fprint_bintree_action(a,type,l,p1) OP *a;VISIT type;INT l;FILE *p1;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if ((type==postorder)||  (type==leaf))
	{
		fprint(p1,*a);
		fprintf(p1," ");
		if (p1==stdout) 
			{	
			zeilenposition++;
			if (zeilenposition >70L) {
				fprintf(p1,"\n");
				zeilenposition=0L; }
			}
	}
#endif /*BINTREETRUE*/
}


INT fprint_bintree(fp,a) FILE *fp; OP a;
/* AK 050891 V1.3 */
/* gibt einen bintree aus */
{
#ifdef BINTREETRUE
	void fprint_bintree_action();
	OBJECTSELF d;
	d = S_O_S(a);
	if (d.ob_charpointer == NULL)
		{
		fprintf(fp,"empty tree");
		if (fp == stdout) zeilenposition += 10L;
		}
	else
		twalk(d.ob_charpointer,fprint_bintree_action,fp,NULL,NULL);
	return OK;
#endif /*BINTREETRUE*/
}

INT insert_bintree(a,bt,eh,cf) OP a,bt; INT (*cf)(), (*eh)();
/* fuegt a in bintree bt ein */
/* cf ist die vergleichsfunktion
	   eh gibt die operation bei schon vorhandenem
	   gleichen eintrag an */
/* AK 040189 */
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	char ** result;
	INT	comp();

	if (S_O_K(a) == BINTREE) 
		return(insert_bt_bt(a,bt,eh,cf));

	if (cf == NULL) cf = comp;
	/* default wert */

	result = tsearch(a, &((S_O_S(bt)).ob_charpointer) ,cf);
	if (*result == (char *)a) return(INSERTOK);
	/* d.h. das element wurde eingefuegt */
else /* d.h. es wurde ein gleiches element festgestelt
				und result ist ein pointer darauf */
	{
		if (eh != NULL) 
			(*eh)(a,*result);
		else
			freeall(a);
		return(INSERTEQ);
	}
#endif /*BINTREETRUE*/
}

INT insert_bt_bt(a,bt,eh,cf) OP a,bt; INT (*cf)(), (*eh)();
/* fuegt a was auch bintree ist
	in bintree bt ein */
/* cf ist die vergleichsfunktion
	   eh gibt die operation bei schon vorhandenem
	   gleichen eintrag an */
/* AK 090189 */

/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	void insert_bt_bt_action();
	OBJECTSELF d;

	d = S_O_S(a);
	tfree(&d.ob_charpointer,insert_bt_bt_action,bt,eh,cf);
	C_O_K(a,EMPTY); /* leer setzen */

#endif /*BINTREETRUE*/
}

static void insert_bt_bt_action(a,type,bt,eh,cf)OP *a,bt; VISIT type; 
		INT (*eh)(),(*cf)();
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	INT insert_erg;

	if ((type==postorder)||  (type==leaf))
	{
		insert_erg = insert_bintree(*a,bt,eh,cf);
		/* if (insert_erg == INSERTEQ) freeall(*a); */
	}
#endif /*BINTREETRUE*/
}

INT copy_bintree(a,b) OP a,b;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	void copy_bintree_action();
	OBJECTSELF d;

	init(BINTREE,b);
	d = S_O_S(a);
	twalk(d.ob_charpointer,copy_bintree_action,b,NULL,NULL);
	return OK;
#endif /*BINTREETRUE*/
}

static void copy_bintree_action(a,type,l,bt) OP *a; VISIT type; INT l; OP bt;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if ((type==postorder)||  (type==leaf))
	{
		OP c=callocobject();
		copy(*a,c);
		insert_bintree(c,bt,NULL,NULL);
	}
#endif /*BINTREETRUE*/
}


static Node ** find(k,rootp,compar, parent, c) char *k; 
	register Node ** rootp; INT (*compar)(); 
	Node ** parent; INT *c;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	*parent = (Node *) 0;
	if (rootp && *rootp)
		for (;;)
		{
			if ((*c = (*compar) (k,KEY(*rootp))) == 0L)
				break;
			*parent = *rootp;
			if( *c < 0L)
			{
				rootp = & L(*parent);
				if (! *rootp) break;
			}
			else {
				rootp = & R(*parent);
				if (RTAG(*parent)) break;
			}
		}

	return (rootp);
#endif /*BINTREETRUE*/
}

static char **tfind(k,rootp,compar) char *k; 
	register Node ** rootp; 
	INT (*compar)();
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	Node * parent;
	INT c;

	if ((rootp = find(k,rootp,compar, & parent, &c))
	    && * rootp && c==0)
		return(& KEY(*rootp));
	return( (char **) 0);
#endif /*BINTREETRUE*/
}

static char ** tsearch(k,rootp,compar) char *k; 
	register Node ** rootp;
	INT (*compar)();
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	register Node *p;
	Node * parent;
	INT c;

	if (rootp = find(k,rootp,compar, &parent, &c))
		if (*rootp && c == 0)
			return (&KEY(*rootp));
		else if (p = (Node *) malloc(sizeof(Node)))
		{
			KEY(p) =k;
			L(p) = (Node *) 0;
			if (parent && c>0)
			{
				R(p) = R(parent);
				R(parent) = p, RTAG(parent)= 0;
			}
			else
			{
				R(p) = parent;
				* rootp = p;
			}
			RTAG(p) = 1;
			return (&KEY(p));
		}
	return ((char**) 0);
#endif /*BINTREETRUE*/
}


static void walk(root,action,l,p1,p2,p3) register Node *root; 
	void (*action) (); 
	INT l; 
	char *p1,*p2, *p3;
/* fuer parameter bei action */

/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if (! L(root) && RTAG(root))
		(*action) (&KEY(root), leaf, l,p1,p2,p3);
	else
	{
		(*action) (&KEY(root), preorder, l,p1,p2,p3);
		if (L(root))
			walk(L(root), action, l+1L,p1,p2,p3);
		(*action) (&KEY(root), postorder, l,p1,p2,p3);
		if (! RTAG(root))
			walk(R(root), action, l+1L,p1,p2,p3);
		(*action) (&KEY(root), endorder, l,p1,p2,p3);

	}
#endif /*BINTREETRUE*/
}

static INT twalk(root,action,p1,p2,p3) Node *root; 
	void (*action) (); 
	char *p1,*p2, *p3; /* fuer parameter bei action */
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if (root)
		walk(root,action,0L,p1,p2,p3);
	return OK;
#endif /*BINTREETRUE*/
}


static void tfree(rootp,a,p1,p2,p3) Node **rootp; void (*a)(); char *p1,*p2,*p3;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	register Node *root,*p;

	if (!rootp || ! (root = *rootp))
		return;
	* rootp = (Node *)0;
	for (;;)
	{
		while (p = L(root))
			root = p;
		if (RTAG(root))
		{
			if (a)
				(* a)(&KEY(root), leaf,
				    p1,p2,p3);
			do
			{
				p=R(root),free(root),root=p;
				if (! root)
					return;
				if (a)
					(* a)(&KEY(root),postorder,
					    p1,p2,p3);
			} while(RTAG(root));
		}
		else
		{
			if (a)
				(* a)(&KEY(root),postorder,
				    p1,p2,p3);
		}
		p=R(root),free(root),root=p;
	}
#endif /*BINTREETRUE*/
}

INT t_BINTREE_LIST(a,b) OP a,b;
/* wandelt einen BINTREE in ein LIST object um */
/* die liste ist nach den gleichen vergleich sortiert */
/* AK 070390 V1.1 */ /* AK 050891 V1.3 */
{
#ifdef BINTREETRUE
	void t_BINTREE_LIST_action();
	INT erg = OK; /* AK 170392 */
	OP h, *h2;

	if (a == b)
		{
		h = callocobject();
		*h = *b;
		C_O_K(b,EMPTY);
		erg += t_BINTREE_LIST(h,b);
		goto ende;
		}

	h = callocobject();
	erg += b_sn_l(NULL,NULL,h);

	if (not EMPTYP(b)) 
		erg += freeself(b);
	h2 = &S_L_N(h);
	erg += twalk((S_O_S(a)).ob_charpointer,t_BINTREE_LIST_action,
			&h2,NULL,NULL);

	if (S_L_N(h) != NULL) 
		*b = *S_L_N(h);
	else 
		erg += b_sn_l(NULL,NULL,b);

	free(S_L_N(h)); /* AK 161091 */
	S_L_N(h)=NULL; 
ende:
	erg += freeall(h); 
	return erg;
#endif /* BINTREETRUE */
}

static void t_BINTREE_LIST_action(a,type,l,bt)OP *a;VISIT type;INT l;OP **bt;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if ((type==postorder) ||  (type==leaf))
		{
		**bt = callocobject();
		b_sn_l(callocobject(),NULL,**bt);
		copy(*a,S_L_S(**bt));
		*bt = & S_L_N(**bt);
		}
#endif /* BINTREETRUE */
}

INT t_BINTREE_SCHUR(a,b) OP a,b;
/* wandelt einen BINTREE in ein SCHUR object um */
/* die liste ist nach den gleichen vergleich sortiert */
/* AK 070390 V1.1 */ /* AK 050891 V1.3 */
{
#ifdef BINTREETRUE
	void t_BINTREE_SCHUR_action();
	OP h = callocobject();
	OP *h2;
	if (a == b) {
		*h = *b;
		C_O_K(b,EMPTY);
		t_BINTREE_SCHUR(h,b);
		freeall(h);
		return OK;
		}
	b_sn_l(NULL,NULL,h);
	C_O_K(h,SCHUR);

	if (not EMPTYP(b)) 
		freeself(b);
	h2 = &S_L_N(h);
	twalk((S_O_S(a)).ob_charpointer,t_BINTREE_SCHUR_action,
			&h2,NULL,NULL);

	if (S_L_N(h) != NULL) 
		*b = *S_L_N(h);
	else 
		{
		b_sn_l(NULL,NULL,b);
		C_O_K(b,SCHUR);
		}

	free(S_L_N(h)); /* AK 161091 */
	S_L_N(h)=NULL; 
	freeall(h); 
	return(OK);
#endif /* BINTREETRUE */
}

static void t_BINTREE_SCHUR_action(a,type,l,bt)OP *a;VISIT type;INT l;OP **bt;
/* AK 210891 V1.3 */
{
#ifdef BINTREETRUE
	if ((type==postorder)||  (type==leaf))
		{
		**bt = callocobject();
		b_sn_l(callocobject(),NULL,**bt);
		C_O_K(**bt,SCHUR);
		copy(*a,S_L_S(**bt));
		*bt = & S_L_N(**bt);
		}
#endif /* BINTREETRUE */
}
#ifdef BINTREETRUE
INT test_bintree()
{
	OP a,b,c;
	a = callocobject();
	b = callocobject();
	c = callocobject();
	printf("test_bintree:init(BINTREE,a) ");
	init(BINTREE,a); println(a);
	printf("test_bintree:insert(5L,a) ");
	m_i_i(5L,b);insert(b,a,NULL,NULL); println(a);
	printf("test_bintree:insert(7L,a) ");
	b = callocobject();
	m_i_i(7L,b);
	insert(b,a,NULL,NULL);  println(a);
	printf("test_bintree:copy(a,c) ");
	copy(a,c); println(c);
	printf("test_bintree:insert(9L,c) ");
	b = callocobject();
	m_i_i(9L,b);
	insert(b,c,NULL,NULL); 
	println(c);
	freeall(a);
	freeall(c);
	return OK;
}
#endif /* BINTREETRUE */
#ifdef BINTREETRUE
#endif /* BINTREETRUE */
