/* file boe.c */
#include "def.h"
#include "macro.h"

/* AK 180791 berechnung der specht darstellung
Wilhelm Specht: Mathematische Zeitschrift 39 (1935) 696-711 */

#ifdef TABLEAUXTRUE
INT specht_dg(a,b,c) OP a,b,c;
/* a partition fuer irr. darstellung
   b permutation 
   c wird die darstellung */
/* AK 200891 V1.3 */
{
	OP d,f, e;
	INT i,j;

	if (
		(S_O_K(a) != PARTITION) &&
		(S_O_K(a) != SKEWPARTITION) 
	    ) return error("specht_dg:a no partition type");
	if (S_O_K(b) != PERMUTATION) return error("specht_dg:b no PERMUTATION");

	d = callocobject();
	e = callocobject();
	f = callocobject();
	weight(a,d);
	last_partition(d,e);
	kostka_tab(a,e,d);
	t_LIST_VECTOR(d,e); /* e ist vector of tab */
	m_il_v(S_V_LI(e),d);
	for (i=0L;i<S_V_LI(d); i++)
		specht_poly(S_V_I(e,i),S_V_I(d,i)); 
	/* d is vector of specht poly */
	m_ilih_nm(S_V_LI(d),S_V_LI(d),c);

	for (i=0L;i<S_V_LI(d); i++)
		{
		operate_perm_polynom(b,S_V_I(d,i),e);
		/* e ist das geaenderte specht polynom, welches nun in der
		   basis geschrieben werden muss */
aaa:
		if (not nullp(e)) 
			for (j=0L;j<S_V_LI(d); j++)
				if (EQ(S_PO_S(e),S_PO_S(S_V_I(d,j))))
					{
					copy(S_PO_K(e),S_M_IJ(c,i,j));
					mult(S_PO_K(e),S_V_I(d,j),f);
					sub(e,f,e);
					goto aaa;
					}
		
		}

	freeall(d);
	freeall(e);
	freeall(f);
	return OK;
}
#endif /* TABLEAUXTRUE */
#ifdef MATRIXTRUE
INT vander_gen(a,b) OP a,b;
/* a ist monom, d.h. vector von integer als self
   b wird die vandermonde, wie sie bei specht definiert wird */
/* AK 200891 V1.3 */
{
	OP c,d;
	INT i,j,k;

	if (S_O_K(a) != MONOM) return error("vander_gen:no MONOM");
	if (S_O_K(S_MO_S(a)) != VECTOR) return error("vander_gen:no VECTOR");

	c=callocobject();
	d=callocobject();
	k=0L;
	for (i=0L;i<S_MO_SLI(a);i++)
		if (not nullp(S_MO_SI(a,i))) k++;

	m_ilih_m(k,k,c);
	for (i=0L;i<S_M_HI(c);i++)
		{
		for (k=0L;k<S_MO_SLI(a);k++)
			if (not nullp(S_MO_SI(a,k))) break;
		for (j=0L;j<S_M_HI(c);j++)
			{
			b_skn_po(callocobject(),
				callocobject(),NULL,S_M_IJ(c,i,j));
			m_l_nv(S_MO_SL(a),S_PO_S(S_M_IJ(c,i,j)));
			copy(S_MO_K(a),S_PO_K(S_M_IJ(c,i,j)));
			m_i_i(i+S_MO_SII(a,k)-1L,S_PO_SI(S_M_IJ(c,i,j),k));
			k++;
			for (;k<S_MO_SLI(a);k++)
				if (not nullp(S_MO_SI(a,k))) break;
			}
		}



	det_mat_imm(c,b);
	freeall(c);
	freeall(d);
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef TABLEAUXTRUE
INT specht_poly(a,b) OP a,b;
/* a ist tableaux
   b wird das zugehoerige spechtpolynom, welches basis im entsprechenden
     modul */
/* AK 200891 V1.3 */
{
	OP c,d,e,f;
	INT i,j;
	if (S_O_K(a) != TABLEAUX) return error("specht_poly:not TABLEAUX");

	c = callocobject();
	d = callocobject();
	e = callocobject();
	f = callocobject();
	conjugate(S_T_U(a),c);
	weight(c,f);
	/* m_i_i(1L,b); */
	b_skn_po(callocobject(),callocobject(),NULL,b);
	m_l_nv(f,S_PO_S(b));
	M_I_I(1L,S_PO_K(b));

	if (S_O_K(S_T_U(a)) == PARTITION) 
		{
		for (i=0L; i<S_PA_LI(c); i++)
			{
			b_sk_mo(callocobject(),callocobject(),d);
			m_l_nv(f,S_MO_S(d));
			M_I_I(1L,S_MO_K(d));
			for (j=0L;j<S_PA_II(c,i);j++)
				m_i_i(1L,S_MO_SI(d,
/* s_t_iji statt S_T_IJI wg MSC */
					s_t_iji(a,j,S_PA_LI(c)-1L-i)-1L));
			
			vander_gen(d,e); /* e ist poly auch falls 1*/
			mult_apply(e,b);
			}
		}
	if (S_O_K(S_T_U(a)) == SKEWPARTITION) 
		{
		for (i=0L; i<S_SPA_GLI(c); i++)
			{
			b_sk_mo(callocobject(),callocobject(),d);
			m_l_nv(f,S_MO_S(d));
			M_I_I(1L,S_MO_K(d));
			for (j=spaltenanfang(a,i);j<=spaltenende(a,i);j++)
				{
				m_i_i(1+spaltenanfang(a,i),
				       S_MO_SI(d,S_T_IJI(a,j,i)-1L) );
				}
			
			vander_gen(d,e); /* e ist poly auch falls 1*/
			mult_apply(e,b);
			}
		}
	freeall(c);
	freeall(d);
	freeall(e);
	freeall(f);
	return OK;
}
#endif /* TABLEAUXTRUE */
