/* file: bruch.c */

#include "def.h"
#include "macro.h"

static struct bruch * callocbruch();

#ifdef BRUCHTRUE
INT add_bruch_scalar(a,b,c) OP a, b, c;
/* AK 050789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg=OK;
	OP d = callocobject();
	erg += m_scalar_bruch(b,d); 
	erg += add_bruch_bruch(a,d,c); /* hat kuerzen */
	erg += freeall(d); 
	if (erg != OK)
		return error("add_bruch_scalar: error in computing");
	return erg;
}
#endif  /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT add_bruch_bruch(a,b,c) OP a, b, c;
/* AK 050789 V1.0 */ /* AK 181289 V1.1 */ /* AK 270291 V1.2 */
/* AK 200891 V1.3 */
{
	OP  zw2;
	/* AK 071091 ohne zw1 */
	INT erg =OK;

	erg += b_ou_b(callocobject(),callocobject(),c);
	erg += mult(S_B_U(a),S_B_U(b),S_B_U(c));
	zw2 = callocobject();
	erg += mult(S_B_O(a), S_B_U(b), S_B_O(c));
	erg += mult(S_B_U(a), S_B_O(b), zw2);
	erg += add_apply(zw2,S_B_O(c));

	erg += freeall(zw2); 
	erg += kuerzen(c); 
	if (erg != OK) 
		return error("add_bruch_bruch: error in computing");
		
	return erg;
}
#endif  /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT add_bruch(a,b,c) OP a,b,c;
/* AK 310888 */ /* AK 050789 V1.0 */ /* AK 181289 V1.1 */
/* AK 270291 V1.2 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	switch(S_O_K(b))
		{
		case INTEGER:
		case LONGINT: erg +=  add_bruch_scalar(a,b,c);break;
		case BRUCH: erg +=  add_bruch_bruch(a,b,c); break;
		default :
			printobjectkind(b);
			error("add_bruch:wrong second type"); 
			return ERROR;
		};
	if (erg != OK) 
		error("add_bruch: error in computing");
	return erg;
}
#endif  /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT negp_bruch(a) OP a;
/* AK 050789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	if (negp(S_B_O(a))) { 
		if (negp(S_B_U(a))) return(FALSE);
		else return(TRUE); 
	}
	if (negp(S_B_U(a))) return(TRUE);
	return(FALSE);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT einsp_bruch(a) OP a;
/* AK 050789 V1.0 */ /* AK 081289 V1.1 */ /* AK 200891 V1.3 */
{
	return EQ(S_B_O(a),S_B_U(a));
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT negeinsp_bruch(a) OP a;
/* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	OP c = callocobject();
	INT erg;
	addinvers(S_B_O(a),c);
	erg = EQ(c,S_B_U(a));
	freeall(c);
	return(erg);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT nullp_bruch(a) OP a;
/* AK 050789 V1.0 */ /* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{ return (nullp(S_B_O(a))); }
#endif /* BRUCHTRUE */



#ifdef BRUCHTRUE
INT addinvers_bruch(a,b) OP a,b;
/* AK 290388*/ /* AK 050789 V1.0 */ /* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),b);
	addinvers(S_B_O(a),S_B_O(b));
	return(copy(S_B_U(a),S_B_U(b)));
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT addinvers_apply_bruch(a) OP a;
/* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{ return(addinvers_apply(S_B_O(a))); }
#endif /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT invers_bruch(a,b) OP a,b;
/* AK 031286 */ /* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),b);
	copy(S_B_U(a),S_B_O(b)); 
	copy(S_B_O(a),S_B_U(b));
	return(OK);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_bruch_integer(a,b,c) OP a,b,c;
/* AK 040789 V1.0 */ /* AK 081289 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	/* AK fuer integer und longint */
	erg += copy(a,c);
	erg += mult(b,S_B_O(a),S_B_O(c));
	erg += kuerzen(c);
	if (erg != OK)
		return error("mult_bruch_integer: error in computing");
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_bruch_bruch(a,b,ergebnis) OP a,b,ergebnis;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	erg += b_ou_b(callocobject(),callocobject(),ergebnis);
	erg += mult(S_B_O(a),S_B_O(b),S_B_O(ergebnis));
	erg += mult(S_B_U(a),S_B_U(b),S_B_U(ergebnis));
	erg += kuerzen(ergebnis);
	if (erg != OK)
		return error("mult_bruch_bruch: error in computing");
	return erg;
}
#endif /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT tex_bruch(a) OP a;
/* AK 070291 V1.2 */ /* AK 300791 V1.3 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	erg += tex(S_B_O(a));
	fprintf(texout," $/$ ");
	texposition += 5L;
	erg += tex(S_B_U(a));
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT fprint_bruch(a,b) FILE *a; OP b;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 040391 V1.2 */
/* AK 200891 V1.3 */
{
	extern INT zeilenposition;
	if (nullp(S_B_O(b))) {
		freeself_bruch(b); 
		M_I_I(0L,b); 
		fprint_integer(a,b);
		return(OK); 
		}

	fprint(a,S_B_O(b)); 
	fprintf(a,"/"); 
	if (a == stdout) 
		{
		if (zeilenposition > 70L) 
			{
			zeilenposition = 0L; 
			fprintf(a,"\n");
			}
		else
			zeilenposition++;
		}
	fprint(a,S_B_U(b));
	return OK;
}
#endif /* BRUCHTRUE */



#ifdef BRUCHTRUE
INT freeself_bruch(bruch) OP bruch;
/* AK 050789 V1.0 */ /* AK 211189 V1.1 */ /* AK 200891 V1.3 */
{
	OBJECTSELF d;
	d = S_O_S(bruch);
	if (S_B_U(bruch) == S_B_O(bruch)+1)
		{
		if (S_O_K(S_B_O(bruch)) != INTEGER) freeself(S_B_O(bruch));
		if (S_O_K(S_B_U(bruch)) != INTEGER) freeself(S_B_U(bruch));
		free(S_B_O(bruch));
		}
	else    {
		if (S_O_K(S_B_O(bruch)) == INTEGER) free(S_B_O(bruch));
		else freeall(S_B_O(bruch)); 
		if (S_O_K(S_B_U(bruch)) == INTEGER) free(S_B_U(bruch));
		else freeall(S_B_U(bruch)); 
		}
	free(d.ob_bruch); C_O_K(bruch,EMPTY);
	return(OK);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT copy_bruch(von,nach) OP von, nach;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	OP a;
	a = (OP) calloc(2 , sizeof(struct object));
	if (a == NULL) 
		return error("copy_bruch: no mem");
	/*
	b_ou_b(callocobject(),callocobject(),nach);
	*/
	b_ou_b(a,a+1,nach);
	if (S_O_K(S_B_O(von)) == INTEGER) *S_B_O(nach) = *S_B_O(von);
	else copy(S_B_O(von),S_B_O(nach)); 
	if (S_O_K(S_B_U(von)) == INTEGER) *S_B_U(nach) = *S_B_U(von);
	else copy(S_B_U(von),S_B_U(nach));
	return(OK);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
static struct bruch * callocbruch()
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	struct bruch *
	ergebnis = (struct bruch *) malloc( sizeof(struct bruch));
	if (ergebnis == NULL) error("callocbruch:no memory");
	return ergebnis;
}
#endif /* BRUCHTRUE */



#ifdef BRUCHTRUE
INT m_ou_b(oben,unten,ergebnis) OP oben, unten,ergebnis;
/* AK 221190 V1.1 */ /* AK 200891 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),ergebnis);
	copy(oben, S_B_O(ergebnis));
	copy(unten, S_B_U(ergebnis)); 
	return OK;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT b_ou_b(oben,unten,ergebnis) OP oben, unten,ergebnis;
/* AK 050789 V1.0 */ /* AK 071289 V1.1 */ /* AK 200891 V1.3 */
{
	OBJECTSELF d;

	d.ob_bruch = callocbruch();
	B_KS_O(BRUCH, d, ergebnis);
	C_B_O(ergebnis,oben); 
	C_B_U(ergebnis,unten);
	return(OK);
}
#endif  /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT m_ioiu_b(oben,unten,ergebnis) INT oben,unten; OP ergebnis;
/* AK 030389
	ein bruch mit einem integer eintrag im zaehler und einem
	integer eintrag im nenner 
	z.b. oben = 3 unten = 5 --> 3/5
	*/
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),ergebnis);
	M_I_I(oben,S_B_O(ergebnis));
	M_I_I(unten,S_B_U(ergebnis));
	return(OK);
}
#endif /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT scan_bruch(ergebnis) OP ergebnis;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	OBJECTKIND kind;
	b_ou_b(callocobject(),callocobject(),ergebnis);
	printeingabe("bruch-zaehler");
	kind = scanobjectkind();
	scan(kind,S_B_O(ergebnis));
	printeingabe("bruch-nenner");
	kind = scanobjectkind();
	scan(kind,S_B_U(ergebnis));
	kuerzen(ergebnis);
	return(OK);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
OP s_b_o(a) OP a;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{

	OBJECTSELF c;
	c = s_o_s(a);
	return(c.ob_bruch->b_oben);
}

OP s_b_u(a) OP a;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{

	OBJECTSELF c;
	c = s_o_s(a);
	return(c.ob_bruch->b_unten);
}

INT s_b_oi(a) OP a; 
/* AK 240789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	return(s_i_i(s_b_o(a)));
}

INT s_b_ui(a) OP a; 
/* AK 240789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{
	return(s_i_i(s_b_u(a)));
}

INT c_b_o(a,b) OP a,b;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{

	OBJECTSELF c;
	c = s_o_s(a);

	c.ob_bruch->b_oben = b;
	return(OK);
}

INT c_b_u(a,b) OP a,b;
/* AK 050789 V1.0 */ /* AK 010290 V1.1 */ /* AK 200891 V1.3 */
{

	OBJECTSELF c;
	c = s_o_s(a);

	c.ob_bruch->b_unten = b;
	return(OK);
}

#endif /* BRUCHTRUE */
#ifdef BRUCHTRUE
INT posp_bruch(a) OP a;
/* AK 040590 V1.1 */ /* AK 200891 V1.3 */
	{
	if (nullp(S_B_O(a))) return(FALSE);
	if (posp(S_B_O(a))) {
		if (posp(S_B_U(a))) return(TRUE);
		return(FALSE);
		}
	if (negp(S_B_U(a))) return(TRUE);
	return(FALSE);
	}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT comp_bruch(a,b) OP a,b;
/* AK 030389 VERGLEICH ZWISCHEN bruechen */
/* AK 050789 V1.0 */
/* AK 310190 V1.1 */ /* fehler beseitigt von Isabel Klein */ 
/* AK 200891 V1.3 */
{
	if (S_O_K(b) == BRUCH)
	{
		/* a/b < c/d   <==>  ad < cb */
		INT erg;
		OP c = callocobject(),d = callocobject();
		mult(S_B_O(a),S_B_U(b),c); 
		mult(S_B_O(b),S_B_U(a),d);
                if 	(
			(negp(S_B_U(a)) && negp(S_B_U(b))) 
			|| 
			(posp(S_B_U(a)) && posp(S_B_U(b)))
			)
		   erg = comp(c,d); 
                else 
                   erg = comp(d,c);
		freeall(c); freeall(d); return(erg);
	}
	else if (scalarp(b))
		return(comp_bruch_scalar(a,b));
	else	{
		printobjectkind(b);
		return error("comp_bruch: wrong second type");
	}
}
#endif  /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT comp_bruch_scalar(a,b) OP a,b;
/* AK 050789 V1.0 */ /* AK 310190 V1.1 */ /* AK 200891 V1.3 */
{
	/* a/b < c   <==>  a < cb */
	INT erg;
	OP c = callocobject();
	mult(S_B_U(a),b,c); 
	erg = comp(S_B_O(a),c);
	freeall(c); 
	return(erg);
}
#endif /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT kuerzen(bruch) OP bruch;
/* AK 050789 V1.0 */ /* AK 061289 V1.1 */ /* AK 100791 V1.3 */
{
	OP ggterg, moderg;
	INT erg=OK;
	INT ggtierg,vorzeichen=1L;

	if (S_O_K(bruch) != BRUCH) /* AK 070789 */ return(OK); 

	if (nullp(S_B_O(bruch)))
		{ 
		freeself(bruch); 
		M_I_I(0L,bruch); 
		return(OK); 
		}

	if (
	    (S_O_K(S_B_O(bruch)) == INTEGER) &&
	    (S_O_K(S_B_U(bruch)) == INTEGER) )
	{
		INT oi = S_B_OI(bruch);
		INT ui = S_B_UI(bruch);
		/* bruch mit oben und unten INTEGER */
		/* AK 061289 */
		if (oi == ui)
			{ 
			freeself_bruch(bruch); 
			M_I_I(1L,bruch); 
			return(OK); 
			}
		ggtierg = ggt_i(oi,ui);
		if (ggtierg == ui)
			{ 
			freeself_bruch(bruch); 
			M_I_I(oi/ggtierg,bruch); 
			return(OK); 
			}
		if (ui/ggtierg == 1L) 
			{
			freeself_bruch(bruch); 
			M_I_I(oi/ggtierg,bruch); 
			return(OK); 
			}
		if (ui/ggtierg == -1L) 
			{
			freeself_bruch(bruch); 
			M_I_I(-oi/ggtierg,bruch); 
			return(OK); 
			}
		M_I_I(oi/ggtierg,S_B_O(bruch));
		M_I_I(ui/ggtierg,S_B_U(bruch));
		return(OK);
	}

	moderg = callocobject();
	if (negp(S_B_U(bruch))) { 
			vorzeichen *= -1L;
			erg += addinvers_apply(S_B_U(bruch));
			}
	if (negp(S_B_O(bruch))) { 
			vorzeichen *= -1L;
			erg += addinvers_apply(S_B_O(bruch));
			}


	ggterg = callocobject();
	
	erg += ggt(S_B_O(bruch),S_B_U(bruch),ggterg);

	erg += ganzdiv(S_B_O(bruch),ggterg,S_B_O(bruch));
	erg += ganzdiv(S_B_U(bruch),ggterg,S_B_U(bruch));
	erg += freeall(ggterg);

	if (einsp(S_B_U(bruch)) )
		{
		copy(S_B_O(bruch),moderg);
		freeself(bruch);
		*bruch = *moderg;
		if (vorzeichen == -1L) 
			erg += addinvers_apply(bruch);
		free(moderg);
		return OK;
		}

	erg += freeall(moderg);
	if (vorzeichen == -1L) 
		erg += addinvers_apply(bruch);
	if (erg != OK)
		return error("kuerzen: error in computing");
	return erg;
}
#endif  /* BRUCHTRUE */


#ifdef BRUCHTRUE
INT m_scalar_bruch(a,b) OP a,b;
/* AK 210387 macht aus scalar bruch */
/* die integerzahl 5 wird z.B. 5/1 */
/* AK 050789 V1.0 */ /* AK 040590 V1.1 */
/* AK 050789 V1.0 */ /* AK 061289 V1.1 */ /* AK 100791 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),b);
	M_I_I(1L,S_B_U(b)); 
	copy(a,S_B_O(b));
	return(OK);
}
#endif  /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_apply_scalar_bruch(a,b) OP a,b;
/* AK 150290 V1.1 */ /* AK 100791 V1.3 */
{
	INT erg = OK;
	erg += mult_apply(a,S_B_O(b));
	erg += kuerzen(b);
	if (erg != OK)
		error("mult_apply_scalar_bruch: error in computing");
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_apply_bruch_scalar(a,b) OP a,b;
/* AK 140290 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	OP c = callocobject();
	*c = *b;
	C_O_K(b,EMPTY);
	erg += copy_bruch(a,b);
	erg += mult_apply_scalar_bruch(c,b); /* hat kuerzen */
	erg += freeall(c);
	if (erg != OK)
		error("mult_apply_bruch_scalar: error in computing");
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT add_apply_bruch_bruch(a,b) OP a,b;
/* b = b + a */ 
/* AK 220390 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	OP c = callocobject();
	*c = *b; 
	C_O_K(b,EMPTY); 
	erg += add_bruch_bruch(a,c,b);  /* hat kuerzen */
	erg += freeall(c);
	if (erg != OK)
		return error("add_apply_bruch_bruch: error in computing");
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT add_apply_bruch_scalar(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 200891 V1.3 */
{
	OP c = callocobject();
	*c = *b; 
	C_O_K(b,EMPTY); 
	add_bruch_scalar(a,c,b); 
	freeall(c);
	return(OK);
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT add_apply_scalar_bruch(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 050791 V1.3 */
{
	OP c = callocobject();
	INT erg = OK;
	*c = *b; 
	C_O_K(b,EMPTY); 
	erg += add_bruch_scalar(c,a,b); 
	erg += freeall(c);
	return erg;
}
#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE

INT add_apply_bruch(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 190291 V1.2 */ /* AK 050791 V1.3 */
{
	INT erg = OK;
	switch (S_O_K(b)) {
		case BRUCH: 
			erg += add_apply_bruch_bruch(a,b); break;
		case LONGINT:
		case INTEGER: 
			erg += add_apply_bruch_scalar(a,b); break;
		default:
			{
			OP c = callocobject();
			*c = *b;
			C_O_K(b,EMPTY);
			erg += add(a,c,b);
			erg += freeall(c);
			break;
			}
		}
	erg += kuerzen(b);
	if (erg != OK)
		{
		error("add_apply_bruch:error during computation");
		}
	return erg;
}

#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_apply_bruch(a,b) OP a,b;
/* a is BRUCHobject */
/* AK 140290 V1.1 */ /* AK 190291 V1.2 */ /* AK 200891 V1.3 */
{
	OP c;
	INT erg=OK;
	switch (S_O_K(b)) {
		case BRUCH: erg += mult_apply(S_B_O(a),S_B_O(b));
			    erg += mult_apply(S_B_U(a),S_B_U(b));
				erg += kuerzen(b);
				break;

		case INTEGER: 
		case LONGINT:  erg+= mult_apply_bruch_scalar(a,b);
				erg += kuerzen(b);
				break;
#ifdef MATRIXTRUE
		case MATRIX: erg += mult_apply_scalar_matrix(a,b);
				break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM: erg += mult_apply_scalar_monom(a,b);
				break;
#endif /* MONOMTRUE */
#ifdef POLYTRUE
		case POLYNOM: erg += mult_apply_scalar_polynom(a,b);
				break;
#endif /* POLYTRUE */
		default:
			c = callocobject();
			erg+=mult(a,b,c);
			erg+=freeself(b);
			*b = *c;
			free(c);
		}
	if (erg != OK)
		{
		error("mult_apply_bruch: error during computation");
		}
	return erg;
}

#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT mult_bruch(a,b,c) OP a,b,c;
/* AK 050789 V1.0 */ /* AK 140290 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	switch( S_O_K(b)) {

	case BRUCH:  erg += mult_bruch_bruch(a,b,c);break;
#ifdef INTEGERTRUE
	case LONGINT:
	case INTEGER: erg += mult_bruch_integer(a,b,c);break;
#endif /* INTEGERTRUE */
#ifdef MATRIXTRUE
	case MATRIX: erg += mult_scalar_matrix(a,b,c);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
	case MONOM: erg += mult_scalar_monom(a,b,c);break;
#endif /* MONOMTRUE */
#ifdef POLYTRUE
	case GRAL:
	case POLYNOM: erg += mult_scalar_polynom(a,b,c);break;
#endif /* POLYTRUE */
#ifdef SCHURTRUE
	case SCHUR: erg += mult_scalar_schur(a,b,c);break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
	case SYMCHAR: erg += mult_scalar_symchar(a,b,c);break;
#endif /* CHARTRUE */
#ifdef VECTORTRUE
	case VECTOR:  erg += mult_scalar_vector(a,b,c);break;
#endif /* VECTORTRUE */
	default: 
		printobjectkind(b);
		error("mult_bruch: wrong second type");
		return(ERROR);
	};
	if (erg != OK) 
		return error("mult_bruch: error in computing");
	return erg;
}

#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT test_bruch()
/* AK 150290 V1.1 */ /* AK 200891 V1.3 */
{
	OP a= callocobject();
	OP b= callocobject();
	OP c= callocobject();

	printf("test_bruch:scan(a) ");
	scan(BRUCH,a);
	println(a);
	printf("test_bruch:scan(b) ");
	scan(BRUCH,b);
	println(b);
	printf("test_bruch:posp(a) ");
	if (posp(a)) {printf(" a ist positiv\n");}
	else  {printf(" a ist nicht positiv\n");}
	printf("test_bruch:einsp(a) ");
	if (einsp(a)) {printf(" a ist eins\n");}
	else  {printf(" a ist nicht eins\n");}

	printf("test_bruch:add(a,b,c) ");
	add(a,b,c);
	println(c);
	printf("test_bruch:mult(a,b,c) ");
	mult(a,b,c);
	println(c);
	printf("test_bruch:kuerzen(c) ");
	kuerzen(c); println(c);
	freeall(a); freeall(b); freeall(c);
	return(OK);
}

#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT objectwrite_bruch(f,a) FILE *f; OP a;
/* AK 200690 V1.1 */ /* AK 200891 V1.3 */
{
	fprintf(f,"%ld\n", (INT)BRUCH);
	objectwrite(f,S_B_O(a));
	objectwrite(f,S_B_U(a)); return OK;
}

#endif /* BRUCHTRUE */

#ifdef BRUCHTRUE
INT objectread_bruch(f,a) FILE *f; OP a;
/* AK 200690 V1.1 */ /* AK 200891 V1.3 */
{
	b_ou_b(callocobject(),callocobject(),a);
	objectread(f,S_B_O(a));
	objectread(f,S_B_U(a)); return OK;
}
#endif /* BRUCHTRUE */
