

#include "def.h"
#include "macro.h"

#ifdef DGTRUE    /* Darstellungen werden benoetigt */

#define ALLOCOFFSET 0

#define mod(a,b) (((a)%(b))<0L?(a)%(b)+(b):(a)%(b))/* mod(a,b)=a mod b >= 0 */
#define adp(x,y,p) mod((x)+(y),p)
#define mulp(x,y,p) mod((x)*(y),p)
#define divp(x,y,p) mulp((x),invp(y,p),p)
/*
  Macros for portability of ANSI- and KR-standard
*/
static INT fak();
static INT nexgitt();
static INT _ber_idx_pelem();
static INT darmod();
static INT lmatmulp();
static INT rmatmulp();
static INT homtestp();

#ifdef ANSI

#define AH(x,y) x y /* ANSI-Header */
#define KH(x)       /* Kernighan/Ritchie-Header */
#define EH(x) x     /* Extern-Header */
#define _EH(x) ,x   /* Extern-Header Ende */

#else /* ANSI */

#define AH(x,y) y
#define KH(x) x;
#define EH(x)
#define _EH(x)

#endif /* ANSI */
/*
  Global variables of MODULDAR
*/
/*******************************************************************************
*
* Datei MODDGGLB.C
*
* Globale Variablen, die eventuell geaendert werden muessen.
*
*******************************************************************************/
/*
  Ueblicher Headerfile...
*/

static INT idmat();
/*
  Globale Variablen des Programmpakets MODULDAR
*/
INT MAXN = 20L;
INT MAXZEILENZ = 20L;
INT MAXSPALTENZ = 20L;
INT MAXDM = 2000L;
INT ZYK = 200L;
INT PZ[] = {2L,3L,5L,7L,11L,13L,17L,19L,23L,29L};
FILE  *stream = NULL;

/*
  Defines of possible errors
*/
#define LmbNul -10L
#define LmbEmp -11L
#define LmbLt_null -12L
#define LmbNRg -13L
#define NLe_null -14L
#define NGtMax -15L
#define ZzGtMx -16L
#define SzGtMx -17L
#define DmGtMx (-18L)
#define BzNul -19L
#define CntOFl -20L
#define DimLe_null -21L
#define DrtNul -22L
#define GzlNul -23L
#define NoPrm -24L
#define PrmLe_null -25L
#define PrmGtN -26L
#define NoSolu -27L
#define DDmLt_null -28L
#define DDmGMx -29L
#define PerNul -30L
#define PerLe_null -31L
#define PerGtN -32L
#define PeLgGN -33L
#define RTabFt -9998L
#define NtEMem -9999L

/*
  Macros for modulararithmetic


  Die Modulararithmetik berechnet Summen (adp), Produkte (mulp),
  Inverse (invp) und Quotienten (divp) modulo p. Bei Verwendung der
  entsprechenden Funktionen muss p als Parameter uebergeben werden.
*/

/*
  und schliesslich globale Variablen.
*/
static INT _zeilenz;
static INT q_zeilenz;
static INT _spaltenz;
static INT _n;
static INT _zyk;
#ifdef UNDEF
#define COEFF(x,y,z) ((z-y)%2L)?((-1L)*fak(x+y-2L*z)*fak(z-y)*fak(z)) \
      : (fak(x+y-2L*z)*fak(z-y)*fak(z))
#endif
INT COEFF(x,y,z) INT x,y,z; 
	{
	return ((z-y)%2L)?((-1L)*fak(x+y-2L*z)*fak(z-y)*fak(z)) 
      : (fak(x+y-2L*z)*fak(z-y)*fak(z)) ;
	}

/*----------------------------------------------------------------------------*/
INT _k_zweikonmat(AH(INT *,lambda),AH(INT *,bz),AH(INT,pz))
/*-----------------------------------------------------------------------------
  berechnet die Koeffizientenmatrix B zu einer Partition lambda, deren
  Laenge gleich zwei ist. Dabei werden die Elemente der Matrix modulo pz
  abgelegt. (Vgl. MODULKFF.C Funktion zweikonmat().)
  Variablen:  lambda, Partition;
              pz, Primzahl.
  Reuckgabe Koeffizientenmatrix bz.
  Rueckgabewerte: >0L, Dimension der gewoehnlichen irred. Darstellung;
               -9999L, falls nicht genuegend Speicher zur Verfuegung stand.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *bz) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,l,z,zaehl,mdim,dim,*g_i,*g_j,*start;
  INT *_bz,g_im,g_jm;

  start=(INT *)calloc(ALLOCOFFSET+(int)_n*3,sizeof(INT));
  if (!start) return no_memory();
  g_i=start+(INT)_n;
  g_j=g_i+(INT)_n;
  mdim=MAXDM;
  g_im=FALSE;
  if (nexgitt(start,lambda,&g_im))
  {
    free(start);return no_memory();
  }
  for (z=0L;z<_n;g_i[z]=start[z],z++);
  _bz=bz;
  for (i=0L,g_im=TRUE;g_im;i++)
  {
    for (z=0L;z<_n;g_j[z]=start[z],z++);

    for (j=0L,g_jm=TRUE;g_jm;j++)
    {
      for (l=0L,zaehl=0L;l<_n;l++)
        if (g_i[l]==1L && g_j[l]==1L) zaehl++;
      *_bz++ = (INT) mod( COEFF(_n,zaehl,lambda[1]) ,pz);
      if (nexgitt(g_j,lambda,&g_jm))
	      { free(start);
                return  no_memory(); }
    }
    if (!i)
    {
      dim=j;
      if (dim>MAXDM)
      {
        dim *= (-1L);
        break;
      }
    }
    if (dim<mdim)
      mdim=dim;
    if (nexgitt(g_i,lambda,&g_im))
    {
      free(start);return no_memory();
    }
  }
  free(start);return(dim);
} /* k_zweikonmat */




/*
  Externe Funktion der Modulararithmetik aus MODULARI.C
*/
/*******************************************************************************
*
* Datei MODULARI.C
*   Version vom 29.09.1989
*
*
* Zeile Funktion
*
*       Funktion zur Berechnung des modular Inversen
*       --------------------------------------------
* 30    INT invp(INT z,INT p)
*
*******************************************************************************/
/*
  Uebliche...
*/



/*----------------------------------------------------------------------------*/
INT invp(AH(INT,z),AH(INT,p))
/*------------------------------------------------------------------------------
  berechnet das Inverse von z in GF(p) mit Hilfe Euklids.
  Variablen:  z,  ganze Zahl;
              p,  Primzahl.
  Rueckgabewert:  Inverses von z in GF(p).
------------------------------------------------------------------------------*/
KH(INT z) KH(INT p)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT x[2],y[2],yh,i,q,r;

  x[0]=1L;
  x[1]=(INT)abs(z);
  y[0]=0L;
  y[1]=(INT)abs(p);
  if (x[1]<y[1])
    for (i=0L;i<2L;++i)
    {
      yh=y[i];
      y[i]=x[i];
      x[i]=yh;
    }
  while (y[1]>0L)
  {
    while (2L*y[1]>x[1])
      for (i=0L;i<2L;++i)
      {
        yh=y[i];
        y[i]=x[i]-y[i];
        x[i]=yh;
      }
    q=x[1]/y[1];
    r=x[1]%y[1];
    yh=y[0];
    y[0]=x[0]-q*y[0];
    x[0]=yh;
    x[1]=y[1];
    y[1]=r;
  }
  x[0]= z<0L ? -x[0] : x[0];
  return(((x[0]%p)<0L) ? x[0]%p+p : x[0]%p);
} /* invp */


/*
  Makros zur Modulararithmetik
*/

/*******************************************************************************
*
* Datei MODULKFF.C
*   Version vom 29.09.89
*
*
* Zeile Funktion
*
*
*       Funktionen fuer Mengenoperationen
*       ---------------------------------
* 88    INT setmin(INT *a)
* 107   INT a_teilmenge_b(INT *a,INT *b)
* 129   INT leer(INT *a)
* 148   a_ohne_b_gl_c(INT *a,INT *b,INT *c)
*
*       Funktionen zur Berechnung der Koeffizientenmatrix (B,C_eins,C_zwei)
*       -----------------------------------------------------------
* 175   INT zykschnitt(INT *t_eins,INT *t_zwei,INT *perm,INT *zykmt)
* 216   INT inzeil(INT la,INT *zmat,INT *fln)
* 355   INT j_zyk(INT la,INT j_zwei,INT **xm,INT *zh)
* 454   INT k_alzyk(INT la,INT *zmat,INT *fln,INT *cy)
* 523   INT alzyk(INT la,INT *zmat,INT *fln,INT *cy)
* 547   INT sigper(INT *fln,INT la)
* 586   INT symdet(INT *mat,INT *slambda,INT li,INT *tsc)
* 804   INT fak(INT i)
* 820   INT alcoeff(INT *mat,INT *slambda)
* 849   INT nexgitt(INT *y,INT *lambda,INT *mtc)
* 918   INT zweikonmat(INT *lambda,INT *perm,INT *bz)
* 1003  konjugiere(INT *lambda,INT *lambdastrich)
* 1025  schnitt(INT *t_eins,INT *t_zwei,INT *mat)
* 1043  INT mat_comp(INT *co,INT *mat,INT *slamda,FILE *sfp)
*
*       Hauptfunktion
*       -------------
* 1099  INT alkonmat(INT *lambda,INT *perm,INT *bz)
*
*******************************************************************************/
/*
  Headerfiles wie in jedem C-Programm,...
*/




/*
  interne Makros ...
*/
#define IND(a,b,c) (INT)((INT)(a)*(INT)(c)+(INT)(b))
/*
#define COEFF(x,y,z) ((z-y)%2L)?((-1L)*fak(x+y-2L*z)*fak(z-y)*fak(z)) \
      : (fak(x+y-2L*z)*fak(z-y)*fak(z))
*/
#define INDEX(x) ZYK/2+x



/*******************************************************************************
*
* Funktionen fuer Mengenoperationen ...
*
* Mengen sind Felder a mit Eintraegen a[i]:
* Element i nicht enthalten => a[i]=0
* Element i enthalten => a[i]=1
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
INT setmin(AH(INT *,a))
/*------------------------------------------------------------------------------
  errechnet das Minimum der Menge a.
  Rueckgabewerte: Elementnummer m, falls m Minimum ist;
                  -1L, falls kein Minimum existiert.
------------------------------------------------------------------------------*/
KH(INT *a)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_a;
  INT m;

  for (m=0L,_a=a;m<_n;m++,_a++)
  if (*_a)
    return(m);
  return(-1L);
}


/*----------------------------------------------------------------------------*/
INT a_teilmenge_b(AH(INT *,a),AH(INT *,b))
/*------------------------------------------------------------------------------
  ueberprueft, ob Menge a Teilmenge von Menge b ist.
  Rueckgabewerte: TRUE, falls a Teilmenge von b ist;
                 FALSE, falls a nicht Teilmenge von b ist.
------------------------------------------------------------------------------*/
KH(INT *a) KH(INT *b)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_a,*_b;
  INT m;

  for (m=0L,_a=a,_b=b;m<_n;m++,_a++,_b++)
    if (*_a)
    {
      if (! *_b)
        return(FALSE);
    }
  return(TRUE);
}


/*----------------------------------------------------------------------------*/
INT leer(AH(INT *,a))
/*------------------------------------------------------------------------------
  ueberprueft, ob die Menge a leer ist.
  Rueckgabewerte: TRUE, falls a leer ist;
                 FALSE, falls a nicht leer ist.
------------------------------------------------------------------------------*/
KH(INT *a)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_a;
  INT m;

  for (m=0L,_a=a;m<_n;m++,_a++)
    if (*_a)
      return (FALSE);
  return (TRUE);
}


/*----------------------------------------------------------------------------*/
a_ohne_b_gl_c(AH(INT *,a),AH(INT *,b),AH(INT *,c))
/*------------------------------------------------------------------------------
  berechnet die Menge a\b.
  Rueckgabe Menge c = a\b.
------------------------------------------------------------------------------*/
KH(INT *a) KH(INT *b) KH(INT *c)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_a,*_b,*_c;
  INT m;

  for (m=0L,_a=a,_b=b,_c=c;m<_n;m++,_a++,_b++,_c++)
  {
    *_c = *_a;
    if (*_b)
      *_c = 0L;
  }
}


/*******************************************************************************
*
* Funktionen fuer die Bestimmung der Koeffizientenmatrix (B,C_eins,C_zwei)...
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
INT zykschnitt (AH(INT *,t_eins),AH(INT *,t_zwei),AH(INT *,perm),AH(INT *,zykmt))
/*------------------------------------------------------------------------------
  berechnet Schnittmatrix zykmt in Abhaengigkeit von der Permutation perm.
  Rueckgabewerte: 0L, falls alles ohne Fehler durchgefuehrt werden konnte;
              -9999L, falls nicht genuegend Speicher zu Verfuegung steht.
  Rueckgabe Schnittmatrix zykmt.
------------------------------------------------------------------------------*/
KH(INT *t_eins) KH(INT *t_zwei) KH(INT *perm) KH(INT *zykmt)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,*zeile,*z;
  INT enthalten;

  zeile=(INT *)calloc(ALLOCOFFSET+(int)_n*(int)_n,sizeof(INT));
  if (!zeile) return no_memory();
  for (i=q_zeilenz,z=zykmt;i>0L;i--,*z++ = 0L);
/*
  Berechnung der Zeilenziffernmengen von (perm)T2:
*/
  for (i=_n-1L;i>=0L;--i)
    zeile[IND(t_zwei[i],perm[i]-1L,_n)]=1L;
  for (j=0L;j<_n;++j)
  {
    enthalten=FALSE;
    i=0L;
    do
    {
      if (zeile[IND(i,j,_n)])
      {
        ++zykmt[IND(t_eins[j],i,_zeilenz)];
        enthalten=TRUE;
      }
      else
        ++i;
    } while (!enthalten);
  }
  free(zeile);
  return(0L);
} /* zykschnitt */


/*----------------------------------------------------------------------------*/
INT inzeil(AH(INT,la),AH(INT *,zmat),AH(INT *,fln))
/*------------------------------------------------------------------------------
  bestimmt, falls moeglich, paarweise verschiedene Ziffern i_eins,i2L,...,ilambda1L,
  welche die injektive erste Zeile eines Elementes von [Ts]c darstellen.
  (Weitere Erlaeuterung in:
    Golembiowski, Andreas
      Zur Berechnung modular irreduzibler Matrixdarstellungen symmetrischer
      Gruppen mit Hilfe eines Verfahrens von M.Clausen
    Bayreuther Mathematische Schriften Heft 25L, Bayreuth 1987
    SS. 162ff)
  Variablen:  la, Teil der konjugierten Partition;
              zmat, Schnittmatrix.
  Rueckgabewerte: -9999L, falls kein Speicher zur Verfuegung stand;
                      0L, sonst.
  Rueckgabe Matrix fln.
------------------------------------------------------------------------------*/
KH(INT la) KH(INT *zmat) KH(INT *fln)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,i_eins,j,j_eins,r,k,m,oz;
  INT **xm,**qu,*ze[2],*un,*hilf;

  xm=(INT **)calloc(ALLOCOFFSET+(int)(_zeilenz+_zeilenz+2L),sizeof(INT *));
  if (!xm)
    return no_memory();
  qu=xm+(INT)_zeilenz+1L;
  hilf=(INT *)calloc(ALLOCOFFSET+(int)(_zeilenz+_zeilenz+6L)*(INT)_n,sizeof(INT));
  if (!hilf)
  {
    free(xm);
    return no_memory();
  }
  un=hilf+(INT)_n;
  ze[0]=un+(INT)_n;
  ze[1]=ze[0]+(INT)_n;
  xm[0]=ze[1]+(INT)_n;
  for (i=1L;i<=_zeilenz;xm[i]=xm[i-1]+(INT)_n,i++);
  qu[0]=xm[_zeilenz]+(INT)_n;
  for (i=1L;i<=_zeilenz;qu[i]=qu[i-1]+(INT)_n,i++);
  for (j=0L;j<la;fln[j++]= -1L);
  i=0L;
  while (fln[0]<0L)
    if (zmat[IND(i,0L,_zeilenz)])
      fln[0]=i;
    else
      ++i;
  ze[0][fln[0]]=1L;
  ze[1][0]=1L;
  r=1L;
  while (r<la)
  {
    for (m=0L;m<la;xm[0][m]=ze[0][m]?0L:1L, m++);
    for (m=0L;m<_n;qu[0][m++]=0L);
    for (j=0L;j<la;++j)
    {
      i=0L;
      oz=0L;
      while (!oz && i<la)
        if (xm[0][i] && zmat[IND(i,j,_zeilenz)])
        {
          qu[0][j]=1L;
          oz=1L;
        }
        else
          ++i;
    }
    for (m=0L;m<_n;un[m]=qu[0][m],m++);
    k=0L;
    while (a_teilmenge_b(qu[k],ze[1]) && (oz!=2L))
    {
      ++k;
      for (m=0L;m<_n;xm[k][m++]=0L);
      for (j=0L;j<la;++j)
        if (qu[k-1][j])
          xm[k][fln[j]]=1L;
      for (m=0L;m<_n;qu[k][m++]=0L);
      for (j=0L;j<la;++j)
      {
        for (m=0L;m<la;hilf[m]=un[m]?0L:1L,m++);
        if (hilf[j])
        {
          i=0L;
          oz=0L;
          while (!oz && i<la)
            if ((xm[k][i]) && (zmat[IND(i,j,_zeilenz)]))
            {
              qu[k][j]=1L;
              oz=1L;
            }
            else
              ++i;
        }
      }
      if (leer(qu[k]))
      {
        oz=2L;
        fln[0]= -1L;
      }
      else
        for (m=0L;m<_n;++m)
          if (qu[k][m])
            un[m]=1L;
    }
    if (oz!=2L)
    {
      a_ohne_b_gl_c(qu[k],ze[1],hilf);
      j_eins=setmin(hilf);
      ze[1][j_eins]=1L;
      ++r;
      i_eins=0L;
      while (fln[j_eins]<0L)
        if (xm[k][i_eins] && zmat[IND(i_eins,j_eins,_zeilenz)])
          fln[j_eins]=i_eins;
        else
          ++i_eins;
      while (k>=1L)
      {
        for (j=0L;fln[j]!=i_eins || j==j_eins;j++);
        j_eins=j;
        i=0L;
        while (fln[j_eins]==i_eins)
          if (xm[k-1][i] && zmat[IND(i,j_eins,_zeilenz)])
            fln[j_eins]=i;
          else
            ++i;
        i_eins=i;
        --k;
      }
      ze[0][i_eins]=1L;
    }
    else
      r=la;
  }
  free(hilf);
  free(xm);
  return(0L);
} /* inzeil */


/*----------------------------------------------------------------------------*/
INT j_zyk(AH(INT,la),AH(INT,j_zwei),AH(INT **,xm),AH(INT *,zh))
/*------------------------------------------------------------------------------
  berechnet Menge der Zyklen (j_null j_eins ... jk).
  (Weitere Erlaeuterung in:
    Golembiowski, Andreas
      Zur Berechnung modular irreduzibler Matrixdarstellungen symmetrischer
      Gruppen mit Hilfe eines Verfahrens von M.Clausen
    Bayreuther Mathematische Schriften Heft 25L, Bayreuth 1987
    SS. 166ff)
  Variablen:  la, Element der konjugierten Partition;
              j_zwei, erstes Element des Zykels;
              xm, Mengen.
  Rueckgabewerte: -9999L, nicht genug Speicher;
                      0L, sonst.
  Rueckgabe Vektor zh.
------------------------------------------------------------------------------*/
KH(INT la) KH(INT j_zwei) KH(INT **xm) KH(INT *zh)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,k,l,nr,m,*j;
  INT *ym,*hilf,**xm_eins;

  j=(INT *)calloc(ALLOCOFFSET+(int)_zeilenz+1,sizeof(INT));
  if (!j)
    return no_memory();
  xm_eins=(INT **)calloc(ALLOCOFFSET+(int)_zeilenz,sizeof(INT *));
  if (!xm_eins)
  {
    free(j);
    return no_memory();
  }
  hilf=(INT *)calloc(ALLOCOFFSET+(int)(_zeilenz+2L)*(int)_n,sizeof(INT));
  if (!hilf)
  {
    free(j);
    free(xm_eins);
    return no_memory();
  }
  ym=hilf+_n;
  xm_eins[0]=ym+_n;
  for (i=1L;i<_zeilenz;xm_eins[i]=xm_eins[i-1]+_n,i++);
  j[0]=j_zwei;
  for (i= -la;i<=ZYK;++i)
  {
    if ((i<la) && (i>=0L))
    for (m=0L;m<_n;xm_eins[i][m]=xm[i][m],m++);
    zh[INDEX(i)]=0L;
  }
  l=0L;
  nr=1L;
  while (!leer(xm_eins[j_zwei]))
  {
    for (m=0L;m<_n;ym[m++]=0L);
    k=1L;
    do
    {
      a_ohne_b_gl_c(xm_eins[j[k-1]],ym,hilf);
      j[k]=setmin(hilf);
      if (xm_eins[j[k]][j[0]])
      {
        ++nr;
        zh[INDEX(-nr)]=l+1L;
        ++zh[INDEX(-1L)];
        if (l==0L)
          zh[INDEX(0L)]=k+1L;
        else if ((k+1L)<(zh[INDEX(0L)]))
          zh[INDEX(0L)]=k+1L;
        zh[INDEX(l+1L)]=k+1L;
        zh[INDEX(l+2L)]=j[0]+1L;
        for (i=k+1L;i>=2L;--i)
          zh[INDEX(l+k+4-i)]=j[i-1]+1L;
        l=l+k+3L;
      }
      ym[j[k-1]]=1L;
      a_ohne_b_gl_c(xm_eins[j[k]],ym,hilf);
      if (!leer(hilf))
        ++k;
      else
      {
        while (leer(hilf) && (k>=1L))
        {
          xm_eins[j[k-1]][j[k]]=0L;
          ym[j[k]]=0L;
          for (m=0L;m<_n;xm_eins[j[k]][m]=xm[j[k]][m],m++);
          --k;
          a_ohne_b_gl_c(xm_eins[j[k]],ym,hilf);
        }
        if (k>=1L)
          ++k;
      }
    } while (k);
  }
  free(j);
  free(hilf);
  free(xm_eins);
  return(0L);
} /* j_zyk */


/*----------------------------------------------------------------------------*/
INT k_alzyk(la,AH(INT *,zmat),AH(INT *,fln),AH(INT *,cy))
/*------------------------------------------------------------------------------
  initialisiert Felder, die im Unterprogramm j_zyk benoetigt werden, und ruft
  j_zyk auf.
  (Weitere Erlaeuterung in:
    Golembiowski, Andreas
      Zur Berechnung modular irreduzibler Matrixdarstellungen symmetrischer
      Gruppen mit Hilfe eines Verfahrens von M.Clausen
    Bayreuther Mathematische Schriften Heft 25L, Bayreuth 1987
    SS. 168ff)
  Variablen:  la, Element der konjugierten Partition;
              zmat, Schnittmatrix;
              fln, Matrix aus inzeil.
  Rueckgabewerte: -9999L,  nicht genug Speicher;
      0L,  sonst.
  Rueckgabe Matrix aller Zyklen.
------------------------------------------------------------------------------*/
INT la; KH(INT *zmat) KH(INT *fln) KH(INT *cy)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j_eins,j_zwei,m,*zh,*z_eins,*z_zwei;
  INT **xm;

  xm=(INT **)calloc(ALLOCOFFSET+(int)_zeilenz,sizeof(INT *));
  if (!xm)
    return no_memory();
  xm[0]=(INT *)calloc(ALLOCOFFSET+(int)_zeilenz*(int)_n,sizeof(INT));
  if (!xm[0])
  {
    free(xm);
    return no_memory();
  }
  zh=(INT *)calloc(ALLOCOFFSET+(int)_zyk,sizeof(INT));
  if (!zh)
  {
    free(xm[0]);
    free(xm);
    return no_memory();
  }
  for (i=1L;i<_zeilenz;xm[i]=xm[i-1]+_n,i++);
  for (j_eins=0L,z_eins=zmat;j_eins<la;j_eins++,z_eins++)
  {
    j_zwei=fln[j_eins];
    for (m=0L;m<_n;(xm[j_zwei])[m++]=0L);
    for (i=0L,z_zwei=z_eins;i<la;i++,z_zwei += _zeilenz)
      if (*z_zwei && (i!=j_zwei))
        xm[j_zwei][i]=1L;
  }
  for (j_eins=0L;j_eins<la;++j_eins)
  {
    j_zwei=fln[j_eins];
    if (j_zyk(la,j_zwei,xm,zh))
    {
      free(xm[0]);
      free(xm);
      free(zh);
      return no_memory();
    }
    for (i= -(ZYK/2L),z_eins= &cy[IND(j_zwei,0L,_zyk)];i<=ZYK;i++,z_eins++)
      *z_eins=zh[INDEX(i)];
    for (m=0L;m<_n;xm[j_zwei][m++]=0L);
  }
  free(xm[0]);
  free(xm);
  free(zh);
  return(0L);
} /* k_alzyk */


/*----------------------------------------------------------------------------*/
INT alzyk(AH(INT,la),AH(INT *,zmat),AH(INT *,fln),AH(INT *,cy))
/*------------------------------------------------------------------------------
  ruft inzeil und k_alzyk koordiniert auf.
  Variablen:  la, Element der konjugierten Partition;
              zmat, Schnittmatrix.
  Rueckgabewerte: -9999L, nicht genug Speicher;
                      0L, sonst.
  Rueckgabe Matrix cy aller Zyklen und Matrix fln paarweise verschiedene
      Ziffern i_eins,...,ilambda1.
------------------------------------------------------------------------------*/
KH(INT la) KH(INT *zmat) KH(INT *fln) KH(INT *cy)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  if (inzeil(la,zmat,fln))
    return no_memory();
  if (fln[0]>=0L)
  {
    if (k_alzyk(la,zmat,fln,cy))
      return no_memory();
  }
  return(0L);
} /* alzyk */


/*----------------------------------------------------------------------------*/
INT sigper(AH(INT *,fln),AH(INT,la))
/*------------------------------------------------------------------------------
  berechnet sgn(fln).
  Variablen:  fln, gewisses pi* aus inzeil;
              la, Element aus konjugierter Partition.
  Rueckgabewert:  -9999L, falls nicht genuegend Speicher;
                 signum, sonst.
------------------------------------------------------------------------------*/
KH(INT *fln) KH(INT la)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *hilf,i,j,k,l,v;

  hilf=(INT *)calloc(ALLOCOFFSET+(int)_zeilenz,sizeof(INT));
  if (!hilf)
    return no_memory();
  for (i=0L;i<_zeilenz;hilf[i]=fln[i],i++);
  v=1L;
  for (i=0L;i<la;++i)
    if ((hilf[i]>=0L) && (hilf[i]!=i))
    {
      l=1L;
      j=hilf[i];
      while (j>=0L && hilf[j]!=i)
      {
        ++l;
        k=hilf[j];
        hilf[j]= -1L;
        j=k;
      }
      hilf[j]= -1L;
      if (l%2L)
        v *= (-1L);
    }
  free(hilf);
  return(v);
} /* sigper */


/*----------------------------------------------------------------------------*/
INT symdet (AH(INT *,mat),AH(INT *,slambda),AH(INT,li),AH(INT *,tsc))
/*------------------------------------------------------------------------------
  berechnet einen Faktor des Koeffizienten zur Schnittmatrix mat.
  (Weitere Erlaeuterung in:
    Golembiowski, Andreas
      Zur Berechnung modular irreduzibler Matrixdarstellungen symmetrischer
      Gruppen mit Hilfe eines Verfahrens von M.Clausen
    Bayreuther Mathematische Schriften Heft 25L, Bayreuth 1987
    SS. 170ff)
  Variablen:  mat, Schnittmatrix;
              slambda, konjugierte Partition;
              li, Element aus slambda.
  Rueckgabewerte: -9998L, falls Resttableau falsch;
                  -9999L, falls nicht genug Speicher;
                      0L, sonst.
  Rueckgabe Koeffizientenfaktor tsc.
------------------------------------------------------------------------------*/
KH(INT *mat) KH(INT *slambda) KH(INT li) KH(INT *tsc)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *cy,*pi,*zmat,*fln,*hfl,*afl,*ii,*z;
  INT lpi,i,j,k,l,d,la,_li,signum,bv,ik,r,err;
  INT *piset,*mpi,*zm;

  _li=li;
  la=slambda[_li];
  ++_li;
  if (la==1L)
  {
    if (mat[0]==(_spaltenz-_li+1L))
    {
      *tsc=1L;
      return(0L);
    }
    else
    {
      *tsc=0L;
      return(0L);/*return(RTabFt);*/
    }
  }
  cy=(INT *)calloc(ALLOCOFFSET+(int)_zeilenz*((int)_zyk+2*(int)_zeilenz+5),
		   sizeof(INT));
  if (!cy)  return no_memory();
  mpi=(INT *)calloc(ALLOCOFFSET+(int)q_zeilenz+(int)_zeilenz,sizeof(INT));
  if (!mpi)
  {
    free(cy);
    return no_memory();
  }
  pi=cy+_zeilenz*_zyk;
  zmat=pi+_zeilenz*(_zeilenz+1L);
  fln=zmat+q_zeilenz;
  hfl=fln+_zeilenz;
  afl=hfl+_zeilenz;
  ii=afl+_zeilenz;
  piset=mpi+_zeilenz;
  *tsc=0L;
  matcopy(zmat,mat,_zeilenz);
  if (alzyk(la,zmat,fln,cy))
  {
    free(cy);
    free(mpi);
    return no_memory();
  }
  if (fln[0]>=0L)
  {
    for (r=0L;r<_zeilenz;afl[r]=fln[r],r++);
    signum=sigper(fln,la);
/*   kann nich sein AK 090792 
    if (signum==NtEMem)
    {
      free(cy);
      free(mpi);
      return(NtEMem);
    }
*/
    bv= *tsc;
    if (_li == _spaltenz)
      *tsc=signum;
    else
    {
      for (j=0L;j<la;++j)
        --zmat[IND(fln[j],j,_zeilenz)];
      if ((err=symdet(zmat,slambda,_li,tsc))!=0L)
      {
        free(cy);
        free(mpi);
        return(err);
      }
      *tsc *= signum;
    }
    *tsc +=  bv;
    matcopy(zmat,mat,_zeilenz);
    if (_li == _spaltenz)
    {
      free(cy);
      free(mpi);
      return(0L);
    }
    for (k=0L,z=pi+1L;k<la;k++,z += (_zeilenz+1L))
      *z=0L;
    for (r=0L;r<_zeilenz;mpi[r++]=0L);
    lpi=0L;
    k=0L;
fl111:
    if ((lpi+cy[IND(k,INDEX(0L),_zyk)])<=la)
    {
      ii[k]=1L;
  fl100:
      if (ii[k]<=cy[IND(k,INDEX(-1L),_zyk)])
      {
        ik=ii[k];
        i=cy[IND(k,INDEX(-ik-1L),_zyk)];
        d=0L;
        l=1L;
        while ((d!=1L) && (l<=cy[IND(k,INDEX(i),_zyk)]))
        {
          if (mpi[cy[IND(k,INDEX(i+1L),_zyk)]-1])
            d=1L;
          ++l;
        }
        if (d==0L)
        {
          for (r=0L,zm= &piset[IND(k,0L,_zeilenz)];r<_zeilenz;r++,zm++)
            *zm=0L;
          for (j=i+1L;j<=(i+cy[IND(k,INDEX(i),_zyk)]);++j)
          {
            pi[IND(k,0L,_zeilenz+1L)]=cy[IND(k,INDEX(i),_zyk)];
            pi[IND(k,j-i,_zeilenz+1L)]=cy[IND(k,INDEX(j),_zyk)];
            piset[IND(k,cy[IND(k,INDEX(j),_zyk)]-1L,_zeilenz)]=1L;
          }
          for (r=0L,zm= &piset[IND(k,0L,_zeilenz)];r<_zeilenz;r++,zm++)
            if (*zm)
              mpi[r]=1L;
          lpi += pi[IND(k,0L,_zeilenz+1L)];
          for (r=0L;r<_zeilenz;hfl[r]=fln[r],r++);
          l=pi[IND(k,0L,_zeilenz+1L)];
          for (j=1L,z= &pi[IND(k,1L,_zeilenz+1L)];j<=l;j++,z++)
            for (i=0L;i<la;++i)
              if (*z==fln[i]+1L)
                hfl[i]= (j==1L)?pi[IND(k,l,_zeilenz+1L)]-1
                    :pi[IND(k,j-1L,_zeilenz+1L)]-1L;
          for (r=0L;r<_zeilenz;fln[r]=hfl[r],r++);
          for (j=0L;j<la;++j)
            --zmat[IND(fln[j],j,_zeilenz)];
          bv= *tsc;
          if ((err=symdet(zmat,slambda,_li,tsc))!=0L)
          {
            free(cy);
            free(mpi);
            return(err);
          }
          if ((l+1L)%2L)
            signum *= (-1L);
          *tsc = bv + signum * (*tsc);
          matcopy(zmat,mat,_zeilenz);
          if ((lpi<=(la-2L)) && (k<la-1L))
          {
            ++k;
            goto fl111;
          }
          else
          {
            for(r=0L;r<_zeilenz;fln[r]=afl[r],r++);
            pi[IND(k,1L,_zeilenz+1L)]=0L;
            for (r=0L,zm= &piset[IND(k,0L,_zeilenz)];r<_zeilenz;r++,zm++)
              if (*zm)
                mpi[r]=0L;
            --lpi;
            if ((l+1L)%2L)
              signum *= (-1L);
            ++ii[k];
            goto fl100;
          }
        }
        else
        {
          ++ii[k];
          goto fl100;
        }
      }
      else
      {
        if (k<la-1L)
        {
          pi[IND(k,1L,_zeilenz+1L)]=0L;
          ++k;
          goto fl111;
        }
        else
          goto fl222;
      }
    }
    else
fl222:
    {
      while ((pi[IND(k-1L,1L,_zeilenz+1L)]==0L) && k>1L)
        --k;
      if (pi[IND(k-1L,1L,_zeilenz+1L)])
      {
        --k;
        for (r=0L;r<_zeilenz;fln[r]=afl[r],r++);
        pi[IND(k,1L,_zeilenz+1L)]=0L;
        for (r=0L,zm= &piset[IND(k,0L,_zeilenz)];r<_zeilenz;r++,zm++)
          if (*zm)
            mpi[r]=0L;
        lpi -= pi[IND(k,0L,_zeilenz+1L)];
        if ((pi[IND(k,0L,_zeilenz+1L)]+1L)%2L)
          signum *= (-1L);
        ++ii[k];
        goto fl100;
      }
    }
  }
  free(cy);
  free(mpi);
  return(0L);
} /* symdet */


/*----------------------------------------------------------------------------*/
static INT fak(AH(INT,x))
/*------------------------------------------------------------------------------
  berechnet x!.
  Variable: x,  natuerliche Zahl.
  Rueckgabewert:  x!.
------------------------------------------------------------------------------*/
KH(INT x)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  if (x<=1L)
    return(1L);
  else
    return (x*fak(x-1L));
} /*fak*/


/*----------------------------------------------------------------------------*/
INT alcoeff(AH(INT *,mat),AH(INT *,slambda))
/*------------------------------------------------------------------------------
  berechnet aus der Schnittmatrix mat und Partition slambda den Koeffizienten.
  Variablen:  mat, Schnittmatrix;
              slambda, konjugierte Partition zu lambda;
  Rueckgabewerte: koeff, Koeffizient zu mat und slambda;
                  -9998L, falls ein Resttableau falsch war;
                  -9999L, falls kein Speicherplatz vorhanden war.
------------------------------------------------------------------------------*/
KH(INT *mat) KH(INT *slambda)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *z,i,tsc,faktor;

  faktor=symdet(mat,slambda,0L,&tsc);
  if (faktor)
    return(faktor);
  if (tsc)
  {
    for (i=q_zeilenz,z=mat,faktor=1L;i>0L;i--,z++)
      if (*z)
        faktor *= fak(*z);
    return(faktor*tsc);
  }
  else
    return(0L);
} /* alcoeff */


/*----------------------------------------------------------------------------*/
static INT nexgitt(y,AH(INT *,lambda),AH(INT *,mtc))
/*------------------------------------------------------------------------------
  berechnet aus Tableau y und Partition lambda das naechste Tableau y.
  Variablen:  y, Tableau;
              lambda, Partition.
  Rueckgabe neues Tableau y, falls ein neues existiert (mtc = TRUE).
  Rueckgabewerte: 0L, falls kein Fehler aufgetreten ist;
              -9999L,  falls kein Speicherplatz vorhanden war.
------------------------------------------------------------------------------*/
INT *y; KH(INT *lambda) KH(INT *mtc)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *hilf,*h,i,j,l,merke;
  INT durch;

  h=(INT *)calloc(ALLOCOFFSET+(int)_n+(int)_n,sizeof(INT));
  if (!h)
    return no_memory();
  hilf=h+_n;
  for (i=0L;i<_n;h[i]=y[i],i++);
  if (!(*mtc))
    for (i=0L,j=0L;lambda[i];++i)
    {
      for (l=j;l<j+lambda[i];h[l++]=i);
      j += lambda[i];
    }
  else
  {
    for (i=0L;i<_n;i++) hilf[i] = 0L;
    i=_n-1L;
    durch=FALSE;
    do
    {
      ++ hilf[h[i]];
      if (h[i]>h[i-1])
      {
        if ((lambda[h[i-1]]-lambda[h[i]])>=
          (hilf[h[i-1]]-hilf[h[i]]+2L))
        {
          durch=TRUE;
          merke=h[i-1];
          j=merke+1L;
          while ((hilf[j]==0L) ||
            ((lambda[h[i-1]]-lambda[j])<
            (hilf[h[i-1]]-hilf[j]+2L)))
            ++j;
          h[i-1]=j;
          --hilf[j];
          ++hilf[merke];
          for (l=i;l<_n;++l)
            if (j<_n)
            {
              for (j=0L;!hilf[j];++j);
              h[l]=j;
              --hilf[j];
            }
        }
      }
      --i;
      if (i == 0L)
        *mtc=FALSE;
    } while (!durch && *mtc);
  }
  for (i=0L;i<_n;y[i]=h[i],i++);
  free(h);
  return(0L);
}  /*nexgitt*/


/*----------------------------------------------------------------------------*/
INT zweikonmat(AH(INT *,lambda),AH(INT *,perm),AH(INT *,bz))
/*------------------------------------------------------------------------------
  berechnet die Koeffizientenmatrix bz fuer Partitionen lambda der
  Laenge 2.
  Variablen:  lambda, eigentliche Partition;
              perm, Permutation.
  Rueckgabe Koeffizientenmatrix bz.
  Rueckgabewerte: dim, Dimension der gewoehnlichen Darstellungen, dim ist
                       negativ, falls dim groesser MAXDM;
                -9999L, falls kein Speicherplatz vorhanden war.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *perm) KH(INT *bz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,k,l,z,zaehl[3],mdim,dim;
  INT *hz,*g_i,*g_j,*start,*hilf_zwei,*hilf_drei,*_hz,*_bz,*z_eins;
  INT g_im,g_jm;

  start=(INT *)calloc(ALLOCOFFSET+(int)_n*5+(int)MAXDM*3,sizeof(INT));
  if (!start)
    return no_memory();
  g_i=start+_n;
  g_j=g_i+_n;
  hilf_zwei=g_j+_n;
  hilf_drei=hilf_zwei+_n;
  hz=hilf_drei+_n;
  mdim=MAXDM;
  g_im=FALSE;
  if (nexgitt(start,lambda,&g_im))
  {
    free(start);
    return no_memory();
  }
  for (z=0L;z<_n;g_i[z]=start[z],z++);
  for (i=0L,g_im=TRUE;g_im;++i)
  {
    for (z=0L;z<_n;g_j[z]=start[z],z++);
    for (z=3L*mdim,_hz=hz;z>0L;z--,*_hz++ = 0L);
    for (j=0L,g_jm=TRUE,_hz=hz;g_jm;j++,_hz++)
    {
      for (z=0L;z<3L;zaehl[z++]=0L);
      for (z=0L;z<_n;hilf_zwei[z]=hilf_drei[perm[z]-1]=g_j[z],z++);
      hilf_zwei[1]=0L;
      for (l=0L;l<_n;++l)
        if (g_i[l]==1L)
        {
          if (g_j[l]==1L) ++zaehl[0];
          if (hilf_zwei[l]==1L) ++zaehl[1];
          if (hilf_drei[l]==1L) ++zaehl[2];
        }
      for (z=0L,z_eins=_hz;z<3L;z++,z_eins += mdim)
        *z_eins=COEFF(_n,zaehl[z],lambda[1]);
      if (nexgitt(g_j,lambda,&g_jm))
      {
        free(start);
        return no_memory();
      }
    }
    if (!i)
    {
      dim=j;
      if (dim>MAXDM)
      {
        dim *= (-1L);
        break;
      }
      else
        _bz=bz;
    }
    for (z=0L,_hz=hz;z<3L;z++,_hz += mdim)
      for (k=0L,z_eins=_hz;k< dim;k++)
        *_bz++ = *z_eins++;
    if (dim<mdim)
      mdim=dim;
    if(nexgitt(g_i,lambda,&g_im))
    {
      free(start);
      return no_memory();
    }
  }
  free(start);
  return(dim);
} /* zweikonmat */


/*----------------------------------------------------------------------------*/
konjugiere(AH(INT *,lambda),AH(INT *,lambdastrich))
/*------------------------------------------------------------------------------
  konjugiert die eigentliche Partition lambda mit Ergebnis lambdastrich.
  Variablen:  lambda, eigentliche Partition.
  Rueckgabe lambdastrich.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *lambdastrich)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j;

  for (i=0L;i<lambda[0];++i)
  {
    for (j=0L;j<_zeilenz && lambda[j]>=i+1L;++j);
    if ((j<_n) && (lambda[j] < i+1L))
      lambdastrich[i]=j;
    else
      lambdastrich[i]=_zeilenz;
  }
} /* konjugiere */


/*----------------------------------------------------------------------------*/
schnitt(AH(INT *,t_eins),AH(INT *,t_zwei),AH(INT *,mat))
/*------------------------------------------------------------------------------
  berechnet Schnittmatrix zu den Tableaux t_eins und t_zwei.
  Variablen:  t_eins, Tableau;
              t_zwei, Tableau.
  Rueckgabe Schnittmatrix mat.
------------------------------------------------------------------------------*/
KH(INT *t_eins) KH(INT *t_zwei) KH(INT *mat)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *z,i;

  for (i=q_zeilenz,z=mat;i>0L;i--,*z++ =0L);
  for (i=0L;i<_n;++i)
    ++mat[IND(t_eins[i],t_zwei[i],_zeilenz)];
} /*schnitt*/

struct ak {
	INT c;
	INT p;
	char *ptr;
	};

struct ak * ak_tmpfile()
	{
	struct ak *a;
	a = calloc((int)1,sizeof(struct ak));
	if (a==NULL) return no_memory();
	a->c = 0L; /* erste unzulaessige stelle */
	a->p = 0L;
	a->ptr = NULL;
	return a;
	}
ak_rewind(a) struct ak *a;
	{
	a->p = 0L;
	}

ak_fread(buf,size,numb,a) char **buf; INT size; INT numb; struct ak *a;
	{
	size = size * numb;
	if (a->p + size > a->c) size = a->c - a->p;
	*buf = a->ptr + a->p;
	a->p = a->p + size;
	}

#define AXSIZE 1000

ak_fwrite(buf,size,numb,a) char *buf; INT size; INT numb; struct ak *a;
	{
	size = size *numb;

	if (a->ptr == NULL) { a->ptr = calloc(AXSIZE,1L); a->c =  AXSIZE; }
again:
	if (a->ptr == NULL) return no_memory();
	if (a->p + size > a->c) {
		a->ptr = realloc(a->ptr,a->c + AXSIZE);
		if (a->ptr == NULL) return no_memory();
		a->c = a->c + AXSIZE;
		goto again;
		}
	memcpy(a->ptr + a->p, buf,(int) size);
	a->p = a->p + size;
	}

ak_fclose(a) struct ak *a;
	{
	if  (a->ptr != NULL) free (a->ptr);
	free(a);
	}

/*----------------------------------------------------------------------------*/
INT mat_comp(AH(INT *,co),AH(INT *,mat),AH(INT *,slambda),AH(FILE *,sfp))
/*------------------------------------------------------------------------------
  ueberprueft die Schnittmatrix mat, ob mit dieser schon gerechnet wurde. Ist
  dies der Fall, so ist der Koeffizient gleich. Ansonsten wird fuer mat der
  neue Koeffizient berechnet.
  Variablen:  co, Zaehler der verschiedenen Schnittmatrizen;
              mat, Schnittmatrix;
              slambda, konjugierte Partition zu lambda;
              sfp, temporaere Datei, in der die schon benutzten Schnittmatri-
                   zen und ihre Koeffizienten stehen.
  Rueckgabe co mit alter bzw. neuer Anzahl der verschiedenen Schnittmatrizen.
  Rueckgabewerte: koeff,  Koeffizient zu mat und slambda;
                  -9999L,  falls nicht genuegend Speicher vorhanden ist.
------------------------------------------------------------------------------*/
KH(INT *co) KH(INT *mat) KH(INT *slambda) KH(FILE *sfp)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT gefunden;
  INT *schnittmat,*z_eins,*z_zwei,i,rr,koeff;
  INT *ak_buffer; /* AK 060392 */
  i=1L;
  if ((*co)>0L)
  {
	/* printeingabe("D1");*/ 
    /* schnittmat=(INT *)calloc(ALLOCOFFSET+(int)q_zeilenz,sizeof(INT));
	AK 060392 */
/*
    ak_buffer =(INT *)calloc(ALLOCOFFSET+(int)(((*co) + 1) * (q_zeilenz +1)),
			sizeof(INT));
*/
    /* if (!schnittmat)
	AK 060392 */
    if (ak_buffer == NULL)
      return no_memory();
    ak_rewind(sfp);
	/* printeingabe("D2");*/ 
      ak_fread(&ak_buffer,(INT)sizeof(INT),(INT)((*co)+1L )*(q_zeilenz+1L),sfp);
    for (i=0L,schnittmat=ak_buffer;i<((*co)+1L);
		i++,schnittmat=schnittmat+q_zeilenz+1L)
    {
      gefunden=TRUE;
/*
      fread(schnittmat,sizeof(INT),(INT)q_zeilenz,sfp);
      fread(&koeff,sizeof(INT),1L,sfp);
AK 060392 */
      /* schnittmat = ak_buffer + (i*(q_zeilenz+1L)); */
	/* printeingabe("D3");*/ 
      koeff = *(schnittmat + q_zeilenz);
      for (rr=q_zeilenz,z_eins=mat,z_zwei=schnittmat;rr>0L;rr--,z_eins++,z_zwei++)
        if (*z_eins != *z_zwei)
        {
          gefunden=FALSE;
          break;
        }
      if (gefunden)
        break;
    }
/*
    free(schnittmat);
AK 060392 */
	/* printeingabe("D4");*/ 
/*
    free(ak_buffer); 
*/
  }
  if (i==((*co)+1L))
  {
    ++(*co);
	/* printeingabe("D5");*/ 
    ak_fwrite(mat,(INT)sizeof(INT),(INT)q_zeilenz,sfp);
    koeff = alcoeff(mat,slambda);
    if (koeff==RTabFt || koeff==NtEMem)
      return(koeff);
    ak_fwrite(&koeff,(INT)sizeof(INT),1L,sfp);
	/* printeingabe("D6");*/ 
  }
  return(koeff);
} /* mat_comp */


/*----------------------------------------------------------------------------*/
INT alkonmat(AH(INT *,lambda),AH(INT *,perm),AH(INT *,bz))
/*------------------------------------------------------------------------------
  berechnet zu einer Partition lambda und einer Permutation perm die Koeffi-
  zientenmatrix (B|C(12)|C(perm)).
  Variablen:  lambda, eigentliche Partition;
              perm, Permutation.
  Rueckgabewerte: >0L, kein Fehler aufgetreten;
                 -10L, falls Pointer auf lambda NULL ist;
                 -11L, falls lambda leer ist;
                 -12L, falls ein Element von lambda kleiner 0 ist;
                 -13L, falls lambda keine eigentliche Partition ist;
                 -15L, falls n > MAXN;
                 -16L, falls Laenge von lambda groesser MAXZEILENZ ist;
                 -17L, falls erstes Element von lambda groesser MAXSPALTENZ ist;
                 -18L, falls Dimension der gew. irred. Dg. >MAXDIM;
                 -19L, falls Pointer auf bz NULL ist;
                 -20L, falls sich der temporaere File nicht oeffnen laesst;
                 -30L, falls Pointer auf perm NULL ist;
                 -31L, falls Teil von perm <= 0 ist;
                 -32L, falls Teil von perm > n ist;
                 -33L, falls perm zu viele Elemente hat;
               -9998L, falls Resttableau in SYMDET falsch ist;
               -9999L, falls nicht genuegend Speicher vorhanden ist.
  Rueckgabe Koeffizientenmatrix bz.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *perm) KH(INT *bz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *mat,*transmt,*zykmt,*hz,*t_eins,*t_zwei,*ht,*asslambda,*_hz,*_bz,*z_eins;
  INT ii,jj,kk,i,k,z,co = 0L,co_eins,co_zwei,dim,diag,mdim,dim_,koeff;
  INT mehr_eins,mehr_zwei;
  FILE  *sfp;

/*
  Moegliche Eingabefehler...
*/
  if (!lambda)
    return(LmbNul);
  else if (!lambda[0])
    return(LmbEmp);
  else if (!bz)
    return(BzNul);
  for (i=0L,_n=0L;lambda[i];++i)
    if (lambda[i]<0L)
      return(LmbLt_null);
    else
      _n += lambda[i];
  if (_n>MAXN)
    return(NGtMax);
  else if (perm==NULL)
    return(PerNul);
  for (i=0L;i<MAXN && perm[i];i++);
  if (i>_n)
    return(PeLgGN);
  for (i=0L;i<_n;i++)
    if (perm[i]<=0L)
      return(PerLe_null);
    else if (perm[i]>_n)
      return(PerGtN);
  for (i=1L;lambda[i];++i)
    if (lambda[i]>lambda[i-1])
      return(LmbNRg);


/*
  Na denn ma' los...
*/
  _zyk=ZYK/2+ZYK+1L;
  if ((_spaltenz=lambda[0])>MAXSPALTENZ)
    return(SzGtMx);
  if ((_zeilenz=i)>MAXZEILENZ)
    return(ZzGtMx);
  q_zeilenz=_zeilenz*_zeilenz;
  if (_zeilenz==2L)
  {
    dim_=zweikonmat(lambda,perm,bz);
/*  kann nicht sein AK 090792
    if (dim_==NtEMem)
      return(NtEMem);
*/ 
    if (dim_<0L)
      dim=DmGtMx;
    else
      dim=dim_;
  }
  else
  { /* allgemeine Partition/Anfang */
    if ((sfp=ak_tmpfile())==NULL) return(CntOFl);
    mat=(INT *)calloc(ALLOCOFFSET+(int)(q_zeilenz+MAXDM)*3+(int)(4*_n),sizeof(INT));
    if (mat == NULL)
    {
      ak_fclose(sfp);
      return no_memory();
    }
    transmt=mat+q_zeilenz;
    zykmt=transmt+q_zeilenz;
    t_eins=zykmt+q_zeilenz;
    t_zwei=t_eins+_n;
    ht=t_zwei+_n;
    asslambda=ht+_n;
    hz=asslambda+_n;
    mdim=MAXDM;
    konjugiere(lambda,asslambda);
    for (ii=0L,diag=1L;ii<_zeilenz;++ii)
      diag *= fak(lambda[ii]);
    for (ii=0L,kk=0L;ii<_n && lambda[ii];++ii)
    {
      for (jj=kk;jj < (kk+lambda[ii]);ht[jj++]= ii);
      kk += lambda[ii];
    }
    for (z=0L;z<_n;t_zwei[z]=ht[z],z++);
    co_eins=co_zwei=0L;
    for (i=0L,mehr_zwei=TRUE;mehr_zwei;++i)
    {
      for (z=0L;z<_n;t_eins[z]=ht[z],z++);
      for (z=3L*mdim,_hz=hz;z>0L;z--,*_hz++ =0L);
      for (k=0L,mehr_eins=TRUE;mehr_eins;++k)
      {
        if (i==k)
        /*Hauptdiag. von B(lambda) und C(lambda/(12))*/
        {
          hz[i]=diag;
          if (t_zwei[1]==1L)
            hz[i+mdim]=(-1L)*(hz[i]/lambda[0]);
          else
            hz[i+mdim]=hz[i];
        }
        else if (i<k)
        {
          schnitt(t_eins,t_zwei,mat);
          /*Rest von B(lambda)*/
          koeff=mat_comp(&co,mat,asslambda,sfp);
          if (koeff!=NtEMem && koeff!=RTabFt)
            hz[k]=koeff;
          else
          {
            ak_fclose(sfp);
            free(mat);
            return(koeff);
          }
          if ((t_zwei[1]==1L) && (t_eins[1]==1L))
          /*Rest von C(lambda/(12))*/
          {
            matcopy(transmt,mat,_zeilenz);
            --transmt[0];
            --transmt[_zeilenz+1];
            ++transmt[1];
            ++transmt[_zeilenz];
            ii=co;
            koeff=mat_comp(&co,transmt,asslambda,sfp);
            if (koeff!=NtEMem && koeff!=RTabFt)
              hz[k+mdim]=koeff;
            else
            {
              ak_fclose(sfp);
              free(mat);
              return(koeff);
            }
            if (co>ii) co_eins++;
          }
          else
            hz[k+mdim]= hz[k];
        }
        if (zykschnitt(t_zwei,t_eins,perm,zykmt))
        {
          ak_fclose(sfp);
          free(mat);
          return no_memory();
        }
        /*Berechnung von C(lambda/(1..n)).*/
        if (!i && !k)
        {
          co=0L;
          koeff=mat_comp(&co,zykmt,asslambda,sfp);
          if (koeff!=NtEMem && koeff!=RTabFt)
            hz[2L*mdim]=koeff;
          else
          {
            ak_fclose(sfp);
            free(mat);
            return(koeff);
          }
        }
        ii=co;
        koeff=mat_comp(&co,zykmt,asslambda,sfp);
        if (koeff!=NtEMem && koeff!=RTabFt)
          hz[k+2L*mdim]=koeff;
        else
        {
          ak_fclose(sfp);
          free(mat);
          return(koeff);
        }
        if (co>ii) ++co_zwei;
        if (nexgitt(t_eins,lambda,&mehr_eins))
        {
          ak_fclose(sfp);
          free(mat);
          return no_memory();
        }
      }
      if ((_zeilenz==1L) || (_spaltenz==1L))
        co=1L;
      if (!i)
      {
        dim=dim_=k;
        if (dim>MAXDM)
        {
          dim_ *= (-1L);
          dim=DmGtMx;
          break;
        }
        else
          _bz=bz;
      }
      for (z=0L,_hz=hz;z<3L;z++,_hz += mdim)
        for (k=0L,z_eins=_hz;k<dim;k++)
          *_bz++ = *z_eins++;
      if (dim<mdim)
        mdim=dim;
      if (nexgitt(t_zwei,lambda,&mehr_zwei))
      {
        ak_fclose(sfp);
        free(mat);
        return no_memory();
      }
    }
    ak_fclose(sfp);
    free(mat);


  } /*allgemeine Partition/Ende*/


  return(dim);
}  /*alkonmat*/
/*******************************************************************************
*
* Datei MODULDIM.C
*   Version vom 17.11.89
*
*
* Zeile Funktion
*
*       Funktionen zur Berechnung der Dimensionen mod. irred. Darstellungen
*       -------------------------------------------------------------------
* 77    INT _k_zweikonmat(INT *lambda,INT *bz,INT pz)
* 139   INT k_alkonmat(INT *lambda,INT *bz,INT pz)
* 269   _k_moddreimat(INT *bz,INT pz)
* 311   INT _k_modgauss(INT *bz,INT pz)
* 359   INT k_dimmod(INT *bz,INT dim,INT pz)
*
*******************************************************************************/

static INT dm;
static INT dm_zwei;
static INT qdm;


/*
  Defines...
*/
/*----------------------------------------------------------------------------*/
INT k_alkonmat(AH(INT *,lambda),AH(INT *,bz),AH(INT,pz))
/*------------------------------------------------------------------------------
  berechnet die Koeffizientenmatrix B fuer alle Partitionen lambda. Dabei
  werden die Eintraege der Matrix modulo pz abgelegt.
  (Vgl. in MODULKFF.C Funktion alkonmat().)
  Variablen:  lambda, Partition;
              pz, Primzahl.
  Rueckgabe Koeffizientenmatrix bz.
  Rueckgabewerte: >0L, Dimension der gew. irred. Darstellung;
               sonst, s. MODULKFF.C Funktion alkonmat().
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *bz) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *mat,*t_eins,*t_zwei,*ht,*slambda;
  INT ii,jj,kk,i,k,z,co = 0L,dim,diag,mdim,dim_,koeff;
  INT mehr_eins,mehr_zwei,*_bz;
  FILE  *sfp;

/*
  Moegliche Eingabefehler...
*/
  if (!lambda) return(LmbNul);
  else if (!lambda[0]) return(LmbEmp);
  else if (!bz) return(BzNul);
  for (i=0L,_n=0L;lambda[i];++i)
    if (lambda[i]<0L) return(LmbLt_null);
    else _n += lambda[i];
  if (_n>MAXN) return(NGtMax);
  else if (pz<=0L) return(PrmLe_null);
  else if (pz)
  {
    for (i=0L;PZ[i]<=pz;i++);
    if (pz!=PZ[i-1]) return(NoPrm);
  }
  for (i=1L;lambda[i];++i)
    if (lambda[i]>lambda[i-1]) return(LmbNRg);


/*
  Na denn ma' los...
*/
	/* printeingabe("C1");*/ 
  _zyk=ZYK/2L+ZYK+1L;
  if ((_spaltenz=lambda[0])>MAXSPALTENZ) return(SzGtMx);
  if ((_zeilenz=i)>MAXZEILENZ) return(ZzGtMx);
  q_zeilenz=_zeilenz*_zeilenz;
  if (_zeilenz==2L)
  {
    dim_=_k_zweikonmat(lambda,bz,pz);
/* kann nich sein AK 090792
    if (dim_==NtEMem)
      return(NtEMem);
*/
    if (dim_<0L)
      dim=DmGtMx;
    else
      dim=dim_;
  }
  else
  { /* allgemeine Partition/Anfang */
	/* printeingabe("C2");*/ 
    if ((sfp=ak_tmpfile())==NULL) return(CntOFl);
    mat=(INT *)calloc(ALLOCOFFSET+(int)(q_zeilenz)+(int)(4*_n)+1,sizeof(INT));
    if (mat == NULL)
    {
      ak_fclose(sfp);
      return no_memory();
    }
    t_eins=mat+(INT)q_zeilenz;
    t_zwei=t_eins+(INT)_n;
    ht=t_zwei+(INT)_n;
	/* printeingabe("C3");*/ 
    slambda=ht+_n;
    mdim=MAXDM;
    _assoziiere(lambda,slambda,_n);
    for (ii=0L,diag=1L;ii<_zeilenz;++ii)
      diag *= fak(lambda[ii]);
    for (ii=0L,kk=0L;ii<_n && lambda[ii];++ii)
    {
      for (jj=kk;jj < (kk+lambda[ii]);ht[jj++]= ii);
      kk += lambda[ii];
    }
    for (z=0L;z<_n;t_zwei[z]=ht[z],z++);
    _bz=bz;
    for (i=0L,mehr_zwei=TRUE;mehr_zwei;++i)
    {
      for (z=0L;z<_n;t_eins[z]=ht[z],z++);
      for (k=0L,mehr_eins=TRUE;mehr_eins;++k)
      {
	/* printeingabe("C4");*/ 
        if (i==k)
          *_bz++ = (INT) mod(diag,pz);
        else if (k<i)
            *_bz++ = bz[k*MAXDM+i];
        else if (i<k)
        {
          schnitt(t_eins,t_zwei,mat);
	/* printeingabe("C5");*/ 
          koeff=mat_comp(&co,mat,slambda,sfp);
          if (koeff!=NtEMem && koeff!=RTabFt)
            *_bz++ =(INT) mod(koeff,pz);
          else
          {
            ak_fclose(sfp);free(mat);return(koeff);
          }
        }
	/* printeingabe("C6");*/ 
        if (nexgitt(t_eins,lambda,&mehr_eins))
        {
          ak_fclose(sfp);free(mat);return no_memory();
        }
      }
      if ((_zeilenz==1L) || (_spaltenz==1L))
        co=1L;
      if (!i)
      {
	/* printeingabe("C7");*/ 
        dim=dim_=k;
        if (dim>MAXDM)
        {
          dim_ *= (-1L);
          dim=DmGtMx;
          break;
        }
      }
      if (dim<mdim)
        mdim=dim;
	/* printeingabe("C7");*/ 
      if (nexgitt(t_zwei,lambda,&mehr_zwei))
      {
        ak_fclose(sfp);free(mat);return no_memory();
      }
    }
    ak_fclose(sfp);free(mat);
  } /*allgemeine Partition/Ende*/
	/* printeingabe("C8");*/ 
  return(dim);
}  /*alkonmat*/


/*----------------------------------------------------------------------------*/
_k_moddreimat(AH(INT *,bz),AH(INT,pz))
/*------------------------------------------------------------------------------
  bringt die Matrix bz mit Hilfe des Gaussalgorithmus ueber GF(pz) auf obere
  Dreiecksform mit 1 oder 0 auf der Hauptdiagonalen.
  (Vgl. in MODULDG.C Funktion moddreimat().)
  Variablen:  bz, Koeffizientenmatrix aus k_alkonmat();
              pz, Primzahl;
  Rueckgabe bz.
------------------------------------------------------------------------------*/
KH(INT *bz) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_bz,*jz,*z_eins,*z_zwei;
  INT qu,mu;
  INT i,j,k;

  for (i=0L,_bz=bz;i<dm;i++,_bz += (dm+1L))
  {
    for (k=i+1L,jz=_bz+dm;!*_bz && k<dm;k++,jz += dm)
      if (*jz)
        for (j=dm,z_eins=jz,z_zwei=_bz;j>i;j--)
        {
          mu= *z_zwei; *z_zwei++ = *z_eins; *z_eins++ = mu;
        }
    if (*_bz)
    {
      if ((qu= *_bz)!=1L)
        for (j=dm,z_eins=_bz;j>i;j--,z_eins++) *z_eins=(INT)divp(*z_eins,qu,pz);
      if (i<dm-1L)
        for (k=i+1L,jz=_bz+dm;k<dm;k++,jz += dm)
          if ((qu= *jz)!=0L)
            for (j=dm,z_eins=jz,z_zwei=_bz;j>i;j--,z_eins++,z_zwei++)
              if (*z_zwei)
              {
                mu= (INT)((-1L)*mulp(qu,*z_zwei,pz));
                *z_eins=(INT)adp(*z_eins,mu,pz);
              }
    }
  }
} /* _k_moddreimat */


/*----------------------------------------------------------------------------*/
INT _k_modgauss(AH(INT *,bz),AH(INT,pz))
/*------------------------------------------------------------------------------
  berechnet mit Hilfe des Gaussalgorithmus ueber GF(pz) die Dimension der
  modular irreduziblen Darstellung.
  (Vgl. in MODULDG.C Funktion modgauss().)
  Variablen:  bz, Matrix mit Basis;
              pz, Primzahl.
  Rueckgabe bz.
  Rueckgabewert: Dimension der mod. irred. Darstellung.
------------------------------------------------------------------------------*/
KH(INT *bz) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_bz,*z_eins,*z_zwei,*z_drei,*z_vier,mu,qu;
  INT i,j,k,prang;

  prang=0L;
  for (i=dm-1L,_bz= &bz[qdm-1];i>0L;i--,_bz -= (dm+1L))
    if (*_bz)
    {
      if ((qu= *_bz)!=1L)
        for (k=i,z_eins=_bz;k<dm;k++,z_eins++)
          if (*z_eins)
            *z_eins=(INT)divp(*z_eins,qu,pz);
      for (j=i-1L,z_eins= &bz[i*dm+i],z_zwei=z_eins-dm;j>=0L;j--,z_zwei -= dm)
        if ((qu= *z_zwei)!=0L)
          for (k=dm,z_drei=z_eins,z_vier=z_zwei;k>i;k--,z_drei++,z_vier++)
            if (*z_drei)
            {
              mu=(INT)((-1L)*mulp(qu,*z_drei,pz));
              *z_vier = (INT)adp(*z_vier,mu,pz);
            }
    }
    else
      prang++;
  if (bz[0]!=1L)
  {
    if ((qu=bz[0])==0L)
      prang++;
    else
      for (j=0L,_bz=bz;j<dm;j++,_bz++)
        if (*_bz)
          *_bz= (INT)divp(*_bz,qu,pz);
  }
  return(dm-prang);
} /* _k_modgauss */


/*----------------------------------------------------------------------------*/
INT k_dimmod(AH(INT *,bz),AH(INT,dim),AH(INT,pz))
/*------------------------------------------------------------------------------
  berechnet aus bz, der Koeffizientenmatrix aus k_alkonmat(), die Dimension
  der modular irreduziblen Darstellung fuer ein pz.
  Variablen:  bz, Koeffizientenmatrix aus k_alkonmat();
              dim, Dimension der Matrix;
              pz, Primzahl.
  Rueckgabewert:  Dimension der mod. irred. Darstellung.
------------------------------------------------------------------------------*/
KH(INT *bz) KH(INT dim) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  dm=dim;
  dm_zwei=2L*dm;
  qdm=(INT)dm*(INT)dm;
  _k_moddreimat(bz,pz);
  return(_k_modgauss(bz,pz));
} /* k_dimmod */
/*******************************************************************************
*
* Datei MODULDCM.C
*   Version vom 22.11.89
*
*
* Zeile Funktionen
*
*       Funktionen zur Berechnung der Zerlegungszahlen
*       ----------------------------------------------
* 61    INT _nexpart(INT n,INT mode,INT *r,INT *m)
* 103   INT _part_reg(INT p,INT *r,INT *m)
* 124   INT _num_part(INT n,INT pz)
* 159   INT _r_induk(INT *lambda,INT n,INT pz,INT i,INT r)
* 188   INT _ber_lambdas(INT **lambda,INT n,INT p)
* 238   INT _fakul(INT n)
* 250   _assoziiere(INT *lambda,INT *slambda,INT n)
* 274   INT _dimension(INT *lambda,INT n)
* 302   INT _ber_dim(INT *dim,INT **lambda,INT lda,INT n,INT p)
* 366   INT _v_eintrag(INT **lambda,INT lanz,INT *part,INT *v,INT vv,INT n)
* 405   INT _ggT(INT a,INT b)
* 431   _ggT_v(INT *v,INT vl)
* 455   INT _kleiner(INT *col_eins,INT *col_zwei,INT len)
* 483   INT _diff(INT *col_eins,INT *col_zwei,INT *erg,INT len)
* 507   INT _red_r_mat(INT **r_mat,INT col,INT row)
* 608   INT _teste_r_mat_dim(INT **r_mat,INT col,INT row,INT p,INT *dim,
*              INT *rg_dim,INT ab)
* 709   INT _search_dec(INT *decomp,INT n, INT pz)
* 753   _append_dec(INT *decomp,INT row,INT col,INT n,INT pz)
* 778   INT d_mat(INT *decomp,INT col,INT row,INT n,INT pz)
*
*******************************************************************************/
/*
  Uebliche Headerfiles
*/




/*
  Defines...
*/
#define _H_IJ(l,i,sl,j) (l[i]-i+sl[j]-j-1L) /* Macro Hook_length */


/*----------------------------------------------------------------------------*/
INT _nexpart(AH(INT,n),AH(INT,mode),AH(INT *,r),AH(INT *,m))
/*------------------------------------------------------------------------------
  berechnet die naechste Partition von n. Dabei enthaelt r die r[0] Teile der
  Partition und m die Vielfachheiten.
  Variablen:  n, die zu partitionierende Zahl;
              mode, =0 erste Partitionierung,
                    !=0 weitere Partitionierungen.
  Rueckgabe r und m.
  Rueckgabewerte: 0L, falls keine weitere Partitionierung moeglich;
                  1L, falls weitere Partitionen von n existieren.
------------------------------------------------------------------------------*/
KH(INT n) KH(INT mode) KH(INT *r) KH(INT *m)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT d,s,sum,f;

  d=r[0];
  if (mode)
  {
    sum=(r[d]==1L)? m[d--]+1L : 1L;
    f=r[d]-1L;
    if (m[d]!=1L) m[d++]--;
    r[d]=f;
    m[d]=(sum/f)+1L;
    s=sum % f;
    if (s>0L)
    {
      r[++d]=s;
      m[d]=1L;
    }
    r[0]=d;
    return(m[d]!=n);
  }
  else
  {
    r[0]=m[1]=1L;
    r[1]=n;
    return(n!=1L);
  }
} /* _nexpart */


/*----------------------------------------------------------------------------*/
INT _part_reg(AH(INT,p),AH(INT *,r),AH(INT *,m))
/*------------------------------------------------------------------------------
  ueberprueft die Partition gegeben durch r und m, ob sie p-regulaer ist.
  Variablen:  p, Primzahl;
              r, Partition mit r[0]=Laenge von r und m,
                 r[1]...r[r[0]] Elemente der Partition;
              m, Vielfachheiten von r[1]...r[r[0]].
  Rueckgabewerte: 0L, falls Partition nicht p-regulaer;
                  1L, falls Partition p-regulaer ist.
------------------------------------------------------------------------------*/
KH(INT p) KH(INT *r) KH(INT *m)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i;
  for (i=1L;i<=r[0];i++)
    if (m[i]>=p)
      return(0L);
  return(1L);
} /* _part_reg */


/*----------------------------------------------------------------------------*/
INT _num_part(AH(INT,n),AH(INT,pz))
/*------------------------------------------------------------------------------
  berechnet  fuer pz=0 die Anzahl der Partitionen zu n und fuer pz!=0 die
  Anzahl der regulaeren Partitionen.
  Variablen:  n, die zu partitionierende Zahl;
              pz, Primzahl oder 0.
  Rueckgabewerte: >0L, die Anzahl der (p-regulaeren) Partitionen von n;
               -9999L, falls nicht genuegend Speicher vorhanden war.
------------------------------------------------------------------------------*/
KH(INT n) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT num,d,e;
  INT *r,*m;

  r=(INT *)calloc(ALLOCOFFSET+2*(int)(n+1),sizeof(INT));
  if (r==NULL) return no_memory();
  m=r+(INT)n+1L;
  num=0L;
  e=1L;
  d=0L;
  while (e)
  {
    e=d=_nexpart(n,d,r,m);
    if (pz)
    {
      if (_part_reg(pz,r,m)) num++;
    }
    else num++;
  }
  free(r);
  return(num);
} /* _num_part */


/*----------------------------------------------------------------------------*/
INT _r_induk(AH(INT *,lambda),AH(INT,n),AH(INT,pz),AH(INT,i),AH(INT,r))
/*------------------------------------------------------------------------------
  ueberprueft die Moeglichkeit einer r-Induktion des zur Partition lambda
  gehoerenden Tableaux in der Zeile i.
  Variablen:  lambda, Partition zu n;
              n;
              pz, Primzahl;
              i, Zeile des Tableaux;
              r, die "Ordnung" des anzuhaengenden Knotens.
  Rueckgabewerte: 0L, falls r-Induktion nicht moeglich;
                  1L, falls r-Induktion moeglich ist.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT n) KH(INT pz) KH(INT i) KH(INT r)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT len;

  for (len=0L;len<n && lambda[len];len++);
  if (!i) return(mod(lambda[0],pz)==r);
  else if (i<len)
  {
    if (lambda[i-1]>lambda[i]) return(mod(lambda[i]-i,pz)==r);
    else return(0L);
  }
  else if (i==len) return(mod(-i,pz)==r);
  else return(0L);
} /* _r_induk */


/*----------------------------------------------------------------------------*/
INT _ber_lambdas(AH(INT **,lambda),AH(INT,n),AH(INT,p))
/*------------------------------------------------------------------------------
  berechnet fuer p=0 alle eigentlichen Partitionen von n und fuer p!=0L, p
  Primzahl, alle p-regulaeren Partitionen von n.
  Variablen:  n, die zu partitionierende Zahl;
              p, Primzahl oder 0L;
  Rueckgabe lambda, Vektor von Partitionen.
  Rueckgabewerte: 0L, falls alle Partitionen ohne Fehler berechnet wurden;
              -9999L, falls kein Speicher zur Verfuegung stand.
------------------------------------------------------------------------------*/
KH(INT **lambda) KH(INT n) KH(INT p)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *r,*m,d,e,i,j,k,l;

  r=(INT *)calloc(ALLOCOFFSET+(int)(n+1)*2,sizeof(INT));
  if (r == NULL) return no_memory();
  m=r+(INT)(n+1L);
  e=1L;
  k=d=0L;
  while(e)
  {
    d=e=_nexpart(n,d,r,m);
    if (!p)
    {
      for (i=0L;i<n;lambda[k][i++]=0L);
      for (i=1L,l=0L;i<=r[0];i++)
        for (j=0L;j<m[i];j++)
          lambda[k][l++]=r[i];
      k++;
    }
    else
    {
      if (_part_reg(p,r,m))
      {
        for (i=0L;i<n;lambda[k][i++]=0L);
        for (i=1L,l=0L;i<=r[0];i++)
          for (j=0L;j<m[i];j++)
            lambda[k][l++]=r[i];
        k++;
      }
    }
  }
#ifndef __TURBOC__ /* leider gibt Turbo C hier nicht sauber frei?? */
  free(r);
#endif
  return(0L);
} /* _ber_lambdas */


/*----------------------------------------------------------------------------*/
INT _fakul(AH(INT,n))
/*------------------------------------------------------------------------------
  berechnet n! und gibt das Ergebnis als Langzahl zurueck.
------------------------------------------------------------------------------*/
KH(INT n)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  if (n<=1L) return(1L);
  else return ((INT)n*_fakul(n-1L));
} /* _fakul */


/*----------------------------------------------------------------------------*/
_assoziiere(AH(INT *,lambda),AH(INT *,slambda),AH(INT,n))
/*------------------------------------------------------------------------------
  konjugiert die eigentliche Partition lambda mit Ergebnis slambda.
  Variablen:  lambda, eigentliche Partition.
  Rueckgabe slambda.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT *slambda) KH(INT n)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,llen;

  for (i=0L;i<=n;slambda[i++]=0L);
  for (llen=0L;llen<n && lambda[llen];llen++);
  for (i=0L;i<lambda[0];++i)
  {
    for (j=0L;j<llen && lambda[j]>=i+1L;++j);
    if ((j<n) && (lambda[j] < i+1L))
      slambda[i]=j;
    else
      slambda[i]=llen;
  }
} /* _assoziiere */


/*----------------------------------------------------------------------------*/
INT _dimension(AH(INT *,lambda),AH(INT,n))
/*------------------------------------------------------------------------------
  berechnet die Dimension der Darstellung zu einer eigentlichen Partition
  mit Hilfe der Hakenformel.
  Variablen:  lambda, Partition;
              n, die partitionierte Zahl.
  Rueckgabewert: Dimension.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT n)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,l;
  INT zz,zn;
  INT *slambda;

  slambda=(INT *)calloc(ALLOCOFFSET+(int)(n+1),sizeof(INT));
  if (slambda == NULL) return no_memory();
  _assoziiere(lambda,slambda,n);
  zz=_fakul(n);
  for (l=0L;l<n && lambda[l];l++);
  for (i=0L,zn=1L;i<l;i++)
    for (j=0L;j<lambda[i];j++)
      zn *= (INT)_H_IJ(lambda,i,slambda,j);
  free(slambda);
  return((INT)(zz/zn));
} /* _dimension */


/*----------------------------------------------------------------------------*/
INT _ber_dim(AH(INT *,dim),AH(INT **,lambda),AH(INT,lda),AH(INT,n),AH(INT,p))
/*------------------------------------------------------------------------------
  berechnet fuer p=0 die Dimensionen zu allen eigentlichen Partitionen lambda
  und fuer p!=0L, p Primzahl, die p-Dimensionen zu allen p-regulaeren Parti-
  tionen lambda.
  Variablen:  lambda, Vektor von Partitionen;
              lda, Laenge des Vektors lambda;
              n, die partitionierte Zahl;
              p, Primzahl oder 0.
  Rueckgabe dim, Vektor der Dimensionen.
  Rueckgabewerte: 0L, falls alles ohne Fehler berechnet wurde;
                 <0L, s. Datei MODULKFF.C Funktion alkonmat().
------------------------------------------------------------------------------*/
KH(INT *dim) KH(INT **lambda) KH(INT lda) KH(INT n) KH(INT p)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *slambda,i,dm,omaxdim;
  INT *bz;

  omaxdim=MAXDM;
  for (i=0L;i<lda;dim[i++]=0L);
  for (i=0L;i<lda;i++)
  {
    if (p)
    {
	/* printeingabe("B1");*/ 
      MAXDM=_dimension(lambda[i],n);
      if (MAXDM<0L)
      {
        MAXDM=omaxdim;return(MAXDM);
      }
      slambda=(INT *)calloc(ALLOCOFFSET+(int)(n+1),sizeof(INT));
	/* printeingabe("B2");*/ 
      if (slambda == NULL)
      {
        MAXDM=omaxdim;return no_memory();
      }
      bz=(INT *)calloc(ALLOCOFFSET+(int)MAXDM*(int)MAXDM,sizeof(INT));
	/* printeingabe("B3");*/ 
      if (bz == NULL)
      {
        MAXDM=omaxdim;free(slambda);return no_memory();
      }
      if (lambda[i][0]==5L && lambda[i][1]==4L && lambda[i][2]==2L && n==11L && p==2L)
	dim[i]=416L;
      else
      {
	/* printeingabe("B4");*/ 
      _assoziiere(lambda[i],slambda,n);
	/* printeingabe("B4.1");*/ 
      if ((dm=k_alkonmat(slambda,bz,p))<0L)
      {
        MAXDM=omaxdim;free(slambda);free(bz);return(dm);
      }
	/* printeingabe("B5");*/ 
      if ((dim[i]=k_dimmod(bz,MAXDM,p))<0L)
      {
        MAXDM=omaxdim;free(slambda);free(bz);return(dim[i]);
      }
      }
      free(bz);
      free(slambda);
	/* printeingabe("B6");*/ 
    }
    else
      if ((dim[i]=_dimension(lambda[i],n))<0L)
      {
        MAXDM=omaxdim;
        return(dim[i]);
      }
  }
  MAXDM=omaxdim;
  return(0L);
} /* _ber_dim */


/*----------------------------------------------------------------------------*/
INT _v_eintrag(AH(INT **,lambda),AH(INT,lanz),AH(INT *,part),AH(INT *,v),
               AH(INT,vv),AH(INT,n))
/*------------------------------------------------------------------------------
  zaehlt das Vorkommen der durch r-Induktion erhaltenen Partition part von
  n in lambda. Dabei wird der Eintrag der Zerlegungsmatrix fuer n-1 berueck-
  sichtigt.
  Variablen:  lambda, Vektor der Partitionen von n;
              lanz, Laenge des Vektors lambda;
              part, Partition, errechnet durch r-Induktion von n-1 nach n;
              v, Spalte der Zerlegungsmatrix;
              vv, Eintrag der Partition part vor der r-Induktion in der Zer-
                  legungsmatrix fuer n-1L;
              n, partitionierte Zahl.
  Rueckgabewerte: 0L, alles in Ordnung;
                 -1L, warum existiert kein solches lambda?????
------------------------------------------------------------------------------*/
KH(INT **lambda) KH(INT lanz) KH(INT *part) KH(INT *v) KH(INT vv) KH(INT n)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j;
  INT gefunden;

  for (i=0L,gefunden=0L;i<lanz && !gefunden;i++)
  {
    for (j=0L;j<n;j++)
      if (lambda[i][j]!=part[j])
        break;
    gefunden= (j==n);
  }
  if (gefunden)
  {
    v[i-1] += vv*1L;
    return(0L);
  }
  else
    return(-1L);
} /* _v_eintrag */


/*----------------------------------------------------------------------------*/
INT _ggT(AH(INT,a),AH(INT,b))
/*------------------------------------------------------------------------------
  berechnet mit Hilfe Euklids den ggT zweier Zahlen a und b.
------------------------------------------------------------------------------*/
KH(INT a) KH(INT b)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT x,y,r;

  if (a==b)    return(a);
  else if (!a) return(b);
  else if (!b) return(a);
  x=a;y=b;
  if (x<y)
  {
    r=x;x=y;y=r;
  }
  x=a;y=b;
  while(y)
  {
    r=x%y;x=y;y=r;
  }
  return(x);
} /* _ggT */


/*----------------------------------------------------------------------------*/
_ggT_v(AH(INT *,v),AH(INT,vl))
/*------------------------------------------------------------------------------
  berechnet den ggT der Eintraege eines Vektors v der Laenge vl und
  multipliziert den Vektor mit 1/ggT.
------------------------------------------------------------------------------*/
KH(INT *v) KH(INT vl)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,ggT;

  for (i=0L;i<vl;i++)
    if (v[i]==1L)
      return;
  ggT=_ggT(v[0],v[1]);
  for (i=2L;i<vl;i++)
    ggT=_ggT(ggT,v[i]);
  if (ggT>1L)
  {
    for (i=0L;i<vl;i++)
      v[i] = v[i]/ggT;
  }
} /* _ggT_v */


/*----------------------------------------------------------------------------*/
INT _kleiner(AH(INT *,col_eins),AH(INT *,col_zwei),AH(INT,len))
/*------------------------------------------------------------------------------
  vergleicht zwei Spalten col_eins und col_zwei.  Ist col_eins (lexikographisch)
  kleiner als col_zwei, so gibt _kleiner eine 1 zurueck, sonst 0.
  Variablen:  col_eins, erste Spalte;
              col_zwei, zweite Spalte;
              len, Laenge der Spalten.
  Rueckgabewerte: 1L, falls col_eins kleiner col_zwei;
                  0L, sonst.
------------------------------------------------------------------------------*/
KH(INT *col_eins) KH(INT *col_zwei) KH(INT len)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i;

  if (!col_zwei) return(0L);
  if (!col_eins) return(1L);
  for (i=0L;i<len;i++)
    if (col_eins[i] || col_zwei[i])
    {
      if (col_eins[i]<col_zwei[i]) return(1L);
      else if (col_eins[i]==col_zwei[i]) continue;
      else break;
    }
  return(0L);
} /* _kleiner */


/*----------------------------------------------------------------------------*/
INT _diff(AH(INT *,col_eins),AH(INT *,col_zwei),AH(INT *,erg),AH(INT,len))
/*------------------------------------------------------------------------------
  berechnet die Differenz erg=col_eins-col_zwei. Existiert in erg ein Eintrag
  kleiner als 0L, so gibt _diff 0 zurueck, sonst 1.
  Variablen:  col_eins, erste Spalte;
              col_zwei, zweite Spalte;
              len, Laenge der Spalten.
  Rueckgabe Ergebnis erg.
  Rueckgabewerte: 0L, falls Eintrag von erg <0L;
                  1L, sonst.
------------------------------------------------------------------------------*/
KH(INT *col_eins) KH(INT *col_zwei) KH(INT *erg) KH(INT len)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i;

  for (i=0L;i<len;erg[i++]=0L);
  for (i=0L;i<len;i++)
    if ((erg[i]=col_eins[i]-col_zwei[i])<0L)
      return(0L);
  return(1L);
} /* _diff */


/*----------------------------------------------------------------------------*/
INT _red_r_mat(AH(INT **,r_mat),AH(INT,col),AH(INT,row))
/*------------------------------------------------------------------------------
  untersucht die Matrix r_mat auf Spalten, die 0L, gleich oder von
  anderen abgezogen werden koennen.
  Variablen:  r_mat, Matrix aller durch r-Induktion entstandenen
                     Spalten;
              col, Anzahl der Spalten von r_mat;
              row, Anzahl der Zeilen von r_mat;
  Rueckgabe ausreduzierte Matrix r_mat.
  Rueckgabewerte: 0L, alles ohne Fehler gelaufen;
              -9999L, falls nicht genuegend Speicher verfuegbar war.
------------------------------------------------------------------------------*/
KH(INT **r_mat) KH(INT col) KH(INT row)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,k,l,*hp,max,*r,*c;
  INT gleiche;

  c=(INT *)calloc(ALLOCOFFSET+(int)(col+row),sizeof(INT));
  if (c == NULL) return no_memory();
  r=c+(INT)row;
  for (i=0L;i<col;i++) /* pruefe, ob in r_mat Spalte=0 existiert */
  {
    if (!r_mat[i]) continue;
    for (j=0L;j<row;j++)
      if (r_mat[i][j])
        break;
    if (j==row)       /* wenn ja, vergesse Spalte */
      r_mat[i]=NULL;
  }
  for (i=0L;i<col-1L;i++) /* pruefe, ob in r_mat zwei Spalten gleich sind */
  {
    if (!r_mat[i]) continue;
    for (j=i+1L;j<col;j++)
    {
      if (!r_mat[j]) continue;
      for (k=0L;k<row;k++)
        if (r_mat[i][k]!=r_mat[j][k])
          break;
      if (k==row)      /* wenn ja, vergesse eine davon */
        r_mat[j]=NULL;
    }
  }
  for (i=0L;i<col-1L;i++) /* sortiere Spalten in r_mat lexikographisch */
  {                     /* absteigend */
    max=i;
    for (j=i+1L;j<col;j++)
      if (_kleiner(r_mat[max],r_mat[j],row))
        max=j;
    if (max!=i)
    {
      hp=r_mat[i];r_mat[i]=r_mat[max];r_mat[max]=hp;
    }
  }
  for (i=0L;i<col;i++)      /* belege r[i] mit der Zeilennummer des ersten */
    if (!r_mat[i]) r[i]=0L; /* Eintrags in  der Spalte r_mat[i] */
    else
      for (j=0L;j<row;j++)
        if (r_mat[i][j])
        {
          r[i]=j+1L;
          break;
        }
  for (i=0L,gleiche=0L;i<col-1L && !gleiche;i++)
  { /* ueberpruefe r auf gleiche Eintraege */
    if (!r[i]) continue;
    for (j=i+1L;j<col;j++)
    {
      if (!r[j]) continue;
      if (r[i]==r[j]) /* existieren zwei gleiche Eintraege: */
      {
        if (_diff(r_mat[i],r_mat[j],c,row)) /* probiere, die zwei Spalten */
          for (k=0L;k<row;k++)               /* voneinander abzuziehen */
            r_mat[i][k]=c[k];
        else /* lassen sie sich nicht abziehen, probiere, hintere Spalten */
             /* von der lex. kleineren der beiden Spalten abzuziehen */
          for (k=col-1L;k>j;k--)
          {
            if (!r_mat[k]) continue;
            if (_diff(r_mat[j],r_mat[k],c,row))
            {
              for (l=0L;l<row;l++)
                r_mat[j][l]=c[l];
              break;
            }
          }
        gleiche=1L;
        break;
      }
    }
  }
  if (gleiche)                     /* gab es gleiche Spalten, so */
    if (_red_r_mat(r_mat,col,row)) /* untersuche r_mat nochmals */
    {
      free(c);return no_memory();
    }
  free(c);
  return(0L);
} /* _red_r_mat */


/*----------------------------------------------------------------------------*/
INT _teste_r_mat_dim(AH(INT **,r_mat),AH(INT,col),AH(INT,row),AH(INT,p),
                     AH(INT *,dim),AH(INT *,rg_dim),AH(INT,ab))
/*------------------------------------------------------------------------------
  untersucht die Zeilen von r_mat auf Richtigkeit. Dabei werden die p-Dimen-
  sionen der p-regulaeren Partitionen multipliziert mit den korrespon-
  dierenden Eintraegen in den Zeilen von r_mat aufsummiert und schliesslich
  mit den jeweiligen gewoehnlichen Dimensionen zu den Partitionen verglichen.
  Variablen:  r_mat, vorher mit _red_r_mat() ueberpruefte Matrix der mit
                     r-Induktion erhaltenen Spalten;
              col, Anzahl der p-regulaeren Partitionen;
              row, Anzahl der eigentlichen Partitionen;
              dim, Dimensionen der gew. irred. Dg.en zu den eigentlichen
                   Partitionen;
              rg_dim, p-Dimensionen der mod. irred. Dg.en zu den p-regulaeren
                      Partitionen.
  Rueckgabe Matrix r_mat, ueberprueft und eventl. mit neuen Spalten, die
    durch Abziehen lexikographisch kleinerer Spalten von der alten entstanden
    ist.
  Rueckgabewerte: 0L, alles ohne Fehler abgelaufen;
              -9999L, falls nicht genuegend Speicher vorhanden war.
------------------------------------------------------------------------------*/
KH(INT **r_mat) KH(INT col) KH(INT row) KH(INT p) KH(INT *dim)
KH(INT *rg_dim) KH(INT ab)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,k,clmn,dm,*c,*hp,err,l,*r;

  clmn=col*p;
  c=(INT *)calloc(ALLOCOFFSET+(int)row*2+(INT)clmn,sizeof(INT));
  if (c == NULL) return no_memory();
  hp=c+(INT)row;
  r=hp+(INT)row;
  for (i=ab;i<row;i++)
  {
    for (j=0L,k=0L,dm=0L;j<clmn;j++) /* summiere in den Zeilen die Produkte */
    {                             /* aus Eintraegen von r_mat und Dimen- */
      if (!r_mat[j]) continue;    /* sionen der p-regulaeren Partitionen */
      dm += (rg_dim[k++]*r_mat[j][i]);
    }
    if (dm>dim[i]) break;
    else if (dm<dim[i])
    {
      free(c);
      error("Achtung, keine Loesung fuer Zerlegungsmatrix!\n");
      return(-1L);
    }
  }
  if (i==row)
  {
    free(c);return(0L);
  }
  for (j=0L;j<clmn;j++)     /* belege r[i] mit der Zeilennummer des ersten */
    if (r_mat[j])          /* Eintrags in  der Spalte r_mat[i] */
      for (k=0L;k<row;k++)
      {
	if (r_mat[j][k])
        {
          r[j]=k+1L;
          break;
        }
      }
    else r[j]=0L;
  for (j=0L;j<clmn-1L;j++)
  {
    if (!r_mat[j]) continue;
    if (r_mat[j][i])
    {
      for (k=j+1L;k<clmn;k++)
      {
        if (!r[k]) continue;
        if (i+1!=r[k]) continue;
        if (r_mat[k][i])
        {
          if (_diff(r_mat[j],r_mat[k],c,row))
          {
            for (l=0L;l<row;l++)
            {
              hp[l]=r_mat[j][l];
              r_mat[j][l]=c[l];
            }
            if ((err=_teste_r_mat_dim(r_mat,col,row,p,dim,rg_dim,i))<0L )
            {
              for (l=0L;l<row;l++)
                r_mat[j][l]=hp[l];
              if (err == -9999L)
              {
                free(c);return(err);
              }
              break;
            }
            free(c);return(0L);
          }
        }
      }
    }
  }
  free(c);
  return(0L);
} /* _teste_r_mat_dim */


/*----------------------------------------------------------------------------*/
INT _search_dec(AH(INT *,decomp),AH(INT,n),AH(INT,pz))
/*------------------------------------------------------------------------------
  sucht im File 'decommix.dat' nach, ob die Zerlegungsmatrix fuer n und pz
  schon einmal berechnet wurde.
  Variablen:  decomp, Zerlegungsmatrix;
              n, Sn;
              pz, Primzahl.
  Rueckgabe der Zerlegungsmatrix fuer n und pz, falls gefunden.
  Rueckgabewerte: 0L, falls keine Zerlegungsmatrix fuer n und pz gefunden werden
                     konnte;
                  1L, falls Zerlegungsmatrix fuer n und pz existiert.
------------------------------------------------------------------------------*/
KH(INT *decomp) KH(INT n) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  FILE *dfp;
  INT  info[4],*d;
  INT end;

  dfp=fopen("decommix.dat","r");
  if (!dfp) return(0L);
  rewind(dfp);
  do
  {
    fread(info,sizeof(INT),4,dfp);
    if (info[0]==n && info[1]==pz)
    {
      fread(decomp,sizeof(INT),(int)info[2]*(int)info[3],dfp);
      fclose(dfp);
      return(1L);
    }
    else
    {
      d=(INT *)calloc(ALLOCOFFSET+(int)info[2]*(int)info[3],sizeof(INT));
      if (d==NULL) return(0L);
      end=fread(d,sizeof(INT),(int)info[2]*(int)info[3],dfp);
      free(d);
    }
  } while(end);
  fclose(dfp);
  return(0L);
} /* _search_dec */


/*----------------------------------------------------------------------------*/
_append_dec(AH(INT *,decomp),AH(INT,row),AH(INT,col),AH(INT,n),AH(INT,pz))
/*------------------------------------------------------------------------------
  haengt an das Ende des Files 'decommix.dat' eine fuer n und pz noch nicht
  berechnete Zerlegungsmatrix.
  Variablen:  decomp, Zerlegungsmatrix;
              row, Zeilenzahl der Zerlegungsmatrix;
              col, Spaltenzahl der Zerlegungsmatrix;
              n, Sn;
              pz, Primzahl.
------------------------------------------------------------------------------*/
KH(INT *decomp) KH(INT row) KH(INT col) KH(INT n) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  FILE *dfp;
  INT  info[4];

  dfp=fopen("decommix.dat","a+");
  if (!dfp) return;
  info[0]=n;info[1]=pz;info[2]=row;info[3]=col;
  fwrite(info,sizeof(INT),4,dfp);
  fwrite(decomp,sizeof(INT),(int)row*(int)col,dfp);
  fclose(dfp);
} /*_append_dec */


/*----------------------------------------------------------------------------*/
INT d_mat(AH(INT *,decomp),AH(INT,col),AH(INT,row),AH(INT,n),AH(INT,pz))
/*------------------------------------------------------------------------------
  berechnet die (row x col)-Zerlegungsmatrix decomp zu n und der Primzahl pz.
  Variablen:  col, Spaltenzahl der Zerlegungsmatrix;
              row, Zeilenzahl der Zerlegungsmatrix;
              n;
              pz, Primzahl.
  Rueckgabe Zerlegungsmatrix decomp.
  Rueckgabewerte: 0L, alles ohne Fehler;
              sonst, s. Datei MODULKFF.C Funktion alkonmat().
------------------------------------------------------------------------------*/
KH(INT *decomp) KH(INT row) KH(INT col) KH(INT n) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT **lambda,**rg_lambda,*part,*pr,*mr,*v,*dim,*rg_dim;
  INT num,i,j,k,l,r,e,d,o,p,m,err;
  INT *odec,orow,ocol,**r_mat,vv,*z,**hr,*hrc;

  if (n<=1L)
  {
    decomp[0]=1L;
    return(0L);
  }
  else
  {
    if (_search_dec(decomp,n,pz))
      return(0L);
    if ((orow=_num_part(n-1L,0L))<0L) return(orow);
    ocol=_num_part(n-1L,pz);
    odec=(INT *)calloc(ALLOCOFFSET+(int)ocol*(int)orow,sizeof(INT));
    if (!odec) return no_memory();
    if ((err=d_mat(odec,ocol,orow,n-1L,pz))<0L)
    {
      free(odec);
      return error("d_mat:error in n-1");
    }
    lambda=(INT **)calloc(ALLOCOFFSET+(int)row+(int)col,sizeof(INT *));
    if (lambda == NULL)
    {
      free(odec);return no_memory();
    }
	/* printeingabe("1");*/ 
    rg_lambda=lambda+(INT)row;
    lambda[0]=(INT *)calloc(ALLOCOFFSET+(int)(row+col)*(int)(n+1),sizeof(INT));
    if (lambda[0] == NULL)
    {
      free(odec);free(lambda); return no_memory();
    }
    for (i=1L;i<row;i++)
      lambda[i]=lambda[i-1]+(INT)n;
	/* printeingabe("2");*/ 
    if ((err=_ber_lambdas(lambda,n,0L))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);
	return error("d_mat:error in ber_lambdas");
    }
    rg_lambda[0]=lambda[row-1]+(INT)n;
    for (i=1L;i<col;i++)
      rg_lambda[i]=rg_lambda[i-1]+(INT)n;
	/* printeingabe("3");*/ 
    if ((err=_ber_lambdas(rg_lambda,n,pz))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);return(err);
    }
    dim=rg_lambda[col-1]+(INT)n;
    rg_dim=dim+(INT)row;
	/* printeingabe("4");*/ 
    if ((err=_ber_dim(dim,lambda,row,n,0L))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);return(err);
    }
	/* printeingabe("5");*/ 
    if ((err=_ber_dim(rg_dim,rg_lambda,col,n,pz))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);return(err);
    }
    hr=r_mat=(INT **)calloc(ALLOCOFFSET+(int)(col*pz),sizeof(INT));
	/* printeingabe("6");*/ 
    if (!r_mat)
    {
      free(odec);free(lambda[0]);free(lambda);return no_memory();
    }
    hrc=r_mat[0]=(INT *)calloc(ALLOCOFFSET+(int)(col*pz)*(int)row,sizeof(INT));
    if (!r_mat[0])
    {
      free(odec);free(lambda[0]);free(lambda);free(r_mat);return no_memory();
    }
	/* printeingabe("7");*/ 
    for (i=1L;i<col*pz;i++)
      r_mat[i]=r_mat[i-1]+(INT)row;
    part=(INT *)calloc(ALLOCOFFSET+3*(int)n+2+(int)row,sizeof(INT));
    if (!part)
    {
      free(odec);free(lambda[0]);free(lambda);free(r_mat[0]);free(r_mat);
      return no_memory();
    }
    pr=part+(INT)n;
    mr=pr+(INT)n+1L;
    v=mr+(INT)n+1L;
    k=0L;
/*
  Berechne alle r-Induktionen und lege die Ergebnisse in der Matrix r_mat
  spaltenweise ab.
*/
	/* printeingabe("8");*/ 
    for (l=0L;l<ocol && k<(col*pz);l++)
    {
      for (i=0L,num=0L;i<orow;i++)
        if (odec[i*ocol+l])
          num ++;
      for (r=0L;r<pz && k<(col*pz);r++)
      {
        e=1L;
        d=0L;
        j=0L;
        for (i=0L;i<row;v[i++]=0L);
        for (i=0L;i<num;i++)
        {
          do
          {
            e=d=_nexpart(n-1L,d,pr,mr);
            vv=odec[j*ocol+l];
            j++;
          } while(!vv && e);
          for (o=0L;o<n;part[o++]=0L);
          for (p=1L,m=0L;p<=pr[0];p++)
          {
            for (o=0L;o<mr[p];o++)
              part[m++]=pr[p];
          }
          for (p=0L;p<n;p++)
            if (_r_induk(part,n-1L,pz,p,r))
            {
              part[p]++;
              _v_eintrag(lambda,row,part,v,vv,n);
              part[p]--;
            }
        }
        for (i=0L;i<row;i++)
          if(v[i])
          {
            _ggT_v(v,row);
            break;
          }
        for (i=0L;i<row;i++)
          r_mat[k][i]=v[i];
        k++;
      }
    }
	/* printeingabe("9");*/ 
/*
  Durchsuche nun r_mat nach ueberfluessigen Spalten und
  errechne schliesslich die entgueltige Zerlegungsmatrix fuer n und pz.
*/
    if ((err=_red_r_mat(r_mat,col*pz,row))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);free(hrc);free(hr);
      free(part);return(err);
    }
	/* printeingabe("10");*/ 
    if ((err=_teste_r_mat_dim(r_mat,col,row,pz,dim,rg_dim,0L))<0L)
    {
      free(odec);free(lambda[0]);free(lambda);free(hrc);free(hr);
      free(part);return(err);
    }
    for (i=0L,k=0L;i<col*pz;i++)
      if (r_mat[i])
      {
        for (j=0L,z=decomp+(INT)k;j<row;j++,z += (INT)col)
          *z = r_mat[i][j];
        k++;
      }
	/* printeingabe("11");*/ 
    _append_dec(decomp,row,col,n,pz);
    free(lambda[0]);
    free(lambda);
    free(hrc);
    free(hr);
    free(odec);
    free(part);
    return(0L);
  }
} /* d_mat */

/*----------------------------------------------------------------------------*/
INT moddg(prime,lambda,pi,dmat)
/*------------------------------------------------------------------------------
  berechnet zu einer Primzahl prime, einer Partition lambda und einer
  Permutation pi die modulare Matrixdarstellung dmat.
  Variablen:  prime,  Primzahl  (objectkind: INTEGER);
      lambda, Partition (objectkind: PARTITION);
      pi, Permutation (objectkind: PERMUTATION).
  Rueckgabewerte: >=0L, Dimension der Darstellung;
      -1L,  falls Fehler Aufgetreten ist.
  Rueckgabe darstellende Matrix dmat, die erst hier dimensioniert wird,
    falls die Dimension groesser 0 ist.
------------------------------------------------------------------------------*/
OP prime;OP lambda;OP pi;OP dmat;
{
  INT *part,*bz,*perm;
  INT *darmat[2],*dar,pz,dim;
  INT spe,i,j,l_pa,l_p,gzl;
  OP   dimen;

  if (S_PA_LI(lambda) == 1L)  /* AK 020692 */
	if (S_PA_II(lambda,0L) == 1L)  /* AK 020692 */
		{  /* AK 020692 */
		m_ilih_m(1L,1L,dmat);  /* AK 020692 */
		m_i_i(1L,S_M_IJ(dmat,0L,0L));  /* AK 020692 */
		return OK;  /* AK 020692 */
		}  /* AK 020692 */

  dimen=callocobject();

  l_pa=S_PA_LI(lambda);
  l_p=S_P_LI(pi);
  spe=l_pa+l_p+2L;
  dimension(lambda,dimen);
  MAXDM=(INT)S_I_I(dimen);
  spe += ((INT)MAXDM*(INT)MAXDM*5L);
  part=(INT *)calloc(ALLOCOFFSET+spe,sizeof(INT));
  if (!part)
    return(-1L);
  perm=part+l_pa+1L;
  bz=perm+l_p+1L;
  for (i=0L;i<l_pa;i++)
    part[i]=(INT)S_PA_II(lambda,(l_pa-1L-i));
  for (i=0L;i<l_p;i++)
    perm[i]=(INT)S_P_II(pi,i);
  if ((dim=alkonmat(part,perm,bz))<0L)
  {
    freeall(dimen);free(part);
    return(-1L);
  }
  darmat[0]=(INT *)calloc(ALLOCOFFSET+(int)dim*(int)dim,sizeof(INT));
  darmat[1]=(INT *)calloc(ALLOCOFFSET+(int)dim*(int)dim,sizeof(INT));
  if (!darmat[0])
  {
    freeall(dimen);free(part);
    return(-1L);
  }
  if (!darmat[1])
  {
    freeall(dimen);free(part);
    return(-1L);
  }
  pz=(INT)S_I_I(prime);
  gzl=1L;
  if ((dim=darmod(part,dim,bz,pz,&gzl,perm,darmat))
	<=0L) /* AK 020692 <= statt < */
  {
	freeall(dimen);
	free(part);
	free(darmat[0]); /* AK 020692 statt free(darmat) */
	free(darmat[1]); /* AK 020692 statt free(darmat) */
	return(-1L);
  }
  m_ilih_m((INT)dim,(INT)dim,dmat);
  for (i=0L,dar=darmat[1];i<(INT)dim;i++)  
		/* darmat[1] statt darmat[0] *//* AK 301091 */
    for (j=0L;j<(INT)dim;j++)
      m_i_i((INT)(*dar++),s_m_ij(dmat,i,j));
  freeall(dimen);free(part);
  free(darmat[0]);
  free(darmat[1]);
  return((INT)dim);
} /* moddg */


/*----------------------------------------------------------------------------*/
INT decp_mat(sn,prime,dmat) OP sn; OP prime;OP dmat;
/*-----------------------------------------------------------------------------
  berechnet zu Sn und einer Primzahl prime die Zerlegungsmatrix dmat.
  Variablen:    sn, Sn;
                prime, Primzahl.
  Rueckgabewerte: 0L, falls kein Fehler aufgetreten ist;
                 -1L, falls Fehler aufgetreten ist.
  Rueckgabe Zerlegungsmatrix dmat.
-----------------------------------------------------------------------------*/
{
  INT TL_n,p,row,col,*dec,*d;
  INT i,j;

  TL_n=(INT)S_I_I(sn);
  p=(INT)S_I_I(prime);
  if ((col=_num_part(TL_n,p))<0L) return(ERROR);
  row=_num_part(TL_n,0L);
  dec=(INT *)calloc(ALLOCOFFSET+(int)col*(int)row,sizeof(INT));
  if (!dec) return(ERROR);
  if (d_mat(dec,col,row,TL_n,p))
  {
    free(dec);
    return error("decp_mat:error during computation");
  }
  m_ilih_m((INT)col,(INT)row,dmat);
  for (i=0L,d=dec;i<(INT)row;i++)
    for (j=0L;j<(INT)col;j++)
      m_i_i((INT)(*d++),S_M_IJ(dmat,i,j));
  free(dec);
  return(0L);
} /* decp_mat */


/*----------------------------------------------------------------------------*/
INT homp(transmat,nzykmat,sn,prime,relation)
/*------------------------------------------------------------------------------
  testet die Darstellung ueber die darstellenden Matrizen einer
  Transposition und eines n-Zykels.
  Variablen:  transmat, darstellende Matrix einer Transposition
        (objectkind: MATRIX);
      nzykmat,  darstellende Matrix eines n-Zykels
        (objectkind: MATRIX);
      sn,  Sn (objectkind: INTEGER);
      prime,  Primzahl,fuer welche die darstellenden Matrizen
        berechnet wurden (objectkind: INTEGER).
  Rueckgabewerte: 0L,  alle Relationen sind erfuellt;
      >0L, Relation ... ist nicht erfuellt;
      -1L,  Fehler aufgetreten.
  Rueckgabe relation erhaelt die Nummer der nicht erfuellten Relation
    oder 0.
------------------------------------------------------------------------------*/
OP transmat;OP nzykmat;OP sn;OP prime;OP relation;
{
  INT *darmat[2],*d[2];
  INT dm,i_n,rl,pz;
  INT i,j;

  if (!S_M_LI(transmat))
  {
    m_i_i(0L,relation);
    return(0L);
  }
  dm=(INT)S_M_LI(transmat);
  i_n=(INT)S_I_I(sn);
  pz=(INT)S_I_I(prime);
  darmat[0]=(INT *)calloc(ALLOCOFFSET+(int)dm*(int)dm*2,sizeof(INT));
  if (!darmat[0])
    return(-1L);
  darmat[1]=darmat[0]+(INT)dm*(INT)dm;
  for (i=0L,d[0]=darmat[0],d[1]=darmat[1];i<(INT)dm;i++)
    for (j=0L;j<(INT)dm;j++)
    {
      *d[0]++ =(INT)S_M_IJI(transmat,i,j);
      *d[1]++ =(INT)S_M_IJI(nzykmat,i,j);
    }
  if ((rl=homtestp(darmat,i_n,dm,pz))<0L)
  {
    free(darmat[0]);
    return(-1L);
  }
  m_i_i((INT)rl,relation);
  free(darmat[0]);
  return((INT)rl);
} /* homp */


/*----------------------------------------------------------------------------*/
INT brauer_char(sn,prime,bc)
/*------------------------------------------------------------------------------
  berechnet die Charaktertafel der Brauercharaktere der Sn zur Primzahl prime.
  Variablen:    sn, Sn (objectkind:INTEGER);
                prime,Primzahl (objectkind:INTEGER).
  Rueckgabewerte: 0L, falls fehlerfrei;
                 -1L, falls Fehler aufgetreten ist.
  Rueckgabe der Charaktertafel bc.
------------------------------------------------------------------------------*/
OP sn,prime,bc;
{
  INT _n,p,col,*idx,*idm;
  INT i,j,k;
  OP  tafel=callocobject();
  OP  decomp=callocobject();
  OP  su=callocobject();
  OP  mu=callocobject();
  OP  _su=callocobject();

  _n=(INT)S_I_I(sn);
  p=(INT)S_I_I(prime);
  if ((col=_num_part(_n,p))<0L)
    return(-1L);
  idx=(INT *)calloc(ALLOCOFFSET+(int)col*2,sizeof(INT));
  if (!idx)
  {
    freeall(tafel);
    freeall(decomp);freeall(su);
    freeall(mu);freeall(su);
    return(-1L);
  }
  idm=idx+(INT)col;
  if (_ber_idx_pelem(_n,p,col,idx))
  {
    free(idx);freeall(tafel);
    freeall(decomp);freeall(su);
    freeall(mu);freeall(su);
    return(-1L);
  }
  if (decp_mat(sn,prime,decomp))
  {
    free(idx);freeall(tafel);
    freeall(decomp);freeall(su);
    freeall(mu);freeall(_su);
    return(-1L);
  }
  _ber_inx_dec(decomp,idm);
  start_longint();
  chartafel(sn,tafel);
  m_ilih_m((INT)col,(INT)col,bc);
  for (i=0L;i<(INT)col;i++)
    for (j=0L;j<(INT)col;j++)
    {
      copy(S_M_IJ(tafel,(INT)idm[i],(INT)idx[j]),su);
      for (k=0L;k<i;k++)
      {
        mult(S_M_IJ(decomp,(INT)idm[i],k),S_M_IJ(bc,k,j),mu);
        addinvers(mu,_su);
        add(su,_su,su);
      }
      copy(su,S_M_IJ(bc,i,j));
    }
  free(idx);
  freeall(tafel);freeall(decomp);freeall(su);
  freeall(_su);freeall(mu);
  return(0L);
} /* brauer_char */
/*
  test the functions moddg(...), homp(...), decp_mat(...) and
  brauer_char(...).
*/


INT test_mdg()
{
  OP  lambda=callocobject();
  OP  trans=callocobject();
  OP  transmat=callocobject();
  OP  nzyk=callocobject();
  OP  nzykmat=callocobject();
  OP  prime=callocobject();
  OP  sn=callocobject();
  OP  relation=callocobject();
  INT i_n,i,dim;

  scan(PARTITION,lambda);
  scan(INTEGER,prime);
  weight(lambda,sn);
  i_n=S_I_I(sn);
  init(PERMUTATION,trans);
  m_il_v(i_n,S_P_S(trans));
  m_i_i(2L,S_P_I(trans,0L));
  m_i_i(1L,S_P_I(trans,1L));
  for (i=2L;i<i_n;i++) m_i_i(i+1L,S_P_I(trans,i));
  println(trans);
  if ((dim=moddg(prime,lambda,trans,transmat))<0L)
  {
    freeall(lambda);freeall(prime);
    freeall(trans);freeall(transmat);
    freeall(nzyk);freeall(nzykmat);
    freeall(sn);freeall(relation);
    return(-1L);
  }
  println(transmat);
  init(PERMUTATION,nzyk);
  m_il_v(i_n,S_P_S(nzyk));
  for(i=0L;i<i_n-1L;i++) m_i_i(i+2L,S_P_I(nzyk,i));
  m_i_i(1L,S_P_I(nzyk,i_n-1L));
  println(nzyk);
  if ((dim=moddg(prime,lambda,nzyk,nzykmat))<0L)
  {
    freeall(lambda);freeall(prime);
    freeall(trans);freeall(transmat);
    freeall(nzyk);freeall(nzykmat);
    freeall(sn);freeall(relation);
    return(-1L);
  }
  println(nzykmat);
  if (homp(transmat,nzykmat,sn,prime,relation)<0L)
  {
    freeall(lambda);freeall(prime);
    freeall(trans);freeall(transmat);
    freeall(nzyk);freeall(nzykmat);
    freeall(sn);freeall(relation);
    return(-1L);
  }
  println(relation);
  freeall(lambda);freeall(relation);
  freeall(trans);freeall(transmat);
  freeall(nzyk);freeall(nzykmat);
  freeall(sn);freeall(prime);
} /* test_mdg */


INT test_dcp()
{
  OP  prime=callocobject();
  OP  sn=callocobject();
  OP  decmat=callocobject();

  scan(INTEGER,sn);
  scan(INTEGER,prime);
  if (decp_mat(sn,prime,decmat))
  {
    freeall(prime);freeall(sn);
    freeall(decmat);
    return(-1L);
  }
  println(decmat);
  freeall(prime);freeall(sn);
  freeall(decmat);
  return(0L);
} /* test_dcp */


INT test_brc()
{
  OP  prime=callocobject();
  OP  sn=callocobject();
  OP  tafel=callocobject();

  scan(INTEGER,sn);
  scan(INTEGER,prime);
  if (brauer_char(sn,prime,tafel))
  {
    freeall(prime);freeall(sn);
    freeall(tafel);
    return(-1L);
  }
  println(tafel);
  freeall(prime);freeall(sn);
  freeall(tafel);
  return(0L);
} /* test_brc */

/*----------------------------------------------------------------------------*/
static INT _ber_idx_pelem(sn,p,c,idx)
/*------------------------------------------------------------------------------
  berechnet Index eines p-Elements in der Liste der Partitionen der Sn.
  Variablen:    sn, Sn;
                p, Primzahl;
                c, Anzahl der p-Elemente.
  Rueckgabewerte: 0L, kein Fehler aufgetreten;
              -9999L, nicht genuegend Speicher.
  Rueckgabe Indexvektor idx.
------------------------------------------------------------------------------*/
INT sn,p,c,*idx;
{
  INT i,j,e,d,*r,*m,*id;

  for (i=0L;i<c;idx[i++]=0L);
  r=(INT *)calloc(ALLOCOFFSET+(int)(sn+1)*2,sizeof(INT));
  if (r == NULL) return no_memory();
  m=r+(INT)(sn+1L);
  e=1L;d=0L;
  i=0L;
  id=idx;
  while (e)
  {
    e=d=_nexpart(sn,d,r,m);
    for (j=1L;j<=r[0];j++)
      if (!(r[j]%p))
        break;
    if (j>r[0]) *id++ =i;
    i++;
  }
  free(r);
  return(0L);
} /* _ber_idx_pelem */


/*----------------------------------------------------------------------------*/
_ber_inx_dec(dcm,idx)
/*------------------------------------------------------------------------------
  berechnet in den Spalten der Zerlegungsmatrix dcm den Zeilenindex des ersten
  Elements !=0.
  Variablen:    dcm, Zerlegungsmatrix;
                col, Spaltenanzahl der Zerlegungsmatrix;
                row, Zeilenanzahl der Zerlegungsmatrix.
  Rueckgabe Indexvektor idx.
------------------------------------------------------------------------------*/
OP dcm;INT *idx;
{
  INT i,j,col,row;
  INT *id;

  col=S_M_LI(dcm);
  row=S_M_HI(dcm);
  for (i=0L;i<col;idx[i++]=0L);
  for (j=0L,id=idx;j<col;j++)
    for (i=0L;i<row;i++)
      if (!nullp(S_M_IJ(dcm,i,j)))
      {
        
        *id++ = (INT)i;
        break;
      }
} /* _ber_idx_dec */

/*******************************************************************************
*
* Datei HOMP.C
*   Version vom 29.09.1989
*
*
* Zeile Funktion
*
*       Funktion zur Ueberpruefung der Darstellungen
*       --------------------------------------------
* 30    INT homtestp(INT **darmat,INT n,INT ddim,INT pz)
*
*******************************************************************************/

/*----------------------------------------------------------------------------*/
static INT homtestp(AH(INT **,darmat),AH(INT,n),AH(INT,ddim),AH(INT,pz))
/*------------------------------------------------------------------------------
  ueberprueft, ob die im Buch von Carmichael auf Seite 175  (Aufgabe 2)
  angegebenen Relationen erfuellt sind, d.h. eine treue Darstellung von Sn
  erzeugt wird. Dabei wird ueber GF(pz) gerechnet. Es handelt sich insgesamt
  um 4+[n/2] Relationen.
  Indexnummern: 1.  t^2 = I,
                2.  s^n = I,
                3.  (st)^(n-1L) = I,
                4.  (ts^(-1L)ts)^3 = I,
                3+j.  (ts^(-j)ts^j)^2 = I fuer j=2L,...,[n/2].
  Variablen:  darmat, darstellende Matrizen einer Transposition
                      und eines n-Zykels;
              n,  Sn;
              ddim, Dimension der darstellenden Matrizen;
              pz, Primzahl.
  Rueckgabewerte: 0L,  falls alle Relationen erfuellt sind;
              index,  falls Relation mit Indexnummer index nicht
                      erfuellt ist;
                -14L,  falls n kleiner 1 ist;
                -15L,  falls n groesser MAXN ist;
                -22L,  falls Pointer auf darmat NULL ist;
                -24L,  falls pz keine Primzahl ist;
                -25L,  falls pz kleiner 1 ist;
                -26L,  falls pz groesser n ist;
                -28L,  falls ddim kleiner 0 ist;
                -29L,  falls ddim groesser MAXDM ist;
              -9999L,  falls nicht genuegend Speicher zu Verfuegung war.
------------------------------------------------------------------------------*/
KH(INT **darmat) KH(INT n) KH(INT ddim) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *invzyk,*mat,*mat_eins,k,i,j,az;

  if (ddim<0L) return(DDmLt_null);
  else if (ddim==0L) return(0L);
  else if (ddim>MAXDM) return(DDmGMx);
  else if (darmat==NULL) return (DrtNul);
  else if (n<=0L) return(NLe_null);
  else if (n>MAXN) return(NGtMax);
  else if (pz<=0L) return(PrmLe_null);
  else if (pz>n) return(PrmGtN);
  for (i=0L;PZ[i]<=n && PZ[i]<=pz;i++);
  if (pz!=PZ[i-1]) return(NoPrm);
/*
  Kein Eingabefehler, also koennen wir loslegen:
*/
  mat=(INT *)calloc(ALLOCOFFSET+(int)ddim*(int)ddim*3,sizeof(INT));
  if (!mat)
    return no_memory();
  mat_eins= &mat[(INT)ddim*(INT)ddim];
  invzyk= &mat_eins[(INT)ddim*(INT)ddim];
  if (stream) fprintf(stream,"There are %d relations.\n",n/2+3L);
  matcopy(mat,darmat[0],ddim);
  if (rmatmulp(mat,darmat[0],ddim,pz)<0L)
  {
    free(mat);
    return no_memory();
  }
  if (!idmat(mat,ddim)) /* t^2 = 1 ? */
  {
    if (stream) fprintf(stream,"Relation 1 is wrong.\n");
    free(mat);
    return(1L);
  }
  if (stream) fprintf(stream,"Relation 1 ok");
  matcopy(mat,darmat[1],ddim);
  rmatmulp(mat,darmat[0],ddim,pz);
  matcopy(mat_eins,mat,ddim);
  az=1L;
  while (2L*az <= (n-1L))
  {
    matcopy(invzyk,mat_eins,ddim);
    rmatmulp(mat_eins,invzyk,ddim,pz);
    az *= 2L;
  }
  for (i=az+2L; i<= n; i++)
    rmatmulp(mat_eins,mat,ddim,pz);
  if (!idmat(mat_eins,ddim))  /* (s * t) ^ (n-1L) =1 ? */
  {
    if (stream) fprintf(stream,"\nRelation 3 is wrong.\n");
    free(mat);
    return(3L);
  }
  if (stream) fprintf(stream,", 3 ok");
  matcopy(mat,darmat[1],ddim);
  az=1L;
  while (2L*az <= n-1L)
  {
    matcopy(mat_eins,mat,ddim);
    rmatmulp(mat,mat_eins,ddim,pz);
    az*=2L;
  }
  for (i=az+2L;i<=n;++i)
    rmatmulp(mat,darmat[1],ddim,pz);
  matcopy(invzyk,mat,ddim); /* s^(-1L) = s^(n-1L) */
  rmatmulp(mat,darmat[1],ddim,pz);
  if (!idmat(mat,ddim)) /* s^n = 1 ? */
  {
    if (stream) fprintf(stream,"\nRelation 2 is wrong.\n");
    free(mat);
    return(2L);
  }
  if (stream) fprintf(stream,", 2 ok");
  matcopy(mat,darmat[0],ddim);
  rmatmulp(mat,invzyk,ddim,pz);
  rmatmulp(mat,darmat[0],ddim,pz);
  rmatmulp(mat,darmat[1],ddim,pz);
  matcopy(mat_eins,mat,ddim);
  rmatmulp(mat_eins,mat,ddim,pz);
  rmatmulp(mat_eins,mat,ddim,pz);
  if (!idmat(mat_eins,ddim))  /* (t * s^(-1L) * t * s) ^ 3 = 1 ? */
  {
    if (stream) fprintf(stream,"\nRelation 4 is wrong.\n");
    free(mat);
    return(4L);
  }
  if (stream) fprintf(stream,", 4 ok");
  k=n/2L;
  for (j=2L; j<=k; j++)
  {
    rmatmulp(mat,darmat[1],ddim,pz);  /* in mat ist noch t*s^1*t*s */
    lmatmulp(darmat[0],mat,ddim,pz);
    lmatmulp(invzyk,mat,ddim,pz);
    lmatmulp(darmat[0],mat,ddim,pz);
    matcopy(mat_eins,mat,ddim);
    rmatmulp(mat_eins,mat,ddim,pz);
    if (!idmat(mat_eins,ddim))  /* (t*s^(-j)*t*s^j)^2 = 1 fuer j=2L,...k ? */
    {
      if (stream) fprintf(stream,"\nRelation %d is wrong.\n",3+j);
      free(mat);
      return(j+3L);
    }
    if (stream) fprintf(stream,", %d ok",j+3L);
  }
  if (stream) fprintf(stream,".\n");
  free(mat);
  return(0L);
} /*homtestp */
/*******************************************************************************
*
* Datei MODMAT.C
*   Version vom 11.10.1989
*
*
* Zeile Funktion
*
*       Funktionen fuer Matrixoperationen
*       ---------------------------------
* 39    matcopy(INT *ziel,INT *quelle,INT dim)
* 59    INT rmatmulp(INT *lmat,INT *rmat,INT pdim,INT pz)
* 102   INT lmatmulp(INT *lmat,INT *rmat,INT pdim,INT pz)
* 152   INT idmat(INT *z,INT dm)
*
*******************************************************************************/
/*
  Uebliche Headerfiles...
*/



/*----------------------------------------------------------------------------*/
matcopy(AH(INT *,ziel),AH(INT *,quelle),AH(INT,dim))
/*------------------------------------------------------------------------------
  kopiert die (dim x dim)-Matrix quelle auf die (dim x dim)-Matrix ziel.
  Variablen:  quelle, Matrix;
              dim,  Dimension beider Matrizen.
  Rueckgabe Matrix ziel, Kopie von Matrix quelle.
------------------------------------------------------------------------------*/
KH(INT *ziel) KH(INT *quelle) KH(INT dim)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT  i;
  INT *bb,*aa;

  bb=ziel;
  aa=quelle;
  for (i=(INT)dim*(INT)dim; i>0L ; i--)
    *bb++= *aa++;
} /* matcopy */


/*----------------------------------------------------------------------------*/
static INT rmatmulp(AH(INT *,lmat),AH(INT *,rmat),AH(INT,pdim),AH(INT,pz))
/*-----------------------------------------------------------------------------
  multipliziert die (pdim x pdim)-Matrix lmat von rechts mit der
  (pdim x pdim)-Matrix rmat. Dabei werden Multiplikationen und Additionen
  modulo pz ausgefuehrt.
  Variablen:  lmat, Matrix;
              rmat, Matrix;
              pdim, Dimension der Matrizen;
              pz, Primzahl.
  Rueckgabe Ergebnismatrix lmat.
  Ruechgabewerte: 0L,  falls alles geklappt hat;
              -9999L,  falls der noetige Speicher nicht vorhanden war.
------------------------------------------------------------------------------*/
KH(INT *lmat) KH(INT *rmat) KH(INT pdim) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT h,i,j,k,o_eins,o_zwei,*aa,*bb,*hilf,*aa_eins;

  hilf=(INT *)calloc(ALLOCOFFSET+(int)pdim,sizeof(INT));
  if (hilf == NULL) return no_memory();
  aa_eins=lmat;
  for (i=0L ; i < pdim; ++i)
  {
    for (j=0L ; j < pdim; ++j)
    {
      h=0L;
      bb= &rmat[(INT)j];
      aa=aa_eins;
      for (k=0L; k<pdim; k++,bb+=(INT)pdim)
      {
        if ((o_eins= *aa++)==0L) continue;
        if ((o_zwei= *bb)==0L) continue;
        h=adp(h,mulp(o_eins,o_zwei,pz),pz);
      }
      hilf[j]=h;
    }
    for (j=0L; j < pdim; ++j) *aa_eins++=hilf[j];
  }
  free(hilf);
  return(0L);
} /* rmatmulp */


/*----------------------------------------------------------------------------*/
static INT lmatmulp(AH(INT *,lmat),AH(INT *,rmat),AH(INT,pdim),AH(INT,pz))
/*------------------------------------------------------------------------------
  multipliziert die (pdim x pdim)-Matrix rmat von links mit der
  (pdim x pdim)-Matrix lmat. Dabei werden Multiplikationen und Additionen
  modulo pz ausgefuehrt.
  Variablen:  lmat, Matrix;
              rmat, Matrix;
              pdim, Dimension der Matrizen;
              pz, Primzahl.
  Rueckgabe Ergebnismatrix rmat.
  Rueckgabewerte: 0L,  falls kein Fehler aufgetreten ist;
              -9999L,  falls kein Speicher zu Verfuegung stand.
------------------------------------------------------------------------------*/
KH(INT *lmat) KH(INT *rmat) KH(INT pdim) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT h,i,j,k,*hilf,*_a,*_b,o_eins,o_zwei;

  hilf=(INT *)calloc(ALLOCOFFSET+(int)pdim,sizeof(INT));
  if (hilf==NULL) no_memory();

  for (j=0L ;j < pdim; ++j)
  {
    _a=lmat;
    for (i=0L ; i < pdim; ++i)
    {
      _b=rmat+j;
      h=0L;
      for (k=0L ; k < pdim; k++,_b+=pdim)
      {
        if ((o_eins= *_a++)==0L) continue;
        if ((o_zwei= *_b)==0L) continue;
        h=adp(h,mulp(o_eins,o_zwei,pz),pz);
      }
      hilf[i]=h;
    }
    _b=rmat+j;
    for (i=0L; i < pdim; ++i)
    {
      *_b=hilf[(INT)i];
      _b+=pdim;
    }
  }
  free(hilf);
  return(0L);
} /* lmatmulp */


/*----------------------------------------------------------------------------*/
static INT idmat(AH(INT *,z),AH(INT,dm))
/*------------------------------------------------------------------------------
  testet die (dm x dm)-Matrix z, ob sie die Einheitsmatrix ist.
  Variablen:  z,  Matrix;
              dm, Dimension der Matrix.
  Rueckgabewerte: TRUE, falls z Einheitsmatrix ist;
                 FALSE, falls z keine Einheitsmatrix ist.
------------------------------------------------------------------------------*/
KH(INT *z) KH(INT dm)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT i,j,o_eins,*zz;

  zz=z;
  for (i=0L; i<dm; ++i)
    for (j=0L; j<dm; ++j)
    {
      o_eins= *zz++;
      if (i==j)
      {
        if (o_eins!=1L) return(FALSE);
      }
      else
      {
        if (o_eins) return(FALSE);
      }
    }
  return(TRUE);
} /* idmat */
/*******************************************************************************
*
* Datei MODULDG.C
*   Version vom 29.09.1989
*
*
* Zeile Funktion
*
*       Funktionen zur Berechnung der gew./p-mod. irred. Darst.
*       -------------------------------------------------------
* 75    moddreimat(INT *hz,INT pz,INT mode)
* 126   _modgauss(INT *hz,INT pz,INT i,INT mode)
*
*       Funktionen zur Berechnung der gew. irred. Darstellungen
*       -------------------------------------------------------
* 160   r_modgauss(INT *hz,INT pz)
* 181   INT ganzgaussmod(INT *bz,INT *hz)
*
*       Funktionen zur Berechnung der p-mod. irred. Darstellungen
*       ---------------------------------------------------------
* 269   modmat(INT *hz,INT pr)
* 290   INT modgauss(INT *hz,INT *v,INT pr)
* 363   p_rel(INT *hz,INT *v,INT pr)
* 392   zykel(INT *liste,INT *zyk)
* 439   INT p_writemat(INT *hz,INT *v,INT *lambda,INT pr,INT *perm,INT **darmat,
*             INT prang)
* 521   INT TL_darmod(INT *hz,INT *lambda,INT pr,INT *perm,INT **darmat)
*
*       Hauptfunktion
*       -------------
* 563   INT darmod(INT *lambda,INT dim,INT *bz,INT pz,INT *gzl,INT *perm,
*             INT **darmat)
*
*******************************************************************************/
/*
  Uebliche Headerfiles,...
*/

#define IND(a,b,c) (INT)((INT)(a)*(INT)(c)+(INT)(b))


/*
  und globale Variablen.
*/
static INT _dm;
static INT _dm_zwei;
static INT _dm_drei;


/*******************************************************************************
*
* Funktionen fuer die Bestimmung gew./p-mod. irred. Darstellungen...
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
moddreimat(AH(INT *,hz),AH(INT,pz),AH(INT,mode))
/*------------------------------------------------------------------------------
  mode=1:
    bringt die erste (_dm x _dm)-Teilmatrix von hz mit Hilfe des Gaussalgorith-
    mus ueber GF(pz) auf obere Dreiecksform mit 1 oder 0 auf der Hauptdiago-
    nalen,
  mode=3:
    wendet auf das (_dm x 3_dm)-Gleichungsschema hz den Gaussalgorithmus ueber
    GF(pz) an, bis die erste der drei (_dm x _dm)-Teilmatrizen eine obere Drei-
    ecksmatrix mit 1 oder 0 auf der Hauptdiagonalen ist.
    (Simultanes Loesen von 2_dm linearen Gleichungssystemen.)
  Variablen:  hz, Matrix mit Basis und Darstellungen;
              pz, Primzahl;
              mode, s.o.
  Rueckgabe Matrix hz.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT pz) KH(INT mode)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,*jz,*z_eins,*z_zwei,qu,mu,i,j,k,mdm;

  mdm=mode*_dm;
  for (i=0L,_hz=hz;i<_dm;i++,_hz += (_dm_drei+1L))
  {
    for (k=i+1L,jz=_hz+_dm_drei;!*_hz && k<_dm;k++,jz += _dm_drei)
      if (*jz)
        for (j=mdm,z_eins=jz,z_zwei=_hz;j>i;j--)
        {
          mu= *z_zwei;
          *z_zwei++ = *z_eins;
          *z_eins++ = mu;
        }
    if (*_hz)
    {
      if ((qu= *_hz)!=1L)
        for (j=mdm,z_eins=_hz;j>i;j--,z_eins++)
          *z_eins=divp(*z_eins,qu,pz);
      if (i<_dm-1L)
        for (k=i+1L,jz=_hz+_dm_drei;k<_dm;k++,jz += _dm_drei)
          if ((qu= *jz)!=0L)
            for (j=mdm,z_eins=jz,z_zwei=_hz;j>i;j--,z_eins++,z_zwei++)
              if (*z_zwei)
              {
                mu=(-1L)*(mulp(qu,*z_zwei,pz));
                *z_eins=adp(*z_eins,mu,pz);
              }
    }
  }
} /* moddreimat */


/*----------------------------------------------------------------------------*/
_modgauss(AH(INT *,hz),AH(INT,pz),AH(INT,i),AH(INT,mode))
/*------------------------------------------------------------------------------
  wird benoetigt fuer die Funktionen modgauss und r_modgauss.
  Variablen:  hz, Matrix mit Basis und Darstellungen;
              pz, Primzahl;
              i, Anfangswert der Schleife;
              mode, =1L, fuer modgauss,
                    =3L, fuer r_modgauss;
  Rueckgabe Matrix hz.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT pz) KH(INT i) KH(INT mode)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,*jz,*z_eins,*z_zwei,qu,mu,j,k,mdm;

  mdm=mode*_dm;
  for (j=i-1L,_hz= &hz[IND(i,i,_dm_drei)],jz=_hz-_dm_drei;j>=0L;j--,jz -= _dm_drei)
    if ((qu= *jz)!=0L)
      for (k=mdm,z_eins=_hz,z_zwei=jz;k>i;k--,z_zwei++,z_eins++)
        if (*z_eins)
        {
          mu= (-1L)*(mulp(qu,*z_eins,pz));
          *z_zwei= adp(*z_zwei,mu,pz);
        }
} /* _modgauss */


/*******************************************************************************
*
* Funktionen zur Bestimmung der gew. irred. Darstellungen...
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
r_modgauss(AH(INT *,hz),AH(INT,pz))
/*------------------------------------------------------------------------------
  wendet den Gaussalgorithmus ueber GF(pz) auf das (_dm x 3_dm)-Koeffizienten-
  schema an, wobei die erste (_dm x _dm)-Teilmatrix eine obere Dreiecksmatrix
  mit 0 oder 1 auf der Hauptdiagonalen sein muss.
  (Simultanes Loesen von 2_dm linearen Gleichungssystemen.)
  Variablen:  hz, Matrix mit Basis und Darstellungen;
              pz, Primzahl.
  Rueckgabe Matrix hz.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT pz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,i;

  for (i=_dm-1L,_hz= &hz[IND(_dm-1L,_dm-1L,_dm_drei)];i>0L;i--,_hz -= (_dm_drei+1L))
    if (*_hz)
      _modgauss(hz,pz,i,3L);
} /* r_modgauss */


/*----------------------------------------------------------------------------*/
INT ganzgaussmod(AH(INT *,bz),AH(INT *,hz))
/*------------------------------------------------------------------------------
  loest simultan die in dem (_dm x 3_dm)-Koeffizientenschema bz kodierten 2_dm
  linearen Gleichungssysteme. Am Ende stehen die Loesungen fuer die gew.
  irred. Darstellungen in den letzten 2_dm Spalten von bz.
  Koennen keine ganzz. Loesungen errechnet werden, wird die Berechnung abge-
  brochen.
  Variablen:  bz, Matrix aus alkonmat;
              hz, Matrix wie bz.
  Rueckgabe Matrix hz mit Basis und Matrizen der gewoehnlichen Darstellungen.
  Rueckgabewerte: 0L, falls alles geglueckt ist;
                -27L, falls keine ganzzahlige Loesung existiert.
------------------------------------------------------------------------------*/
KH(INT *bz) KH(INT *hz)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,*_bz,*z_eins,*z_zwei,*z_drei,su,i,j,k,pz;
  INT  il,cl;
  INT chance;

  pz=29L;
  chance=TRUE;
  while (chance)
  {
/*
  Interpretation von bz ueber GF(pz) und Uebergabe an hz
*/
    for (il=(INT)_dm*(INT)_dm_drei,_hz=hz,_bz=bz;il>0L;il--,_hz++,_bz++)
      if (*_bz)
        *_hz = mod(*_bz,pz);
      else
        *_hz = 0L;
/*
  Anwendung des Gaussalgorithmus ueber GF(pz)
*/
    moddreimat(hz,pz,3L);
    r_modgauss(hz,pz);
/*
  Rekonstruktion der ganzzahligen Loesungen
*/
    for (i=0L,_hz=hz+_dm;i<_dm;i++,_hz += _dm_drei)
      for (j=_dm,z_eins=_hz;j<_dm_drei;j++,z_eins++)
        if (*z_eins)
        {
          if ((*z_eins + *z_eins) > pz)
            *z_eins -= pz;
        }
/*
  Verifikation der Loesungen: Die Koeffizientenmatrix der Gleichungssysteme
  (die ersten _dm Spalten von bz) wird mit der Loesungsmatrix (die letzten
  2_dm Spalten von hz) multipliziert. Jeder Eintrag der Produktmatrix wird
  unmittelbar nach seiner Berechnung mit dem entsprechenden Eintrag in den
  letzten 2_dm Spalten von bz verglichen.
  cl gibt die Anzahl der Uebereinstimmungen an.
*/
    for(i=0L,cl=0L,_bz=bz;i<_dm;i++,_bz += _dm_drei)
      for (j=_dm,z_eins=_bz+_dm,_hz=hz+_dm;j<_dm_drei;j++,z_eins++,_hz++)
      {
        for (k=0L,su=0L,z_zwei=_hz,z_drei=_bz;k<_dm;k++,z_drei++,z_zwei +=_dm_drei)
        {
          if (! *z_zwei) continue;
          if (! *z_drei) continue;
          su += (*z_zwei * *z_drei);
        }
        if (su == *z_eins)
          ++cl;
      }
    if (cl==((INT)_dm_zwei*(INT)_dm))
      chance=FALSE;
    else
    {
      if (pz==211L)
        return(NoSolu);
      pz=211L;
      chance=TRUE;
    }
  }
  return(0L);
} /* ganzgaussmod */


/*******************************************************************************
*
* Funktionen zur Bestimmung der p-mod. irred. Darstellungen...
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
modmat(AH(INT *,hz),AH(INT,pr))
/*------------------------------------------------------------------------------
  transformiert die (_dm x 3_dm)-Matrix hz nach (hz mod pr).
  Variablen:  hz, Matrix mit Basis und Darstellungen;
              pr, Primzahl.
  Rueckgabe Matrix hz gerechnet modulo pr.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT pr)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz;
  INT  il;

  for (il=(INT)_dm*(INT)_dm_drei,_hz=hz;il>0L;il--,_hz++)
    if (*_hz)
      *_hz=mod(*_hz,pr);
    else
      *_hz=0L;
} /* modmat */


/*----------------------------------------------------------------------------*/
INT modgauss(AH(INT *,hz),AH(INT *,v),AH(INT,pr))
/*------------------------------------------------------------------------------
  berechnet mit Hilfe des Gaussalgorithmus ueber GF(pr) die Dimension der
  p-mod. irred. Darstellung. Der Gaussalgorithmus wird dabei auf die erste
  (_dm x _dm)-Teilmatrix von hz angewendet, wobei diese eine obere Dreiecks-
  matrix mit 0 oder 1 auf der Hauptdiagonalen sein muss.
  Variablen:  hz, Matrix mit Basis und Darstellungen;
              pr, Primzahl.
  Rueckgabe Nummernvektor v der abhaengigen Spalten in hz.
  Rueckgabewerte: prang, Dimension der p-modular irreduziblen Darstellung.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT *v) KH(INT pr)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,*z_eins,*z_zwei,*_v,qu,su,z,i,j,k,prang;

  prang=0L;
  for (i=0L;i<_dm;v[i++]=0L);
  for (i=_dm-1L,_hz= &hz[IND(_dm-1L,_dm-1L,_dm_drei)],_v= &v[_dm-1];i>0L;
       i--,_hz -= (_dm_drei+1L),_v--)
    if (*_hz)
    {
      if ((qu = *_hz)!=1L)
        for (k=i,z_eins=_hz;k<_dm;k++,z_eins++)
          if (*z_eins)
            *z_eins= divp(*z_eins,qu,pr);
      _modgauss(hz,pr,i,1L);
    }
    else
    {
      *_v = i+1L;
      ++prang;
    }
  if (hz[0]!=1L)
  {
    if ((qu=hz[0])==0L)
    {
      v[0]=1L;
      ++prang;
    }
    else
      for (j=0L,_hz=hz;j<_dm;j++,_hz++)
        if (*_hz)
          *_hz = divp(*_hz,qu,pr);
  }
  prang=_dm-prang;

  if (stream)
fprintf(stream,"The %d-dimension of the representation is %d.\n\n\n",pr,prang);

  for (i=_dm-2L,_v= &v[_dm-2],_hz= &hz[IND(_dm-2L,_dm-1L,_dm_drei)];i>=0L;
       i--,_v--,_hz -= (_dm_drei+1L))
    if (*_v == i+1L)
    {
      for (j=i+1L,su=0L,z_eins=_hz;!su && j<_dm;j++,z_eins++)
        if (*z_eins)
          su=j;
      if (su)
      {
        v[su]=0L;
        z_eins= &hz[IND(i,su,_dm_drei)];
        z_zwei= &hz[IND(su,su,_dm_drei)];
        for (j=su;j<_dm;++j)
        {
          z= *z_eins;
          *z_eins++ = *z_zwei;
          *z_zwei++ = z;
        }
      }
      _modgauss(hz,pr,su,1L);
    }
  return(prang);
} /* modgauss */


/*----------------------------------------------------------------------------*/
p_rel(AH(INT *,hz),AH(INT *,v),AH(INT,pr))
/*------------------------------------------------------------------------------
  Simultane Ermittlung und Anwendung der p-Relationen.
  (Lineare Algebra!)
  Variablen:  v, Nummern der abhaengigen Spalten in hz;
              pr, Primzahl;
              hz, Matrix mit Basis und Darstellungen.
  Rueckgabe Matrix hz.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT *v) KH(INT pr)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_v,*_hz,*z_eins,*z_zwei,*z_drei,*z_vier,mu,su,i,j,k;

  for (i=0L,_v=v,_hz=hz;i<_dm;i++,_v++,_hz += _dm_drei)
    if (*_v == i+1L)
      for (j=0L,z_eins=_hz+_dm,z_zwei=hz+_dm;j<_dm_zwei;j++,z_eins++,z_zwei++)
        if ((mu= *z_eins)!=0L)
          for (k=0L,z_drei=hz+i,z_vier=z_zwei;k<=i-1L;k++,z_drei += _dm_drei,z_vier += _dm_drei)
            if (*z_drei != 0L)
            {
              su= mulp(mu,*z_drei,pr);
              *z_vier=adp(su,*z_vier,pr);
            }
} /* p_rel */


/*----------------------------------------------------------------------------*/
INT zykel(AH(INT *,liste),AH(INT *,zyk))
/*------------------------------------------------------------------------------
  berechnet die Zykelschreibweise einer Permutation liste aus ihrer Listen-
  schreibweise. Dabei steht eine negative Zahl immer als Ende des Zykels.
  Variablen:  liste, Pointer auf die Permutation in Listenschreibweise.
  Rueckgabe Permutation zyk in Zykelschreibweise.
  Rueckgabewerte: 0L, falls kein Fehler aufgetreten ist;
              -9999L, falls nicht genuegend Speicher vorhanden war.
------------------------------------------------------------------------------*/
KH(INT *liste) KH(INT *zyk)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *z,merk,merk_eins,i,j,n;
  INT fertig;
  INT *besucht;

  for (n=0L;liste[n];n++);
  if ((besucht=(INT *)calloc(ALLOCOFFSET+(int)n,sizeof(INT)))==NULL)
    return no_memory();
  z=zyk;
  i=0L;
  *z++ =merk=merk_eins=1L;
  fertig=FALSE;
  do
  {
    besucht[i]=1L;
    if (liste[i]==merk_eins)
    {
      z--;
      *z++ = -merk;
      for (j=0L;j<n && besucht[j] && liste[j];j++);
      i=j;
      if (i>=n || !liste[i])
        fertig=TRUE;
      else
        *z++ =merk=merk_eins=i+1L;
    }
    else
    {
      merk= *z++ =liste[i];
      i=liste[i]-1L;
    }
  } while (!fertig && i<n && liste[i]);
  return(0L);
} /* zykel */


/*----------------------------------------------------------------------------*/
INT p_writemat(AH(INT *,hz),AH(INT *,v),AH(INT *,lambda),AH(INT,pr),
  AH(INT *,perm),AH(INT **,darmat),AH(INT ,prang))
/*------------------------------------------------------------------------------
  schreibt die in darmod berechneten Matrizen unter Beruecksichtigung der
  pr-Relationen auf stream. In darmat stehen die Darstellungsmatrizen, falls
  sie mindestens eine Spalte und eine Zeile enthalten.
  Rueckgabe Darstellungsmatrizen darmat.
  Rueckgabewerte: 0L, falls alles ohne Fehler durchgefuehrt wurde;
              -9999L, falls nicht genuegend Speicherplatz vorhanden ist.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT *v) KH(INT *lambda) KH(INT pr) KH(INT *perm)
KH(INT **darmat) KH(INT prang)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *dar,*_hz,*vi,*vj,*z_eins,*z_zwei,*z,i,j,n;
  INT q,klam;

  if (prang)
  {
    for (n=0L;perm[n];n++);
    n++;
    if (stream && prang<85L)
    {
      if ((z=(INT *)calloc(ALLOCOFFSET+(int)n,sizeof(INT)))==NULL)
        return no_memory();
      if (zykel(perm,z))
        return no_memory();
    }
    for (q=0L,_hz=hz+_dm;q<2L;q++,_hz += _dm)
    {
      for (i=0L,vi=v,z_eins=_hz,dar=darmat[q];i<_dm;i++,vi++,z_eins += _dm_drei)
        if (! *vi)
          for (j=0L,vj=v,z_zwei=z_eins;j<_dm;j++,vj++,z_zwei++)
            if (! *vj)
              *dar++ = *z_zwei;
      if (stream && prang<85L)
      {

        fprintf(stream,"D(%d/(%d",pr,lambda[0]);
        for (i=1L;i<n && lambda[i];++i)
          fprintf(stream,",%d",lambda[i]);
        switch ((int)q)
        {
          case 0L:
            fprintf(stream,")/(1 2L))");
            break;
          case 1L:
            fprintf(stream,")/(");
            klam=1L;
            for (i=0L;i<n && z[i];i++)
            {
              if (!klam)
              {
                fprintf(stream,"(");
                klam = 1-klam;
              }
              if (z[i]>0L)
                fprintf(stream,"%d ",z[i]);
              else
              {
                fprintf(stream,"%d)",-z[i]);
                klam=1-klam;
              }
            }
            fprintf(stream,")");
            break;
        }
        fprintf(stream,"\n");
        for (i=prang*prang,dar=darmat[q];i>0L;i--,dar++)
        {
          if (!(i%prang)) fprintf(stream,"\n");
          fprintf(stream,"%3d",*dar);
        }
        fprintf(stream,"\n\n\n");
        free(z);
      }
    }
  }
  return(0L);
}  /* p_writemat */


/*----------------------------------------------------------------------------*/
INT TL_darmod(AH(INT *,hz),AH(INT *,lambda),AH(INT,pr),AH(INT *,perm),
  AH(INT **,darmat))
/*------------------------------------------------------------------------------
  berechnet die pr-modular irreduziblen Darstellungsmatrizen fuer zwei Permu-
  tationen. Dazu muessen die Spalten der ersten (_dm x _dm)-Teilmatrix von hz
  die zugrunde gelegte Basis kodieren sowie die naechsten beiden (_dm x _dm)-
  Teilmatrizen von hz die  zugehoerigen gewoehnlichen darstellenden Matrizen
  sein. (_dm ist die gewoehnliche Dimension der Darstellung.)
  Variablen:  hz, Matrix mit der zugrunde gelegten Basis und die zugehoerigen
                  gewoehnlichen Darstellungsmatrizen;
              lambda, Partition;
              pr, Primzahl;
              perm, Permutation.
  Rueckgabe Matrizen darmat der p-modular irreduziblen Darstellungen.
  Rueckgabewerte: prang, Dimension der p-modular irreduziblen Darstellungen;
                  -9999L, falls nicht genuegend Speicher vorhanden war.
------------------------------------------------------------------------------*/
KH(INT *hz) KH(INT *lambda) KH(INT pr) KH(INT *perm) KH(INT **darmat)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *v,prang;

  if ((v=(INT *)calloc(ALLOCOFFSET+(int)_dm,sizeof(INT)))==NULL)
    return no_memory();
  modmat(hz,pr);
  moddreimat(hz,pr,1L);
  prang=modgauss(hz,v,pr);
  p_rel(hz,v,pr);
  if (p_writemat(hz,v,lambda,pr,perm,darmat,prang))
    return no_memory();
  free(v);
  return(prang);
} /* TL_darmod */


/*******************************************************************************
*
* Hauptfunktion zur Berechnung der p-mod. irred. Darstellungen...
*
*******************************************************************************/


/*----------------------------------------------------------------------------*/
static INT darmod(AH(INT *,lambda),AH(INT,dim),AH(INT *,bz),AH(INT,pz),AH(INT *,gzl),
  AH(INT *,perm),AH(INT **,darmat))
/*------------------------------------------------------------------------------
  koordiniert die Berechnung der gew. irred. Darstellungen mit der Berechnung
  der p-mod. irred.
  Variablen:  lambda, Partition;
              dim, Dimension der gewoehnlichen Darstellungen;
              bz, Koeffizientenschema aus alkonmat;
              pz, Primzahl,fuer welche die p-mod. Darstellungsmatrizen be-
                  rechnet werden;
              gzl, #0L, d.h. berechne zuerst die gew. irred. Darstellungen,
                   =0L, d.h. gew. irred. Darstellungen existieren schon;
              perm, Permutation, fuer die die Darstellungen berechnet werden.
  Rueckgabe Matrizen darmat der p-modular irreduziblen Darstellungen.
  Rueckgabewerte: prang, Dimension der Darstellung;
                    -10L, falls Pointer auf lambda NULL ist;
                    -11L, falls lambda keinen Eintrag hat;
                    -12L, falls lambda einen Eintrag kleiner 0 hat;
                    -13L, falls lambda keine eigentliche Partition ist;
                    -15L, falls n MAXN uebersteigt;
                    -18L, falls dim groesser MAXDM ist;
                    -19L, falls Pointer auf bz NULL ist;
                    -21L, falls dim kleiner 1 ist;
                    -22L, falls Pointer auf darmat NULL ist;
                    -23L, falls Pointer auf gzl NULL ist;
                    -24L, falls pz keine Primzahl ist;
                    -25L, falls pz kleiner 1 ist;
                    -26L, falls pz groesser n ist;
                    -27L, falls keine ganzzahlige Loesung bei der Berechnung
                         der gewoehnlichen Darstellungen existiert;
                    -30L, falls Pointer auf perm NULL ist;
                    -31L, falls ein Element von perm kleiner 1 ist;
                    -32L, falls ein Element von perm groesser n ist;
                    -33L, falls Laenge von perm groesser n ist;
                  -9999L, falls nicht genuegend Speicher zu Verfuegung steht.
  Bemerkungen:
    gzl veraendert sich selbststaendig. Wird darmod mit einem von alkonmat
    neuberechneten bz aufgerufen, muss gzl einen von 0 verschiedenen Wert
    haben. Sind die ganzzahligen Loesungen der gewoenlichen  Darstellungen
    berechnet, so ist gzl=0L, und man kann durch nochmaliges Aufrufen von
    darmod mit diesem die Berechnungen der gew. Darstellungen ueberspringen.
------------------------------------------------------------------------------*/
KH(INT *lambda) KH(INT dim) KH(INT *bz) KH(INT pz) KH(INT *gzl) KH(INT *perm)
KH(INT **darmat)
/* TL 0790 */ /* AK 210891 V1.3 */
{
  INT *_hz,*z_eins,*z_zwei,*z_drei,prang,n,j,i;
  INT *hz;  /* dim x 3dim */
  INT  il;


/*
  Abfangen moeglicher Uebergabefehler...
*/
  if (lambda==NULL)
    return(LmbNul);
  else if (!lambda[0])
    return(LmbEmp);
  for (j=0L,n=0L;lambda[j];j++)
    if (lambda[j]<0L)
      return(LmbLt_null);
    else
      n+=lambda[j];
  for (j=1L;lambda[j];j++)
    if (lambda[j]>lambda[j-1])
      return(LmbNRg);
  if (n>MAXN)
    return(NGtMax);
  else if (darmat==NULL)
    return(DrtNul);
  else if (gzl==NULL)
    return(GzlNul);
  else if (bz==NULL)
    return(BzNul);
  else if (dim<=0L)
    return(DimLe_null);
  else if (dim>MAXDM)
    return(DmGtMx);
  else if (pz<=0L)
    return(PrmLe_null);
  else if (pz>n)
    return(PrmGtN);
  else if (pz)
  {
    for (j=0L;PZ[j]<=n && PZ[j]<=pz;j++);
    if (pz!=PZ[j-1])
      return(NoPrm);
  }
  else if (perm==NULL)
    return(PerNul);
  for (j=0L;j<MAXN && perm[j];j++);
  if (j>n)
    return(PeLgGN);
  for (j=0L;j<n;j++)
    if (perm[j]<=0L)
      return(PerLe_null);
    else if (perm[j]>n)
      return(PerGtN);

/*
  Auf geht's...
*/
  _dm=dim;
  _dm_zwei=2L*_dm;
  _dm_drei=3L*_dm;
  if ((hz=(INT *)calloc(ALLOCOFFSET+(int)_dm_drei*(int)_dm,sizeof(INT)))==NULL)
    return no_memory();
  for (il=(INT)_dm*(INT)_dm_drei,z_eins=hz,z_zwei=bz;il>0L;il--)
    *z_eins++ = *z_zwei++;
  if (*gzl)
  {
    if (lambda[2])
      for (i=0L,_hz=hz+1L,z_zwei=hz+_dm_drei;i<_dm-1L;i++,_hz += (_dm_drei+1L),z_zwei += (_dm_drei+1L))
      {
        for (j=i+1L,z_eins=_hz,z_drei=z_zwei;j<_dm;j++,z_eins++,z_drei += _dm_drei)
          *z_drei = *z_eins;
        for (j=i+1L,z_eins=_hz+_dm,z_drei=z_zwei+_dm;j<_dm;j++,z_eins++,z_drei += _dm_drei)
          *z_drei = *z_eins;
      }
    for (il=(INT)_dm*(INT)_dm_drei,z_eins=bz,z_zwei=hz;il>0L;il--)
      *z_eins++ = *z_zwei++;
/*
  Berechnung der gewoehnlichen irreduziblen Darstellung mit Hilfe
  einer modularen Arithmetik.
*/
    *gzl=ganzgaussmod(bz,hz);
    for (i=0L,z_eins=hz,z_zwei=bz;i<_dm;++i)
    {
      for (j=0L;j<_dm;++j)
        *z_eins++ = *z_zwei++;
      for (j=_dm;j<_dm_drei;++j)
        *z_zwei++ = *z_eins++;
    }
  }
  if (!(*gzl))
/*
  Berechnung der modular irred. Darstellg.
*/
      prang=TL_darmod(hz,lambda,pz,perm,darmat);
  else
    prang= *gzl;
  free(hz);
  return(prang);
} /* darmod */

#endif /* DGTRUE */
