/* FILE:nu.c */
#include "def.h"
#include "macro.h"

INT squareroot(a,b) OP a,b;
/* AK 040291 V1.2 */ /* AK 140891 V1.3 */
/* b becomes the squareroot of a */
{
#ifdef SQRADTRUE
	INT erg=OK;

	if (a == b) {
		OP c = callocobject();
		*c = *a;
		erg += C_O_K(a,EMPTY);
		erg += squareroot(c,b);
		erg += freeall(c);
		goto sqende;
		}
	switch (S_O_K(a)) 
		{
#ifdef BRUCHTRUE 
		case BRUCH:  erg += squareroot_bruch(a,b); break;
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE 
		case INTEGER:  erg += squareroot_integer(a,b); break;
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE 
		case LONGINT:  erg += squareroot_longint(a,b); break;
#endif /* LONGINTTRUE */
		default: 
			printobjectkind(a);
			erg += error("squareroot: wrong type");
		}
sqende:
	if (erg != OK)
		error("squareroot:error during computation");
	return erg;

#else /* SQRADTRUE */
	return error("squareroot:SQ_RADICAL not available");
#endif /* SQRADTRUE */
}

INT ganzsquareroot(a,b) OP a,b;
/* AK 040291 V1.2 */
/* b becomes the integer squareroot of a */
/* AK 140891 V1.3 */
{
#ifdef SQRADTRUE
	INT erg = OK;
	if (a == b) {
		OP c = callocobject();
		*c = *a;
		erg += C_O_K(a,EMPTY);
		erg = ganzsquareroot(c,b);
		erg += freeall(c);
		goto gsqende;
		}
	switch (S_O_K(a)) 
		{
#ifdef INTEGERTRUE 
		case INTEGER:  erg+= ganzsquareroot_integer(a,b);
				break;
#endif /* INTEGERTRUE */
		default: printobjectkind(a);
			erg+=  error("ganzsquareroot: wrong type");
			break;
		}
gsqende:
	if (erg != OK)	
		error("ganzsquareroot:error during computation");
	return erg;
#else /* SQRADTRUE */
	return error("ganzsquareroot:SQ_RADICAL not available");
#endif /* SQRADTRUE */
}


INT max(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 010290 V1.1 */
/* b is a copy of the maximum element */

/* AK 140891 V1.3 */
{
	INT erg = OK;
	if (not EMPTYP(b)) 
		erg += freeself(b);
	switch (S_O_K(a))
	{
#ifdef MATRIXTRUE
	case MATRIX: erg += max_matrix(a,b);break;
#endif /* MATRIXTRUE */
#ifdef VECTORTRUE
	case WORD:
	case VECTOR: erg += max_vector(a,b); break;
#endif  /* VECTORTRUE */
	default: 
		printobjectkind(a); 
		return error("max:wrong type");
	};
	if (erg != OK)
		{
		printobjectkind(a); 
		error("max: error during computation");
		}
	return erg;
}

INT absolute(a,c) OP a,c;
/* AK 100888 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140891 V1.3 */
{
	switch(S_O_K(a))
		{
#ifdef INTEGERTRUE
		case INTEGER: return 
			m_i_i((S_I_I(a) > 0 ? S_I_I(a): - S_I_I(a)),c);
#endif /* INTEGERTRUE */
		}
	if (posp(a)) 	return(copy(a,c));
	else return(addinvers(a,c));
}

INT transpose(a,b) OP a,b;
/* AK 280388 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140891 V1.3 */
{
	if (a == b)
	{
		OP c = callocobject();
		copy (a,c); 
		transpose(c,b); 
		freeall(c);
		return(OK);
	};
	if (not EMPTYP(b)) 
		freeself(b);
	switch (S_O_K(a))
	{
#ifdef MATRIXTRUE
	case KOSTKA:
	case KRANZTYPUS:
	case MATRIX: return transpose_matrix(a,b);
#endif /* MATRIXTRUE */
	default:
		{
			printobjectkind(a);
			return error("transpose: wrong type");
		}
	};
}

INT sub(a,b,c)	OP a,b,c;
/* AK 300388 */ /* c = a - b */ /* AK 280689 V1.0 */ /* AK 131289 V1.1 */
/* AK 270291 V1.2 */ /* AK 140891 V1.3 */
{
	INT erg = OK; /* 270291 */
	OP d;
	d=callocobject();
	erg += addinvers(b,d); 
	erg += add(a,d,c); 
	erg += freeall(d);
	if (erg != OK)
		{
		printobjectkind(a);
		printobjectkind(b);
		error("sub: errors in computing");
		}
	return erg;
}

INT kgv(first,second,d) OP first, second, d;
/* 031186 */ /* d = kgv(first,second) */
/* AK 280689 V1.0 */ /* AK 131289 V1.1 */ /* AK 290591 V1.2 */
/* AK 140891 V1.3 */
{
	INT erg = OK;
	OP a=callocobject(), b=callocobject();
	erg += mult(first,second,a); 
	erg += ggt(first,second,b); 
	erg += div(a,b,d);
	erg += freeall(a); 
	erg += freeall(b); 
	return erg;
}

INT signum(a,c) OP a,c;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 140891 V1.3 */
{
	if (not EMPTYP(c))
		freeself(c);
	switch (S_O_K(a))
	{
#ifdef PERMTRUE
	case PERMUTATION: return(signum_permutation(a,c));
#endif /* PERMTRUE */
	default:
		{ 
		printobjectkind(a); 
		return error("signum:wrong type"); }
	};
}


INT lehmercode(a,b) OP a,b;
/* berechnet den lehmercode entweder einer permuation oder eines vectors
AK 270787 */
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 140891 V1.3 */
{
	INT erg = OK; /* AK 301091 */
	if (a==b) {
		OP c = callocobject(); 
		*c = *a; 
		C_O_K(b,EMPTY);
		erg += lehmercode(c,b); 
		erg += freeall(c); 
		return erg;
		}

	if (not EMPTYP(b)) 
		erg += freeself(b);
	switch (S_O_K(a))
	{
#ifdef PERMTRUE
	case PERMUTATION: erg += lehmercode_permutation(a,b);break;
	case VECTOR: erg += lehmercode_vector(a,b);break;
#endif /* PERMTRUE */
	default:
		{ 
		printobjectkind(a); 
		return error("lehmercode:input is of wrong type"); 
		}
	};
	if (erg  != OK) /* AK 301091 */
		error("lehmercode:error during computation");
	return erg;
}

INT add(a,b,d) OP a,b,d;
/* AK 160986 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 270291 V1.2 */ /* AK 070891 V1.3 */
{
	INT erg=OK;
	if 	((a == d)&&(b == d))
	{
		OP c=callocobject();
		*c = *a; 
		C_O_K(d, 0);
		erg += add(c,c,d); 
		erg += freeall(c); 
		goto add_ende;
	}
	else if	(a == d) 
		{
		OP c=callocobject();
		*c = *a; 
		C_O_K(d, 0);
		erg += add(c,b,d); 
		erg += freeall(c); 
		goto add_ende;
		}
	else if	(b == d) 
		{
		OP c=callocobject();
		*c = *b; 
		C_O_K(d, 0);
		erg += add(a,c,d); 
		erg += freeall(c); 
		goto add_ende;
		}
	
	
	else if	(EMPTYP(a)) 
		{
		erg +=  copy(b,d);
		goto add_ende;
		}
	else if	(EMPTYP(b)) 
		{
		erg +=  copy(a,d);
		goto add_ende;
		}
	if (not EMPTYP(d)) 
		if (S_O_K(d) != INTEGER) 
			erg += freeself(d);

	switch(S_O_K(b)) 
	{
#ifdef	MONOPOLYTRUE
	case MONOPOLY: erg += add_monopoly (b,a,d);goto add_ende;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC: erg += add_cyclo (b,a,d);goto add_ende;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL: erg += add_sqrad (b,a,d);goto add_ende;
#endif /* SQRADTRUE */
	}

	switch(S_O_K(a))
	{
#ifdef	MONOPOLYTRUE
	case MONOPOLY: erg += add_monopoly (a,b,d);goto add_ende;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC: erg += add_cyclo (a,b,d);goto add_ende;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL: erg += add_sqrad (a,b,d);goto add_ende;
#endif /* SQRADTRUE */
#ifdef GENCHARTRUE
	case GEN_CHAR: erg += add_gen_char(a,b,d);break;
#endif /* GENCHARTRUE */
	case INTEGER : 	erg += add_integer(a,b,d);break;
#ifdef PARTTRUE
	case PARTITION: erg += add_partition(a,b,d);break;
#endif  /* PARTTRUE */
#ifdef POLYTRUE
	case GRAL:
	case POLYNOM : erg += add_polynom(a,b,d);break;
	case MONOM : erg += add_monom(a,b,d);break;
#endif /* POLYTRUE */
#ifdef VECTORTRUE
	case VECTOR : erg += add_vector(a,b,d);break;
#endif /* VECTORTRUE */
#ifdef SCHURTRUE
	case SCHUR : erg += add_schur(a,b,d); break;
#endif  /* SCHURTRUE */
#ifdef LONGINTTRUE
	case LONGINT : erg += add_longint(a,b,d);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
	case KRANZTYPUS:
	case MATRIX : erg += add_matrix(a,b,d);break;
#endif /* MATRIXTRUE */
#ifdef HOMSYMTRUE
	case HOM_SYM : erg += add_homsym(a,b,d);break;
#endif
#ifdef SCHUBERTTRUE
	case SCHUBERT:
		{
			switch(S_O_K(b))
			{
			case SCHUBERT : erg += add_schubert_schubert(
					    a,b,d);break;
			default :
				{ printobjectkind(b);
				return error("add_schubert:wrong second type");}
			};
			break;
		}
#endif /* SCHUBERTTRUE */
#ifdef CHARTRUE
	case SYMCHAR: erg += add_symchar(a,b,d);break;
#endif
#ifdef BRUCHTRUE
	case BRUCH : erg += add_bruch (a,b,d);break;
#endif /* BRUCHTRUE */
	default: 
		{
		if (nullp(a)) {erg += copy(b,d); break; }
		if (nullp(b)) {erg += copy(a,d); break; }
			printobjectkind(a); 
			printobjectkind(b);
			return error("add: wrong types");
		}
	};
add_ende:
	if (erg != OK)
		{
			printobjectkind(a); 
			printobjectkind(b);
			return error("add: error during computation");
		}
	return erg;
}

INT sort(a) OP a;
/* sortiert das object in aufsteigender reihenfolge AK 270787 */
/* AK 160986 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 070891 V1.3 */
{
	if (a == NULL) 
			return error("sort:object is NULL"); 

	switch(S_O_K(a))
	{
#ifdef VECTORTRUE
	case VECTOR : return(sort_vector(a));
#endif /* VECTORTRUE */
	default: 
		{
			printobjectkind(a);
			return error("sort:wrong type"); 
		}
	};
}

INT length(a,d) OP a,d;
/* 160986 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140891 V1.3 */
{
	INT erg = OK; /* AK 071191 */
	OP c;
	if (a == d) /* AK 071191 */
		{
		c = callocobject();
		*c = *a;
		C_O_K(a,EMPTY);
		erg += length(c,a);
		erg += freeall(c);
		return erg;
		}

	if (not EMPTYP(d)) /* AK 071191 */
		erg += freeself(d);

	switch(S_O_K(a))
	{
#ifdef LISTTRUE
	case GRAL:
	case HOM_SYM:
	case LIST:
	case POLYNOM:
	case MONOPOLY:  /* MD */
	case SCHUBERT:
	case SCHUR: erg += length_list(a,d);break;
#endif /* LISTTRUE */
#ifdef PARTTRUE
	case PARTITION : erg += length_partition(a,d);break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
	case PERMUTATION : erg += length_permutation(a,d);break;
#endif /* PERMTRUE */
#ifdef SKEWPARTTRUE
	case SKEWPARTITION : erg += length_skewpartition(a,d);break;
#endif /* SKEWPARTTRUE */
#ifdef VECTORTRUE
	case WORD:
	case COMP:
	case VECTOR : erg += length_vector(a,d);break;
#endif /* VECTORTRUE */
	default:
		{
			printobjectkind(a);
			return error("length: wrong type");
		}
	};
	if (erg != OK) /* AK 071191 */
		return error("length: error during computation");
	return erg;
}

INT inhalt(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 050390 V1.1 */ /* AK 140891 V1.3 */
{
	if (a==b) {
		OP c = callocobject();
		copy(a,c); 
		inhalt(c,b); 
		freeall(c);
		return(OK); 
	}
	if (not EMPTYP(b))
		freeself(b);
	switch(S_O_K(a))
	{
#ifdef TABLEAUXTRUE
	case TABLEAUX : return(inhalt_tableaux(a,b));
#endif /* TABLEAUXTRUE */
	default:printobjectkind(a);return error("inhalt:wrong type");
	};
}

INT sum(a,res) OP a,res;
/* AK 280689 V1.0 */ /* AK 050390 V1.1 */ /* AK 120391 V1.2 */
/* AK 140891 V1.3 */
{
	INT erg = OK;
	/* if 181286 */
	if 	(a == res)
	{
		OP c=callocobject();
		*c = *a;
		C_O_K(a,EMPTY);
		erg += sum(c,res);
		erg += freeall(c);
		return erg;
	};

	if (not EMPTYP(res))
		erg += freeself(res);
	switch(S_O_K(a))
	{
#ifdef VECTORTRUE 
	case COMP :
	case VECTOR : erg += sum_vector(a,res); break;
#endif /* VECTORTRUE */
	default: 
		printobjectkind(a); 
		erg = error("sum:wrong type");
		break;
	};

	if (erg != OK)
		error("sum:error during computation");
	return erg;
}


INT conjugate(a,res) OP a,res;
/* AK 280689 V1.0 */ /* AK 281289 V1.1 */
/* AK 120891 V1.3 */
{
	INT erg = OK;
	if (EMPTYP(a)) 
		return(OK);

	if (a == res) {
		OP c = callocobject();
		*c = *a; 
		C_O_K(res,EMPTY); 
		erg += conjugate(c,res);
		erg += freeall(c); 
		goto conj_ende;
		}

	if (not EMPTYP(res)) 
		erg += freeself(res);

	switch(S_O_K(a))
	{
#ifdef PARTTRUE
	case PARTITION : erg += fastconjugate_partition(a,res);break;
#endif /* PARTTRUE */
#ifdef SKEWPARTTRUE
	case SKEWPARTITION :  /* AK 020890 V1.1 */
			erg += b_gk_spa(
			callocobject(), callocobject(), res);
			erg += conjugate(S_SPA_G(a),S_SPA_G(res));
			erg += conjugate(S_SPA_K(a),S_SPA_K(res));
			break;
#endif /* SKEWPARTTRUE */
	default:
		printobjectkind(a);
		erg +=  error("conjugate:wrong type");
		break;
	};
conj_ende:
	if ( erg != OK)
		error("conjugate: error during computation");
	return erg;
}


INT addinvers(a,res) OP a,res;
/* AK 280689 V1.0 */ /* AK 131289 V1.1 */ /* AK 270291 V1.2 */
/* AK 140891 V1.3 */
{
	INT erg = OK;
	if (a == res)
	{
		OP c=callocobject(); 
		*c = *a; 
		C_O_K(res,EMPTY);
		erg += addinvers(c,res); 
		erg += freeall(c); 
		if (erg != OK) 
			return error("addinvers:(1) error in computing");
		return erg;
	};

	if (not EMPTYP(res)) 
		erg += freeself(res);
	if (EMPTYP(a)) return(OK);

	switch(S_O_K(a))
	{
#ifdef BRUCHTRUE
	case BRUCH : 	erg += addinvers_bruch(a,res);break;
#endif /* BRUCHTRUE */
#ifdef CYCLOTRUE
	case CYCLOTOMIC: erg +=  addinvers_cyclo (a,res);break;
#endif /* CYCLOTRUE */
#ifdef HOMSYMTRUE
	case HOM_SYM : 	 erg+= addinvers_homsym(a,res);break;
#endif /* HOMSYMTRUE */
#ifdef INTEGERTRUE
	case INTEGER : 	  erg+= addinvers_integer(a,res);break;
#endif /* INTEGERTRUE */	
#ifdef LONGINTTRUE
	case LONGINT : 	 erg+= addinvers_longint(a,res);break;
#endif /* LONGINTTRUE */
#ifdef MONOMTRUE
	case MONOM :  erg+= addinvers_monom(a,res);break;
#endif /* MONOMTRUE */
#ifdef MONOPOLYTRUE
	case MONOPOLY: erg+= addinvers_monopoly (a,res);break;
#endif /* MONOPOLYTRUE */
#ifdef POLYTRUE
	case GRAL:
	case POLYNOM : 	erg += addinvers_polynom(a,res);break;
#endif /* POLYTRUE */
#ifdef SCHUBERTTRUE
	case SCHUBERT :	erg += addinvers_schubert(a,res);break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
	case SCHUR : 	erg += addinvers_schur(a,res);break;
#endif /* SCHURTRUE */
#ifdef SQRADTRUE
	case SQ_RADICAL: erg+=  addinvers_sqrad (a,res);break;
#endif /* SQRADTRUE */
#ifdef CHARTRUE
	case SYMCHAR : 	erg += addinvers_symchar(a,res);break;
#endif /* CHARTRUE */
#ifdef VECTORTRUE
	case VECTOR : 	 erg += addinvers_vector(a,res);break;
#endif /* VECTORTRUE */
	default: 
		{
			printobjectkind(a);
			return error("addinvers:wrong type");
		}
	};
	if (erg != OK) 
		{
		return error("addinvers:(2) error in computing");
		}
	return erg;
}

INT binom(oben , unten, d) OP oben, unten, d;
/* AK 041186 */
/* d = oben ! / unten ! * (oben -unten)! */
/* auf integer umgestellt am 120187 */
/* AK 280689 V1.0 */ /* AK 010290 V1.1 */
/* AK 140891 V1.3 */
{
	OP a,b,c;
	INT erg = OK;
	if (S_O_K(oben) != INTEGER) 
		return(error("binom:oben not integer"));
	else if (S_O_K(unten) != INTEGER) 
		return(error("binom:unten not integer"));
	else if (S_I_I(unten) < 0 ) 
		return(error("binom:unten < 0"));

	if (oben == d)
		{
		c = callocobject();
		*c = *oben;
		C_O_K(d,EMPTY);
		erg += binom(c,unten,d);
		erg += freeall(c);
		return erg;
		}

	if (unten == d)
		{
		c = callocobject();
		*c = *unten;
		C_O_K(d,EMPTY);
		erg += binom(oben,c,d);
		erg += freeall(c);
		return erg;
		}

	if (not EMPTYP(d)) 
		freeself(d);

	if (S_I_I(oben) == (-1L))
	{
		(S_I_I(unten) % 2L == 0L ?
		    M_I_I(1L,d) :
		    M_I_I(-1L,d));
		return(OK);
	}

	if (negp(oben))
	{
		INT schalter = 0L;
		b = callocobject();
		c = callocobject();
		a = callocobject();
		COPY_INTEGER(unten,b); COPY_INTEGER(oben,a);
		INC_INTEGER(a);
		while(S_I_I(b) >= 0L)
		{
			binom(a,b,c);
			(schalter++ % 2L == 0L ? add(c,d,d):
			    sub(d,c,d));
			dec(b);
		};
		goto binomende;
	}



	if (lt(oben,unten)) return(M_I_I(0L,d));
	if (eq(oben,unten)) return(M_I_I(1L,d));


	a = callocobject(); 
	fakul(oben,a);
	b = callocobject(); 
	fakul(unten,b);
	c = callocobject(); 
	sub(oben,unten,c); 
	fakul(c,c);

	mult(b,c,c); 
	ganzdiv(a,c,d);
binomende:
	freeall(a); freeall(b); freeall(c); return(OK);
}


INT inc(a) OP a;
/* AK 280689 V1.0 */ /* AK 081289 V1.1 */ /* AK 140891 V1.3 */
{
	switch(S_O_K(a))
	{
#ifdef INTEGERTRUE
	case INTEGER : return(INC_INTEGER(a));
#endif /* INTEGERTRUE */	
#ifdef LONGINTTRUE
	case LONGINT : return(inc_longint(a));
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
	case KRANZTYPUS:
	case MATRIX : return inc_matrix(a);
#endif /* MATRIXTRUE */
#ifdef PARTTRUE
	case PARTITION : return(INC_PARTITION(a));
#endif /* PARTTRUE */
#ifdef PERMTRUE
	case PERMUTATION : return(inc_permutation(a));
#endif /* PERMTRUE */
#ifdef TABLEAUXTRUE
	case TABLEAUX : return(inc_tableaux(a));
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
	case VECTOR : return(inc_vector(a));
#endif /* VECTORTRUE */
	default:
		{
			printobjectkind(a);
			return error("inc:wrong type");
		}
	};
}

INT dec(a) OP a;
/* AK 280689 V1.0 */ /* AK 131289 V1.1 */ /* AK 140891 V1.3 */
{
	switch(S_O_K(a))
	{
#ifdef INTEGERTRUE
	case INTEGER : return(dec_integer(a));
#endif /* INTEGERTRUE */	
#ifdef LONGINTTRUE
	case LONGINT : return dec_longint(a);
#endif /* LONGINTTRUE */
#ifdef PARTTRUE
	case PARTITION : return(dec_partition(a));
#endif /* PARTTRUE */
#ifdef PERMTRUE
	case PERMUTATION : return(dec_permutation(a));
#endif /* PERMTRUE */
#ifdef VECTORTRUE
	case VECTOR : return(dec_vector(a));
#endif /* VECTORTRUE */
	default: { printobjectkind(a);
		return error("wrong type"); }
	};
}


INT dimension(n,d) OP n, d;
/* AK 011288 */ /* AK 060789 V1.0 */ /* AK 131289 V1.1 */
/* AK 140891 V1.3 */
{
	if (n==d) {
		OP c = callocobject();
                *c = *n; C_O_K(d,EMPTY); dimension(c,d);
		freeall(c); return OK;
		}

	if (not EMPTYP(d)) freeself(d);
	
	switch (S_O_K(n))
	{
#ifdef PARTTRUE
	case AUG_PART: return dimension_augpart(n,d);
	case PARTITION: return dimension_partition(n,d);
#endif /* PARTTRUE */
#ifdef SCHURTRUE /* AK 020890 V1.1 */
	case SCHUR: return dimension_schur(n,d);
#endif /* SCHURTRUE */
#ifdef SKEWPARTTRUE /* AK 020890 V1.1 */
	case SKEWPARTITION: return dimension_skewpartition(n,d);
#endif /* SKEWPARTTRUE */
	default: { printobjectkind(n);
		return error("dimension:wrong type"); }
	}
}


INT div(a,b,d) OP a,b,d;
/* AK 280689 V1.0 */ /* AK 071289 V1.1 */ /* AK 250391 V1.2 */
/* AK 140891 V1.3 */
{
	/* AK 031286 als invers*mult */
	INT erg = OK;
	OP c = callocobject();
	erg += invers(b,c); 
	erg += mult(a,c,d); 
	erg += freeall(c); 
	if (erg != OK)
		{
		error("div: error during computation");
		}
	return erg;
}

INT quores(a,b,c,d) OP a,b,c,d;
/* c = ganzdiv(a,b)  d = mod(a,b) */
/* AK 050291 V1.2 */ /* AK 140891 V1.3 */
{
	OP e; 
	INT erg;
	if (c == d) return error("quores: two result in one variable");
	if (a == c)
		{ e =callocobject(); *e = *a; C_O_K(c,EMPTY); erg=quores(e,b,c,d); 
		freeall(e); return(erg); }
	if (a == d)
		{ e =callocobject(); *e = *a; C_O_K(d,EMPTY); erg=quores(e,b,c,d); 
		freeall(e); return(erg); }
	if (b == c)
		{ e =callocobject(); *e = *b; C_O_K(c,EMPTY); erg=quores(a,e,c,d); 
		freeall(e); return(erg); }
	if (b == d)
		{ e =callocobject(); *e = *b; C_O_K(d,EMPTY); erg=quores(a,e,c,d); 
		freeall(e); return(erg); }
	if (not EMPTYP(d)) freeself(d);
	if (not EMPTYP(c)) freeself(c);
	if (EMPTYP(a) || EMPTYP(b)) return(OK);
	if (nullp(b))	return error("quores:null division");
	if (einsp(b)) return(copy(a,c)+m_i_i(0L,d));


	switch(S_O_K(a))
		{
#ifdef INTEGERTRUE
	case INTEGER : 	 return(quores_integer(a,b,c,d));
#endif /* INTEGERTRUE */	
#ifdef LONGINTTRUE
	case LONGINT : 	return(quores_longint(a,b,c,d));
#endif /* LONGINTTRUE */
	default:
		{
			printobjectkind(a); debugprint(a);
			return error("quores:wrong first type");
		}
	}
}

INT ganzdiv (a,b,d) OP a,b,d;
/* AK 220888 */ /* AK 280689 V1.0 */ /* AK 071289 V1.1 */
/* AK 140891 V1.3 */
{
	OP c;
	INT erg=OK;
	/* sonderfaelle bei gleichen variablennamen */
	if 	(a == d)
		{ c =callocobject(); *c = *a; C_O_K(d,EMPTY); 
		erg += ganzdiv(c,b,d); 
		erg += freeall(c); 
		return(erg); 
		}
	if 	(b == d)
		{ c =callocobject(); *c = *b; C_O_K(d,EMPTY); 
		erg += ganzdiv(a,c,d); 
		erg += freeall(c); 
		return(erg); 
		}

	/*freigabe des speichers belegt durch d */
	if (not EMPTYP(d)) 
		freeself(d);

	/*falls beides leere objecte => d auch leer  */
	if (EMPTYP(a) || EMPTYP(b)) 
		return(OK);

	if (nullp(b))	
		return error("ganzdiv:null division");
	if (einsp(b)) 
		return copy(a,d);



	switch(S_O_K(a))
	{
#ifdef INTEGERTRUE
	case INTEGER : 	 erg += ganzdiv_integer(a,b,d);break;
#endif /* INTEGERTRUE */	
#ifdef LONGINTTRUE
	case LONGINT : 	erg += ganzdiv_longint(a,b,d);break;
#endif /* LONGINTTRUE */
#ifdef BRUCHTRUE
	case BRUCH: if (S_O_K(S_B_U(a)) == INTEGER)
			if (S_B_UI(a) == 1L) {
				/* erg += copy(S_B_U(a),a); */
				erg += ganzdiv(S_B_O(a),b,d); }
		    else {
			printobjectkind(a); 
			debugprint(a);
			erg = error("ganzdiv: wrong bruch type");
			}
			break;
#endif /* BRUCHTRUE */
	default:
		{
			printobjectkind(a); 
			debugprint(a);
			return error("ganzdiv:wrong first type");
		}
	}
	if (erg != OK)
		{
		printobjectkind(a);
		printobjectkind(b);
		error("ganzdiv: error during computation");
		}

	return erg;
}

INT fakul(n,d) OP n, d;
/* AK 081086 */ /* d = n! */
/* auf integer umgestellt 120187 */
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060391 V1.2 */
/* AK 140891 V1.3 */
{
	INT i = 2L,erg = 1L;

	if (S_O_K(n) != INTEGER) 
		{
		debugprint(n);
		error("fakul:no INTEGER");
		return ERROR;
		}
	if (S_I_I(n) < 0L) 
		{
		debugprint(n);
		error("fakul:negativ INTEGER");
		return ERROR;
		}

	if (n == d)
	{
		OP c = callocobject(); 
		*c = *n; 
		C_O_K(d,EMPTY);
		fakul(c,d); 
		free(c); 
		return(OK);
		/* free genuegt da INTEGER */
	}

	if (not EMPTYP(d)) 
		freeself(d);
	if (S_I_I(n) > 12L)   {
#ifdef LONGINTTRUE
		return(fakul_longint(n,d));
#else /* LONGINTTRUE */
		return error("fakul:overflow no LONGINT available");
#endif /* LONGINTTRUE */
	}
	while (i <= S_I_I(n)) erg *= i++;
	/* erg ist das ergebnis */

	M_I_I(erg,d);
	return(OK);
}


#ifdef LONGINTTRUE
INT fakul_longint(n,res) OP n,res;
/* AK 180888 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140591 V1.2 */ /* AK 140891 V1.3 */
{
	OP i = callocobject();
	INT erg = OK;
	erg += m_i_longint(479001600L,res); /* 12! */
	erg += M_I_I(13L,i);
	while (S_I_I(i) <= S_I_I(n))
	{
		erg += mult_apply(i,res);
		erg += INC_INTEGER(i);
	}
	erg += freeall(i);
	return erg;
}
#endif /* LONGINTTRUE */

INT ggt_integer(a,b,c) OP a, b, c;
/* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140591 V1.2 */
/* AK 140891 V1.3 */
{
	return(M_I_I(ggt_i(S_I_I(a),S_I_I(b)),c));
}

INT ggt_i(i,j) INT i, j;
/* AK 031186 */ /* c = ggt(a,b) */ /* ok 5/12/86 */
/* AK 280689 V1.0 */ /* AK 061289 V1.1 */
/* AK 140591 V1.2 */
/* AK 140891 V1.3 */
{
	INT neg=1L;
	INT m=i;

	if (i<0L) i *= (-1L);
	if (j<0L) 	{
		j *= (-1L);
		if (m < 0L) neg=(-1L);
	};
	while ((i != 0L) && (j != 0L)) if (i > j) i=i%j; 
	else j=j%i;

	if (i > 0L) { 
		i *=neg; 
		return(i); 
	}
	if (j > 0L) { 
		j *=neg; 
		return(j); 
	}
	return(error("ggt_i: both zero"));
}

INT ggt(a,b,c) OP a,b,c;
/* AK 190888 */ /* AK 280689 V1.0 */ /* AK 010290 V1.1 */
/* AK 140591 V1.2 */ /* AK 140891 V1.3 */
{
	OP d;
	OP i,j;
	INT erg;
	if (a==c) { 
		d = callocobject();
		copy(a,d); 
		ggt(d,b,c); 
		freeall(d); 
		return(OK); 
	};
	if (b==c) { 
		d = callocobject();
		copy(b,d); 
		ggt(a,d,c); 
		freeall(d); 
		return(OK); 
	};

	if (        (S_O_K(a) == INTEGER)
		    && 
		    (S_O_K(b) == INTEGER)
	    )
		return(ggt_integer(a,b,c));

	i = callocobject(); 
	j=callocobject();
	absolute(a,i);
	absolute(b,j);

	while (posp(i) && posp(j))
	{

		erg = comp(i,j);
		if (erg > 0L) mod(i,j,i);
		else	mod(j,i,j);
	};

	if (posp(i))
		if (negp(a) && negp(b))   addinvers(i,c);
		else	copy(i,c);
	else if (posp(j))
		if (negp(a) && negp(b))   addinvers(j,c);
		else	copy(j,c);
	else	error("ggt:two 0");

	freeall(i); freeall(j); return(OK);

}

INT hoch(basis,expon,ergeb)	OP basis, ergeb, expon;
/* AK 041186 ergeb = basis ** expon */ /* AK 031286  ok */
/* AK 280689 V1.0 */ /* AK 160190 V1.1 */
/* AK 061190 V1.1 hoch erlaubt als exponent auch LONGINT */
/* AK 090891 V1.3 */
{
	INT erg = OK;
	if ((expon == ergeb)&&(expon == basis)) /* AK 061191 */
	{
		OP c=callocobject();
		*c = *expon;
		C_O_K(ergeb,EMPTY);
		erg += hoch(c,c,ergeb);
		erg += freeall(c);
		return erg;
	};
	if (expon == ergeb)
	{
		OP c=callocobject();
		*c = *expon;
		C_O_K(ergeb,EMPTY); /* AK 071091 ohne copy */
		erg += hoch(basis,c,ergeb);
		erg += freeall(c);
		return erg;
	};
	if (basis == ergeb)
	{
		OP c=callocobject();
		*c = *basis;
		C_O_K(ergeb,EMPTY);
		erg += hoch(c,expon,ergeb);
		erg += freeall(c);
		return erg;
	};

	if (not EMPTYP(ergeb)) 
		freeself(ergeb);
	if ((S_O_K(expon) != INTEGER)&&(S_O_K(expon) != LONGINT))
	{
		printobjectkind(expon);
		return error("hoch:wrong type of expon");
	};
	if (negp(expon))
	{
		OP c=callocobject(), d=callocobject();
		invers(basis,c);
		addinvers(expon,d);
		hoch(c,d,ergeb);
		freeall(c); 
		freeall(d);
		return OK;
	}
	else if (nullp(expon))
		 return M_I_I(1L,ergeb); 
	else if (einsp(expon)) 
		return copy(basis,ergeb);
	else	{
		OP n = callocobject();
		OP a = callocobject();
		copy(expon,n);
		copy(basis,a);
		/* M_I_I(1L,ergeb); */
		copy(basis,ergeb);  /* AK 290692 */
		dec(n);  /* AK 290692 */
		while (not nullp(n)) {
			mult_apply(a,ergeb);	
			dec(n);
			}
		freeall(a);
		freeall(n);
	};
	return OK;
}


INT invers(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 070789 sonderfaelle 0 und 1 */
/* AK 081289 V1.1 */ /* AK 250391 V1.2 */ /* AK 140891 V1.3 */
{
	OP c;
	INT erg = OK;
	/* sonderfaelle bei gleichen variablennamen */
	if (nullp(a)) /* AK 070789 */
	{
		fprintf(stderr,"first = ");
		fprintln(stderr,a);
		return error("invers:first is null"); 
	}
	if 	(a == b)
	{ 
		c =callocobject();
		*c = *a; 
		C_O_K(b,EMPTY); 
		invers(c,b); 
		freeall(c); 
		return(OK); 
	}

	if (not EMPTYP(b)) 
		erg += freeself(b);
	if (einsp(a)) /* AK 070789 */
		return(copy(a,b));
	switch(S_O_K(a))
	{
#ifdef BRUCHTRUE
	case BRUCH : erg += invers_bruch(a,b);break;
#endif /* BRUCHTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC: erg += invers_cyclo (a,b);break;
#endif /* CYCLOTRUE */
#ifdef INTEGERTRUE
	case INTEGER :
	case LONGINT : erg += invers_integer(a,b);break;
#endif /* INTEGERTRUE */	
#ifdef MATRIXTRUE
	case KRANZTYPUS:
	case KOSTKA :
	case MATRIX : 
			erg += invers_matrix(a,b);break;
#endif /* MATRIXTRUE */
#ifdef PERMTRUE
	case PERMUTATION : 
			erg += invers_permutation(a,b);break;
#endif /* PERMTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL: erg += invers_sqrad (a,b);break;
#endif /* SQRADTRUE */
	default:
			printobjectkind(a);
			return error("invers: wrong type");
	};
	if (erg != OK)
		{
		printobjectkind(a);
		error("invers:error during computation");
		}
	return erg;
}


INT mod (a,b,d) OP a,b,d;
/* AK 180888 */ /* AK 280689 V1.0 */ /* AK 111289 V1.1 */
/* AK 270391 V1.2 */ /* AK 140891 V1.3 */
{
	OP c;
	INT erg=OK;
	
	if (negp(b)) 
		{
		c =callocobject();  
		erg += addinvers(b,c);
		erg += mod(a,c,d);
		erg += freeall(c);
		return erg;
		}
	if 	(a == d)
	{ 
		c =callocobject();  
		*c = *a; 
		C_O_K(a,EMPTY); 
		erg=mod(c,b,d); 
		freeall(c); 
		return erg; 
	}
	if 	(b == d)
	{ 
		c =callocobject();  
		*c = *b; 
		C_O_K(b,EMPTY); 
		erg=mod(a,c,d); 
		freeall(c); 
		return erg; 
	}

	if (negp(a)) { 
		c =callocobject();
		addinvers(a,c); 
		mod(c,b,d); 
		sub(b,d,d); /* AK 310590 */
		freeall(c); 
		return(OK); 
	}

	/*freigabe des speichers belegt durch d */
	if (not EMPTYP(d)) 
		freeself(d);

	/*falls beides leere objecte => d auch leer  */
	if (EMPTYP(a) || EMPTYP(b)) return(OK);

	if (einsp(b)) return(M_I_I(0L,d));

	erg = comp(a,b);
	if (erg == 0L) return(M_I_I(0L,d));
	if (erg == -1L) return(copy(a,d));

	/* nun sind beide positiv */
	switch(S_O_K(a))
	{

#ifdef INTEGERTRUE
	case INTEGER : return mod_integer(a,b,d);
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
	case LONGINT : 	return mod_longint(a,b,d);
#endif /* LONGINTTRUE */
	default: 	
		{
			printobjectkind(a);
			printobjectkind(b);
			return error("mod:wrong type"); 
		}
	}
}

INT mult(a,b,d) OP a,b,d;
/* AK 280689 V1.0 */ /* AK 081289 V1.1 */ /* AK 140891 V1.3 */
{
	OP c;
	INT erg = OK;
	if (a == NULL || b == NULL || d == NULL)
		return error("mult: NULL object"); 

	if (EMPTYP(a))
		return error("mult: b empty object"); 
	if (EMPTYP(b)) 
		return error("mult: b empty object"); 

	/* sonderfaelle bei gleichen variablennamen */
	if	((a == d)&&(b==d)) 
	{ 
		c =callocobject(); *c = *a; C_O_K(d,EMPTY);
		mult(c,c,d); freeall(c); return(OK); 
	}
	else if	(a == d)
	{ 
		c =callocobject(); 
		*c = *a; 
		C_O_K(d,EMPTY);
		mult(c,b,d); 
		freeall(c); 
		return(OK); 
	}
	else if (b == d)
	{ 
		c =callocobject(); 
		*c = *b ;
		C_O_K(d,EMPTY);
		mult(a,c,d); 
		freeall(c); 
		return(OK); 
	}

	/*freigabe des speichers belegt durch d */
	if (not EMPTYP(d)) freeself(d);


#ifdef UNDEF /* AK 290692 */
	if (einsp(a)) return copy(b,d);
	if (einsp(b)) return copy(a,d);
#endif /* UNDEF */
#ifdef UNDEF
	if (nullp(a)) return M_I_I(0L,d),OK; /* macro  da vorher freeself */
	if (nullp(b)) return M_I_I(0L,d),OK;
#endif /* UNDEF */
/* MD */
	switch(S_O_K(b))
	{
#ifdef	MONOPOLYTRUE
	case MONOPOLY: erg += mult_monopoly (b,a,d);goto aaa;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC: erg += mult_cyclo (b,a,d);goto aaa;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL: erg += mult_sqrad (b,a,d);goto aaa;
#endif /* SQRADTRUE */
	}

	switch(S_O_K(a))
	{
#ifdef	MONOPOLYTRUE
	case MONOPOLY:  erg+=mult_monopoly (a,b,d);break;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC:  erg+=mult_cyclo (a,b,d);break;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL:  erg+=mult_sqrad (a,b,d);break;
#endif /* SQRADTRUE */
#ifdef BRUCHTRUE
	case BRUCH : 	 erg+=mult_bruch(a,b,d);break;
#endif  /* BRUCHTRUE */
#ifdef INTEGERTRUE
	case INTEGER : 	 erg+=mult_integer(a,b,d);break;
#endif /* INTEGERTRUE */
#ifdef POLYTRUE
	case POLYNOM :  erg+=mult_polynom(a,b,d);break;
#endif /* POLYTRUE */
#ifdef SCHUBERTTRUE
	case SCHUBERT :
		switch(S_O_K(b))
		{
		case BRUCH:
		case LONGINT:
		case INTEGER:  erg+=mult_scalar_schubert(b, a, d);break;
		case POLYNOM:  erg+=mult_schubert_polynom(a,b,d);break;
		case SCHUBERT:  erg+=mult_schubert_schubert(a,b,d);break;
		}; 
		break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
	case SCHUR : erg += mult_schur(a,b,d); break;
#endif  /* SCHURTRUE */
#ifdef HOMSYMTRUE
	case HOM_SYM :  erg+=mult_homsym(a,b,d);break;
#endif
#ifdef MATRIXTRUE
	case KRANZTYPUS:
	case KOSTKA :
	case MATRIX : 	
			 erg+=mult_matrix(a,b,d);break;
#endif  /* MATRIXTRUE */
#ifdef LONGINTTRUE
	case LONGINT:    erg+=mult_longint(a,b,d);break;
#endif /* LONGINTTRUE */
#ifdef PERMTRUE
	case PERMUTATION:  erg+=mult_permutation(a,b,d);break;
#endif /* PERMTRUE */
#ifdef VECTORTRUE
	case VECTOR :
		switch(S_O_K(b))
		{
#ifdef BRUCHTRUE
		case BRUCH:
#endif /* BRUCHTRUE */
		case LONGINT:
		case INTEGER:   erg+=mult_scalar_vector(b,a,d);break;
		case VECTOR:    erg+=mult_vector_vector(a,b,d);break;
#ifdef MATRIXTRUE
		case MATRIX:    erg+=mult_vector_matrix(a,b,d);break;
#endif /* MATRIXTRUE  */
		default: 
				printobjectkind(b);
				error("mult_vector:wrong second type");
				return ERROR;
		};
		break;
#endif /* VECTORTRUE */
#ifdef CHARTRUE
	case SYMCHAR :
		switch(S_O_K(b))

		{
		case BRUCH:
		case LONGINT:
		case INTEGER:  erg+=mult_scalar_symchar(b,a,d);break;
		case SYMCHAR:  erg+=mult_symchar_symchar(a,b,d);break;
		};
		break;
#endif /* CHARTRUE */
	case GRAL:
		switch(S_O_K(b))
		{
		case GRAL: erg += mult_gral_gral(a,b,d); break;
		}
		
	default: 
		{
			printobjectkind(a); 
			printobjectkind(b);
			return error("mult:wrong types");
		}
	}
aaa:
	if (erg != OK)
		return error("mult: error in computation");
	return erg;
}


INT scalarproduct(a,b,c) OP a,b,c;
/* AK 010888 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */ 
/* AK 140891 V1.3 */
{
	INT erg=OK;
	if 	(a == c)
	{
		OP d =callocobject();
		copy(a,d);
		scalarproduct(d,b,c);
		freeall(d); 
		return(OK); 
	}
	if 	(b == c)
	{
		OP d =callocobject();
		copy(b,d);
		scalarproduct(a,d,c);
		freeall(d); 
		return(OK); 
	}

	if (not EMPTYP(c))
		freeself(c);
	switch(S_O_K(a))
	{
#ifdef GENCHARTRUE
	case GEN_CHAR: erg += scalarproduct_gen_char(a,b,c);break;
#endif
#ifdef CHARTRUE
	case SYMCHAR : erg += scalarproduct_symchar(a,b,c);break;
#endif
#ifdef VECTORTRUE
	case VECTOR : erg += scalarproduct_vector(a,b,c);break;
#endif /* VECTORTRUE */
	default:
			printobjectkind(a);
			return error("scalarproduct:wrong type");
	};
	return erg;
}


INT vander(n,erg) OP n,erg;
/* AK 300588 */ /* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140891 V1.3 */
{
#ifdef POLYTRUE
	INT i,j;
	OP a,b,c;

	if (S_O_K(n) != INTEGER) return error("vander:n != INTEGER");

	m_i_i(1L,erg);

	a = callocobject(); 
	b = callocobject(); 
	c = callocobject();

	for (i=2L;i<=S_I_I(n);i++)
		for (j=1L;j<i;j++)
		{
			m_iindex_monom(i-1,a);
			m_iindex_monom(j-1,b);
			sub(a,b,c);
			mult(c,erg,erg);
		}

	freeall(a); freeall(b); freeall(c); return(OK);
#else /* POLYTRUE */
	return error("vander:POLYNOM not supported");
#endif  /* POLYTRUE */
}

INT weight(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 050390 V1.1 */
/* AK 140891 V1.3 */
{
	if (a == b)
		{
		OP c = callocobject();	
		*c = *a;
		C_O_K(a,EMPTY);
		weight(c,a);
		freeall(c);
		return OK;
		}
	if (not EMPTYP(b)) 
		freeself(b);
	switch(S_O_K(a))
	{
#ifdef PARTTRUE
	case AUG_PART : return(weight_augpart(a,b));
	case PARTITION : return(weight_partition(a,b));
#endif /* PARTTRUE */
#ifdef SKEWPARTTRUE
	case SKEWPARTITION : return weight_skewpartition(a,b);
#endif  /* SKEWPARTTRUE */
#ifdef TABLEAUXTRUE
	case TABLEAUX : return(weight_tableaux(a,b));
#endif /* TABLEAUXTRUE */
	default:
		{ printobjectkind(a);
		return error("weight:wrong first type"); }
	};
}

INT trace(a,b) OP a,b;
/* AK 131289 Spur berechnung */ /* AK 131289 V1.1 */
/* AK 140891 V1.3 */
{
	if (a==b) {
		OP c = callocobject(); *c = *a;
		C_O_K(a,EMPTY); trace(c,b); freeall(c); return(OK); }
	if (not EMPTYP(b)) freeself(b);
	switch (S_O_K(a)) {
#ifdef MATRIXTRUE
		case KRANZTYPUS:
		case MATRIX: return(trace_matrix(a,b));
#endif /* MATRIXTRUE */
		default:
			{ printobjectkind(a);
			return error("trace:wrong first type");  }
		};
}

INT det(a,b) OP a,b;
/* AK 151289 Determinante berechnung */ /* AK 151289 V1.1 */
{
	if (a==b) {
		OP c = callocobject(); *c = *a;
		C_O_K(a,EMPTY); det(c,b); freeall(c); return(OK); }
	if (not EMPTYP(b)) freeself(b);
	switch (S_O_K(a)) {
#ifdef MATRIXTRUE
		case KRANZTYPUS:
		case MATRIX: return(det_matrix(a,b));
#endif /* MATRIXTRUE */
		default:
			{ printobjectkind(a);
			return error("det:wrong first type");  }
		};
}

INT invers_apply(a) OP a;
/* AK 140591 V1.2 */ /* AK 140891 V1.3 */
{
	INT erg = OK;
	if (EMPTYP(a)) 
		return(OK);
	switch(S_O_K(a))
	{
#ifdef INTEGERTRUE
	case INTEGER : 	  erg += invers_apply_integer(a);break;
#endif /* INTEGERTRUE */
	default: {
		OP c = callocobject();
		erg += copy(a,c);
		erg += invers(c,a);
		erg += freeall(c);
		}
	}
	if (erg != OK)
		{
		error("invers_apply:error during computation");
		}
	return erg;
}

INT addinvers_apply(a) OP a;
/* addinvers am platz */ /* AK 201289 V1.1 */
/* AK 140891 V1.3 */
{
	if (EMPTYP(a)) return(OK);
	switch(S_O_K(a))
	{
#ifdef BRUCHTRUE
	case BRUCH : 	return(addinvers_apply_bruch(a));
#endif /* BRUCHTRUE */
#ifdef	CYCLOTRUE
	case CYCLOTOMIC: return(addinvers_apply_cyclo (a));
#endif /* CYCLOTRUE */
#ifdef HOMSYMTRUE
	case HOM_SYM : 	return(addinvers_apply_homsym(a));
#endif /* HOMSYMTRUE */
#ifdef INTEGERTRUE
	case INTEGER : 	 return(addinvers_apply_integer(a));
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
	case LONGINT : 	return(addinvers_apply_longint(a));
#endif /* LONGINTTRUE */
#ifdef MONOMTRUE
	case MONOM : return(addinvers_apply_monom(a));
#endif /* MONOMTRUE */
#ifdef	MONOPOLYTRUE
	case MONOPOLY: return(addinvers_apply_monopoly (a));
#endif /* MONOPOLYTRUE */
#ifdef POLYTRUE
	case GRAL:
	case POLYNOM : 	return(addinvers_apply_polynom(a));
#endif /* POLYTRUE */
#ifdef SCHURTRUE
	case SCHUR : 	return(addinvers_apply_schur(a));
#endif /* SCHURTRUE */
#ifdef	SQRADTRUE
	case SQ_RADICAL: return(addinvers_apply_sqrad (a));
#endif /* SQRADTRUE */
#ifdef CHARTRUE
	case SYMCHAR : 	return(addinvers_apply_symchar(a));
#endif /* CHARTRUE */
#ifdef VECTORTRUE
	case VECTOR : 	 return(addinvers_apply_vector(a));
#endif /* VECTORTRUE */
	default: 
		{
			printobjectkind(a);
			return error("addinvers_apply:wrong type");
		}
	};
}

INT mult_apply(a,b) OP a,b;
/* b = a * b */ /* AK 201289 V1.1 */ /* AK 190291 V1.2 */
/* AK 140891 V1.3 */
{
	INT erg = OK;
	if (a == b) {
		OP c;
		switch S_O_K(a) {
			case INTEGER: if (S_I_I(a) < 10000L) return
						M_I_I(S_I_I(a)*S_I_I(a),a);
			};
		c = callocobject();
		copy(a,c); 
		mult_apply(c,b); 
		freeall(c); 
		return(OK);
		}
	if (EMPTYP(b)) 
		return OK;
	if (EMPTYP(a)) 
		return(freeself(b));
	if (einsp(a)) 
		return OK;
	if (einsp(b)) 
		return copy(a,b);

	switch(S_O_K(a)) {
#ifdef BRUCHTRUE
		case BRUCH: erg += mult_apply_bruch(a,b);break;
#endif /* BRUCHTRUE */
		case GRAL: erg += mult_apply_gral(a,b);break;
		case INTEGER: erg += mult_apply_integer(a,b);break;
#ifdef LONGINTTRUE
		case LONGINT: erg += mult_apply_longint(a,b);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case MATRIX: erg += mult_apply_matrix(a,b);break;
#endif /* MATRIXTRUE */
#ifdef POLYTRUE
		case POLYNOM: erg += mult_apply_polynom(a,b);break;
#endif /* POLYTRUE */
#ifdef SCHUBERTTRUE
		case SCHUBERT: erg += mult_apply_schubert(a,b);break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
		case SCHUR: erg += mult_apply_schur(a,b);break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
		case SYMCHAR: erg += mult_apply_symchar(a,b);break;
#endif /* CHARTRUE */
#ifdef	MONOPOLYTRUE
		case MONOPOLY: erg +=  mult_apply_monopoly (a,b);break;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
		case CYCLOTOMIC: erg +=  mult_apply_cyclo (a,b);break;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
		case SQ_RADICAL: erg +=  mult_apply_sqrad (a,b);break;
#endif /* SQRADTRUE */
		case VECTOR: erg += mult_apply_vector(a,b);break;
		default: {
			printobjectkind(a);
			error("mult_apply:wrong first type");
			return ERROR;
			}
		}
	if (erg != OK)
		error("mult_apply: error during computation");
	return erg;
}

INT double_apply(a) OP a;
/* AK 010692 */
{
		OP c;
		INT erg = OK;
		switch S_O_K(a) {
			case INTEGER: if (S_I_I(a) > -10000000L)
				if (S_I_I(a) < 10000000L) return
					M_I_I(S_I_I(a)+S_I_I(a),a);
			case BRUCH: return double_apply(S_B_O(a));
			}
		c = callocobject();
		erg += copy(a,c); 
		erg += add_apply(c,a); 
		erg += freeall(c); 
		return erg;
}

INT add_apply(a,b) OP a,b;
/* b = a + b */ /* AK 120390 V1.1 */ /* AK 140591 V1.2 */
/* AK 140891 V1.3 */
{
	INT erg = OK;
	if (a == b) return double_apply(a);
	if (EMPTYP(a)) return OK;
	if (EMPTYP(b)) {
		erg += copy(a,b);
		goto add_apply_ende;
		}
	if (nullp(a)) return OK;
	if (nullp(b)) {
		erg += copy(a,b);
		goto add_apply_ende;
		}
	switch(S_O_K(a)) {
#ifdef BRUCHTRUE
		case BRUCH: erg += add_apply_bruch(a,b);break;
#endif /* BRUCHTRUE */
#ifdef POLYTRUE
		case GRAL: erg += add_apply_gral(a,b) ; break;
#endif /* POLYTRUE */
		case INTEGER: erg += add_apply_integer(a,b);break;
#ifdef LONGINTTRUE
		case LONGINT: erg += add_apply_longint(a,b);break;
#endif /* LONGINTTRUE */
		case KRANZTYPUS:
#ifdef MATRIXTRUE
		case MATRIX: erg += add_apply_matrix(a,b);break;
#endif /* MATRIXTRUE */
#ifdef SCHUBERTTRUE
		case SCHUBERT:  erg += add_apply_schubert(a,b);break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
		case SCHUR:  erg += add_apply_schur(a,b);break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
		case SYMCHAR:  erg += add_apply_symchar(a,b);break;
#endif /* CHARTRUE */
#ifdef POLYTRUE
		case POLYNOM: erg += add_apply_polynom(a,b);break;
#endif /* POLYTRUE */
		case VECTOR: erg += add_apply_vector(a,b);break;
#ifdef	MONOPOLYTRUE
		case MONOPOLY: erg += add_apply_monopoly (a,b);break;
#endif /* MONOPOLYTRUE */
#ifdef	CYCLOTRUE
		case CYCLOTOMIC: erg += add_apply_cyclo (a,b);break;
#endif /* CYCLOTRUE */
#ifdef	SQRADTRUE
		case SQ_RADICAL: erg += add_apply_sqrad (a,b);break;
#endif /* SQRADTRUE */
		default: {
			printobjectkind(a);
			return error("add_apply:wrong first type");
			}
		}
add_apply_ende:
	if (erg != OK)
		{
		printobjectkind(a);
		printobjectkind(b);
		return error("add_apply:error during computation");
		}
	return erg;
}
