/* file: poly.c */
#include "def.h"
#include "macro.h"

static struct monom * callocmonom();

#ifdef POLYTRUE
INT eval_polynom(poly,vec,erg) OP poly,vec,erg;
/* AK 310588 */
/* ein polynom wird ausgewertet indem der vector
vec eingesetzt wird
bsp 	poly:= 2 [3,0,1]
	vec:= [4,4,5]
	erg = 2 * 4^3 * 5 = 640 [0,0,0] */
/* AK 110789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
	OP zeiger = poly,monom,c;
	INT i;
	INT e=OK;

	if (S_O_K(vec) != VECTOR)
	{ 
		printobjectkind(vec); 
		return error("eval_polynom:vec != VECTOR "); 
	}

	if (not EMPTYP(erg)) 
		freeself(erg); 
	c = callocobject();

	while (zeiger != NULL)
	{
		monom = callocobject(); 
		m_skn_po(S_PO_S(zeiger),S_PO_K(zeiger),NULL,monom);
		if (S_O_K(S_PO_S(zeiger)) != VECTOR)
		{ 
			printobjectkind(S_PO_S(zeiger));
			return error("eval_polynom:self != VECTOR "); 
		}
		for (i=0L;i<S_PO_SLI(zeiger); i++)
		{
			if (i >= S_V_LI(vec)) goto evalpoly3;
			/* i ist < S_V_LI(vec) */
			if (not EMPTYP(S_V_I(vec,i)))
				if (not nullp (S_PO_SI(zeiger,i)))
				{ 
					hoch(S_V_I(vec,i),S_PO_SI(zeiger,i),c);
					mult_apply(c,S_PO_K(monom)); 
				}
			M_I_I(0L,S_PO_SI(monom,i)); 
		};
evalpoly3:
		insert(monom,erg,add_koeff,comp_monomvector_monomvector); 
		zeiger = S_PO_N(zeiger);
	}
	if (nullp(erg))
		m_i_i(0L,erg);
	else if (S_PO_N(erg) == NULL) /* AK 311091 */
		if (nullp(S_PO_S(erg)))
			{
			if (not EMPTYP(c))
				freeself(c);
			*c = *S_PO_K(erg);
			C_O_K(S_PO_K(erg),EMPTY);
			freeself(erg);
			*erg = *c;
			C_O_K(c,EMPTY);
			}
	freeall(c); 
	return OK;
}
#endif /* POLYTRUE */




#ifdef MONOMTRUE
static struct monom * callocmonom()
/* AK 230688 */ /* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
	struct monom *c = 
	(struct monom *) malloc(sizeof(struct monom));
	if (c == NULL) error("callocmonom:no mem");
	return(c);
}
#endif /* MONOMTRUE */

INT m_sk_mo(self,koeff,c) OP self,koeff,c;
/* AK 070690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	b_sk_mo(callocobject(),callocobject(),c);
	copy(self,S_MO_S(c));  
	copy(koeff,S_MO_K(c));
	return OK;
#endif /*  MONOMTRUE */
}

INT b_sk_mo(self,koeff,c) OP self,koeff,c;
/* build_self koeff_monom AK 230688 */
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	OBJECTSELF d;

	d.ob_monom = callocmonom(); /* AK 161189 */

	B_KS_O(MONOM,d,c);
	C_MO_S(c,self);
	C_MO_K(c,koeff);
	return OK;
#endif	 /* MONOMTRUE */
}

INT objectwrite_monom(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	fprintf(f,"%ld ",(INT)MONOM);
	objectwrite(f,S_MO_K(a)); 
	objectwrite(f,S_MO_S(a)); 
	return OK;
#endif /* MONOMTRUE */
}

INT objectread_monom(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	b_sk_mo(callocobject(),callocobject(),a);
	objectread(f,S_MO_K(a)); 
	objectread(f,S_MO_S(a)); 
	return OK;
#endif /* MONOMTRUE */
}

INT scan_monom(c) OP c;
/* AK 230688 */ /* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	OBJECTKIND kind;
	char antwort[2];

	b_sk_mo(callocobject(),callocobject(),c);
	printeingabe("what kind of monom");
	kind = scanobjectkind(); /* nun weiss man das */

	scan(kind,S_MO_S(c));
	printeingabe("what kind of coefficent");
	kind = scanobjectkind(); /* nun weiss man das */
	scan(kind,S_MO_K(c));
	return(OK);
#endif	 /* MONOMTRUE */
}



INT fprint_monom(f,monom) FILE *f; OP monom;
/* AK 230688 */ /* AK 100789 V1.0 */ /* AK 071289 V1.1 */
/* AK 040391 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	fprint(f,S_MO_K(monom)); 
	if (f==stdout)
	{
		if (zeilenposition > 70L) {
			zeilenposition = 0L; fprintf(stdout,"\n"); }
		else zeilenposition++;
	}
	fprintf(f," "); 
	fprint(f,S_MO_S(monom));
	if (f==stdout)
	{
		if (zeilenposition > 70L) {
			zeilenposition = 0L; fprintf(stdout,"\n"); }
	}
	return OK;
#endif	/* MONOMTRUE */
}

INT tex_monom(monom) OP monom;
/* AK 230688 */ /* AK 100789 V1.0 */ /* AK 191289 V1.1 */
/* AK 070291 V1.2 tex to texout */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	tex(S_MO_K(monom)); 
	fprintf(texout,"\\ ");
	texposition += 2L; 
	tex(S_MO_S(monom)); return(OK);
#endif	/* MONOMTRUE */
}

INT m_s_po(self,poly) OP self,poly;
/* AK 120790 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef POLYTRUE
	OP s = callocobject();
	copy(self,s);
	return b_s_po(s,poly);
#endif /* POLYTRUE */
	}

INT b_s_po(self,poly) OP self,poly;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	b_sn_l(callocobject(),NULL,poly);
	C_O_K(poly,POLYNOM);
	b_sk_mo(self,callocobject(),S_L_S(poly));
	M_I_I(1L,S_PO_K(poly));
	return OK;
#endif	 /* POLYTRUE */
}

INT freeself_monom(a) OP a;
/* AK 100789 V1.0 */ /* AK 211189 V1.1 */
/* AK 140891 V1.3 */
{
#ifdef MONOMTRUE
	OBJECTSELF d; 
	INT erg = OK;
	d = S_O_S(a); 
	erg += freeall(S_MO_S(a)); 

	if (S_O_K(S_MO_K(a)) != INTEGER ) 
		erg += freeall(S_MO_K(a)); 
	else 
		free(S_MO_K(a)); /* AK 140891 */

	free(d.ob_monom); 
	C_O_K(a,EMPTY); 
	return(OK);
#endif	/* MONOMTRUE */
}

INT comp_monom(a,b) OP a,b;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */
/* AK 080390 bei gleichheit von self wird koeff verglichen */ 
/* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	INT erg;
	erg = comp(S_MO_S(a), S_MO_S(b));
	if (erg != 0L) return(erg);
	return(comp(S_MO_K(a),S_MO_K(b)));
#endif	/* MONOMTRUE */
}

#ifdef MONOMTRUE
INT copy_monom(a,b) OP a,b;
/* AK 100789 V1.0 */ /* AK 071289 V1.1 */ /* AK 140891 V1.3 */
{
	return M_SK_MO(S_MO_S(a), S_MO_K(a), b);
}
#endif /* MONOMTRUE */

#ifdef MONOMTRUE
OP s_mo_s(a) OP a;
/* select_monom_self */ /* AK 100789 V1.0 */ /* AK 191289 V1.1 */
/* AK 200891 V1.3 */
{
	OBJECTSELF c;
	if (a == NULL) 
		return error("s_mo_s:a == NULL"),(OP)NULL;
	if (S_O_K(a) != MONOM) 
		return error("s_mo_s:a  != MONOM"),(OP)NULL;
	c = s_o_s(a);
	return(c.ob_monom->mo_self);
}

OP s_mo_k(a) OP a;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
	OBJECTSELF c;
	if (a == NULL) 
		return error("s_mo_k:a == NULL"),(OP)NULL;
	if (S_O_K(a) != MONOM) 
		return error("s_mo_k:a  != MONOM"),(OP)NULL;
	c = s_o_s(a);
	return(c.ob_monom->mo_koeff);
}

/* the following routines only work with self part which are VECTORobjects */
OP s_mo_sl(a) OP a; 
/* AK 200891 V1.3 */
{
	return s_v_l(s_mo_s(a)); 
}
INT s_mo_sli(a) OP a; 
/* AK 200891 V1.3 */
{
	return s_v_li(s_mo_s(a)); 
}
OP s_mo_si(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
{
	return s_v_i(s_mo_s(a),i); 
}
INT s_mo_sii(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
{
	return s_v_ii(s_mo_s(a),i); 
}


INT s_mo_ki(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(s_i_i(s_mo_k(a))); 
}

INT c_mo_s(a,b) OP a,b; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_monom->mo_self = b; 
	return(OK); 
}

INT c_mo_k(a,b) OP a,b; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_monom->mo_koeff = b; 
	return(OK); 
}

#endif /* MONOMTRUE */

#ifdef MONOMTRUE
INT mult_scalar_monom(a,b,c) OP a,b,c;
/* AK 111188 */
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
	if (not EMPTYP(c)) 
		freeself(c);
	b_sk_mo(callocobject(),callocobject(),c);
	copy(S_MO_S(b),S_MO_S(c)); 
	return mult(S_MO_K(b),a,S_MO_K(c));
}
#endif	/* MONOMTRUE */

#ifdef POLYTRUE 
INT mult_polynom(a,b,d) OP a,b,d;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 150591 V1.2 */
/* AK 080891 V1.3 */
{
	INT erg = OK;
	if (nullp(a))
		return m_i_i(0L,d); /* AK 110991 */

	switch(S_O_K(b)) {
	case INTEGER:
	case LONGINT:
#ifdef BRUCHTRUE
	case BRUCH: 
#endif /* BRUCHTRUE */
		erg+=mult_scalar_polynom(b,a,d);
		break;
	case POLYNOM: erg+=mult_polynom_polynom(a,b,d);
		break;
#ifdef SCHUBERTTRUE
	case SCHUBERT: erg+=mult_schubert_polynom(b,a,d); /* AK 190690 */
		break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
	case SCHUR: erg += mult_scalar_schur(a,b,d); break; /* AK 110692 */
#endif /* SCHURTRUE */
#ifdef MATRIXTRUE
	case MATRIX: erg+=mult_scalar_matrix(a,b,d);
		break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
	case MONOM: erg += mult_scalar_monom(a,b,d); break; /* AK 110692 */
#endif /* MONOMTRUE */
	default: 
		printobjectkind(b);
		erg += error("mult_polynom: wrong second type"); 
	}
	return erg;
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT mult_scalar_polynom(a,poly,erg) OP a,poly,erg;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 150591 V1.2 */ 
/* AK 200891 V1.3 */
{
	if ((nullp(a))|| (nullp(poly)))
		return m_i_i(0L,erg); /* AK 110991 */
	return trans2formlist(a,poly,erg,mult);
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT mult_polynom_polynom(eins,zwei,c) OP eins, zwei, c;
/* AK 100789 V1.0 */ /* AK 081289 V1.1 */ /* AK 150591 V1.2 */
/* AK 140891 V1.3 */
{
	OP z, ez, zz;

	zz = zwei;
	while (zz != NULL)
	{
		z = callocobject();
		copy_list(eins,z); /* eins ist polynom */

		ez = z;
		while (ez != NULL)
		{
			add_apply(  S_PO_S(zz), S_PO_S(ez));
			mult_apply( S_PO_K(zz), S_PO_K(ez));
			ez = S_PO_N(ez);
		};
		insert(z,c,add_koeff,comp_monomvector_monomvector);
		zz = S_PO_N(zz);
	};
	return(OK);
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT numberofvariables(a,n) OP a,n;
/* AK 250692 */
/* n becomes the number of variables of the POLYNOM a */
{
	INT i,erg = OK;
	OP z;

	if (S_O_K(a) != POLYNOM)
		return ERROR;
	erg += m_i_i(0L,n);
	if (S_L_S(a) == NULL)
		return OK;
	z = a;
	while (z != NULL)
		{
		i = S_PO_SLI(z)-1L;
		while (S_PO_SII(z,i) == 0L) 
			i--;
		if (i+1L > S_I_I(n)) 
			erg += m_i_i(i+1L,n);
		z = S_PO_N(z);
		}
	return erg;
}
#endif /* POLYTRUE */
#ifdef POLYTRUE
INT mult_disjunkt_polynom_polynom(a,b,c) OP a, b, c;
/* AK 300889 */
/* die beiden polynome haben disjunkte alphabete */
/* beim c werden die alphabete hintereinandergehaengt */
/* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
	OP z, ap, bp;
	OP n,l;
	INT i;

	if (S_O_K(a) != POLYNOM) 
		return error("mult_disjunkt_polynom_polynom:a != POLYNOM");
	if (S_O_K(b) != POLYNOM) 
		return error("mult_disjunkt_polynom_polynom:b != POLYNOM");
	if (not EMPTYP(c)) 
		freeself(c);
/* first check the number of variables of a */ /* AK 250692 */
	n = callocobject();
	numberofvariables(a,n);

	bp = b;
	l = callocobject();
	while (bp != NULL)
	{
		z = callocobject();
		copy(a,z);

		ap = z;
		while (ap != NULL)
		{
			if (S_PO_SLI(ap) < S_I_I(n))   /* AK 250692 */
				{
				m_il_nv(S_I_I(n),l);
				for (i=0L;i<S_PO_SLI(ap);i++)
					M_I_I(S_PO_SII(ap,i),S_V_I(l,i));
				append(l,S_PO_S(bp),S_PO_S(ap));
				}
			else
				append(	S_PO_S(ap), S_PO_S(bp), S_PO_S(ap));
			mult(	S_PO_K(ap), S_PO_K(bp), S_PO_K(ap));
			ap = S_PO_N(ap);
		};

		add_apply(z,c);
		freeall(z);

		bp = S_PO_N(bp);
	};
	freeall(n);
	freeall(l);
	return(OK);
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT mult_apply_polynom_scalar(a,b) OP a,b;
/* AK 160290 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	struct object c;
	c = *b;
	C_O_K(b,EMPTY);
	erg += copy_polynom(a,b);
	erg += mult_apply_scalar_polynom(&c,b);
	if (S_O_K((&c)) != INTEGER) erg += freeself(&c);
	if (erg != OK)
		{
		error("mult_apply_polynom_scalar:error during computation");
		}
	return erg;
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT mult_apply_polynom(a,b) OP a,b;
/* AK 140290 V1.1 */ /* AK 140591 V1.2 */ /* AK 220791 V1.3 */
{
	INT erg = OK; /* zuweisung AK091091 */
	if (nullp(b))
		return m_i_i(0L,b); /* AK 120991 */
	switch(S_O_K(b)) {
		case BRUCH:
		case LONGINT:
		case INTEGER:  /* a ist scalar, b ist poly */
			erg+= mult_apply_polynom_scalar(a,b); break;
		case POLYNOM: 
			erg+= mult_apply_polynom_polynom(a,b); break;
		default:
			{
			OP c = callocobject();
			*c = *b; C_O_K(b,EMPTY);
			erg = mult(a,c,b);
			if (erg == ERROR) {
				printobjectkind(c);
				error("mult_apply_polynom:wrong second type");
				}
			freeall(c); return erg;
			}
		}
	if (erg != OK)
		{
		error("mult_apply_polynom:error during computation");
		}
	return erg;
}
#endif /* POLYTRUE */

INT mult_apply_polynom_polynom(a,b) OP a,b;
/* AK 140290 V1.1 */ /* AK 170591 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP c = callocobject();
	INT erg=OK;
	*c = *b;
	C_O_K(b,EMPTY);
	erg += mult_polynom_polynom(a,c,b); 
	erg += freeall(c);
	if (erg != OK)
		{
		error("mult_apply_polynom_polynom:error during computation");
		}
	return erg;
#endif /* POLYTRUE */
}

INT mult_apply_scalar_monom(a,b) OP a,b; 
/* AK 150290 V1.1 */ /* AK 200891 V1.3 */
{
	return(mult_apply(a,S_MO_K(b)));
}

INT mult_apply_scalar_polynom(a,b) OP a,b;
/* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP z = b;
	if (nullp(a))
		{
		return m_i_i(0L,b); /* AK 110991 */
		}
	while (z != NULL)
		{
		mult_apply(a,S_L_S(z));
		z = S_L_N(z);
		}
	return(OK);
#endif /* POLYTRUE */
}


INT scan_polynom(poly) OP poly;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	char antwort[2];
	INT erg;


	/* ergebnis ist ein leeres object */
	b_sn_l(callocobject(),NULL,poly);
	C_O_K(poly,POLYNOM);
	/* self ist nun initialisiert */

	erg=scan(MONOM,S_L_S(poly));
	if (erg == ERROR) {
		error("scan_polynom:error in scaning listelement");
		return(ERROR); 
		}

	printeingabe("one more monom  j/n");
	scanf("%s",antwort);
	if (antwort[0]  == 'j')
		{
			C_L_N(poly,callocobject());
			scan_polynom(S_L_N(poly));
		};
	return OK;
#endif /* POLYTRUE */
}


INT add_monom(a,b,c) OP a,b,c;
/* AK 201289 V1.1 */ /* AK 050891 V1.3 */
{
#ifdef MONOMTRUE
	INT erg = OK;
	switch (S_O_K(b)) {
#ifdef HOMSYMTRUE
		case HOM_SYM: erg += add_monom_homsym(a,b,c);break;
#endif /* HOMSYMTRUE */
#ifdef SCHURTRUE
		case SCHUR: erg += add_monom_schur(a,b,c);break;
#endif /* SCHURTRUE */
		default: return(error("add_monom:"));
		}
	if (erg != OK) 
		error("add_monom:error during computation");
	return erg;
#endif /* MONOMTRUE */
}

#ifdef SCHURTRUE
INT add_monom_schur(a,b,d) OP a,b,d;
/* for all partition typ polynomials */
/* AK 201289 V1.1 */ /* AK 050891 V1.3 */
{ 
	INT erg = OK;
	OP c = callocobject(); 
	erg += init(S_O_K(b),c);
	erg += copy_monom(a,S_L_S(c)); 
	erg += add(c,b,d);
	erg += freeall(c);
	return erg;
}
#endif /* SCHURTRUE */

#ifdef MONOMTRUE
INT add_koeff(a,b) OP a,b;
/* eqhandle bei insert bei polynomen, monopoly
addiert die beiden koeffizienten der monome a und b
nach dem monom b */
/* AK 100789 V1.0 */ /* AK 231189 V1.1 */ /* AK 200891 V1.3 */
{
	if (S_O_K(a) != MONOM) 
			return error("add_koeff:first != MONOM");
	if (S_O_K(b) != MONOM) 
			return error("add_koeff:second != MONOM");
	add_apply(S_MO_K(a), S_MO_K(b));
	freeself_monom(a);
	if (nullp(S_MO_K(b))) 
		freeself_monom(b);
	return(OK);
}
#endif	/* MONOMTRUE */

INT add_scalar_polynom(a,b,c)
/* a scalar, b polynom, c empty */
/* AK 060891 V1.3 */
{
	INT erg = OK;
	OP d;

	if (nullp(a))
		return copy(b,c);

	d = callocobject();
	erg += m_scalar_polynom(a,d);
	erg += add_polynom_polynom(d,b,c);
	erg += freeall(d);
	return erg;
}

INT add_polynom(a,b,c) OP a,b,c;
/* AK 110789 V1.0 */ /* AK 191289 V1.1 */ /* AK 290591 V1.2 */
/* AK 060891 V1.3 */
{
#ifdef POLYTRUE
	INT erg = OK;
	if (nullp(a))
		return copy(b,c);
	if (nullp(b))
		return copy(a,c);

	switch (S_O_K(b))
	{
	case INTEGER:
	case LONGINT:
	case BRUCH: erg += add_scalar_polynom(b,a,c); break; /* AK 060891 */
	case GRAL:
	case POLYNOM: erg+= add_polynom_polynom(a,b,c);break;
	default: 
		{
			printobjectkind(b);
			return error("add_polynom:wrong second type");
		}
	}
	if (erg != OK) 
		{
		printobjectkind(b);
		error("add_polynom:error during computation");
		}	
	return erg;
#endif /* POLYTRUE */
}


INT add_polynom_polynom(a,b,c) OP a,b,c;
/* works for all types */
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 290591 V1.2 */
/* AK 050891 V1.3 */
{
#ifdef POLYTRUE
	INT erg=OK;
	OP d = callocobject();
	if (not EMPTYP(c)) 
		erg += freeself(c);
	erg += copy_list(a,d); 
	erg += copy_list(b,c);
	

	insert(d,c,add_koeff,comp_monomvector_monomvector);

	if (nullp(c))
		if (S_L_S(c) != NULL) {
				b_sn_l(NULL,NULL,c);
				C_O_K(c,S_O_K(a));
				}
	return erg;
#endif /* POLYTRUE */
}
 
INT comp_monomvector_monomvector(a,b) OP a,b;
/* vergleicht zwei monome von vectorform */
/* wenn keine vectorform dann der normale vergleich */
/* AK 100789 V1.0 */ /* AK 081289 V1.1 */ /* vergleich bei polynomen */
/* AK 120391 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	INT i,j,erg;
	OP as,bs;



	if (S_O_K(a) != MONOM) 
		{
		printobjectkind(a);
		return error("comp_monomvector_monomvector:a!=MONOM");
		}
	if (S_O_K(b) != MONOM) 
		{
		printobjectkind(b);
		return error("comp_monomvector_monomvector:b!=MONOM");
		}
	as = S_MO_S(a); 
	bs = S_MO_S(b);

	if (	(S_O_K(as) == PERMUTATION)
		&&
		(S_O_K(bs)==PERMUTATION)		)
		/* AK 210690 if schubert polynom */
		{
		erg=1L;
		if (S_P_LI(bs) > S_P_LI(as)) {
			a=bs;
			bs=as;
			as=a;
			erg= -1L;
		}
		/* as ist laenger als bs */
		for (i=0L; i<S_P_LI(as); i++)
			{
			if (i < S_P_LI(bs))
				{
				if (S_P_II(as,i) > S_P_II(bs,i)) return erg*1L;
				if (S_P_II(as,i) < S_P_II(bs,i)) return erg*-1L;
				}
			else {
				if (S_P_II(as,i) < i+1L) return erg*-1L;
				if (S_P_II(as,i) > i+1L) return erg*1L;
				}
			}
		return 0L;
		}
	if (	(S_O_K(as) == MATRIX)
		&&
		(S_O_K(bs)==MATRIX)		)
		{
		INT h,l;
		h = (S_M_HI(as) > S_M_HI(bs) ? S_M_HI(as) : S_M_HI(bs));
		l = (S_M_LI(as) > S_M_LI(bs) ? S_M_LI(as) : S_M_LI(bs));
		for (i=0L; i<h; i++)
		for (j=0L; j<l; j++)
			{
			if (
				( i<S_M_HI(as) )  &&
				( i<S_M_HI(bs) )  &&
				( j<S_M_LI(as) )  &&
				( j<S_M_LI(bs) ) 
			   ) 
				if ((erg = comp(S_M_IJ(as,i,j),S_M_IJ(bs,i,j)))
					!= 0L) return erg;
			if (
				( i>=S_M_HI(as) )  &&
				( j<S_M_LI(bs) )
			   )
				if (not nullp(S_M_IJ(bs,i,j)))
					return -1L;
			if (
				( i>=S_M_HI(bs) )  &&
				( j<S_M_LI(as) )
			   )
				if (not nullp(S_M_IJ(as,i,j)))
					return 1L;
			if (
				( i<S_M_HI(as) )  &&
				( j>=S_M_LI(bs) )
			   )
				if (not nullp(S_M_IJ(as,i,j)))
					return 1L;
			if (
				( i<S_M_HI(bs) )  &&
				( j>=S_M_LI(as) )
			   )
				if (not nullp(S_M_IJ(bs,i,j)))
					return -1L;
			}
		return 0L;
		}
	if (
		(S_O_K(as) != VECTOR)
		|| 
		(S_O_K(bs) != VECTOR)
	    )
			return comp(as,bs);


	for (i=0L;i<S_V_LI(as);i++)
		{
		if (S_O_K(S_V_I(as,i)) != INTEGER)
		error("comp_monomvector_monomvector:as no INTEGERVECTOR");
		else if (i >= S_V_LI(bs))
			{
			if (S_V_II(as,i) != 0L)
				return 1L; 
			}
		else if (S_O_K(S_V_I(bs,i)) != INTEGER)
		error("comp_monomvector_monomvector:bs no INTEGERVECTOR");
		else if ( S_V_II(as,i) > S_V_II(bs,i) )
			return 1L;
		else if ( S_V_II(as,i) < S_V_II(bs,i) )
			return -1L;
		}

	for (j=i;j<S_V_LI(bs);j++)
		{
		/* if (S_O_K(S_V_I(bs,i)) != INTEGER)  error AK 311091 */
		if (S_O_K(S_V_I(bs,j)) != INTEGER) 
		error("comp_monomvector_monomvector:bs no INTEGERVECTOR");
		/* else if (S_V_II(bs,i) != 0L )  error AK 311091 */
		else if (S_V_II(bs,j) != 0L ) 
                        return -1L; 
		}


	return 0L;
#else /* POLYTRUE */
	return error("comp_monomvector_monomvector:POLYNOM not available");
#endif /* POLYTRUE */
}


INT addinvers_monom(a,b) OP a,b;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MONOMTRUE
	INT erg=OK;
	b_sk_mo(callocobject(),callocobject(),b);
	copy(S_MO_S(a),S_MO_S(b));
	addinvers(S_MO_K(a),S_MO_K(b));
	return(OK);
#endif /* MONOMTRUE */
}

INT addinvers_apply_monom(a) OP a;
/* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(addinvers_apply(S_MO_K(a))); 
}

INT addinvers_polynom(a,b) OP a,b;
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(transformlist(a,b,addinvers)); 
}

INT addinvers_apply_polynom(a) OP a;
/* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(transform_apply_list(a,addinvers_apply)); 
}

INT m_skn_po(a,b,c,d) OP a,b,c,d;
/* make_self.koeff.next_polynom */
/* AK 290590 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP s=NULL,k=NULL,n=NULL;
	if (c != NULL) { n = callocobject(); copy(c,n); }
	if (a != NULL) { s = callocobject(); copy(a,s); }
	if (b != NULL) { k = callocobject(); copy(b,k); }
	return             b_skn_po(s,k,n,d);
#endif /*  POLYTRUE */
}

INT b_skn_po(a,b,c,d) OP a,b,c,d;
/* AK 100789 V1.0 */ /* AK 241189 V1.1 */
/* AK 130891 V1.3 */
{
#ifdef POLYTRUE
	INT erg = OK;
	erg += b_sn_l(callocobject(),c,d); 
	erg += C_O_K(d,POLYNOM);
	erg += b_sk_mo(a,b,S_L_S(d)); 
	return erg;
#else /* POLYTRUE */
	return error("b_skn_po:POLYNOM not available");
#endif /* POLYTRUE */
}

#ifdef POLYTRUE
OP s_po_s(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (a == NULL) return  
		error("s_po_s: a == NULL"),(OP)NULL;
	if (s_o_k(a) != POLYNOM) return  
		error("s_po_s: not POLYNOM"),(OP)NULL;
	return(s_mo_s(s_l_s(a))); 
}

OP s_po_k(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (a == NULL) return  
		error("s_po_k: a == NULL"),(OP)NULL;
	if (s_o_k(a) != POLYNOM) return  
		error("s_po_k: not POLYNOM"),(OP)NULL;
	return s_mo_k(s_l_s(a));
}

OP s_po_n(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (a == NULL) return  
		error("s_po_n: a == NULL"),(OP)NULL;
	if (s_o_k(a) != POLYNOM) return  
		error("s_po_n: not POLYNOM"),(OP)NULL;
	return s_l_n(a); 
}

OP s_po_si(a,i) OP a; INT i; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (a == NULL) return  
		error("s_po_si: a == NULL"),(OP)NULL;
	if (s_o_k(a) != POLYNOM) return  
		error("s_po_si: not POLYNOM"),(OP)NULL;
	return s_v_i(s_mo_s(s_l_s(a)),i); 
}

OP s_po_sl(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (a == NULL) return  
		error("s_po_sl: a == NULL"),(OP)NULL;
	if (s_o_k(a) != POLYNOM) return  
		error("s_po_sl: not POLYNOM"),(OP)NULL;
	return s_v_l(s_mo_s(s_l_s(a))); 
}

INT s_po_ki(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(s_mo_ki(s_l_s(a))); 
}

INT s_po_sii(a,i) OP a; INT i; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(s_v_ii(s_mo_s(s_l_s(a)),i)); 
}


INT s_po_sli(a) OP a; 
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(s_v_li(s_mo_s(s_l_s(a)))); 
}
#endif /* POLYTRUE */

#ifdef POLYTRUE
INT test_poly()
/* AK 191289 V1.1 */ /* AK 190291 V1.2 */ /* AK 200891 V1.3 */
{
	OP a = callocobject();
	OP b = callocobject();
	OP c = callocobject();

	printf("test_poly:scan(a)"); 
	scan(POLYNOM,a);
	println(a);
	printf("test_poly:copy(a,b)"); 
	copy(a,b); 
	println(b);
	printf("test_poly:mult(a,b,b)"); 
	mult(a,b,b); 
	println(b);
	printf("test_poly:tex(b)"); 
	tex(b); 
	printf("test_poly:add(b,a,a)"); 
	add(b,a,a); 
	println(a);
	printf("test_poly:hoch(b,2L,a)"); 
	hoch(b,cons_zwei,a); 
	println(a);
	printf("test_poly:eval_polynom(a,b,c)");
	m_il_v(2L,b); 
	M_I_I(3L,s_v_i(b,0L)); 
	M_I_I(5L,s_v_i(b,1L));
	printf("b=");
	println(b);
	eval_polynom(a,b,c); 
	println(c);
	printf("test_poly:vander(4L,c)"); 
	M_I_I(4L,b);
	vander(b,c);
	println(c);
	printf("test_poly:numberofvariables(c,b)"); 
	numberofvariables(c,b); 
	println(b);

#ifdef BRUCHTRUE
	freeself(a); freeself(b); freeself(c);
	printf("test_poly:lagrange_polynom([1,7],[5,7],c)"); 
	m_il_v(2L,a);
	m_i_i(1L, s_v_i(a,0L));
	m_i_i(7L, s_v_i(a,1L));

	m_il_v(2L,b);
	m_i_i(5L, s_v_i(b,0L));
	m_i_i(7L, s_v_i(b,1L));

	lagrange_polynom(a,b,c);println(c);
#endif /* BRUCHTRUE */
	printf("test_poly:mult_disjunkt_polynom_polynom(c,c,a)"); 
	mult_disjunkt_polynom_polynom(c,c,a); 
	println(a);


	m_i_i(1L,a); 
	m_scalar_polynom(a,b); 
	if (not einsp(b)) 
		printf("test_poly:ERROR!!:einsp test not successful\n");
	else
		printf("test_poly:einsp test successful\n");

	m_i_i(0L,a); 
	m_scalar_polynom(a,b); 
	if (not nullp(b)) 
		printf("test_poly:ERROR!!:nullp test not successful\n");
	else
		printf("test_poly:nullp test successful\n");

	freeall(a);
	freeall(b);
	freeall(c);
	return(OK);
}
#endif /* POLYTRUE */


#ifdef POLYTRUE
INT tex_polynom(poly) OP poly;
/* AK 101187 */ /* zur TeXausgabe eines polynoms */
/* AK 100789 V1.0 */ /* AK 191289 V1.1 */
/* AK 070291 V1.2 tex to texout */ /* AK 200891 V1.3 */
{
	OP zeiger = poly;
	OP z;
	INT i,j;
	INT hbool=1L;

	fprintf(texout,"\\ ");
	texposition += 3L;
	if (EMPTYP(poly)) 
		return(OK);
	while (zeiger != NULL)
	{
		hbool = 1L;
		if (not einsp(S_PO_K(zeiger))) {
			tex(S_PO_K(zeiger)); hbool=0L; }
		/* der koeffizient wird nur geschrieben wenn er ungleich 1 ist*/
		fprintf(texout,"\\ $");
		texposition += 4L;
		if (S_O_K(S_PO_S(zeiger)) == MATRIX) /* AK 031291 */
			{
			z = S_PO_S(zeiger);
			for (i=0L;i<S_M_HI(z);i++)
			for (j=0L;j<S_M_LI(z);j++)
				if (S_M_IJI(z,i,j) >0L)
				{
				hbool=0L;
				if (S_M_IJI(z,i,j) >1L)
					fprintf(texout," x_{%ld,%ld}^{%ld} ",
						i,j,S_M_IJI(z,i,j));
				else 
					fprintf(texout," x_{%ld,%ld} ", i,j);
				texposition += 15L;
				}
			}
		else 	{
		for (i= 0L ;i < S_PO_SLI(zeiger); i++)
			if (S_PO_SII(zeiger,i) > 0L)
			{
				hbool=0L;
				fprintf(texout,"%c",'a'+i);
				texposition ++;
				if (S_PO_SII(zeiger,i) != 1L)
				{
					fprintf(texout,"^{%d}",S_PO_SII(zeiger,i));
					texposition += 10L;
				};
			};
			}
		if (hbool == 1L) fprintf(texout,"1");
		fprintf(texout,"$\\ ");
		texposition += 3L;
		if (texposition > 60L)
		{ 
			fprintf(texout,"\n");
			texposition = 0L; 
		}

		zeiger = S_PO_N(zeiger);
		if (zeiger != NULL)
		{ 
			fprintf(texout," $+$ "); 
			texposition += 5L; 
		}
	};
	fprintf(texout,"\\ ");
	texposition += 2L;
	return(OK);
}
#endif /* POLYTRUE */

#ifdef  POLYTRUE 
INT copy_polynom(a,b) OP a,b; 
/* AK 091190 V1.1 */ /* AK 190291 V1.2 */ /* AK 200891 V1.3 */
	{
	return(copy_list(a,b));
	}
#endif /* POLYTRUE */

INT add_apply_polynom_polynom(a,b) OP a,b;
/* AK 091190 V1.1 */ /* AK 190291 V1.2 */ /* AK 200891 V1.3 */
	{
#ifdef  POLYTRUE 
	INT erg = OK;
	OP c;
	c = callocobject();
	erg += copy_polynom(a,c);
	insert(c,b,add_koeff,comp_monomvector_monomvector);
	return erg;
#endif /* POLYTRUE */
	}

INT add_apply_polynom_scalar(a,b) OP a,b;
/* AK 130891 V1.3 */
{
#ifdef POLYTRUE
	OP c = callocobject();
	INT erg = OK;
	erg += copy(a,c);
	erg += add(a,c,b);
	erg += freeall(c);
	return erg;
#endif /* POLYTRUE */
}

INT add_apply_polynom(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 190291 V1.2 */
/* AK 130891 V1.3 */
{
#ifdef POLYTRUE
	INT erg = OK;
	if ((EMPTYP(b)) 
		||  nullp(b) )
		return(copy_polynom(a,b));
	switch(S_O_K(b)) {
		case BRUCH:
		case LONGINT:
		case CYCLOTOMIC:
		case SQ_RADICAL:
		case INTEGER: erg += add_apply_polynom_scalar(a,b);break;
		case POLYNOM:  erg += add_apply_polynom_polynom(a,b);break;
#ifdef SCHUBERTTRUE
		case SCHUBERT:  erg += add_apply_polynom_schubert(a,b);break;
#endif /* SCHUBERTTRUE */
		default:
			printobjectkind(b);
			return error("add_apply_polynom:wrong second type");
		}
	if (erg != OK)
		error("add_apply_polynom:error during computation");
	return erg;
#endif /* POLYTRUE */
}

#ifdef SCHUBERTTRUE
INT add_apply_polynom_schubert(a,b) OP a,b;
/* AK 190291 V1.2 */ /* AK 200891 V1.3 */
{
	OP c = callocobject();
	INT erg = OK;
	erg += t_POLYNOM_SCHUBERT(a,c);
	erg += add_apply(c,b);
	erg += freeall(c);
	return erg;
}
#endif /* SCHUBERTTRUE */

INT gauss_polynom(a,b,c) OP a,b,c;
/* AK 040190 gausspolynom [a+b \atop b] */
/* mittels schubertpolynome */
/* AK 040190 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef SCHUBERTTRUE
	INT i,m;
	OP vec = callocobject();
	OP perm = callocobject();
	INT erg = OK;

	erg += m_il_v(S_I_I(a)+S_I_I(b)+1L,vec);
	for (i=0L,m=0L;i<S_I_I(b);i++,m++)
		M_I_I(0L,S_V_I(vec,m));
	M_I_I(S_I_I(a),S_V_I(vec,m)); m++;
	for (i=0L;i<S_I_I(a);i++,m++)
		M_I_I(0L,S_V_I(vec,m));
	/* dies ist der lehmercode */
	erg += lehmercode(vec,perm);
	erg += m_perm_schubert_qpolynom(perm,c);
	erg += freeall(perm);
	erg += freeall(vec);
	if (erg != OK)
		return error("gauss_polynom: error during computation");
	return erg;
#else
	return error("gauss_polynom:SCHUBERT not available");
#endif /* SCHUBERTTRUE */
}

INT polya_sub(a,c,b) OP a,b,c;
/* einsetzung */ /* a ist polynom */ /* c ist length of alphabet */
/* b wird ergebnis x_i ----> 1 + q^i */
/* AK 080190 */ /* AK 091190 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP d=callocobject();
	OP e=callocobject();
	OP f=callocobject();
	OP g=callocobject();
	OP z;
	INT i;
	INT erg = OK;

	erg += m_il_v(S_I_I(c),d);
	erg += b_skn_po(callocobject(),callocobject(),NULL,e);
	erg += m_il_v(1L,S_PO_S(e));
	M_I_I(0L,S_PO_SI(e,0L));
	M_I_I(1L,S_PO_K(e));
	erg += copy(e,f); 
	M_I_I(1L,S_PO_SI(f,0L));
	erg += insert(f,e,add_koeff,comp_monomvector_monomvector);
	for (i=0L;i<S_V_LI(d);i++)
		{
		erg += copy(e,S_V_I(d,i));
		z = S_V_I(d,i);
		while (z != NULL)
			{
			M_I_I(S_PO_SII(z,0L)*(i+1L),S_PO_SI(z,0L));
			z = S_L_N(z);
			}
		}
	erg += eval_polynom(a,d,b); 
	/* erg += copy(S_PO_K(g),b); nicht mehr noetig AK 031291 */
	erg += freeall(d);
	erg += freeall(e);
	erg += freeall(g);
	if (erg != OK)
		return error("polya_sub: error during computation");
	return erg;
#endif /* POLYTRUE */
}

INT unimodalp(a) OP a;
/* AK 080190 */ /* AK 091190 V1.1 */ /* AK 200891 V1.3 */
{
	OP z,k;
	if (EMPTYP(a)) return(FALSE);
	if (S_O_K(a) != POLYNOM) return(FALSE);
	z = S_PO_N(a);
	k = S_PO_K(a);
	while (z != NULL)
		{
		if (lt(S_PO_K(z),k)) break;
		k = S_PO_K(z);
		z = S_PO_N(z);
		}
	if (z == NULL) return(TRUE);
	k = S_PO_K(z);
	z = S_PO_N(z);
	while (z != NULL)
		{
		if (gr(S_PO_K(z),k)) return(FALSE);
		k = S_PO_K(z);
		z = S_PO_N(z);
		}
	return(TRUE);
}

INT degree_polynom(a,b) OP a,b;
/* b becomes the degree, but only if in one variable */
/* AK 300590 V1.1 */ /* AK 190291 V1.2 */ /* AK 200891 V1.3 */
{
	OP z,za;
	if (not EMPTYP(b)) freeself(b);
	z = a;
	while (z != NULL)
		{
		za = z;
		if (S_O_K(S_PO_S(z)) != VECTOR) 
			return error("degree_polynom: not VECTOR");
		if (S_PO_SLI(z) != 1L) 
		return error("degree_polynom: not single variable");
	z = S_PO_N(z);
		}
	/* za has now maximail degree */
	copy (S_PO_SI(za,0L),b);
	return(OK);
}

INT lagrange_polynom(a,b,c) OP a,b,c;
/* a sind die stuetzpunkte VECTOR
   b die werte VECTOR
   c wird das polynom */
/* AK 060690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	INT i,j;
	OP zw,h;
	if (not EMPTYP(c)) freeself(c);
	if ( (S_O_K(a) != VECTOR) || (S_O_K(b) != VECTOR) )
		return error("lagrange_polynom: no vector arguments");
	if (S_V_LI(a) != S_V_LI(b))
		return error("lagrange_polynom: different vector length");
	zw = callocobject();
	h = callocobject();
	for (i=0L; i< S_V_LI(a) ; i++ )
		{
		copy (S_V_I(b,i), zw);
		for (j = 0L; j < S_V_LI(a); j++)
		if (i != j) {
			sub (S_V_I(a,i),S_V_I(a,j),h);
			div(zw,h,zw); 
			freeself(h);
			b_skn_po(
			callocobject(),callocobject(),callocobject(),h);
			b_skn_po(
			callocobject(),callocobject(),NULL,S_PO_N(h));
			m_il_v(1L,S_PO_S(h));
			m_il_v(1L,S_PO_S(S_PO_N(h)));
			M_I_I(0L,S_PO_SI(h,0L));
			M_I_I(1L,S_PO_SI(S_PO_N(h),0L));
			addinvers(S_V_I(a,j), S_PO_K(h));
			M_I_I(1L, S_PO_K(S_PO_N(h)));
			mult(h,zw,zw);
			}
		add(zw,c,c); freeself(zw);
		}
	freeall(zw);freeall(h);
	return OK;
#endif /* POLYTRUE */
}

INT m_iindex_monom(i,erg) INT i; OP erg; 
/* AK 200891 V1.3 */
{
#ifdef POLYTRUE
return
 m_iindex_iexponent_monom(i,1L,erg);
#endif /* POLYTRUE */
}

INT m_iindex_iexponent_monom(i,ex,erg) INT i,ex; OP erg;
/* AK 300588 */ /* macht aus i das Monom x_i */
/* AK 030789 V1.0 */ /* AK 060390 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef POLYTRUE
	INT j;

	if (i<0L)  return error("m_iindex_iexponent_monom:index < 0 ");
	if (not EMPTYP(erg)) freeself(erg);
	b_skn_po(callocobject(),callocobject(),NULL,erg);
	m_il_v(i+1L,S_PO_S(erg));
	M_I_I(1L,S_PO_K(erg));
	for(j=0L;j<=i;j++)
		if (j == i)  M_I_I(ex,S_PO_SI(erg,j));
		else M_I_I(0L,S_PO_SI(erg,j));
	return OK;
#else /* POLYTRUE */
	return error("m_iindex_iexponent_monom:POLYNOM not available");
#endif /* POLYTRUE */
	}

INT nullp_polynom(a) OP a;
/* AK 180291 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP z = a;
	if (empty_listp(a)) 
		return TRUE;
	while (z != NULL)
		{
		if (not nullp(S_PO_K(z)) ) return FALSE;
		z = S_PO_N(z);
		}
	return TRUE;
#else /* POLYTRUE */
	return error("nullp_polynom:POLYNOM not available");
#endif /* POLYTRUE */
}


INT einsp_polynom(a) OP a;
/* AK 180291 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP z = a;
	INT i;
	if (empty_listp(a)) return FALSE;
	if (not einsp(S_PO_K(z)) ) return FALSE;
	/* now check whether self == 000000 */
	for (i=0L; i<S_PO_SLI(z); i++)
		if (S_PO_SII(z,i) != 0L) return FALSE;
	z = S_PO_N(z);
	if (z != NULL) return FALSE;
	return TRUE;
#else /* POLYTRUE */
	return error("einsp_polynom:POLYNOM not available");
#endif /* POLYTRUE */
}


INT m_scalar_polynom(a,b) OP a,b;
/* AK 180291 V1.2 */ /* AK 060891 V1.3 */
{
#ifdef POLYTRUE
	b_skn_po(callocobject(),callocobject(),NULL,b);
	copy(a,S_PO_K(b));
	m_il_v(1L,S_PO_S(b));
	m_i_i(0L,S_PO_SI(b,0L));
	return OK;
#else /* POLYTRUE */
	return error("m_scalar_polynom:POLYNOM not available");
#endif /* POLYTRUE */
}
