#include "def.h" 
#include "macro.h"

/* vector.c */
/* AK 160986 */

static struct vector * callocvectorstruct();

INT einsp_vector(a) OP a;
/* AK 010692 */
{
	INT i;
	for (i=0L;i<S_V_LI(a);i++)
		if (not einsp(S_V_I(a,i))) return FALSE;
	return TRUE;
}

INT vectorp(a) OP a;
/* AK 210192 */
{
	if (
		(s_o_k(a) == VECTOR)
		||
		(s_o_k(a) == WORD)
		||
		(s_o_k(a) == KRANZ)
		||
		(s_o_k(a) == COMP)
	   ) return TRUE;
	return FALSE;
}

INT m_o_v(ob,vec) OP ob,vec;
/* make_object_vector */
/* AK 260488 erzeugt aus einen object einen vector */
/* AK 270689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{ 
	m_il_v(1L,vec); 
	return(copy(ob,S_V_I(vec,0L))); 
}

INT b_o_v(ob,vec) OP ob,vec;
/* build_object_vector */ 
/* AK 170590 V1.1 */ /* AK 200891 V1.3 */
{ 
	if (not EMPTYP(vec)) freeself(vec);
	b_ls_v(callocobject(),ob,vec); 
	m_i_i(1L,S_V_L(vec)); 
	return(OK); 
}

INT m_l_nv(il,vec)  OP il,vec;
/* AK 160791 V1.3 */
{
return m_il_nv(S_I_I(il),vec);
}

INT m_il_nv(il,vec) INT il; OP vec;
/* AK 160791 V1.3 */
{
	INT i;
	m_il_v(il,vec);
	for (i=0L;i<S_V_LI(vec);i++)
		M_I_I(0L,S_V_I(vec,i));
	return OK;
}

INT m_il_v(il,vec) INT il; OP vec;
/* make_integerlength_vector */
/* AK 250587 */ /* AK 270689 V1.0 */ /* AK 211289 V1.1 */
/* AK 080291 V1.2 test on negativ
                  test on zero length */
/* AK 200891 V1.3 */
{
#ifdef VECTORTRUE
	INT erg = OK,i;
	if (il < 0L) 
		return error("m_il_v: negativ length");
	if (not EMPTYP(vec)) 
		freeself(vec); /* AK 080989 */
	if (il == 0L) 
		erg += b_ls_v(callocobject(),NULL,vec);
	else
		erg += b_ls_v(callocobject(),
			(OP) malloc((int)il * sizeof(struct object)),vec);
	C_O_K(S_V_L(vec),INTEGER);
	M_I_I(il,S_V_L(vec));
	for (i=0L;i<il;i++) /* AK 271191 DOS */
		C_O_K(S_V_I(vec,i),EMPTY);
	if (erg != OK)
		error("m_il_v: error during computation");
	return erg;
#endif /* VECTORTRUE */
}

#ifdef VECTORTRUE 
INT b_l_v(length,a) OP length, a;
/* build_length_vector
	build bedeutet length wird teil des vector objects */
/* AK 170590 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK,i;
	OP self ; /* self komponente des vectors */

	if (S_O_K(length) != INTEGER)
	{ 
		printobjectkind(length); 
		return error("b_l_v:length no INTEGER");
	}

	if (NULLP_INTEGER(length)) 
		return b_ls_v(length,NULL,a); /* AK 021291 */

	self = (OP) calloc((int)S_I_I(length),sizeof(struct object));
	if (self == NULL) 
		return error("b_l_v:no memory");
	erg += b_ls_v( length , self, a);
	for (i=0L;i<S_V_LI(a);i++) /* AK 271191 DOS */
		C_O_K(S_V_I(a,i),EMPTY);
	if (erg != OK)
		 error("b_l_v:error during computation");
	return erg;
}
#endif /* VECTORTRUE */

#ifdef VECTORTRUE
INT b_l_nv(a,b) OP a,b;
/* AK 170692 */
	{
	INT i;
	if (b_l_v(a,b) != OK) return ERROR;
	for (i=0L;i<S_V_LI(b);i++)
		M_I_I(0L,S_V_I(b,i));
	return OK;
	}
#endif /* VECTORTRUE */

INT m_l_v(length,a) OP length,a;
/* make_length_vector
	make bedeutet length wird copiert */
/* AK 170590 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef VECTORTRUE 
	OP l ;
	if (S_O_K(length) != INTEGER)
	{ 
		printobjectkind(length); 
		error("m_l_v:length no INTEGER"); 
		return(ERROR); 
	};
	l = callocobject();
	COPY_INTEGER(length,l);
	return(b_l_v(l,a));
#endif /* VECTORTRUE */ 
}

INT add_apply_vector(a,b) OP a, b;
/* b = b+a */
/* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef VECTORTRUE 
	INT i;
	OP c;

	if (S_V_LI(a) > S_V_LI(b))
	{
		c = callocobject();
		copy(a,c);
		for (i=0L;i<S_V_LI(a);i++)
			if 	(i < S_V_LI(b))
				add(S_V_I(a,i),S_V_I(b,i),S_V_I(c,i));
			else break;
		freeself(b);
		*b = *c;
		free(c);
	}
	else {
		for (i=0L;i<S_V_LI(b);i++)
			if 	(i < S_V_LI(a))
				add_apply(S_V_I(a,i),S_V_I(b,i));
			else break;
	};
	return(OK);
#endif /* VECTORTRUE */
}


INT add_vector(a,b,c) OP a, b, c;
/* AK 221086 */
/* geaendert ohne hilfsvariable 061186 */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef VECTORTRUE 
	INT i;

	if (S_V_LI(a) > S_V_LI(b))
	{
		copy(a,c);
		for (i=0L;i<S_V_LI(a);i++)
			if 	(i < S_V_LI(b))
				add(S_V_I(a,i),S_V_I(b,i),S_V_I(c,i));
			else break;
	}
	else {
		copy(b,c);
		for (i=0L;i<S_V_LI(b);i++)
			if 	(i < S_V_LI(a))
				add(S_V_I(a,i),S_V_I(b,i),S_V_I(c,i));
			else break;
	};
	return(OK);
#endif /* VECTORTRUE */
}

INT qsort_vector(vec) OP vec;
/* sortiert einen vector in aufsteigender folge mit systemroutine AK 060488 */
/* AK 280689 V1.0 */
/* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef VECTORTRUE 
	qsort(S_V_S(vec),(int)S_V_LI(vec),sizeof(struct object),comp);
	/* (int) wegen PC-compabilitaet AK 120789 */
	return(OK);
#endif /* VECTORTRUE */
}

INT sort_vector(vec) OP vec;
/* sortiert einen vector in aufsteigender folge
nach den algorithmus insertion-sort (knuth) AK 270787 */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef VECTORTRUE 
	INT i,j,k,erg;
	OBJECTSELF zeiger;
	OBJECTKIND art;

	for (i=0L;i<S_V_LI(vec);i++)
		for (j=0L;j<i;j++)
			if (erg = lt(S_V_I(vec,i),S_V_I(vec,j)))
			{
				zeiger =  S_O_S(S_V_I(vec,i));
				art =  S_O_K(S_V_I(vec,i));
				for (k=i;k>j;k--)
					*S_V_I(vec,k) = *S_V_I(vec,k-1L);
				C_O_S(S_V_I(vec,j),zeiger);
				C_O_K(S_V_I(vec,j),art);
			};
	return(OK);
#endif /* VECTORTRUE */
}


INT freeself_vector(vec) OP vec;
/* gibt den speicherplatz eines vectorobjects frei */
/* AK 280689 V1.0 */ /* AK 211189 V1.1 */ /* AK 130691 V1.2 */ 
/* AK 200891 V1.3 */
{
#ifdef VECTORTRUE
	OBJECTSELF d;
	INT  i,erg=OK;
	OP z;

	d = S_O_S(vec);
	z = S_V_S(vec);
	if (S_V_LI(vec) > 0L) 
		{
		for (i=0L;i<S_V_LI(vec);i++,z++) 
			if (not EMPTYP(z))
				if (S_O_K(z) != INTEGER)
					erg += freeself(z);
		free(S_V_S(vec));
		}
	freeall(S_V_L(vec)); 
	free(d.ob_vector);
	C_O_K(vec,EMPTY);
	return erg;
#endif /* VECTORTRUE */
}


INT addinvers_vector(vec,erg) OP vec,erg;
/* AK 270887 */ /* AK 280689 V1.0 */ /* AK 201289 V1.1 */
/* AK 200891 V1.3 */
{
	INT i;

	copy(vec,erg);
	for (i=0L;i<S_V_LI(vec);i++) addinvers(S_V_I(vec,i),S_V_I(erg,i));
	return(OK);
}


INT addinvers_apply_vector(vec) OP vec;
/* AK 201289 V1.1 */ /* AK 080591 V1.2 */ /* AK 200891 V1.3 */
{
	INT i,erg=OK;
	for (i=0L;i<S_V_LI(vec);i++) 
		erg += addinvers_apply(S_V_I(vec,i));
	return erg;
}


INT addtoallvectorelements(zahl,vector,ergebnis) OP zahl,vector,ergebnis;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
	INT		i;
	copy(vector,ergebnis);
	for(	i = 0L; i < S_V_LI(ergebnis);
	    add(zahl,S_V_I(ergebnis,i),S_V_I(ergebnis,i)),
	    i++);
	return OK;
}


INT copy_vector(vec,res) OP vec, res;
/* AK 021286 */ /* AK 280689 V1.0 */ /* AK 081289 V1.1 */
/* AK 120391 V1.2 */ /* AK 200891 V1.3 */
{
	INT		i;

	m_il_v(	S_V_LI(vec), res);

	for(	i=0L; i < S_V_LI(vec); i++)
		{
		if (S_O_K(S_V_I(vec,i)) == INTEGER) /* AK 120391 */
			* (S_V_I(res,i)) = * (S_V_I(vec,i));
		else
			copy(S_V_I(vec,i),S_V_I(res,i));
		}
	C_O_K(res,S_O_K(vec));
	return OK;
}





INT comp_vector(a,b) OP a,b;
/* AK 060488 */ /* AK 280689 V1.0 */ /* AK 201289 V1.1 */
/* AK 200891 V1.3 */
{
	INT i,erg;
	for (	i=0L; i<S_V_LI(a); i++)
	{
		if (i >=  S_V_LI(b)) return(1L);
		erg = comp(S_V_I(a,i),S_V_I(b,i));
		if (erg != 0L) return(erg);
	};
	return(0L);
}


INT scan_integervector(ergebnis) OP ergebnis;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 080591 V1.2 */
/* AK 200891 V1.3 */
{
	INT length;
	INT i,erg =OK;

	erg += printeingabe("length of vector ");
	scanf("%ld",&length);
	erg += m_il_v(length,ergebnis);
	for (i=0L;i<length; erg += scan(INTEGER,S_V_I(ergebnis,i++)));
	return erg;
}

INT scan_vector(ergebnis) OP ergebnis;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
	INT length,erg=OK;
	INT i;
	OBJECTKIND kind;


	erg += printeingabe("length of vector "); 
	scanf("%ld",&length);
	erg += m_il_v(length,ergebnis);
	erg += printeingabe("kind of vector elements ");
	kind = scanobjectkind();
	for (i=0L;i < length; erg += scan(kind,S_V_I(ergebnis,i++)));
	return erg;
}


static struct vector * callocvectorstruct()
/* AK 170889 V1.1 malloc statt calloc */ /* AK 211289 V1.1 */
/* AK 200891 V1.3 */
{
	struct vector * ergebnis =
	(struct vector *) malloc(sizeof(struct vector));
	if (ergebnis == NULL) 
		error("callocvectorstruct: no memory");
	return(ergebnis);
}

INT b_ls_v(length,self,ergebnis) OP length, self,ergebnis;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
	OBJECTSELF d;

	if (not EMPTYP(ergebnis)) 
		freeself(ergebnis); /* AK 170889 */
	d.ob_vector = callocvectorstruct();

	b_ks_o(VECTOR, d,ergebnis);

	C_V_S(ergebnis,self); 
	C_V_L(ergebnis,length);
	return(OK);
}


OP s_v_s(a) OP a; 
/* AK 270689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a);
	if (a==NULL) 
		{ 
		error("s_v_s:object == NULL"); 
		return(NULL); 
		}
	if (c.ob_vector==NULL) 
		{ 
		error( "s_v_s:vector pointer == NULL");
		return(NULL); 
		}
	if (not vectorp(a)) { /* AK 210192 */
		error("s_v_s: not VECTOR");
		return NULL;
		}
	return(c.ob_vector->v_self);
}

OP s_v_l(a) OP a; 
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	OP erg;
	c = s_o_s(a);
	if (a==NULL) 
		{ 
		error("s_v_l:object == NULL"); 
		return(NULL); 
		}
	if (c.ob_vector==NULL)
		{  
		error( "s_v_l:vector pointer == NULL"); 
		return(NULL); 
		}
	if (not vectorp(a)) { /* AK 210192 */
		error("s_v_l: not VECTOR");
		return NULL;
		}
	erg = c.ob_vector->v_length;
	if (s_o_k(erg) != INTEGER) 
		{  
		printobjectkind(erg);
		error( "s_v_l:length != INTEGER");
		return(NULL); 
		}
	if (s_i_i(erg) < 0L) 
		{  
		error( "s_v_l:length <0");
		return(NULL); 
		}
	return erg;
}


INT s_v_li(a) OP a; 
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ 
	INT erg = s_i_i(s_v_l(a)); 
	return erg;
}

OP s_v_i(a,i) OP a; INT i; 
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{
	if (i<0L) 
		{ 
		error("s_v_i:negative index"); 
		return(NULL); 
		}
	if (i >= s_v_li(a) ) 
		{ 
		error("s_v_i:index too big"); 
		return(NULL); 
		}
	return(s_v_s(a) + (i));
}

INT c_v_i(a,i,b) OP a,b; INT i;
/* AK 170889 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ 
	c_o_k(s_v_i(a,i),s_o_k(b)); 
	c_o_s(s_v_i(a,i),s_o_s(b)); 
	return(OK); 
}

INT s_v_ii(a,i) OP a; INT i;
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ return(s_i_i(s_v_i(a,i))); }

INT c_v_s(a,b) OP a,b;
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	(c.ob_vector->v_self)=b; 
	return(OK); 
}

INT c_v_l(a,b) OP a,b;
/* AK 270689 V1.0 */ /* AK 201289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	(c.ob_vector->v_length)=b; 
	return(OK); 
}

INT lastof_vector(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{
	return(copy(S_V_I(a,S_V_LI(a)-1L),b));
}

INT length_vector(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 180691 V1.2 */
/* AK 200891 V1.3 */
{
	return(copy(S_V_L(a),b));
}


INT tex_vector(vecobj) OP vecobj;
/* AK 101187 */
/* mit tex werden alle elemente ausgegeben */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */
/* AK 070291 V1.2 prints to texout */
/* AK 200891 V1.3 */
{
	INT i;
	fprintf(texout,"\\ $[$");
	for(	i = 0L; i<S_V_LI(vecobj); i++)
	{
		texposition += 6L;
		tex(S_V_I(vecobj,i));
		if (i != S_V_LI(vecobj)-1)
			{ fprintf(texout,"$,$"); texposition ++; }
	};

	fprintf(texout,"$]$\\ ");
	texposition += 6L;
	return(OK);
}


INT fprint_vector(f,vecobj) FILE *f; OP vecobj;
/* AK 171186 */
/* AK 211186 als fprint */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
	INT i;
	fprintf(f,"[");
	if (f == stdout) zeilenposition++;
	for(	i = 0L; i<S_V_LI(vecobj); i++)
	{
		fprint(f,S_V_I(vecobj,i));
		if (i != S_V_LI(vecobj)-1)
		{
			fprintf(f,",");
			if (f == stdout) { 
				zeilenposition++;
				if (zeilenposition >70L) {
					fprintf(f,"\n");
					zeilenposition = 0L; 
				}
			}
		};
	};

	fprintf(f,"]");
	if (f == stdout) zeilenposition++;
	return(OK);
}




INT objectread_vector(filename,vec) FILE *filename; OP vec;
/* AK 131086 */ /* AK 280689 V1.0 */ /* AK 211289 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef VECTORTRUE
	INT i;
	OP length = callocobject();
	objectread(filename,length);
	b_l_v(length,vec);
	for (i=0L;i<S_I_I(length);i++) objectread(filename,S_V_I(vec,i));
	return OK;
#else /* VECTORTRUE */
	error("objectread_vector:VECTOR not available");
	return(ERROR);
#endif /* VECTORTRUE */
}

INT objectwrite_vector(filename,vec) FILE *filename; OP vec;
/* AK 131086 */ /* AK 280689 V1.0 */ /* AK 211289 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef VECTORTRUE
	INT i;
	fprintf(filename," %d ",VECTOR);

	objectwrite(filename,S_V_L(vec));

	for (i=0L;i<S_V_LI(vec);i++) objectwrite(filename,S_V_I(vec,i));
	return(OK);
#else /* VECTORTRUE */
	error("objectwrite_vector:VECTOR not available");
	return(ERROR);
#endif /* VECTORTRUE */
}

INT test_vector()
/* AK 280689 */ /* AK 211289 V1.1 */ /* AK 200891 V1.3 */
{
	OP a = callocobject();
	OP b = callocobject();
	OP c = callocobject();
	printf("test_vector:m_il_v(5L,a)\n");
	m_il_v(5L,a);
	println(a);
	printf("test_vector:M_I_I(4L,s_v_i(a,3L))\n");
	M_I_I(4L,s_v_i(a,3L));
	println(a);
	printf("test_vector:m_il_v(4L,s_v_i(a,1L))\n");
	m_il_v(4L,s_v_i(a,1L));
	println(a);
	printf("test_vector:copy_vector(a,b)\n");
	copy_vector(a,b);
	println(b);
	printf("test_vector:inc_vector(b)\n");
	inc_vector(b);
	println(b);
	printf("test_vector:dec_vector(b)\n");
	dec_vector(b);
	println(b);
	printf("test_vector:freeself_vector(b)\n");
	freeself_vector(b);
	println(b);
	printf("test_vector:scan(INTEGERVECTOR,b)\n");
	scan(INTEGERVECTOR,b);
	println(b);
	freeall(a); 
	freeall(b); 
	freeall(c);
	return(OK);
}

INT inc_vector(a) OP a;
/* AK 270887 */
/* verlaengert den vector um ein leeres object, welches am Ende steht */
/* dabei werden die vector elemente kopiert */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef VECTORTRUE
	OP erg = callocobject();
	INT i;
	OP z;


	if (S_V_LI(a) == 0L) 
		z = (OP) calloc(1L,sizeof(struct object));
	else {
		i = (S_V_LI(a) + 1L) * (sizeof(struct object));
		z =  (OP ) realloc((char*) S_V_S(a),(unsigned) i);
		}

/*
	m_il_v(S_V_LI(a)+1,erg);
	for (i=0L;i<S_V_LI(a);i++) 
		copy(S_V_I(a,i),S_V_I(erg,i));
	freeself(a);
	*a = *erg;
	free(erg); 

*/
	if (z == NULL)
		error("inc_vector:self == NULL");
	C_V_S(a,z);
	C_O_K(S_V_I(a,S_V_LI(a)),EMPTY);
	inc(S_V_L(a));
	return(OK);
#else /* VECTORTRUE */
	error("inc_vector: VECTOR not available");
	return(ERROR);
#endif /* VECTORTRUE */
}

INT sum_vector(vecobj,ergebnis) OP vecobj,ergebnis;
/* berechnet die summe der vectorelemente AK 270787 */
/* AK 280689 V1.0 */ /* AK 081289 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef VECTORTRUE
	INT i;
	M_I_I(0L,ergebnis);
	for (	i=0L; i < S_V_LI(vecobj);i++)
		add(	ergebnis, S_V_I(vecobj,i), ergebnis);
	return(OK);
#endif /* VECTORTRUE */
}



INT max_vector(vec,m) OP vec,m;
/* kopiert maximales element */
/* AK 280689 V1.0 */ /* AK 050390 V1.1 */ /* AK 100691 V1.2 */ 
/* AK 070891 V1.3 */
{
	INT i;
	OP zm;
	zm = S_V_I(vec,0L);
	for(i=1L;i<S_V_LI(vec);i++)
		if (GR(S_V_I(vec,i),zm)) zm = S_V_I(vec,i);
	return(copy(zm,m));
}

INT mult_scalar_vector(a,b,c) OP a,b,c;
/* AK 010888 skalarmultiplikation */
/* a ist skalar b ist vector c wird vector */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
	INT i = 0L;
	INT erg = OK;
	erg += m_il_v(S_V_LI(b),c);
	for (i=0L; i<S_V_LI(c); i++)
		erg += mult(a, S_V_I(b,i), S_V_I(c,i));
	return erg;
}

#ifdef VECTORTRUE
#ifdef MATRIXTRUE
INT mult_vector_matrix(a,b,c) OP a, b, c;
/* AK 200192 */
{
	INT i,j;
	INT erg = OK;
	OP d;
	if (S_O_K(a) != VECTOR) return ERROR;
	if (S_O_K(b) != MATRIX) return ERROR;
	if ((a == c) || (b == c)) return ERROR;
	if (S_V_LI(a) != S_M_HI(b)) return ERROR;
	erg += m_il_nv(S_M_LI(b),c);
	d = callocobject();
	for (i=0L;i<S_V_LI(c);i++)
	for (j=0L;j<S_V_LI(a);j++)
		{
		erg += mult(S_V_I(a,j),S_M_IJ(b,j,i),d);
		erg += add_apply(d,S_V_I(c,i));
		}
	erg += freeall(d);
	return erg;
}
#endif /* MATRIXTRUE */
#endif /* VECTORTRUE */

INT mult_vector_vector(a,b,c) OP a, b, c;
/* AK 110588  componentenweise multiplication */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
	INT i = 0L;

	if (S_V_LI(a) !=  S_V_LI(b))
	{
		fprintf(stderr,"size of a: "); fprintln(stderr,S_V_L(a));
		fprintf(stderr,"size of b: "); fprintln(stderr,S_V_L(b));
		return error("mult_vector_vector:different size of vectors ");
	}
	else {
		if (not EMPTYP(c)) freeself(c);
		m_il_v(S_V_LI(a),c);
		for (i=0L;i<S_V_LI(b);i++)
			mult(S_V_I(a,i),S_V_I(b,i),S_V_I(c,i));
		};
	return(OK);
}

INT scalarproduct_vector(a,b,d) OP a,b,d;
/* AK 141189 V1.1 */ /* AK 070891 V1.3 */
{
	INT i,dt=0L;
	INT erg = OK; /* AK 200192 */
	OP c = callocobject();

	if (S_V_LI(a) != S_V_LI(b)) {
		error("scalarproduct_vector:different length");
		return(ERROR); 
	}
	for (i=S_V_LI(a)-1L;i>=0L;i--)
	{
		erg += mult(S_V_I(a,i),S_V_I(b,i),c);
		erg += add_apply(c,d);
	}
	erg += freeall(c);
	return erg;
}

INT dec_vector(a) OP a;
/* AK 120187  kuerzt den vector um 1 */
/* das letzte element wird gestrichen */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
	if (S_V_LI(a) == 0L )
	{
		error("vector der laenge 0 in decvector");
		return(ERROR);
	}
	if (not emptyp(S_V_I(a,S_V_LI(a)-1L)))  /* AK 260991 */
		freeself(S_V_I(a,S_V_LI(a)-1L));
	/* freigeben des speicherplatzes des letzten vectorelements */
	DEC_INTEGER(S_V_L(a));
	/* verkuerzen der laenge um eins */
	return(OK);
}

INT append_vector(a,b,c) OP a, b, c;
/* haengt den vector b an den vector a an */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
	INT		i,length=S_V_LI(a)+S_V_LI(b);
	INT erg = OK;

	erg += m_il_v(length,c);
	for(	i=0L;i<length; i++)
		if (i < S_V_LI(a))
			erg += copy(S_V_I(a,i),S_V_I(c,i));
		else
			erg += copy(S_V_I(b,i-S_V_LI(a)),S_V_I(c,i));
	return erg;
}


INT mult_apply_vector(a,b) OP a, b;
/* AK 070891 V1.3 */
{
	INT erg = OK;
	switch (S_O_K(b)) {
		case VECTOR: erg += mult_apply_vector_vector(a,b); break;
		default:
			erg = error("mult_apply_vector: wrong type"); break;
		}
	return erg;
}

INT mult_apply_vector_vector(a,b) OP a, b;
/* AK 110588  componentenweise multiplication */
/* AK 280689 V1.0 */ /* AK 211289 V1.1 */ /* AK 070891 V1.3 */
{
	INT i = 0L;

	if (S_V_LI(a) !=  S_V_LI(b))
	{
		fprintf(stderr,"size of a: "); fprintln(stderr,S_V_L(a));
		fprintf(stderr,"size of b: "); fprintln(stderr,S_V_L(b));
	return error("mult_apply_vector_vector:different size of vectors ");
	}
	else {
		for (i=0L;i<S_V_LI(b);i++)
			mult_apply(S_V_I(a,i),S_V_I(b,i));
		};
	return(OK);
}

INT nullp_vector(a) OP a;
/* AK 311091 */
{
	INT i;
	for (i=0L;i<S_V_LI(a); i++)
		if (not nullp(S_V_I(a,i)))
			return FALSE;
	return TRUE;
}
