(*^

::[currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, M7, bold, e8,  24, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, M7, bold, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, M7, italic, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a30, e15,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w450, h459,  12, "Courier"; ;
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = Left Header, inactive,  12, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; ;
	fontset = Left Footer, inactive,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; ;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;]
:[font = title; inactive; preserveAspect; ]
Calculation of the cross ratio
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Using this package
:[font = text; inactive; preserveAspect; endGroup; ]
This program needs also the packages "Tessellate.m", "CrossRatio.m" and
"Moebius.m", available using anonymous ftp at nic.funet.fi, directory
"pub/sci/math/riemann/mathematica".

Last modified: February 8th, 1993.

Send comments and bug reports to 
  Juha Haataja, Center for Scientific Computing (jhaataja@csc.fi).
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Initialization
:[font = text; inactive; preserveAspect; ]
Read in the necessary packages:
:[font = input; initialization; preserveAspect; ]
*)
<<CrossRatio.m
(*
:[font = input; initialization; preserveAspect; ]
*)
<<Moebius.m
(*
:[font = input; initialization; preserveAspect; endGroup; ]
*)
<<Tessellate.m
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Defining the fundamental 18-gon
:[font = text; inactive; preserveAspect; ]
Calculate the fundamental polygon (18-gon) for plotting:
:[font = input; initialization; Cclosed; preserveAspect; startGroup; ]
*)
polygon18 = RegularPolygon[18, 2*Pi/3, 0];
polygonpict = DrawHypPolygons[polygon18, 
	Prolog -> {AbsoluteThickness[0.2]}];
(*
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 429; pictureHeight = 459; endGroup; endGroup; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.06818 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.568182 0.454545 [
[ 0 0 0 0 ]
[ 1 1.06818 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
grestore
0 0 moveto
1 0 lineto
1 1.06818 lineto
0 1.06818 lineto
closepath
clip
newpath
gsave
gsave
gsave
0.2 Mabswid
newpath
0.97735 0.65235 0.16834 170 210 arc
stroke
newpath
0.91978 0.81054 0.16834 190 230 arc
stroke
newpath
0.81157 0.9395 0.16834 210 250 arc
stroke
newpath
0.66578 1.02367 0.16834 230 270 arc
stroke
newpath
0.5 1.0529 0.16834 250 290 arc
stroke
newpath
0.33422 1.02367 0.16834 270 310 arc
stroke
newpath
0.18843 0.9395 0.16834 290 330 arc
stroke
newpath
0.08022 0.81054 0.16834 310 350 arc
stroke
newpath
0.02265 0.65235 0.16834 330 370 arc
stroke
newpath
0.02265 0.48401 0.16834 350 390 arc
stroke
newpath
0.08022 0.32582 0.16834 10 50 arc
stroke
newpath
0.18843 0.19687 0.16834 30 70 arc
stroke
newpath
0.33422 0.1127 0.16834 50 90 arc
stroke
newpath
0.5 0.08347 0.16834 70 110 arc
stroke
newpath
0.66578 0.1127 0.16834 90 130 arc
stroke
newpath
0.81157 0.19687 0.16834 110 150 arc
stroke
newpath
0.91978 0.32582 0.16834 130 170 arc
stroke
newpath
0.97735 0.48401 0.16834 150 190 arc
stroke
grestore
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Defining some routines for forming generators
:[font = text; inactive; preserveAspect; ]
Define two angles for the fundamental polygon (in degrees):
:[font = input; initialization; preserveAspect; ]
*)
alfakulma = 60;
betakulma = 10;
(*
:[font = text; inactive; preserveAspect; ]
Convert the above angles to radians:
:[font = input; initialization; preserveAspect; ]
*)
alfar = alfakulma*Pi/180;
betar = betakulma*Pi/180;
(*
:[font = text; inactive; preserveAspect; ]
Make a routine for defining generators in numerical form:
:[font = input; initialization; preserveAspect; ]
*)
genN[phi_, ksi_, alfar_:(Pi/3), betar_:(Pi/18)] := 
    Block[{coshrho = Cos[alfar]/Sin[betar], 
        sinhrho = Sqrt[coshrho^2-1]},
    N[{{-I*Exp[I*(ksi - phi)/2]*coshrho, 
        I*Exp[I*(ksi + phi)/2]*sinhrho},
        {-I*Exp[-I*(ksi + phi)/2]*sinhrho, 
        I*Exp[-I*(ksi - phi)/2]*coshrho}}, 16]]
(*
:[font = text; inactive; preserveAspect; ]
Make a routine for defining generators in symbolical form:
:[font = input; initialization; preserveAspect; endGroup; ]
*)
gen[phi_, ksi_, alfar_:(Pi/3), betar_:(Pi/18)] := 
    Block[{coshrho = Cos[alfar]/Sin[betar], 
        sinhrho = Sqrt[coshrho^2-1]},
    {{-I*Exp[I*(ksi - phi)/2]*coshrho, 
        I*Exp[I*(ksi + phi)/2]*sinhrho},
        {-I*Exp[-I*(ksi + phi)/2]*sinhrho, 
        I*Exp[-I*(ksi - phi)/2]*coshrho}}]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Defining some generators
:[font = text; inactive; preserveAspect; ]
Define some elements of the group (using numerical matrix representation):
:[font = input; initialization; preserveAspect; ]
*)
Ag = genN[210*Pi/180, 130*Pi/180];
(*
:[font = input; initialization; preserveAspect; ]
*)
Bg = genN[150*Pi/180, 230*Pi/180];
(*
:[font = input; initialization; preserveAspect; ]
*)
Cg = genN[330*Pi/180, 50*Pi/180];
(*
:[font = input; initialization; preserveAspect; ]
*)
Dg = genN[30*Pi/180, 310*Pi/180];
(*
:[font = input; initialization; preserveAspect; ]
*)
ABg = MGenMult[{Ag,Bg}];
(*
:[font = input; initialization; preserveAspect; ]
*)
Big = Inverse[Bg];
(*
:[font = input; initialization; preserveAspect; ]
*)
BiAig = MGenMult[{Inverse[Bg], Inverse[Ag]}];
(*
:[font = input; initialization; preserveAspect; ]
*)
AiBig = MGenMult[{Inverse[Ag], Inverse[Bg]}];
(*
:[font = input; initialization; preserveAspect; ]
*)
Aig = Inverse[Ag];
(*
:[font = input; initialization; preserveAspect; ]
*)
BAg = MGenMult[{Bg,Ag}];
(*
:[font = input; initialization; preserveAspect; ]
*)
BABiAig = MGenMult[{Bg,Ag,Inverse[Bg],Inverse[Ag]}];
(*
:[font = input; initialization; preserveAspect; ]
*)
DCDiCig = MGenMult[{Dg,Cg,Inverse[Dg],Inverse[Cg]}];
(*
:[font = input; initialization; preserveAspect; ]
*)
DCg = MGenMult[{Dg,Cg}];
(*
:[font = input; initialization; preserveAspect; ]
*)
Cig = Inverse[Cg];
(*
:[font = input; initialization; preserveAspect; ]
*)
CiDig = MGenMult[{Inverse[Cg], Inverse[Dg]}];;
(*
:[font = input; initialization; preserveAspect; ]
*)
DiCig = MGenMult[{Inverse[Dg], Inverse[Cg]}];;
(*
:[font = input; initialization; preserveAspect; ]
*)
CDg = MGenMult[{Cg,Dg}];
(*
:[font = input; initialization; preserveAspect; ]
*)
ABAiBig = MGenMult[{Ag,Bg,Inverse[Ag],Inverse[Bg]}];
(*
:[font = input; initialization; preserveAspect; endGroup; ]
*)
CDCiDig = MGenMult[{Cg,Dg,Inverse[Cg],Inverse[Dg]}];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Testing the generators
:[font = text; inactive; Cclosed; preserveAspect; startGroup; ]
Define two test routines: 
:[font = input; initialization; preserveAspect; endGroup; ]
*)
DrawGenTest[phi_, ksi_, plabel_String:""] :=
    Block[{gen = genN[phi, ksi], 
        pt = First[RegularPolygon[18, 2*Pi/3, 0]], 
        testpts, imagepts, middlept, middleimgpt,
        arc1pict, arc2pict, origpict, imagepict, imagearcpict},
    testpts = N[{RotatePoint[pt,phi-Pi/18], 
        RotatePoint[pt,phi+Pi/18]}];
    imagepts = ApplyMGen[gen,testpts];
    middlept = HypMiddleOfArc[testpts];
    middleimgpt = ApplyMGen[gen,middlept];
    arc1pict = DrawArcs[{testpts}, DisplayFunction -> Identity, 
        Prolog -> {AbsoluteThickness[2]}];
    arc2pict = DrawArcs[{imagepts}, DisplayFunction -> Identity, 
        Prolog -> {AbsoluteThickness[0.5]}];
    origpict = DrawPoints[{middlept}, 
        Prolog -> {AbsolutePointSize[8]},
        DisplayFunction -> Identity];
    imagepict = DrawPoints[{middleimgpt}, 
        Prolog -> {AbsolutePointSize[5]},
        DisplayFunction -> Identity];
    imagearcpict = DrawArcs[{{middlept,middleimgpt}}, 
        DisplayFunction -> Identity];
    Show[Graphics[UnitCircle], 
        arc1pict, arc2pict, imagepict, origpict, imagearcpict,
        DisplayFunction -> $DisplayFunction, PlotRange -> {{-1,1},{-1,1}},
        PlotLabel -> plabel, AspectRatio -> Automatic]]

DrawGenPointTest[{pt1_, pt2_}, gen_List, plabel_String:""] :=
    Block[{testpts = N[{pt1, pt2}], imagepts, 
        middlept, middleimgpt, arc1pict, arc2pict, 
        origpict, imagepict, imagearcpict},
    imagepts = ApplyMGen[gen,testpts];
    middlept = HypMiddleOfArc[testpts];
    middleimgpt = ApplyMGen[gen,middlept];
    arc1pict = DrawArcs[{testpts}, DisplayFunction -> Identity, 
        Prolog -> {AbsoluteThickness[2]}];
    arc2pict = DrawArcs[{imagepts}, DisplayFunction -> Identity, 
        Prolog -> {AbsoluteThickness[0.5]}];
    origpict = DrawPoints[{middlept},	
        Prolog -> {AbsolutePointSize[8]},
	    DisplayFunction -> Identity];
    imagepict = DrawPoints[{middleimgpt}, 
        Prolog -> {AbsolutePointSize[5]},
        DisplayFunction -> Identity];
    imagearcpict = DrawArcs[{{middlept,middleimgpt}}, 
        DisplayFunction -> Identity];
    Show[Graphics[UnitCircle], 
        arc1pict, arc2pict, imagepict, origpict, imagearcpict,
        DisplayFunction -> $DisplayFunction, PlotRange -> {{-1,1},{-1,1}},
        PlotLabel -> plabel, AspectRatio -> Automatic]]
(*
:[font = text; inactive; preserveAspect; ]
Give two angles to define a generator and draw a picture for testing. 
:[font = input; Cclosed; preserveAspect; startGroup; ]
phi := 210*Pi/180; ksi := 130*Pi/180;
DrawGenTest[phi, ksi, "Generaattori A"]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 447; pictureHeight = 447; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[(Generaattori A)] 0.5 1 0 -2 Msboxa
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
[(Generaattori A)] 0.5 1 0 -2 Mshowa
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
gsave
gsave
0.004 setlinewidth
newpath
0.5 0.5 0.5 0 365.73 arc
stroke
grestore
gsave
gsave
gsave
2 Mabswid
newpath
0.03825 0.23341 0.18517 10 50 arc
stroke
grestore
grestore
grestore
gsave
gsave
gsave
0.5 Mabswid
newpath
0.15727 0.90845 0.18517 290 330 arc
stroke
grestore
grestore
grestore
gsave
gsave
gsave
5 Mabswid
0.2763 0.76659 Mdot
grestore
grestore
grestore
gsave
gsave
gsave
8 Mabswid
0.19861 0.32599 Mdot
grestore
grestore
grestore
gsave
gsave
gsave
0.2 Mabswid
newpath
-0.18545 0.62086 0.4842 322.484 377.516 arc
stroke
grestore
grestore
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = output; output; inactive; preserveAspect; endGroup; ]
The Unformatted text for this cell was not generated.
Use options in the Actions Preferences dialog box to 
control when Unformatted text is generated.
;[o]
-Graphics-
:[font = text; inactive; preserveAspect; ]
Define two points (for example, giving the angle phi) and a generator, 
and draw a test picture. 
:[font = input; Cclosed; preserveAspect; startGroup; ]
angle := 130*Pi/180;
pt = First[RegularPolygon[18, 2*Pi/3, 0]];
testpts = N[{RotatePoint[pt,angle-Pi/18], 
    RotatePoint[pt,angle+Pi/18]}];
DrawGenPointTest[testpts, Aig, "Generaattori A^(-1)"]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 447; pictureHeight = 447; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[(Generaattori A^\(-1\))] 0.5 1 0 -2 Msboxa
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
[(Generaattori A^\(-1\))] 0.5 1 0 -2 Mshowa
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
gsave
gsave
0.004 setlinewidth
newpath
0.5 0.5 0.5 0 365.73 arc
stroke
grestore
gsave
gsave
gsave
2 Mabswid
newpath
0.15727 0.90845 0.18517 290 330 arc
stroke
grestore
grestore
grestore
gsave
gsave
gsave
0.5 Mabswid
newpath
0.03825 0.23341 0.18517 10 50 arc
stroke
grestore
grestore
grestore
gsave
gsave
gsave
5 Mabswid
0.19861 0.32599 Mdot
grestore
grestore
grestore
gsave
gsave
gsave
8 Mabswid
0.2763 0.76659 Mdot
grestore
grestore
grestore
gsave
gsave
gsave
0.2 Mabswid
newpath
-0.18545 0.62086 0.4842 322.484 377.516 arc
stroke
grestore
grestore
grestore
grestore
% End of Graphics
MathPictureEnd
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; ]
The Unformatted text for this cell was not generated.
Use options in the Actions Preferences dialog box to 
control when Unformatted text is generated.
;[o]
-Graphics-
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Calculation of the cross ratio
:[font = text; inactive; preserveAspect; ]
Define generators h1, h2 and h3 in function form using 
the matrix representation from above:
;[s]
7:0,0;18,1;20,0;22,1;24,0;29,1;31,0;94,-1;
2:4,16,11,Times,0,14,0,0,0;3,16,11,Times,1,14,0,0,0;
:[font = input; initialization; preserveAspect; ]
*)
h1[z_] = ApplyMGen[Aig,z];
(*
:[font = input; initialization; preserveAspect; ]
*)
h2[z_] = ApplyMGen[Bg,z];
(*
:[font = input; initialization; preserveAspect; ]
*)
h3[z_] = ApplyMGen[BAg,z];
(*
:[font = text; inactive; preserveAspect; ]
Compute the imaginary part of the cross ratio.  
Approximate computing time on a Macintosh IIfx is 4 minutes.
:[font = input; preserveAspect; endGroup; ]
vars = {x, y};
poly = CrossRatioPoly[{h1, h2, h3}, vars];
numpoly = N[poly, numprecision = 16];
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Plotting of the zero curves
:[font = text; inactive; preserveAspect; ]
Plot the zero curves of the polynomial calculated from the cross ratio 
using the ContourPlot function of Mathematica.  
Approximate computing time on a Macintosh IIfx is 1 minutes 
using resolution of 100 points.
;[s]
3:0,0;106,1;117,0;214,-1;
2:2,16,11,Times,0,14,0,0,0;1,16,11,Times,2,14,0,0,0;
:[font = input; preserveAspect; ]
curvepict = PlotPoly[numpoly, vars, 
	pictresolution = 50];
:[font = text; inactive; preserveAspect; ]
Show the combined plot:
:[font = input; preserveAspect; startGroup; ]
polylabel = "[I, Ai, B, BA]";
Show[curvepict, polygonpict, PlotLabel -> polylabel, 
	DisplayFunction -> $DisplayFunction, 
	AspectRatio -> Automatic, PlotRange -> {{-1,1},{-1,1}}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 429; pictureHeight = 459; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.06818 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.4329 0.566558 0.4329 [
[([I, Ai, B, BA])] 0.5 1.06818 0 -2 Msboxa
[ 0 0 0 0 ]
[ 1 1.06818 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
0 setgray
gsave
[([I, Ai, B, BA])] 0.5 1.06818 0 -2 Mshowa
grestore
0 0 moveto
1 0 lineto
1 1.06818 lineto
0 1.06818 lineto
closepath
clip
newpath
gsave
% Start of sub-graphic
gsave
0.04978 0.11634 0.95022 1.01677 MathSubStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.480769 0.5 0.480769 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: ContourGraphics
[ ] 0 setdash
gsave
gsave
grestore
grestore
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
gsave
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37073 0.03714 moveto
0.37245 0.0368 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37073 0.03714 moveto
0.36394 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3865 0.03328 moveto
0.39207 0.03226 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3865 0.03328 moveto
0.37245 0.0368 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.40255 0.02971 moveto
0.4117 0.0282 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.40255 0.02971 moveto
0.39207 0.03226 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.41899 0.02653 moveto
0.43132 0.02477 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.41899 0.02653 moveto
0.4117 0.0282 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4359 0.02382 moveto
0.45094 0.0221 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4359 0.02382 moveto
0.43132 0.02477 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45337 0.02166 moveto
0.47057 0.02027 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45337 0.02166 moveto
0.45094 0.0221 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47147 0.02014 moveto
0.49019 0.01935 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47147 0.02014 moveto
0.47057 0.02027 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.50981 0.01935 moveto
0.49029 0.01934 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.49029 0.01934 moveto
0.49019 0.01935 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.52943 0.02026 moveto
0.50992 0.01934 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.50992 0.01934 moveto
0.50981 0.01935 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54906 0.02205 moveto
0.53045 0.02025 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.53045 0.02025 moveto
0.52943 0.02026 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.56868 0.02466 moveto
0.55201 0.02218 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54906 0.02205 moveto
0.55201 0.02218 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.5883 0.02802 moveto
0.57472 0.02527 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.56868 0.02466 moveto
0.57472 0.02527 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.60793 0.03206 moveto
0.59878 0.02971 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.5883 0.02802 moveto
0.59878 0.02971 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.62755 0.0367 moveto
0.62442 0.03572 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.60793 0.03206 moveto
0.62442 0.03572 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.62755 0.0367 moveto
0.63514 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70604 0.02203 moveto
0.70078 0.01923 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.72567 0.03317 moveto
0.71198 0.02517 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70604 0.02203 moveto
0.71198 0.02517 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.72567 0.03317 moveto
0.73532 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31255 0.05745 moveto
0.31358 0.05711 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31255 0.05745 moveto
0.30962 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.32686 0.05214 moveto
0.3332 0.05 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.32686 0.05214 moveto
0.31358 0.05711 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3412 0.04685 moveto
0.35283 0.04286 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3412 0.04685 moveto
0.3332 0.05 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35567 0.0417 moveto
0.36394 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35567 0.0417 moveto
0.35283 0.04286 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.64717 0.04266 moveto
0.63514 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.6668 0.04965 moveto
0.65254 0.04422 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.64717 0.04266 moveto
0.65254 0.04422 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.68642 0.05701 moveto
0.68377 0.05583 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.6668 0.04965 moveto
0.68377 0.05583 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.68642 0.05701 moveto
0.6898 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.74529 0.0451 moveto
0.73532 0.03885 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76491 0.05773 moveto
0.76255 0.05612 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.74529 0.0451 moveto
0.76255 0.05612 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76491 0.05773 moveto
0.76598 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27282 0.07659 moveto
0.27433 0.07592 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27282 0.07659 moveto
0.2693 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.28614 0.07028 moveto
0.29396 0.06656 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.28614 0.07028 moveto
0.27433 0.07592 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29925 0.06377 moveto
0.30962 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29925 0.06377 moveto
0.29396 0.06656 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70604 0.06612 moveto
0.6898 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.72567 0.07572 moveto
0.72047 0.07291 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70604 0.06612 moveto
0.72047 0.07291 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.72567 0.07572 moveto
0.73001 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78454 0.07215 moveto
0.76598 0.05848 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78454 0.07215 moveto
0.79229 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.24834 0.09135 moveto
0.25471 0.08759 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.24834 0.09135 moveto
0.23664 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.26053 0.08392 moveto
0.2693 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.26053 0.08392 moveto
0.25471 0.08759 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.74529 0.08702 moveto
0.73001 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.74529 0.08702 moveto
0.76305 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80416 0.08757 moveto
0.79229 0.0781 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80416 0.08757 moveto
0.81621 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21303 0.11492 moveto
0.21546 0.11331 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21303 0.11492 moveto
0.20868 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.22478 0.10704 moveto
0.23509 0.09907 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.22478 0.10704 moveto
0.21546 0.11331 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23583 0.09846 moveto
0.23664 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23583 0.09846 moveto
0.23509 0.09907 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76491 0.09891 moveto
0.76305 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78454 0.11283 moveto
0.76851 0.10132 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76491 0.09891 moveto
0.76851 0.10132 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78454 0.11283 moveto
0.79047 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82378 0.1043 moveto
0.81621 0.09772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82378 0.1043 moveto
0.83783 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1914 0.13253 moveto
0.19584 0.12894 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1914 0.13253 moveto
0.18449 0.13697 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.20224 0.12375 moveto
0.20868 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.20224 0.12375 moveto
0.19584 0.12894 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80416 0.12815 moveto
0.79047 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80416 0.12815 moveto
0.81453 0.13697 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84341 0.12266 moveto
0.83783 0.11735 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85732 0.13697 moveto
0.84341 0.12266 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1708 0.15118 moveto
0.17622 0.14596 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1708 0.15118 moveto
0.16321 0.15659 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.18082 0.14158 moveto
0.18449 0.13697 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.18082 0.14158 moveto
0.17622 0.14596 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82378 0.14506 moveto
0.81453 0.13697 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82378 0.14506 moveto
0.83584 0.15659 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85732 0.13697 moveto
0.86303 0.14295 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87496 0.15659 moveto
0.86303 0.14295 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.15126 0.17089 moveto
0.15659 0.16498 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.15126 0.17089 moveto
0.14424 0.17622 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.16063 0.16063 moveto
0.16321 0.15659 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.16063 0.16063 moveto
0.15659 0.16498 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84341 0.16396 moveto
0.83584 0.15659 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85475 0.17622 moveto
0.84341 0.16396 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87496 0.15659 moveto
0.88265 0.16548 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89107 0.17622 moveto
0.88265 0.16548 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13277 0.19164 moveto
0.13697 0.18649 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13277 0.19164 moveto
0.12724 0.19584 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.14172 0.18097 moveto
0.14424 0.17622 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.14172 0.18097 moveto
0.13697 0.18649 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85475 0.17622 moveto
0.86303 0.18525 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87167 0.19584 moveto
0.86303 0.18525 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89107 0.17622 moveto
0.90228 0.19055 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90598 0.19584 moveto
0.90228 0.19055 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.11518 0.2133 moveto
0.11735 0.21054 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.11518 0.2133 moveto
0.1121 0.21546 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.12412 0.20262 moveto
0.12724 0.19584 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.12412 0.20262 moveto
0.11735 0.21054 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87167 0.19584 moveto
0.88265 0.20933 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.88705 0.21546 moveto
0.88265 0.20933 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90598 0.19584 moveto
0.9148 0.20836 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.91953 0.21546 moveto
0.9148 0.20836 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10777 0.22551 moveto
0.1121 0.21546 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10777 0.22551 moveto
0.09866 0.23509 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.88705 0.21546 moveto
0.89843 0.23124 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90105 0.23509 moveto
0.89843 0.23124 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.91953 0.21546 moveto
0.9219 0.21899 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93141 0.23509 moveto
0.9219 0.21899 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09239 0.24937 moveto
0.09772 0.23775 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09239 0.24937 moveto
0.08559 0.25471 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09859 0.23595 moveto
0.09866 0.23509 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09859 0.23595 moveto
0.09772 0.23775 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90105 0.23509 moveto
0.90228 0.23687 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.91283 0.25471 moveto
0.90228 0.23687 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93141 0.23509 moveto
0.94152 0.25198 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94295 0.25471 moveto
0.94152 0.25198 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07716 0.2734 moveto
0.0781 0.27185 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07716 0.2734 moveto
0.07459 0.27433 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08517 0.26178 moveto
0.08559 0.25471 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08517 0.26178 moveto
0.0781 0.27185 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.91283 0.25471 moveto
0.9219 0.26981 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92422 0.27433 moveto
0.9219 0.26981 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94295 0.25471 moveto
0.94458 0.25776 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95263 0.27433 moveto
0.94458 0.25776 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03642 0.29152 moveto
0.03885 0.29011 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01923 0.29047 moveto
0.03642 0.29152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05816 0.29364 moveto
0.05848 0.29341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03885 0.29011 moveto
0.05816 0.29364 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07418 0.29004 moveto
0.07459 0.27433 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07418 0.29004 moveto
0.05848 0.29341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92422 0.27433 moveto
0.92679 0.27922 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93375 0.29396 moveto
0.92679 0.27922 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95263 0.27433 moveto
0.96115 0.2915 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96219 0.29396 moveto
0.96115 0.2915 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05587 0.31097 moveto
0.05848 0.29989 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05721 0.31358 moveto
0.05587 0.31097 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0781 0.30176 moveto
0.05986 0.29534 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05986 0.29534 moveto
0.05848 0.29989 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08592 0.31358 moveto
0.0781 0.30176 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93375 0.29396 moveto
0.94152 0.31004 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94296 0.31358 moveto
0.94152 0.31004 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96219 0.29396 moveto
0.963 0.29581 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96992 0.31358 moveto
0.963 0.29581 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05143 0.32615 moveto
0.05721 0.31358 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05143 0.32615 moveto
0.05003 0.3332 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08592 0.31358 moveto
0.09772 0.32555 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10083 0.3332 moveto
0.09772 0.32555 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94296 0.31358 moveto
0.94399 0.31605 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95024 0.3332 moveto
0.94399 0.31605 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96992 0.31358 moveto
0.97575 0.32818 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97751 0.3332 moveto
0.97575 0.32818 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04724 0.34159 moveto
0.05003 0.3332 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04724 0.34159 moveto
0.04283 0.35283 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10083 0.3332 moveto
0.10209 0.33757 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10537 0.35283 moveto
0.10209 0.33757 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95024 0.3332 moveto
0.95546 0.34714 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95728 0.35283 moveto
0.95546 0.34714 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97751 0.3332 moveto
0.98077 0.34227 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03731 0.3709 moveto
0.03885 0.36519 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03731 0.3709 moveto
0.0365 0.37245 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0424 0.35637 moveto
0.04283 0.35283 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0424 0.35637 moveto
0.03885 0.36519 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10526 0.36036 moveto
0.10537 0.35283 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10526 0.36036 moveto
0.1046 0.37245 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95728 0.35283 moveto
0.96115 0.36458 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96327 0.37245 moveto
0.96115 0.36458 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03448 0.38769 moveto
0.0365 0.37245 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03448 0.38769 moveto
0.03147 0.39207 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10291 0.37764 moveto
0.1046 0.37245 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10291 0.37764 moveto
0.09835 0.39207 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96327 0.37245 moveto
0.96408 0.37538 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96788 0.39207 moveto
0.96408 0.37538 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03147 0.39207 moveto
0.03342 0.40626 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03342 0.40626 moveto
0.02674 0.4117 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08739 0.40136 moveto
0.09772 0.39323 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08739 0.40136 moveto
0.07902 0.4117 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09812 0.39247 moveto
0.09835 0.39207 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09812 0.39247 moveto
0.09772 0.39323 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96788 0.39207 moveto
0.96991 0.40084 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97192 0.4117 moveto
0.96991 0.40084 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03885 0.42223 moveto
0.02674 0.4117 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02554 0.43132 moveto
0.01923 0.42352 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05848 0.42035 moveto
0.04459 0.41743 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04459 0.41743 moveto
0.03885 0.42223 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.06321 0.41643 moveto
0.0781 0.41253 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.06321 0.41643 moveto
0.05848 0.42035 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07849 0.41209 moveto
0.07902 0.4117 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07849 0.41209 moveto
0.0781 0.41253 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97192 0.4117 moveto
0.9744 0.42495 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9753 0.43132 moveto
0.9744 0.42495 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02117 0.43326 moveto
0.02554 0.43132 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02212 0.45094 moveto
0.02117 0.43326 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9753 0.43132 moveto
0.97762 0.4478 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97793 0.45094 moveto
0.97762 0.4478 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02084 0.45255 moveto
0.02212 0.45094 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02084 0.45255 moveto
0.02026 0.47057 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97793 0.45094 moveto
0.97968 0.46947 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97974 0.47057 moveto
0.97968 0.46947 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01992 0.47125 moveto
0.02026 0.47057 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01992 0.47125 moveto
0.01934 0.49019 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97974 0.47057 moveto
0.98065 0.49007 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.98065 0.49019 moveto
0.98065 0.49007 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01932 0.49027 moveto
0.01934 0.49019 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01934 0.50981 moveto
0.01932 0.49027 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.98065 0.49019 moveto
0.98066 0.5097 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.98066 0.5097 moveto
0.98065 0.50981 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.01932 0.50991 moveto
0.01934 0.50981 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02024 0.52943 moveto
0.01932 0.50991 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9798 0.52846 moveto
0.98065 0.50981 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9798 0.52846 moveto
0.97973 0.52943 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02014 0.53035 moveto
0.02024 0.52943 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.022 0.54906 moveto
0.02014 0.53035 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97819 0.54648 moveto
0.97973 0.52943 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97819 0.54648 moveto
0.97792 0.54906 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02197 0.55179 moveto
0.022 0.54906 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0246 0.56868 moveto
0.02197 0.55179 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97594 0.56385 moveto
0.97792 0.54906 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97594 0.56385 moveto
0.97527 0.56868 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0246 0.56868 moveto
0.025 0.57445 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02797 0.5883 moveto
0.025 0.57445 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97317 0.58071 moveto
0.97527 0.56868 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97317 0.58071 moveto
0.97187 0.5883 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.02797 0.5883 moveto
0.02947 0.59855 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03203 0.60793 moveto
0.02947 0.59855 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96999 0.59715 moveto
0.97187 0.5883 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96999 0.59715 moveto
0.96782 0.60793 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.03203 0.60793 moveto
0.03564 0.62433 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0367 0.62755 moveto
0.03564 0.62433 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96649 0.61327 moveto
0.96782 0.60793 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96649 0.61327 moveto
0.96324 0.62755 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0367 0.62755 moveto
0.03885 0.63506 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04264 0.64717 moveto
0.03885 0.63506 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95816 0.64418 moveto
0.96115 0.63567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95816 0.64418 moveto
0.95723 0.64717 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96278 0.62918 moveto
0.96324 0.62755 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96278 0.62918 moveto
0.96115 0.63567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04264 0.64717 moveto
0.0442 0.65252 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04966 0.6668 moveto
0.0442 0.65252 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95289 0.65854 moveto
0.95723 0.64717 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95289 0.65854 moveto
0.95015 0.6668 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.04966 0.6668 moveto
0.05585 0.6838 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05702 0.68642 moveto
0.05585 0.6838 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94765 0.67292 moveto
0.95015 0.6668 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94765 0.67292 moveto
0.94294 0.68642 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.05702 0.68642 moveto
0.05848 0.68986 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.06619 0.70604 moveto
0.05848 0.68986 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93604 0.70056 moveto
0.94152 0.69012 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93604 0.70056 moveto
0.93363 0.70604 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94251 0.68741 moveto
0.94294 0.68642 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94251 0.68741 moveto
0.94152 0.69012 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97782 0.7031 moveto
0.98077 0.69505 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97782 0.7031 moveto
0.97691 0.70604 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.06619 0.70604 moveto
0.07312 0.72069 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07577 0.72567 moveto
0.07312 0.72069 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92951 0.71366 moveto
0.93363 0.70604 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92951 0.71366 moveto
0.92417 0.72567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97249 0.71739 moveto
0.97691 0.70604 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.97249 0.71739 moveto
0.96978 0.72567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.07577 0.72567 moveto
0.0781 0.73021 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08723 0.74529 moveto
0.0781 0.73021 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9159 0.7393 moveto
0.9219 0.73037 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9159 0.7393 moveto
0.91268 0.74529 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92336 0.72713 moveto
0.92417 0.72567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92336 0.72713 moveto
0.9219 0.73037 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96727 0.73179 moveto
0.96978 0.72567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96727 0.73179 moveto
0.96267 0.74529 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08723 0.74529 moveto
0.09772 0.7632 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09899 0.76491 moveto
0.09772 0.7632 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29375 0.7647 moveto
0.29396 0.76469 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29375 0.7647 moveto
0.29298 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31016 0.76149 moveto
0.31358 0.76142 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31016 0.76149 moveto
0.29396 0.76469 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3332 0.7601 moveto
0.32815 0.75986 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.32815 0.75986 moveto
0.31358 0.76142 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35283 0.76071 moveto
0.34799 0.76008 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.34799 0.76008 moveto
0.3332 0.7601 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37245 0.76324 moveto
0.37028 0.76275 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35283 0.76071 moveto
0.37028 0.76275 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37245 0.76324 moveto
0.37923 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90151 0.76414 moveto
0.90228 0.76321 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90151 0.76414 moveto
0.90101 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9085 0.75152 moveto
0.91268 0.74529 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9085 0.75152 moveto
0.90228 0.76321 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95605 0.75982 moveto
0.96115 0.74936 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.95605 0.75982 moveto
0.95403 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96221 0.74635 moveto
0.96267 0.74529 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.96221 0.74635 moveto
0.96115 0.74936 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.09899 0.76491 moveto
0.10202 0.76921 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1132 0.78454 moveto
0.10202 0.76921 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.24895 0.77878 moveto
0.25471 0.77713 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.24895 0.77878 moveto
0.23827 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.26281 0.77301 moveto
0.27433 0.76992 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.26281 0.77301 moveto
0.25471 0.77713 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27779 0.76837 moveto
0.29298 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27779 0.76837 moveto
0.27433 0.76992 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.39207 0.76775 moveto
0.37923 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4117 0.77431 moveto
0.39595 0.7688 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.39207 0.76775 moveto
0.39595 0.7688 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.43132 0.78292 moveto
0.42815 0.78137 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4117 0.77431 moveto
0.42815 0.78137 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.43132 0.78292 moveto
0.43403 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89281 0.77507 moveto
0.90101 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89281 0.77507 moveto
0.88692 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94985 0.77324 moveto
0.95403 0.76491 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94985 0.77324 moveto
0.94526 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1132 0.78454 moveto
0.11735 0.79127 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.12914 0.80416 moveto
0.11735 0.79127 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21102 0.79972 moveto
0.21546 0.79796 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21102 0.79972 moveto
0.20459 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.22298 0.79206 moveto
0.23509 0.78638 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.22298 0.79206 moveto
0.21546 0.79796 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23612 0.78557 moveto
0.23827 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23612 0.78557 moveto
0.23509 0.78638 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45094 0.79411 moveto
0.43403 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45094 0.79411 moveto
0.46528 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87614 0.79765 moveto
0.88265 0.79089 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87614 0.79765 moveto
0.87146 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.88504 0.78693 moveto
0.88692 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.88504 0.78693 moveto
0.88265 0.79089 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93741 0.80005 moveto
0.94152 0.79296 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93741 0.80005 moveto
0.93552 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94399 0.787 moveto
0.94526 0.78454 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.94399 0.787 moveto
0.94152 0.79296 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.12914 0.80416 moveto
0.13697 0.81626 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13697 0.81626 moveto
0.14778 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.18814 0.81608 moveto
0.19584 0.81217 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.18814 0.81608 moveto
0.17898 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.19952 0.80784 moveto
0.20459 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.19952 0.80784 moveto
0.19584 0.81217 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47057 0.80783 moveto
0.46528 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47057 0.80783 moveto
0.48913 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85836 0.81911 moveto
0.86303 0.81501 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.85836 0.81911 moveto
0.85451 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.86743 0.80856 moveto
0.87146 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.86743 0.80856 moveto
0.86303 0.81501 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93048 0.81274 moveto
0.93552 0.80416 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.93048 0.81274 moveto
0.92537 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.14778 0.82378 moveto
0.15659 0.84199 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1672 0.83439 moveto
0.17622 0.83032 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1672 0.83439 moveto
0.15659 0.84199 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.17792 0.82549 moveto
0.17898 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.17792 0.82549 moveto
0.17622 0.83032 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.49019 0.82472 moveto
0.48913 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.50752 0.84341 moveto
0.49019 0.82472 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83934 0.83934 moveto
0.84341 0.83629 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83934 0.83934 moveto
0.83558 0.84341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84882 0.82919 moveto
0.85451 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84882 0.82919 moveto
0.84341 0.83629 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9168 0.83831 moveto
0.9219 0.83061 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.9168 0.83831 moveto
0.91419 0.84341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92407 0.82596 moveto
0.92537 0.82378 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.92407 0.82596 moveto
0.9219 0.83061 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.14801 0.85444 moveto
0.15659 0.84414 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.14801 0.85444 moveto
0.14406 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.17622 0.85098 moveto
0.15766 0.84448 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.15659 0.84414 moveto
0.15766 0.84448 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.18293 0.86303 moveto
0.17622 0.85098 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.50752 0.84341 moveto
0.50981 0.84607 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.52228 0.86303 moveto
0.50981 0.84607 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.81905 0.85829 moveto
0.82378 0.8552 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.81905 0.85829 moveto
0.81421 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82916 0.84878 moveto
0.83558 0.84341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82916 0.84878 moveto
0.82378 0.8552 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90944 0.85057 moveto
0.91419 0.84341 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90944 0.85057 moveto
0.90307 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13058 0.87626 moveto
0.13697 0.86721 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13058 0.87626 moveto
0.1282 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13929 0.86535 moveto
0.14406 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.13929 0.86535 moveto
0.13697 0.86721 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.19584 0.87026 moveto
0.18293 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.20803 0.88265 moveto
0.19584 0.87026 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.52228 0.86303 moveto
0.52943 0.87376 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.53477 0.88265 moveto
0.52943 0.87376 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.79749 0.87599 moveto
0.80416 0.87212 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.79749 0.87599 moveto
0.79017 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80847 0.86734 moveto
0.81421 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.80847 0.86734 moveto
0.80416 0.87212 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89459 0.87496 moveto
0.90228 0.86444 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.89459 0.87496 moveto
0.89032 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90275 0.86351 moveto
0.90307 0.86303 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.90275 0.86351 moveto
0.90228 0.86444 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.11514 0.90007 moveto
0.11735 0.89571 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.11514 0.90007 moveto
0.11464 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1225 0.88781 moveto
0.1282 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.1225 0.88781 moveto
0.11735 0.89571 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21546 0.88648 moveto
0.20803 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23509 0.90087 moveto
0.22988 0.89707 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.21546 0.88648 moveto
0.22988 0.89707 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.23509 0.90087 moveto
0.23659 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.53477 0.88265 moveto
0.5413 0.89452 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54497 0.90228 moveto
0.5413 0.89452 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76409 0.90146 moveto
0.76491 0.90115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.76409 0.90146 moveto
0.76288 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.7748 0.89254 moveto
0.78454 0.88737 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.7748 0.89254 moveto
0.76491 0.90115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78684 0.88495 moveto
0.79017 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.78684 0.88495 moveto
0.78454 0.88737 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8795 0.89913 moveto
0.88265 0.89518 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8795 0.89913 moveto
0.87763 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8871 0.8871 moveto
0.89032 0.88265 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8871 0.8871 moveto
0.88265 0.89518 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10774 0.91229 moveto
0.11464 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10774 0.91229 moveto
0.10429 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.25471 0.91233 moveto
0.23659 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.25471 0.91233 moveto
0.26924 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54497 0.90228 moveto
0.54906 0.91231 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.55317 0.9219 moveto
0.54906 0.91231 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.73892 0.91553 moveto
0.74529 0.91327 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.73892 0.91553 moveto
0.72966 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.7512 0.90818 moveto
0.76288 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.7512 0.90818 moveto
0.74529 0.91327 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87121 0.91046 moveto
0.87763 0.90228 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.87121 0.91046 moveto
0.86451 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0955 0.93929 moveto
0.09772 0.93368 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.0955 0.93929 moveto
0.09519 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10135 0.92553 moveto
0.10429 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.10135 0.92553 moveto
0.09772 0.93368 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27433 0.92408 moveto
0.26924 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29396 0.93345 moveto
0.27852 0.92608 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.27433 0.92408 moveto
0.27852 0.92608 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.29396 0.93345 moveto
0.30968 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.55317 0.9219 moveto
0.55671 0.92956 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.55953 0.94152 moveto
0.55671 0.92956 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70001 0.93549 moveto
0.70604 0.93417 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.70001 0.93549 moveto
0.68942 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.71313 0.92898 moveto
0.72567 0.92441 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.71313 0.92898 moveto
0.70604 0.93417 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.727 0.92323 moveto
0.72966 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.727 0.92323 moveto
0.72567 0.92441 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8551 0.93359 moveto
0.86303 0.92417 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.8551 0.93359 moveto
0.85021 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.86386 0.92273 moveto
0.86451 0.9219 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.86386 0.92273 moveto
0.86303 0.92417 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08993 0.95335 moveto
0.09519 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08993 0.95335 moveto
0.08858 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31358 0.94291 moveto
0.30968 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3332 0.95007 moveto
0.31577 0.94371 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.31358 0.94291 moveto
0.31577 0.94371 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35283 0.95718 moveto
0.34664 0.95496 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.3332 0.95007 moveto
0.34664 0.95496 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.35283 0.95718 moveto
0.36423 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.55953 0.94152 moveto
0.56546 0.95793 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.56546 0.95793 moveto
0.56459 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.64717 0.95758 moveto
0.64347 0.95744 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.64347 0.95744 moveto
0.6339 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.65753 0.95188 moveto
0.6668 0.95069 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.65753 0.95188 moveto
0.64717 0.95758 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.67221 0.94694 moveto
0.68642 0.94308 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.67221 0.94694 moveto
0.6668 0.95069 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.68728 0.94238 moveto
0.68942 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.68728 0.94238 moveto
0.68642 0.94308 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83879 0.95653 moveto
0.84341 0.95136 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83879 0.95653 moveto
0.83582 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84713 0.94525 moveto
0.85021 0.94152 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.84713 0.94525 moveto
0.84341 0.95136 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08532 0.96836 moveto
0.08858 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.08532 0.96836 moveto
0.08312 0.98077 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37245 0.96324 moveto
0.36423 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.39207 0.96783 moveto
0.37522 0.96391 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.37245 0.96324 moveto
0.37522 0.96391 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4117 0.97189 moveto
0.40061 0.96969 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.39207 0.96783 moveto
0.40061 0.96969 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.43132 0.97528 moveto
0.42484 0.97429 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.4117 0.97189 moveto
0.42484 0.97429 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45094 0.97792 moveto
0.4478 0.97763 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.43132 0.97528 moveto
0.4478 0.97763 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47057 0.97973 moveto
0.46951 0.97971 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.45094 0.97792 moveto
0.46951 0.97971 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.49008 0.98066 moveto
0.49019 0.98065 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.47057 0.97973 moveto
0.49008 0.98066 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.50971 0.98067 moveto
0.50981 0.98065 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.49019 0.98065 moveto
0.50971 0.98067 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.52868 0.98001 moveto
0.52943 0.97969 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.52868 0.98001 moveto
0.50981 0.98065 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54747 0.97918 moveto
0.54906 0.97756 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54747 0.97918 moveto
0.52943 0.97969 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.56459 0.96115 moveto
0.56868 0.97908 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.54906 0.97756 moveto
0.56648 0.98077 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.5883 0.97281 moveto
0.57321 0.96567 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.57321 0.96567 moveto
0.56868 0.97908 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.60793 0.96841 moveto
0.59442 0.96726 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.59442 0.96726 moveto
0.5883 0.97281 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.61192 0.96514 moveto
0.62755 0.96346 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.61192 0.96514 moveto
0.60793 0.96841 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.6288 0.9624 moveto
0.6339 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.6288 0.9624 moveto
0.62755 0.96346 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82231 0.9793 moveto
0.82378 0.97772 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.82231 0.9793 moveto
0.82133 0.98077 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83021 0.96758 moveto
0.83582 0.96115 lineto
stroke
grestore
gsave
0.65 0.26 0.26 setrgbcolor
0.2 Mabswid
0.83021 0.96758 moveto
0.82378 0.97772 lineto
stroke
grestore
grestore
MathSubEnd
grestore
% End of sub-graphic
% Start of sub-graphic
gsave
0.02381 0.02543 0.97619 1.04275 MathSubStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.568182 0.454545 [
[ 0 0 0 0 ]
[ 1 1.06818 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics
[ ] 0 setdash
gsave
grestore
0 0 moveto
1 0 lineto
1 1.06818 lineto
0 1.06818 lineto
closepath
clip
newpath
gsave
gsave
gsave
0.2 Mabswid
newpath
0.97735 0.65235 0.16834 170 210 arc
stroke
newpath
0.91978 0.81054 0.16834 190 230 arc
stroke
newpath
0.81157 0.9395 0.16834 210 250 arc
stroke
newpath
0.66578 1.02367 0.16834 230 270 arc
stroke
newpath
0.5 1.0529 0.16834 250 290 arc
stroke
newpath
0.33422 1.02367 0.16834 270 310 arc
stroke
newpath
0.18843 0.9395 0.16834 290 330 arc
stroke
newpath
0.08022 0.81054 0.16834 310 350 arc
stroke
newpath
0.02265 0.65235 0.16834 330 370 arc
stroke
newpath
0.02265 0.48401 0.16834 350 390 arc
stroke
newpath
0.08022 0.32582 0.16834 10 50 arc
stroke
newpath
0.18843 0.19687 0.16834 30 70 arc
stroke
newpath
0.33422 0.1127 0.16834 50 90 arc
stroke
newpath
0.5 0.08347 0.16834 70 110 arc
stroke
newpath
0.66578 0.1127 0.16834 90 130 arc
stroke
newpath
0.81157 0.19687 0.16834 110 150 arc
stroke
newpath
0.91978 0.32582 0.16834 130 170 arc
stroke
newpath
0.97735 0.48401 0.16834 150 190 arc
stroke
grestore
grestore
grestore
MathSubEnd
grestore
% End of sub-graphic
grestore
% End of Graphics
MathPictureEnd
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; ]
The Unformatted text for this cell was not generated.
Use options in the Actions Preferences dialog box to 
control when Unformatted text is generated.
;[o]
-Graphics-
:[font = section; inactive; preserveAspect; fontLeading = 10; spaceAbove = 20; fontSize = 20; ]
Final pictures
^*)