<<Tessellate.m

DrawCompletedTriangle[pts_List] :=
    Block[{triangle = Flatten[pts], len = Length[triangle],
       hypcenter, hypmiddles, centerarcs, 
       trianglepict, arcpict, ptpict},
    hypcenter = HypCenterOfPolygon[triangle];
    hypmiddles = Table[HypMiddleOfArc[{triangle[[i]], 
        triangle[[1+Mod[i,len]]]}], {i, 1, len}];
    centerarcs = Map[{#,hypcenter}&, hypmiddles];
    trianglepict = DrawHypPolygons[triangle, 
        DisplayFunction -> Identity];
    arcpict = DrawArcs[centerarcs, 
        DisplayFunction -> Identity, Prolog -> {AbsoluteThickness[0.5]}];
    ptpict = DrawPoints[Prepend[hypmiddles, hypcenter], 
        DisplayFunction -> Identity, Prolog -> {AbsolutePointSize[4]}];
    Show[trianglepict, arcpict, ptpict, 
        DisplayFunction -> $DisplayFunction]]

triangle = {0.8 + 0.2*I, -0.8 + 0.4*I, -0.1 - 0.9*I};

trigraf1 = DrawCompletedTriangle[triangle]

tri1 = TriFromAngles[Pi/2, Pi/6, Pi/36];
tri2 = TriFromAngles[0, Pi/3, Pi/2];
tri2 = RotatePoint[tri2, Pi];
trigraf2 = DrawHypPolygons[{tri1,tri2}]

