/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.Counts;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.packing.UnsignedIntPackedInputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class SuffixArrayReader {
    private FileInputStream inputStream;
    private BWT bwt;

    public SuffixArrayReader(File inputFile, BWT bwt) {
        try {
            this.inputStream = new FileInputStream(inputFile);
            this.bwt = bwt;
        }
        catch (FileNotFoundException ex) {
            throw new ReviewedStingException("Unable to open input file", ex);
        }
    }

    public SuffixArray read() {
        long[] suffixArray;
        int suffixArrayInterval;
        long[] occurrences;
        long inverseSA0;
        UnsignedIntPackedInputStream uintPackedInputStream = new UnsignedIntPackedInputStream(this.inputStream, ByteOrder.LITTLE_ENDIAN);
        try {
            inverseSA0 = uintPackedInputStream.read();
            occurrences = new long[4];
            uintPackedInputStream.read(occurrences);
            suffixArrayInterval = (int)uintPackedInputStream.read();
            suffixArray = new long[(int)((occurrences[occurrences.length - 1] + (long)suffixArrayInterval - 1L) / (long)suffixArrayInterval)];
            uintPackedInputStream.read(suffixArray);
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to read BWT from input stream.", ex);
        }
        return new SuffixArray(inverseSA0, new Counts(occurrences, true), suffixArray, suffixArrayInterval, this.bwt);
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to close input file", ex);
        }
    }
}

