/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BasePackedInputStream<T> {
    private final Class<T> type;
    private final FileInputStream targetInputStream;
    private final FileChannel targetInputChannel;
    private final ByteOrder byteOrder;
    private final int basesPerPackedWord = PackUtils.bitsInType(Integer.class) / PackUtils.BITS_PER_BASE;
    private final int bytesPerInteger = PackUtils.bitsInType(Integer.class) / 8;

    public BasePackedInputStream(Class<T> type, File inputFile, ByteOrder byteOrder) throws FileNotFoundException {
        this(type, new FileInputStream(inputFile), byteOrder);
    }

    public BasePackedInputStream(Class<T> type, FileInputStream inputStream, ByteOrder byteOrder) {
        if (type != Integer.class) {
            throw new ReviewedStingException("Only bases packed into 32-bit words are currently supported by this input stream.  Type specified: " + type.getName());
        }
        this.type = type;
        this.targetInputStream = inputStream;
        this.targetInputChannel = inputStream.getChannel();
        this.byteOrder = byteOrder;
    }

    public void read(byte[] bwt) throws IOException {
        this.read(bwt, 0, bwt.length);
    }

    public void read(byte[] bwt, int offset, int length) throws IOException {
        int bufferWidth = (bwt.length + this.basesPerPackedWord - 1) / this.basesPerPackedWord * this.bytesPerInteger;
        ByteBuffer buffer = ByteBuffer.allocate(bufferWidth).order(this.byteOrder);
        this.targetInputChannel.read(buffer);
        this.targetInputChannel.position(this.targetInputChannel.position() + (long)buffer.remaining());
        buffer.flip();
        int packedWord = 0;
        int i = 0;
        while (i < length) {
            if (i % this.basesPerPackedWord == 0) {
                packedWord = buffer.getInt();
            }
            int position = this.basesPerPackedWord - i % this.basesPerPackedWord - 1;
            bwt[offset + i++] = PackUtils.unpackBase((byte)(packedWord >> position * PackUtils.BITS_PER_BASE & 3));
        }
    }
}

