/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class CommandLineUtils {
    private static final String pointerRegexp = ".+@[0-9a-fA-F]+$";

    public static Map<String, String> getApproximateCommandLineArguments(ParsingEngine parsingEngine, Object ... argumentProviders) {
        return CommandLineUtils.getApproximateCommandLineArguments(parsingEngine, false, argumentProviders);
    }

    public static Map<String, String> getApproximateCommandLineArguments(ParsingEngine parsingEngine, boolean skipObjectPointers, Object ... argumentProviders) {
        LinkedHashMap<String, String> commandLineArguments = new LinkedHashMap<String, String>();
        for (Object argumentProvider : argumentProviders) {
            Map<ArgumentSource, Object> argBindings = parsingEngine.extractArgumentBindings(argumentProvider);
            for (Map.Entry<ArgumentSource, Object> elt : argBindings.entrySet()) {
                String argumentValueString;
                Object argumentValue = elt.getValue();
                String string = argumentValueString = argumentValue != null ? argumentValue.toString() : null;
                if (skipObjectPointers && CommandLineUtils.isObjectPointer(argumentValueString)) continue;
                for (ArgumentDefinition definition : elt.getKey().createArgumentDefinitions()) {
                    String argumentName = definition.fullName;
                    commandLineArguments.put(argumentName, argumentValueString);
                }
            }
        }
        return commandLineArguments;
    }

    public static String createApproximateCommandLineArgumentString(ParsingEngine parsingEngine, Object ... argumentProviders) {
        return CommandLineUtils.createApproximateCommandLineArgumentString(parsingEngine, true, argumentProviders);
    }

    public static String createApproximateCommandLineArgumentString(ParsingEngine parsingEngine, boolean skipObjectPointers, Object ... argumentProviders) {
        Map<String, String> commandLineArgs = CommandLineUtils.getApproximateCommandLineArguments(parsingEngine, skipObjectPointers, argumentProviders);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, String> commandLineArg : commandLineArgs.entrySet()) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(commandLineArg.getKey());
            sb.append("=");
            sb.append(commandLineArg.getValue());
            first = false;
        }
        return sb.toString();
    }

    public static Object getValue(Annotation annotation, String method) {
        try {
            return annotation.getClass().getMethod(method, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Unable to access method " + method + " on annotation " + annotation.getClass(), e);
        }
    }

    private static boolean isObjectPointer(String s) {
        return s != null && s.matches(pointerRegexp);
    }

    public static Logger getStingLogger() {
        return Logger.getLogger("org.broadinstitute.sting");
    }

    public static void configureConsoleLogging() {
        for (Logger logger = CommandLineUtils.getStingLogger(); logger != null; logger = (Logger)logger.getParent()) {
            Enumeration e = logger.getAllAppenders();
            for (Appender appender : Collections.list(e)) {
                if (!(appender instanceof ConsoleAppender)) continue;
                return;
            }
        }
        Logger.getRootLogger().addAppender(new ConsoleAppender(new PatternLayout("%r [%t] %p %c %x - %m%n")));
    }

    public static void setLayout(Logger logger, PatternLayout layout) {
        while (logger != null) {
            Enumeration e = logger.getAllAppenders();
            for (Appender appender : Collections.list(e)) {
                appender.setLayout(layout);
            }
            logger = (Logger)logger.getParent();
        }
    }
}

