/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.samtools.util.BlockGunzipper;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Input;

public class UnzipSingleBlock
extends CommandLineProgram {
    @Input(fullName="block_file", shortName="b", doc="block file over which to test unzipping", required=true)
    private File blockFile;
    @Input(fullName="compressed_block_size", shortName="cbs", doc="size of compressed block", required=true)
    private int compressedBufferSize;

    @Override
    public int execute() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        byte[] compressedBuffer = new byte[(int)this.blockFile.length()];
        byte[] uncompressedBuffer = new byte[65536];
        FileInputStream fis = new FileInputStream(this.blockFile);
        fis.read(compressedBuffer);
        fis.close();
        BlockGunzipper gunzipper = new BlockGunzipper();
        gunzipper.setCheckCrcs(true);
        Method unzipBlock = BlockGunzipper.class.getDeclaredMethod("unzipBlock", byte[].class, byte[].class, Integer.TYPE);
        unzipBlock.setAccessible(true);
        unzipBlock.invoke((Object)gunzipper, uncompressedBuffer, compressedBuffer, this.compressedBufferSize);
        System.out.printf("SUCCESS!%n", new Object[0]);
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int returnCode = 0;
        try {
            UnzipSingleBlock instance = new UnzipSingleBlock();
            UnzipSingleBlock.start(instance, argv);
            returnCode = 0;
        }
        catch (Exception ex) {
            returnCode = 1;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            System.exit(returnCode);
        }
    }
}

