/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.rmd;

import java.util.List;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.datasources.rmd.DataStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.EntireStream;
import org.broadinstitute.sting.gatk.datasources.rmd.MappedStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.ResourcePool;
import org.broadinstitute.sting.gatk.refdata.SeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrack;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.FlashBackIterator;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class ReferenceOrderedDataPool
extends ResourcePool<LocationAwareSeekableRODIterator, LocationAwareSeekableRODIterator> {
    private final RMDTriplet fileDescriptor;
    private final RMDTrackBuilder builder;
    private final Object header;
    private final SAMSequenceDictionary sequenceDictionary;
    boolean flashbackData = false;

    public ReferenceOrderedDataPool(RMDTriplet fileDescriptor, RMDTrackBuilder builder, SAMSequenceDictionary sequenceDictionary, GenomeLocParser genomeLocParser, boolean flashbackData) {
        super(sequenceDictionary, genomeLocParser);
        this.fileDescriptor = fileDescriptor;
        this.builder = builder;
        this.flashbackData = flashbackData;
        LocationAwareSeekableRODIterator iterator = this.createNewResource();
        this.addNewResource(iterator);
        this.header = iterator.getHeader();
        this.sequenceDictionary = iterator.getSequenceDictionary();
    }

    public Object getHeader() {
        return this.header;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public LocationAwareSeekableRODIterator createNewResource() {
        if (this.numIterators() > 0) {
            throw new ReviewedStingException("BUG: Tried to create multiple iterators over streaming ROD interface");
        }
        RMDTrack track = this.builder.createInstanceOfTrack(this.fileDescriptor);
        SeekableRODIterator iter = new SeekableRODIterator(track.getHeader(), track.getSequenceDictionary(), this.referenceSequenceDictionary, this.genomeLocParser, track.getIterator());
        return this.flashbackData ? new FlashBackIterator(iter) : iter;
    }

    @Override
    public LocationAwareSeekableRODIterator selectBestExistingResource(DataStreamSegment segment, List<LocationAwareSeekableRODIterator> resources) {
        if (segment instanceof MappedStreamSegment) {
            GenomeLoc position = ((MappedStreamSegment)segment).getLocation();
            for (LocationAwareSeekableRODIterator RODIterator : resources) {
                if (RODIterator.position() == null && RODIterator.hasNext() || RODIterator.position() != null && RODIterator.position().isBefore(position)) {
                    return RODIterator;
                }
                if (RODIterator.position() == null || !(RODIterator instanceof FlashBackIterator) || !((FlashBackIterator)RODIterator).canFlashBackTo(position)) continue;
                ((FlashBackIterator)RODIterator).flashBackTo(position);
                return RODIterator;
            }
            return null;
        }
        if (segment instanceof EntireStream) {
            return null;
        }
        throw new ReviewedStingException("Unable to find a ROD iterator for segments of type " + segment.getClass());
    }

    @Override
    public LocationAwareSeekableRODIterator createIteratorFromResource(DataStreamSegment segment, LocationAwareSeekableRODIterator resource) {
        return resource;
    }

    @Override
    public void closeResource(LocationAwareSeekableRODIterator resource) {
        if (resource instanceof FlashBackIterator) {
            ((FlashBackIterator)resource).close();
        }
    }
}

