/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.downsampling.ReadsDownsampler;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;

public class DownsamplingReadsIterator
implements StingSAMIterator {
    private StingSAMIterator nestedSAMIterator;
    private ReadsDownsampler<SAMRecord> downsampler;
    private Collection<SAMRecord> downsampledReadsCache;
    private Iterator<SAMRecord> downsampledReadsCacheIterator;

    public DownsamplingReadsIterator(StingSAMIterator iter, ReadsDownsampler<SAMRecord> downsampler) {
        this.nestedSAMIterator = iter;
        this.downsampler = downsampler;
        this.fillDownsampledReadsCache();
    }

    @Override
    public boolean hasNext() {
        if (this.downsampledReadsCacheIterator.hasNext()) {
            return true;
        }
        return this.nestedSAMIterator.hasNext() && this.fillDownsampledReadsCache();
    }

    @Override
    public SAMRecord next() {
        if (!this.downsampledReadsCacheIterator.hasNext() && !this.fillDownsampledReadsCache()) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        return this.downsampledReadsCacheIterator.next();
    }

    private boolean fillDownsampledReadsCache() {
        while (this.nestedSAMIterator.hasNext() && !this.downsampler.hasDownsampledItems()) {
            this.downsampler.submit((SAMRecord)this.nestedSAMIterator.next());
        }
        if (!this.nestedSAMIterator.hasNext()) {
            this.downsampler.signalEndOfInput();
        }
        this.downsampledReadsCache = this.downsampler.consumeDownsampledItems();
        this.downsampledReadsCacheIterator = this.downsampledReadsCache.iterator();
        return this.downsampledReadsCacheIterator.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.nestedSAMIterator.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

