/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class BaseQualityRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("BaseQRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("BaseQRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref base qualities"));
    }

    @Override
    protected void fillQualsFromPileup(byte ref, List<Byte> alts, ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
        for (PileupElement p : pileup) {
            if (!BaseQualityRankSumTest.isUsableBase(p)) continue;
            if (p.getBase() == ref) {
                refQuals.add(Double.valueOf(p.getQual()));
                continue;
            }
            if (!alts.contains(p.getBase())) continue;
            altQuals.add(Double.valueOf(p.getQual()));
        }
    }

    @Override
    protected void fillQualsFromPileup(Allele ref, List<Allele> alts, int refLoc, Map<Allele, List<GATKSAMRecord>> stratifiedContext, List<Double> refQuals, List<Double> altQuals) {
    }

    @Override
    protected void fillIndelQualsFromPileup(ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
        HashMap<PileupElement, LinkedHashMap<Allele, Double>> indelLikelihoodMap = IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap();
        for (PileupElement p : pileup) {
            if (!indelLikelihoodMap.containsKey(p)) continue;
            LinkedHashMap<Allele, Double> el = indelLikelihoodMap.get(p);
            double refLikelihood = 0.0;
            double altLikelihood = Double.NEGATIVE_INFINITY;
            for (Map.Entry<Allele, Double> entry : el.entrySet()) {
                if (entry.getKey().isReference()) {
                    refLikelihood = entry.getValue();
                    continue;
                }
                double like = entry.getValue();
                if (!(like >= altLikelihood)) continue;
                altLikelihood = like;
            }
            if (refLikelihood > altLikelihood + 0.1) {
                refQuals.add(-10.0 * refLikelihood);
                continue;
            }
            if (!(altLikelihood > refLikelihood + 0.1)) continue;
            altQuals.add(-10.0 * altLikelihood);
        }
    }
}

