/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFStandardHeaderLines;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class DepthPerAlleleBySample
extends GenotypeAnnotation
implements StandardAnnotation {
    @Override
    public void annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g, GenotypeBuilder gb) {
        if (g == null || !g.isCalled()) {
            return;
        }
        if (vc.isSNP()) {
            this.annotateSNP(stratifiedContext, vc, gb);
        } else if (vc.isIndel()) {
            this.annotateIndel(stratifiedContext, ref.getBase(), vc, gb);
        }
    }

    private void annotateSNP(AlignmentContext stratifiedContext, VariantContext vc, GenotypeBuilder gb) {
        HashMap<Byte, Integer> alleleCounts = new HashMap<Byte, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele.getBases()[0], 0);
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        for (PileupElement p : pileup) {
            if (!alleleCounts.containsKey(p.getBase())) continue;
            alleleCounts.put(p.getBase(), (Integer)alleleCounts.get(p.getBase()) + 1);
        }
        int[] counts = new int[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(vc.getReference().getBases()[0]);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(vc.getAlternateAllele(i).getBases()[0]);
        }
        gb.AD(counts);
    }

    private void annotateIndel(AlignmentContext stratifiedContext, byte refBase, VariantContext vc, GenotypeBuilder gb) {
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        if (pileup == null) {
            return;
        }
        HashMap<Allele, Integer> alleleCounts = new HashMap<Allele, Integer>();
        Allele refAllele = vc.getReference();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele, 0);
        }
        for (PileupElement p : pileup) {
            if (p.isBeforeInsertion()) {
                Allele insertion;
                String eventBases = p.getEventBases();
                if (eventBases == null || !alleleCounts.containsKey(insertion = Allele.create((char)refBase + eventBases, false))) continue;
                alleleCounts.put(insertion, (Integer)alleleCounts.get(insertion) + 1);
                continue;
            }
            if (p.isBeforeDeletionStart()) {
                Allele deletion;
                if (p.getEventLength() != refAllele.length() - 1 || !alleleCounts.containsKey(deletion = Allele.create(refBase))) continue;
                alleleCounts.put(deletion, (Integer)alleleCounts.get(deletion) + 1);
                continue;
            }
            if (p.getRead().getAlignmentEnd() <= vc.getStart()) continue;
            alleleCounts.put(refAllele, (Integer)alleleCounts.get(refAllele) + 1);
        }
        int[] counts = new int[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(refAllele);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(vc.getAlternateAllele(i));
        }
        gb.AD(counts);
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AD");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(VCFStandardHeaderLines.getFormatLine(this.getKeyNames().get(0)));
    }
}

