/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.sting.gatk.walkers.coverage.DoCOutputType;

class CoveragePartitioner {
    private Collection<DoCOutputType.Partition> types;
    private Map<DoCOutputType.Partition, DepthOfCoverageStats> coverageProfiles = new HashMap<DoCOutputType.Partition, DepthOfCoverageStats>();
    private Map<DoCOutputType.Partition, List<String>> identifiersByType = new HashMap<DoCOutputType.Partition, List<String>>();
    private Set<String> allIdentifiers;

    public CoveragePartitioner(Collection<DoCOutputType.Partition> typesToUse, int start, int stop, int nBins) {
        this.types = typesToUse;
        for (DoCOutputType.Partition type : this.types) {
            this.coverageProfiles.put(type, new DepthOfCoverageStats(DepthOfCoverageStats.calculateBinEndpoints(start, stop, nBins)));
            this.identifiersByType.put(type, new ArrayList());
        }
        this.allIdentifiers = new HashSet<String>();
    }

    public void merge(CoveragePartitioner otherAggregator) {
        for (DoCOutputType.Partition type : this.types) {
            this.coverageProfiles.get((Object)type).merge(otherAggregator.coverageProfiles.get((Object)type));
        }
    }

    public DepthOfCoverageStats getCoverageByAggregationType(DoCOutputType.Partition t) {
        return this.coverageProfiles.get((Object)t);
    }

    public void addIdentifiers(DoCOutputType.Partition t, Set<String> ids) {
        for (String s : ids) {
            this.coverageProfiles.get((Object)t).addSample(s);
            this.identifiersByType.get((Object)t).add(s);
            this.allIdentifiers.add(s);
        }
        Collections.sort(this.identifiersByType.get((Object)t));
    }

    public void initialize(boolean useDels, boolean omitLocusTable) {
        for (DoCOutputType.Partition t : this.types) {
            if (useDels) {
                this.coverageProfiles.get((Object)t).initializeDeletions();
            }
            if (omitLocusTable) continue;
            this.coverageProfiles.get((Object)t).initializeLocusCounts();
        }
    }

    public void update(Map<DoCOutputType.Partition, Map<String, int[]>> countsByIdentifierByType) {
        for (DoCOutputType.Partition t : this.types) {
            this.coverageProfiles.get((Object)t).update(countsByIdentifierByType.get((Object)t));
        }
    }

    public Set<String> getAllIdentifiers() {
        return this.allIdentifiers;
    }

    public Map<DoCOutputType.Partition, List<String>> getIdentifiersByType() {
        return this.identifiersByType;
    }
}

