/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class AlleleFrequencyCalculationModel
implements Cloneable {
    protected int N;
    protected int MAX_ALTERNATE_ALLELES_TO_GENOTYPE;
    protected boolean CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS;
    protected Logger logger;
    protected PrintStream verboseWriter;
    protected static final double VALUE_NOT_CALCULATED = Double.NEGATIVE_INFINITY;
    protected static final int HOM_REF_INDEX = 0;

    protected AlleleFrequencyCalculationModel(UnifiedArgumentCollection UAC, int N, Logger logger, PrintStream verboseWriter) {
        this.N = N;
        this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE = UAC.MAX_ALTERNATE_ALLELES;
        this.CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS = UAC.CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS;
        this.logger = logger;
        this.verboseWriter = verboseWriter;
    }

    protected static ArrayList<double[]> getGLs(GenotypesContext GLs) {
        ArrayList<double[]> genotypeLikelihoods = new ArrayList<double[]>(GLs.size());
        genotypeLikelihoods.add(new double[]{0.0, 0.0, 0.0});
        for (Genotype sample : GLs.iterateInSampleNameOrder()) {
            double[] gls;
            if (!sample.hasLikelihoods() || !(MathUtils.sum(gls = sample.getLikelihoods().getAsVector()) < -0.1)) continue;
            genotypeLikelihoods.add(gls);
        }
        return genotypeLikelihoods;
    }

    protected abstract List<Allele> getLog10PNonRef(VariantContext var1, double[] var2, AlleleFrequencyCalculationResult var3);

    protected abstract GenotypesContext subsetAlleles(VariantContext var1, List<Allele> var2, boolean var3, int var4);

    protected static final class ExactACset {
        final ExactACcounts ACcounts;
        final double[] log10Likelihoods;
        int sum = -1;

        public ExactACset(int size, ExactACcounts ACcounts) {
            this.ACcounts = ACcounts;
            this.log10Likelihoods = new double[size];
            Arrays.fill(this.log10Likelihoods, Double.NEGATIVE_INFINITY);
        }

        public int getACsum() {
            if (this.sum == -1) {
                this.sum = 0;
                for (int count : this.ACcounts.getCounts()) {
                    this.sum += count;
                }
            }
            return this.sum;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExactACset && this.ACcounts.equals(((ExactACset)obj).ACcounts);
        }
    }

    protected static final class ExactACcounts {
        protected final int[] counts;
        private int hashcode = -1;

        public ExactACcounts(int[] counts) {
            this.counts = counts;
        }

        public int[] getCounts() {
            return this.counts;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExactACcounts && Arrays.equals(this.counts, ((ExactACcounts)obj).counts);
        }

        public int hashCode() {
            if (this.hashcode == -1) {
                this.hashcode = Arrays.hashCode(this.counts);
            }
            return this.hashcode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.counts[0]);
            for (int i = 1; i < this.counts.length; ++i) {
                sb.append("/");
                sb.append(this.counts[i]);
            }
            return sb.toString();
        }
    }

    protected static final class LikelihoodSum
    implements Comparable<LikelihoodSum> {
        public double sum = 0.0;
        public Allele allele;

        public LikelihoodSum(Allele allele) {
            this.allele = allele;
        }

        @Override
        public int compareTo(LikelihoodSum other) {
            double diff = this.sum - other.sum;
            return diff < 0.0 ? 1 : (diff > 0.0 ? -1 : 0);
        }
    }

    public static enum Model {
        EXACT;

    }
}

