/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class ConsensusAlleleCounter {
    protected static final Logger logger = Logger.getLogger(ConsensusAlleleCounter.class);
    private final int minIndelCountForGenotyping;
    private final boolean doMultiAllelicCalls;
    private final double minFractionInOneSample;
    private final GenomeLocParser locParser;

    public ConsensusAlleleCounter(GenomeLocParser locParser, boolean doMultiAllelicCalls, int minIndelCountForGenotyping, double minFractionInOneSample) {
        this.minIndelCountForGenotyping = minIndelCountForGenotyping;
        this.doMultiAllelicCalls = doMultiAllelicCalls;
        this.minFractionInOneSample = minFractionInOneSample;
        this.locParser = locParser;
    }

    public List<Allele> computeConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType) {
        Map<String, Integer> consensusIndelStrings = this.countConsensusAlleles(ref, contexts, contextType);
        return this.consensusCountsToAlleles(ref, consensusIndelStrings);
    }

    private Map<String, Integer> countConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType) {
        ReadBackedPileup indelPileup;
        AlignmentContext context;
        GenomeLoc loc = ref.getLocus();
        HashMap<String, Integer> consensusIndelStrings = new HashMap<String, Integer>();
        int insCount = 0;
        int delCount = 0;
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getBasePileup();
            insCount += indelPileup.getNumberOfInsertionsAfterThisElement();
            delCount += indelPileup.getNumberOfDeletionsAfterThisElement();
        }
        if (insCount < this.minIndelCountForGenotyping && delCount < this.minIndelCountForGenotyping) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getBasePileup();
            int nIndelReads = indelPileup.getNumberOfInsertionsAfterThisElement() + indelPileup.getNumberOfDeletionsAfterThisElement();
            int nReadsOverall = indelPileup.getNumberOfElements();
            if (nIndelReads == 0 || (double)nIndelReads / (1.0 * (double)nReadsOverall) < this.minFractionInOneSample) continue;
            for (PileupElement p : indelPileup) {
                GATKSAMRecord read = ReadClipper.hardClipAdaptorSequence(p.getRead());
                if (read == null || ReadUtils.is454Read(read)) continue;
                String indelString = p.getEventBases();
                if (p.isBeforeInsertion()) {
                    int cnt;
                    int k;
                    if (indelString == null) continue;
                    boolean foundKey = false;
                    ArrayList<Pair<String, Integer>> cList = new ArrayList<Pair<String, Integer>>();
                    for (Map.Entry<String, Integer> entry : consensusIndelStrings.entrySet()) {
                        cList.add(new Pair<String, Integer>(entry.getKey(), entry.getValue()));
                    }
                    if (read.getAlignmentEnd() == loc.getStart()) {
                        for (k = 0; k < cList.size(); ++k) {
                            String string = (String)((Pair)cList.get(k)).getFirst();
                            cnt = (Integer)((Pair)cList.get(k)).getSecond();
                            if (string.startsWith(indelString)) {
                                cList.set(k, new Pair<String, Integer>(string, cnt + 1));
                                foundKey = true;
                                continue;
                            }
                            if (!indelString.startsWith(string)) continue;
                            foundKey = true;
                            cList.set(k, new Pair<String, Integer>(indelString, cnt + 1));
                        }
                        if (!foundKey) {
                            cList.add(new Pair<String, Integer>(indelString, 1));
                        }
                    } else if (read.getAlignmentStart() == loc.getStart() + 1) {
                        for (k = 0; k < cList.size(); ++k) {
                            String string = (String)((Pair)cList.get(k)).getFirst();
                            cnt = (Integer)((Pair)cList.get(k)).getSecond();
                            if (string.endsWith(indelString)) {
                                cList.set(k, new Pair<String, Integer>(string, cnt + 1));
                                foundKey = true;
                                continue;
                            }
                            if (!indelString.endsWith(string)) continue;
                            foundKey = true;
                            cList.set(k, new Pair<String, Integer>(indelString, cnt + 1));
                        }
                        if (!foundKey) {
                            cList.add(new Pair<String, Integer>(indelString, 1));
                        }
                    } else {
                        int cnt2 = consensusIndelStrings.containsKey(indelString) ? consensusIndelStrings.get(indelString) : 0;
                        cList.add(new Pair<String, Integer>(indelString, cnt2 + 1));
                    }
                    consensusIndelStrings.clear();
                    for (Pair pair : cList) {
                        consensusIndelStrings.put((String)pair.getFirst(), (Integer)pair.getSecond());
                    }
                    continue;
                }
                if (!p.isBeforeDeletedBase()) continue;
                indelString = String.format("D%d", p.getEventLength());
                int cnt = consensusIndelStrings.containsKey(indelString) ? consensusIndelStrings.get(indelString) : 0;
                consensusIndelStrings.put(indelString, cnt + 1);
            }
        }
        return consensusIndelStrings;
    }

    private List<Allele> consensusCountsToAlleles(ReferenceContext ref, Map<String, Integer> consensusIndelStrings) {
        GenomeLoc loc = ref.getLocus();
        ArrayList<VariantContext> vcs = new ArrayList<VariantContext>();
        int maxAlleleCnt = 0;
        for (Map.Entry<String, Integer> elt : consensusIndelStrings.entrySet()) {
            Allele altAllele;
            Allele refAllele;
            String s = elt.getKey();
            int curCnt = elt.getValue();
            int stop = 0;
            if (curCnt < this.minIndelCountForGenotyping) continue;
            if (s.startsWith("D")) {
                int dLen = Integer.valueOf(s.substring(1));
                int startIdxInReference = 1 + loc.getStart() - ref.getWindow().getStart();
                stop = loc.getStart() + dLen;
                byte[] refBases = Arrays.copyOfRange(ref.getBases(), startIdxInReference - 1, startIdxInReference + dLen);
                if (!Allele.acceptableAlleleBases(refBases, false)) continue;
                refAllele = Allele.create(refBases, true);
                altAllele = Allele.create(ref.getBase(), false);
            } else {
                String insertionBases = (char)ref.getBase() + s;
                if (!Allele.acceptableAlleleBases(insertionBases, false)) continue;
                refAllele = Allele.create(ref.getBase(), true);
                altAllele = Allele.create(insertionBases, false);
                stop = loc.getStart();
            }
            VariantContextBuilder builder = new VariantContextBuilder().source("");
            builder.loc(loc.getContig(), loc.getStart(), stop);
            builder.alleles((Collection<Allele>)Arrays.asList(refAllele, altAllele));
            builder.noGenotypes();
            if (this.doMultiAllelicCalls) {
                vcs.add(builder.make());
                if (vcs.size() < 50) continue;
                break;
            }
            if (curCnt <= maxAlleleCnt) continue;
            maxAlleleCnt = curCnt;
            vcs.clear();
            vcs.add(builder.make());
        }
        if (vcs.isEmpty()) {
            return Collections.emptyList();
        }
        VariantContext mergedVC = VariantContextUtils.simpleMerge(this.locParser, vcs, null, VariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED, VariantContextUtils.GenotypeMergeType.UNSORTED, false, false, null, false, false);
        return mergedVC.getAlleles();
    }
}

