/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.BadCigarFilter;
import org.broadinstitute.sting.gatk.filters.BadMateFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.filters.Platform454Filter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@DocumentedGATKFeature(groupName="BAM Processing and Analysis Tools", extraDocs={CommandLineGATK.class})
@ReadFilters(value={MappingQualityZeroFilter.class, MappingQualityUnavailableFilter.class, BadMateFilter.class, Platform454Filter.class, BadCigarFilter.class})
@Reference(window=@Window(start=-1, stop=50))
@Allows(value={DataSource.READS, DataSource.REFERENCE})
@By(value=DataSource.REFERENCE)
@BAQMode(ApplicationTime=BAQ.ApplicationTime.FORBIDDEN)
public class RealignerTargetCreator
extends RodWalker<Event, EventPair>
implements TreeReducible<EventPair> {
    @Output
    protected PrintStream out;
    @Input(fullName="known", shortName="known", doc="Input VCF file with known indels", required=false)
    public List<RodBinding<VariantContext>> known = Collections.emptyList();
    @Argument(fullName="windowSize", shortName="window", doc="window size for calculating entropy or SNP clusters", required=false)
    protected int windowSize = 10;
    @Argument(fullName="mismatchFraction", shortName="mismatch", doc="fraction of base qualities needing to mismatch for a position to have high entropy", required=false)
    protected double mismatchThreshold = 0.0;
    @Argument(fullName="minReadsAtLocus", shortName="minReads", doc="minimum reads at a locus to enable using the entropy calculation", required=false)
    protected int minReadsAtLocus = 4;
    @Argument(fullName="maxIntervalSize", shortName="maxInterval", doc="maximum interval size; any intervals larger than this value will be dropped", required=false)
    protected int maxIntervalSize = 500;
    private boolean lookForMismatchEntropy;

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public void initialize() {
        if (this.windowSize < 2) {
            throw new UserException.BadArgumentValue("windowSize", "Window Size must be an integer greater than 1");
        }
        this.lookForMismatchEntropy = this.mismatchThreshold > 0.0 && this.mismatchThreshold <= 1.0;
    }

    @Override
    public Event map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        boolean hasIndel = false;
        boolean hasInsertion = false;
        boolean hasPointEvent = false;
        int furthestStopPos = -1;
        if (tracker != null) {
            for (VariantContext vc : tracker.getValues(this.known)) {
                switch (vc.getType()) {
                    case INDEL: {
                        hasIndel = true;
                        if (!vc.isSimpleInsertion()) break;
                        hasInsertion = true;
                        break;
                    }
                    case SNP: {
                        hasPointEvent = true;
                        break;
                    }
                    case MIXED: {
                        hasPointEvent = true;
                        hasIndel = true;
                        if (!vc.isSimpleInsertion()) break;
                        hasInsertion = true;
                        break;
                    }
                }
                if (!hasIndel) continue;
                furthestStopPos = vc.getEnd();
            }
        }
        ReadBackedPileup pileup = context.getBasePileup();
        int mismatchQualities = 0;
        int totalQualities = 0;
        byte refBase = ref.getBase();
        for (PileupElement p : pileup) {
            furthestStopPos = Math.max(furthestStopPos, p.getRead().getAlignmentEnd());
            if (p.isDeletion() || p.isBeforeInsertion()) {
                hasIndel = true;
                if (!p.isBeforeInsertion()) continue;
                hasInsertion = true;
                continue;
            }
            if (!this.lookForMismatchEntropy) continue;
            if (p.getBase() != refBase) {
                mismatchQualities += p.getQual();
            }
            totalQualities += p.getQual();
        }
        if (this.lookForMismatchEntropy && pileup.getNumberOfElements() >= this.minReadsAtLocus && (double)mismatchQualities / (double)totalQualities >= this.mismatchThreshold) {
            hasPointEvent = true;
        }
        if (!hasIndel && !hasPointEvent) {
            return null;
        }
        if (furthestStopPos == -1) {
            return null;
        }
        GenomeLoc eventLoc = context.getLocation();
        if (hasInsertion) {
            eventLoc = this.getToolkit().getGenomeLocParser().createGenomeLoc(eventLoc.getContig(), eventLoc.getStart(), eventLoc.getStart() + 1);
        }
        EVENT_TYPE eventType = hasIndel ? (hasPointEvent ? EVENT_TYPE.BOTH : EVENT_TYPE.INDEL_EVENT) : EVENT_TYPE.POINT_EVENT;
        return new Event(eventLoc, furthestStopPos, eventType);
    }

    @Override
    public void onTraversalDone(EventPair sum) {
        if (sum.left != null && sum.left.isReportableEvent()) {
            sum.intervals.add(sum.left.getLoc());
        }
        if (sum.right != null && sum.right.isReportableEvent()) {
            sum.intervals.add(sum.right.getLoc());
        }
        for (GenomeLoc loc : sum.intervals) {
            this.out.println(loc);
        }
    }

    @Override
    public EventPair reduceInit() {
        return new EventPair(null, null);
    }

    @Override
    public EventPair treeReduce(EventPair lhs, EventPair rhs) {
        EventPair result;
        if (lhs.left == null) {
            result = rhs;
        } else if (rhs.left == null) {
            result = lhs;
        } else if (lhs.right == null) {
            if (rhs.right == null) {
                result = RealignerTargetCreator.canBeMerged(lhs.left, rhs.left) ? new EventPair(RealignerTargetCreator.mergeEvents(lhs.left, rhs.left), null, lhs.intervals, rhs.intervals) : new EventPair(lhs.left, rhs.left, lhs.intervals, rhs.intervals);
            } else if (RealignerTargetCreator.canBeMerged(lhs.left, rhs.left)) {
                result = new EventPair(RealignerTargetCreator.mergeEvents(lhs.left, rhs.left), rhs.right, lhs.intervals, rhs.intervals);
            } else {
                if (rhs.left.isReportableEvent()) {
                    rhs.intervals.add(rhs.left.getLoc());
                }
                result = new EventPair(lhs.left, rhs.right, lhs.intervals, rhs.intervals);
            }
        } else if (rhs.right == null) {
            if (RealignerTargetCreator.canBeMerged(lhs.right, rhs.left)) {
                result = new EventPair(lhs.left, RealignerTargetCreator.mergeEvents(lhs.right, rhs.left), lhs.intervals, rhs.intervals);
            } else {
                if (lhs.right.isReportableEvent()) {
                    lhs.intervals.add(lhs.right.getLoc());
                }
                result = new EventPair(lhs.left, rhs.left, lhs.intervals, rhs.intervals);
            }
        } else {
            if (RealignerTargetCreator.canBeMerged(lhs.right, rhs.left)) {
                Event merge = RealignerTargetCreator.mergeEvents(lhs.right, rhs.left);
                if (merge.isReportableEvent()) {
                    lhs.intervals.add(merge.getLoc());
                }
            } else {
                if (lhs.right.isReportableEvent()) {
                    lhs.intervals.add(lhs.right.getLoc());
                }
                if (rhs.left.isReportableEvent()) {
                    rhs.intervals.add(rhs.left.getLoc());
                }
            }
            result = new EventPair(lhs.left, rhs.right, lhs.intervals, rhs.intervals);
        }
        return result;
    }

    @Override
    public EventPair reduce(Event value, EventPair sum) {
        if (value != null) {
            if (sum.left == null) {
                sum.left = value;
            } else if (sum.right == null) {
                if (RealignerTargetCreator.canBeMerged(sum.left, value)) {
                    sum.left = RealignerTargetCreator.mergeEvents(sum.left, value);
                } else {
                    sum.right = value;
                }
            } else if (RealignerTargetCreator.canBeMerged(sum.right, value)) {
                sum.right = RealignerTargetCreator.mergeEvents(sum.right, value);
            } else {
                if (sum.right.isReportableEvent()) {
                    sum.intervals.add(sum.right.getLoc());
                }
                sum.right = value;
            }
        }
        return sum;
    }

    private static boolean canBeMerged(Event left, Event right) {
        return left.loc.getContigIndex() == right.loc.getContigIndex() && left.furthestStopPos >= right.loc.getStart();
    }

    @Requires(value={"left != null", "right != null"})
    private static Event mergeEvents(Event left, Event right) {
        left.merge(right);
        return left;
    }

    class Event {
        public int furthestStopPos;
        private GenomeLoc loc;
        private int eventStartPos;
        private int eventStopPos;
        private EVENT_TYPE type;
        private ArrayList<Integer> pointEvents = new ArrayList();

        public Event(GenomeLoc loc, int furthestStopPos, EVENT_TYPE type) {
            this.loc = loc;
            this.furthestStopPos = furthestStopPos;
            this.type = type;
            if (type == EVENT_TYPE.INDEL_EVENT || type == EVENT_TYPE.BOTH) {
                this.eventStartPos = loc.getStart();
                this.eventStopPos = loc.getStop();
            } else {
                this.eventStartPos = -1;
                this.eventStopPos = -1;
            }
            if (type == EVENT_TYPE.POINT_EVENT || type == EVENT_TYPE.BOTH) {
                this.pointEvents.add(loc.getStart());
            }
        }

        public void merge(Event e) {
            if (e.type == EVENT_TYPE.INDEL_EVENT || e.type == EVENT_TYPE.BOTH) {
                if (this.eventStartPos == -1) {
                    this.eventStartPos = e.eventStartPos;
                }
                this.eventStopPos = e.eventStopPos;
                this.furthestStopPos = e.furthestStopPos;
            }
            if (e.type == EVENT_TYPE.POINT_EVENT || e.type == EVENT_TYPE.BOTH) {
                int newPosition = e.pointEvents.get(0);
                if (this.pointEvents.size() > 0) {
                    int lastPosition = this.pointEvents.get(this.pointEvents.size() - 1);
                    if (newPosition - lastPosition < RealignerTargetCreator.this.windowSize) {
                        this.eventStopPos = Math.max(this.eventStopPos, newPosition);
                        this.furthestStopPos = e.furthestStopPos;
                        this.eventStartPos = this.eventStartPos == -1 ? lastPosition : Math.min(this.eventStartPos, lastPosition);
                    } else if (this.eventStartPos == -1 && e.eventStartPos != -1) {
                        this.eventStartPos = e.eventStartPos;
                        this.eventStopPos = e.eventStopPos;
                        this.furthestStopPos = e.furthestStopPos;
                    }
                }
                this.pointEvents.add(newPosition);
            }
        }

        public boolean isReportableEvent() {
            return RealignerTargetCreator.this.getToolkit().getGenomeLocParser().isValidGenomeLoc(this.loc.getContig(), this.eventStartPos, this.eventStopPos, true) && this.eventStopPos >= 0 && this.eventStopPos - this.eventStartPos < RealignerTargetCreator.this.maxIntervalSize;
        }

        public GenomeLoc getLoc() {
            return RealignerTargetCreator.this.getToolkit().getGenomeLocParser().createGenomeLoc(this.loc.getContig(), this.eventStartPos, this.eventStopPos);
        }
    }

    static class EventPair {
        public Event left;
        public Event right;
        public TreeSet<GenomeLoc> intervals = new TreeSet();

        public EventPair(Event left, Event right) {
            this.left = left;
            this.right = right;
        }

        public EventPair(Event left, Event right, TreeSet<GenomeLoc> set1, TreeSet<GenomeLoc> set2) {
            this.left = left;
            this.right = right;
            this.intervals.addAll(set1);
            this.intervals.addAll(set2);
        }
    }

    private static enum EVENT_TYPE {
        POINT_EVENT,
        INDEL_EVENT,
        BOTH;

    }
}

