/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="Quality Control and Simple Analysis Tools", extraDocs={CommandLineGATK.class})
@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class CountTerminusEvent
extends ReadWalker<Pair<Long, Long>, Pair<Long, Long>> {
    @Override
    public Pair<Long, Long> map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker tracker) {
        List<CigarElement> cigarElements = read.getCigar().getCigarElements();
        CigarElement lastElement = null;
        for (CigarElement element : cigarElements) {
            if (element.getOperator() == CigarOperator.HARD_CLIP) continue;
            lastElement = element;
        }
        if (lastElement == null) {
            throw new UserException.MalformedBAM(read, "read does not have any bases, it's all hard clips");
        }
        long endsInIndel = lastElement.getOperator() == CigarOperator.INSERTION || lastElement.getOperator() == CigarOperator.DELETION ? 1L : 0L;
        long endsInSC = lastElement.getOperator() == CigarOperator.SOFT_CLIP ? 1L : 0L;
        return new Pair<Long, Long>(endsInIndel, endsInSC);
    }

    @Override
    public Pair<Long, Long> reduceInit() {
        return new Pair<Long, Long>(0L, 0L);
    }

    @Override
    public Pair<Long, Long> reduce(Pair<Long, Long> value, Pair<Long, Long> sum) {
        sum.set(sum.getFirst() + value.getFirst(), sum.getSecond() + value.getSecond());
        return sum;
    }

    @Override
    public void onTraversalDone(Pair<Long, Long> result) {
        System.out.println(String.format("\tReads ending in indels : %d\n\tReads ending in soft-clips: %d\n", result.getFirst(), result.getSecond()));
    }
}

