/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.FrequencyModeSelector;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.GenomeEvent;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class KeepAFSpectrumFrequencySelector
extends FrequencyModeSelector {
    private static final boolean DEBUG = true;
    private int NUM_BINS = 20;
    private int[] preSampleSelectionHistogram;
    private int numTotalSites = 0;
    private int[] postSampleSelectionHistogram;
    private int numSampleSelectedSites = 0;
    private ArrayList<GenomeEvent>[] binnedEventArray;

    public KeepAFSpectrumFrequencySelector(int numBins, GenomeLocParser parser) {
        super(parser);
        this.NUM_BINS = numBins;
        this.binnedEventArray = new ArrayList[this.NUM_BINS];
        for (int k = 0; k < this.NUM_BINS; ++k) {
            this.binnedEventArray[k] = new ArrayList();
        }
        this.preSampleSelectionHistogram = new int[this.NUM_BINS];
        this.postSampleSelectionHistogram = new int[this.NUM_BINS];
    }

    @Override
    public void logCurrentSiteData(VariantContext vc, boolean selectedInTargetSamples, boolean IGNORE_GENOTYPES, boolean IGNORE_POLYMORPHIC) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        double[] afArray = null;
        if (vc.hasGenotypes() && !IGNORE_GENOTYPES) {
            VariantContextUtils.calculateChromosomeCounts(vc, attributes, false);
        }
        if (vc.hasAttribute("AF")) {
            String afo = vc.getAttributeAsString("AF", null);
            if (afo.contains(",")) {
                String[] afs = afo.split(",");
                afs[0] = afs[0].substring(1, afs[0].length());
                afs[afs.length - 1] = afs[afs.length - 1].substring(0, afs[afs.length - 1].length() - 1);
                afArray = new double[afs.length];
                for (int k = 0; k < afArray.length; ++k) {
                    afArray[k] = Double.valueOf(afs[k]);
                }
            } else {
                afArray = new double[]{Double.valueOf(afo)};
            }
        }
        if (afArray == null) {
            return;
        }
        double af0 = MathUtils.arrayMax(afArray);
        int binIndex = this.NUM_BINS - 1 - (int)Math.floor((1.0 - af0) * (double)this.NUM_BINS);
        if (binIndex < 0) {
            binIndex = 0;
        }
        int n = binIndex;
        this.preSampleSelectionHistogram[n] = this.preSampleSelectionHistogram[n] + 1;
        ++this.numTotalSites;
        if (!selectedInTargetSamples && !IGNORE_POLYMORPHIC) {
            return;
        }
        int n2 = binIndex;
        this.postSampleSelectionHistogram[n2] = this.postSampleSelectionHistogram[n2] + 1;
        ++this.numSampleSelectedSites;
        GenomeEvent event = new GenomeEvent(this.parser, vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), attributes);
        this.binnedEventArray[binIndex].add(event);
    }

    @Override
    public ArrayList<VariantContext> selectValidationSites(int numValidationSites) {
        int k;
        int[] sitesToChoosePerBin = new int[this.NUM_BINS];
        int totalSites = 0;
        for (k = 0; k < this.NUM_BINS; ++k) {
            int sites;
            sitesToChoosePerBin[k] = sites = (int)Math.round((double)numValidationSites * (double)this.preSampleSelectionHistogram[k] / (double)this.numTotalSites);
            totalSites += sites;
        }
        while (totalSites > numValidationSites) {
            int n = k = GenomeAnalysisEngine.getRandomGenerator().nextInt(this.NUM_BINS);
            sitesToChoosePerBin[n] = sitesToChoosePerBin[n] - 1;
            --totalSites;
        }
        while (totalSites < numValidationSites) {
            int n = k = GenomeAnalysisEngine.getRandomGenerator().nextInt(this.NUM_BINS);
            sitesToChoosePerBin[n] = sitesToChoosePerBin[n] + 1;
            ++totalSites;
        }
        System.out.println("sitesToChoosePerBin:");
        for (k = 0; k < this.NUM_BINS; ++k) {
            System.out.format("%d ", sitesToChoosePerBin[k]);
        }
        System.out.println();
        System.out.println("preSampleSelectionHistogram:");
        for (k = 0; k < this.NUM_BINS; ++k) {
            System.out.format("%d ", this.preSampleSelectionHistogram[k]);
        }
        System.out.println();
        System.out.println("postSampleSelectionHistogram:");
        for (k = 0; k < this.NUM_BINS; ++k) {
            System.out.format("%d ", this.postSampleSelectionHistogram[k]);
        }
        System.out.println();
        ArrayList<GenomeEvent> selectedEvents = new ArrayList<GenomeEvent>();
        for (int k2 = 0; k2 < this.NUM_BINS; ++k2) {
            selectedEvents.addAll(MathUtils.randomSubset(this.binnedEventArray[k2], sitesToChoosePerBin[k2]));
        }
        Collections.sort(selectedEvents);
        ArrayList<VariantContext> selectedSites = new ArrayList<VariantContext>();
        for (GenomeEvent event : selectedEvents) {
            selectedSites.add(event.createVariantContextFromEvent());
        }
        return selectedSites;
    }
}

