/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(description="Evaluation summary for multi-allelic variants")
public class MultiallelicSummary
extends VariantEvaluator
implements StandardEval {
    protected static final Logger logger = Logger.getLogger(MultiallelicSummary.class);
    @DataPoint(description="Number of processed loci", format="%d")
    public long nProcessedLoci = 0L;
    @DataPoint(description="Number of SNPs", format="%d")
    public int nSNPs = 0;
    @DataPoint(description="Number of multi-allelic SNPs", format="%d")
    public int nMultiSNPs = 0;
    @DataPoint(description="% processed sites that are multi-allelic SNPs", format="%.5f")
    public double processedMultiSnpRatio = 0.0;
    @DataPoint(description="% SNP sites that are multi-allelic", format="%.3f")
    public double variantMultiSnpRatio = 0.0;
    @DataPoint(description="Number of Indels", format="%d")
    public int nIndels = 0;
    @DataPoint(description="Number of multi-allelic Indels", format="%d")
    public int nMultiIndels = 0;
    @DataPoint(description="% processed sites that are multi-allelic Indels", format="%.5f")
    public double processedMultiIndelRatio = 0.0;
    @DataPoint(description="% Indel sites that are multi-allelic", format="%.3f")
    public double variantMultiIndelRatio = 0.0;
    @DataPoint(description="Number of Transitions", format="%d")
    public int nTi = 0;
    @DataPoint(description="Number of Transversions", format="%d")
    public int nTv = 0;
    @DataPoint(description="Overall TiTv ratio", format="%.2f")
    public double TiTvRatio = 0.0;
    @DataPoint(description="Multi-allelic SNPs partially known", format="%d")
    public int knownSNPsPartial = 0;
    @DataPoint(description="Multi-allelic SNPs completely known", format="%d")
    public int knownSNPsComplete = 0;
    @DataPoint(description="Multi-allelic SNP Novelty Rate")
    public String SNPNoveltyRate = "NA";
    public int knownIndelsPartial = 0;
    public int knownIndelsComplete = 0;
    public String indelNoveltyRate = "NA";

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (eval == null || this.getWalker().ignoreAC0Sites() && eval.isMonomorphicInSamples()) {
            return;
        }
        switch (eval.getType()) {
            case SNP: {
                ++this.nSNPs;
                if (eval.isBiallelic()) break;
                ++this.nMultiSNPs;
                this.calculatePairwiseTiTv(eval);
                this.calculateSNPPairwiseNovelty(eval, comp);
                break;
            }
            case INDEL: {
                ++this.nIndels;
                if (eval.isBiallelic()) break;
                ++this.nMultiIndels;
                this.calculateIndelPairwiseNovelty(eval, comp);
                break;
            }
        }
    }

    private void calculatePairwiseTiTv(VariantContext vc) {
        for (Allele alt : vc.getAlternateAlleles()) {
            if (VariantContextUtils.isTransition(vc.getReference(), alt)) {
                ++this.nTi;
                continue;
            }
            ++this.nTv;
        }
    }

    private void calculateSNPPairwiseNovelty(VariantContext eval, VariantContext comp) {
        if (comp == null) {
            return;
        }
        int knownAlleles = 0;
        for (Allele alt : eval.getAlternateAlleles()) {
            if (!comp.getAlternateAlleles().contains(alt)) continue;
            ++knownAlleles;
        }
        if (knownAlleles == eval.getAlternateAlleles().size()) {
            ++this.knownSNPsComplete;
        } else if (knownAlleles > 0) {
            ++this.knownSNPsPartial;
        }
    }

    private void calculateIndelPairwiseNovelty(VariantContext eval, VariantContext comp) {
    }

    @Override
    public void finalizeEvaluation() {
        this.nProcessedLoci = this.getWalker().getnProcessedLoci();
        this.processedMultiSnpRatio = (double)this.nMultiSNPs / (double)this.nProcessedLoci;
        this.variantMultiSnpRatio = (double)this.nMultiSNPs / (double)this.nSNPs;
        this.processedMultiIndelRatio = (double)this.nMultiIndels / (double)this.nProcessedLoci;
        this.variantMultiIndelRatio = (double)this.nMultiIndels / (double)this.nIndels;
        this.TiTvRatio = (double)this.nTi / (double)this.nTv;
        this.SNPNoveltyRate = Utils.formattedNoveltyRate(this.knownSNPsPartial + this.knownSNPsComplete, this.nMultiSNPs);
        this.indelNoveltyRate = Utils.formattedNoveltyRate(this.knownIndelsPartial + this.knownIndelsComplete, this.nMultiSNPs);
    }

    public static enum Type {
        SNP,
        INDEL;

    }
}

