/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="PrintMissingComp", description="the overlap between eval and comp sites")
public class PrintMissingComp
extends VariantEvaluator {
    @DataPoint(description="number of eval sites outside of comp sites", format="%d")
    public long nMissing = 0L;

    public String getName() {
        return "PrintMissingComp";
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        boolean evalIsGood;
        boolean compIsGood = comp != null && comp.isNotFiltered() && comp.isSNP();
        if (compIsGood & !(evalIsGood = eval != null && eval.isSNP())) {
            ++this.nMissing;
            super.getWalker().getLogger().info("MissingFrom" + eval.toString() + " is missing from " + comp.getSource());
        }
    }
}

