/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantSummary;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleCount
extends VariantStratifier {
    int nchrom;

    @Override
    public void initialize() {
        if (this.getVariantEvalWalker().getEvals().size() != 1 && !this.getVariantEvalWalker().mergeEvals) {
            throw new UserException.BadArgumentValue("AlleleCount", "AlleleCount stratification only works with a single eval vcf");
        }
        this.nchrom = this.getVariantEvalWalker().getSampleNamesForEvaluation().size() * 2;
        if (this.nchrom < 2) {
            throw new UserException.BadArgumentValue("AlleleCount", "AlleleCount stratification requires an eval vcf with at least one sample");
        }
        for (int ac = 0; ac <= this.nchrom; ++ac) {
            this.states.add(ac);
        }
        this.getVariantEvalWalker().getLogger().info("AlleleCount using " + this.nchrom + " chromosomes");
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (eval != null) {
            int AC = 0;
            if (eval.hasAttribute("MLEAC") && eval.isBiallelic()) {
                AC = Math.min(eval.getAttributeAsInt("MLEAC", 0), this.nchrom);
            } else if (eval.hasAttribute("AC") && eval.isBiallelic()) {
                AC = eval.getAttributeAsInt("AC", 0);
            } else if (eval.isVariant()) {
                for (Allele allele : eval.getAlternateAlleles()) {
                    AC = Math.max(AC, eval.getCalledChrCount(allele));
                }
            }
            if (AC > this.nchrom) {
                throw new UserException.MalformedVCF(String.format("The AC value (%d) at position %s:%d is larger than the number of chromosomes over all samples (%d)", AC, eval.getChr(), eval.getStart(), this.nchrom));
            }
            return Collections.singletonList(AC);
        }
        return Collections.emptyList();
    }

    @Override
    public Set<Class<? extends VariantEvaluator>> getIncompatibleEvaluators() {
        return new HashSet<Class<? extends VariantEvaluator>>(Arrays.asList(VariantSummary.class));
    }

    @Override
    public String getFormat() {
        return "%d";
    }
}

