/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Molten;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class AnalysisModuleScanner {
    private static final Map<String, Annotation[]> annotationCache = new HashMap<String, Annotation[]>();
    private Map<Field, DataPoint> datums = new LinkedHashMap<Field, DataPoint>();
    private Analysis analysis;
    private Field moltenField = null;
    private Molten moltenAnnotation = null;
    private final Class cls;

    public AnalysisModuleScanner(Class cls) {
        this.cls = cls;
        this.scan();
    }

    public AnalysisModuleScanner(Object obj) {
        this.cls = obj.getClass();
        this.scan();
    }

    public void scan() {
        if (this.cls == null || !this.cls.isAnnotationPresent(Analysis.class)) {
            throw new ReviewedStingException("The class passed in cannot be null, and must contain the @Analysis annotation, class " + this.cls + " was the input");
        }
        this.analysis = this.cls.getAnnotation(Analysis.class);
        this.scanFields();
    }

    private void scanFields() {
        for (Class superCls = this.cls; superCls != null; superCls = superCls.getSuperclass()) {
            for (Field f : superCls.getDeclaredFields()) {
                for (Annotation annotation : this.getAnnotations(f)) {
                    if (annotation.annotationType().equals(DataPoint.class)) {
                        this.datums.put(f, (DataPoint)annotation);
                    }
                    if (!annotation.annotationType().equals(Molten.class)) continue;
                    if (this.hasMoltenField()) {
                        throw new ReviewedStingException("Analysis " + this.analysis.name() + " has multiple @Molten fields, which is forbidden");
                    }
                    this.moltenField = f;
                    this.moltenAnnotation = (Molten)annotation;
                }
            }
        }
        if (this.hasMoltenField() && this.datums.size() > 0) {
            throw new ReviewedStingException("Analysis " + this.analysis.name() + " has an @Molten field as well as @DataPoint fields, which is forbidden");
        }
    }

    public Field getMoltenField() {
        return this.moltenField;
    }

    public Molten getMoltenAnnotation() {
        return this.moltenAnnotation;
    }

    public boolean hasMoltenField() {
        return this.getMoltenField() != null;
    }

    private Annotation[] getAnnotations(Field field) {
        String fieldName = field.toString();
        Annotation[] annotations = annotationCache.get(fieldName);
        if (annotations == null) {
            annotations = field.getAnnotations();
            annotationCache.put(fieldName, annotations);
        }
        return annotations;
    }

    public Map<Field, DataPoint> getData() {
        return this.datums;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public Class getModuleClass() {
        return this.cls;
    }
}

