/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.io.RepeatableInputStream;
import org.jets3t.service.utils.ServiceUtils;

public class RepeatableRequestEntity
implements RequestEntity {
    private static final Log log = LogFactory.getLog(RepeatableRequestEntity.class);
    private String name = null;
    private InputStream is = null;
    private String contentType = null;
    private long contentLength = 0L;
    private long bytesWritten = 0L;
    private InputStream repeatableInputStream = null;
    private ProgressMonitoredInputStream progressMonitoredIS = null;
    protected static long MAX_BYTES_PER_SECOND = 0L;
    private static volatile long bytesWrittenThisSecond = 0L;
    private static volatile long currentSecondMonitored = 0L;
    private static final Random random = new Random();
    private boolean isLiveMD5HashingEnabled = true;
    private byte[] dataMD5Hash = null;

    public RepeatableRequestEntity(String name, InputStream is, String contentType, long contentLength, Jets3tProperties jets3tProperties, boolean enableLiveMD5Hashing) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = is;
        this.name = name;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.isLiveMD5HashingEnabled = enableLiveMD5Hashing;
        InputStream inputStream = is;
        while (true) {
            if (inputStream instanceof ProgressMonitoredInputStream) {
                this.progressMonitoredIS = (ProgressMonitoredInputStream)inputStream;
            }
            if (inputStream.markSupported()) {
                this.repeatableInputStream = inputStream;
                this.repeatableInputStream.mark(Integer.MAX_VALUE);
            }
            if (!(inputStream instanceof InputStreamWrapper)) break;
            inputStream = ((InputStreamWrapper)((Object)inputStream)).getWrappedInputStream();
        }
        if (this.repeatableInputStream == null) {
            if (log.isDebugEnabled()) {
                log.debug("Wrapping non-repeatable input stream in a RepeatableInputStream");
            }
            int bufferSize = jets3tProperties.getIntProperty("uploads.stream-retry-buffer-size", 131072);
            this.repeatableInputStream = this.is = new RepeatableInputStream(is, bufferSize);
        }
        MAX_BYTES_PER_SECOND = 1024L * jets3tProperties.getLongProperty("httpclient.read-throttle", 0L);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        MessageDigest messageDigest;
        block9: {
            if (this.bytesWritten > 0L) {
                this.repeatableInputStream.reset();
                if (log.isWarnEnabled()) {
                    log.warn("Repeating transmission of " + this.bytesWritten + " bytes");
                }
                if (this.progressMonitoredIS != null) {
                    this.progressMonitoredIS.resetProgressMonitor();
                }
                this.bytesWritten = 0L;
            }
            messageDigest = null;
            if (this.isLiveMD5HashingEnabled) {
                try {
                    messageDigest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    if (!log.isWarnEnabled()) break block9;
                    log.warn("Unable to calculate MD5 hash of data sent as algorithm is not available", e);
                }
            }
        }
        byte[] tmp = new byte[16384];
        int count = 0;
        while ((count = this.is.read(tmp)) >= 0) {
            RepeatableRequestEntity.throttle(count);
            this.bytesWritten += (long)count;
            out.write(tmp, 0, count);
            if (messageDigest == null) continue;
            messageDigest.update(tmp, 0, count);
        }
        if (messageDigest != null) {
            this.dataMD5Hash = messageDigest.digest();
            if (log.isDebugEnabled()) {
                log.debug("MD5 digest of data sent for '" + this.name + "' - B64:" + ServiceUtils.toBase64(this.dataMD5Hash) + " Hex:" + ServiceUtils.toHex(this.dataMD5Hash));
            }
        }
    }

    public byte[] getMD5DigestOfData() {
        if (this.dataMD5Hash != null) {
            return this.dataMD5Hash;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void throttle(int bytesToWrite) throws IOException {
        boolean willExceedThrottle;
        if (MAX_BYTES_PER_SECOND <= 0L) {
            return;
        }
        long currentSecond = System.currentTimeMillis() / 1000L;
        Random random = RepeatableRequestEntity.random;
        synchronized (random) {
            boolean isCurrentSecond = currentSecond == currentSecondMonitored;
            boolean bl = willExceedThrottle = isCurrentSecond && bytesWrittenThisSecond + (long)bytesToWrite > MAX_BYTES_PER_SECOND;
            if (!isCurrentSecond) {
                currentSecondMonitored = currentSecond;
                bytesWrittenThisSecond = bytesToWrite;
            }
            if (!willExceedThrottle) {
                bytesWrittenThisSecond += (long)bytesToWrite;
            }
        }
        if (willExceedThrottle) {
            try {
                Thread.sleep(RepeatableRequestEntity.random.nextInt(250));
            }
            catch (InterruptedException e) {
                throw new IOException("Throttling of transmission was interrupted");
            }
            RepeatableRequestEntity.throttle(bytesToWrite);
        }
    }
}

