\name{groupfreq}
\alias{groupfreq}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Group frequencies}
\description{
Creates group frequencies tables: number of loss, normal, gains, amplifications per sample group.
}
\usage{
groupfreq(datacgh, sepfile = "no", dataclinvar, whclinvar = 1, group, groupnames, mc = "no", comparison = "all", lgonly = 0, af = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{datacgh}{A data frame containing discretized aCGH data}
  \item{sepfile}{Do you use a separate file containing clinical data? "yes" or "no"}
  \item{dataclinvar}{A .txt file containing clinical grouping information. Order of rows, in terms of samples, should be the same as the order of the columns in Xmat. Only needed when sepfile = "yes"}
  \item{whclinvar}{The number of the column with clinical data you wish to use}
  \item{group}{If sep= "no": a vector containing the sizes of your groups}
  \item{groupnames}{If sep= "no": a character vector containing the names of your groups}
  \item{mc}{Do you want to make multiple comparisons, "yes" or "no"}
  \item{comparison}{Vector containing comparisons you wish to make. 1 with 3 and 2 with 3 is entered as c(1,3,2,3)}
  \item{lgonly}{What states do you wish to compare? Options: -1 for losses vs non-loss, 1 for gain vs non-gain, 0 for all 3}
  \item{af}{Filter out regions with less than af*100 perc. aberrations}
}

\details{
  See pvalstest for more details
}
\value{
 A dataframe containing frequencies per group
}
\author{Mark A. van de Wiel}


\examples{
data(cghreg)
datacgh <- regions(cghreg)
gfr <- groupfreq(datacgh,group=c(7,30),groupnames=c("MSI+", "CIN+"),af=0.1)
}
