/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.DataType;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import java.util.StringTokenizer;

public class GenericComplementableDiscreteAlphabet
extends ComplementableDiscreteAlphabet {
    private int[] comp;

    public GenericComplementableDiscreteAlphabet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public GenericComplementableDiscreteAlphabet(GenericComplementableDiscreteAlphabetParameterSet parameters) throws IllegalArgumentException, DoubleSymbolException {
        super(parameters);
        StringTokenizer tok = new StringTokenizer((String)parameters.getParameterAt(2).getValue(), " ");
        this.comp = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.comp[i++] = Integer.parseInt(tok.nextToken());
        }
    }

    public GenericComplementableDiscreteAlphabet(boolean caseInsensitive, String[] alphabet, int[] revComp) throws DoubleSymbolException, IllegalArgumentException {
        super(caseInsensitive, alphabet);
        this.comp = (int[])revComp.clone();
    }

    @Override
    public int getComplementaryCode(int code) {
        return this.comp[code];
    }

    @Override
    public Alphabet.AlphabetParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters.clone();
        }
        return new GenericComplementableDiscreteAlphabetParameterSet((String[])this.alphabet.clone(), this.caseInsensitive, (int[])this.comp.clone());
    }

    public static class GenericComplementableDiscreteAlphabetParameterSet
    extends DiscreteAlphabet.DiscreteAlphabetParameterSet {
        public GenericComplementableDiscreteAlphabetParameterSet() {
            super((Class<? extends DiscreteAlphabet>)GenericComplementableDiscreteAlphabet.class);
            try {
                this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "Values of the index for computings the reverse complement", "", true)});
            }
            catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
                throw new RuntimeException(doesnothappen);
            }
        }

        public GenericComplementableDiscreteAlphabetParameterSet(String[] alphabet, boolean caseInsensitive, int[] revComp) throws Exception {
            this();
            String alphString = alphabet[0];
            String revString = "" + revComp[0];
            int i = 1;
            while (i < alphabet.length) {
                alphString = String.valueOf(alphString) + " " + alphabet[i];
                revString = String.valueOf(revString) + " " + revComp[i];
                ++i;
            }
            ((Parameter)this.parameters.get(0)).setValue(alphString);
            ((Parameter)this.parameters.get(1)).setValue(new String(caseInsensitive ? "Case insensitive" : "Case sensitive"));
            ((Parameter)this.parameters.get(2)).setValue(revString);
        }

        public GenericComplementableDiscreteAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }
    }
}

