/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

import de.jtem.numericalMethods.algebra.linear.VectorOperations;

public final class MatrixOperations {
    private MatrixOperations() {
    }

    public static final void times(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        double[][] dArray7 = dArray == dArray5 || dArray == dArray6 ? MatrixOperations.copy(dArray) : dArray;
        double[][] dArray8 = dArray2 == dArray5 || dArray2 == dArray6 ? MatrixOperations.copy(dArray2) : dArray2;
        double[][] dArray9 = dArray3 == dArray5 || dArray3 == dArray6 ? MatrixOperations.copy(dArray3) : dArray3;
        double[][] dArray10 = dArray4 == dArray5 || dArray4 == dArray6 ? MatrixOperations.copy(dArray4) : dArray4;
        int n = dArray9.length;
        int n2 = dArray5.length;
        int n3 = dArray5[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray11 = dArray7[i];
            double[] dArray12 = dArray8[i];
            double[] dArray13 = dArray5[i];
            double[] dArray14 = dArray6[i];
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray11[k] * dArray9[k][j] - dArray12[k] * dArray10[k][j];
                    d2 += dArray11[k] * dArray10[k][j] + dArray12[k] * dArray9[k][j];
                }
                dArray13[j] = d;
                dArray14[j] = d2;
            }
        }
    }

    public static final void times(int[][] nArray, int[][] nArray2, int[][] nArray3) {
        int[][] nArray4;
        int[][] nArray5;
        if (nArray == nArray3) {
            nArray5 = MatrixOperations.copy(nArray3);
            nArray4 = nArray2 != nArray3 ? nArray2 : nArray5;
        } else {
            nArray5 = nArray;
            nArray4 = nArray2 != nArray3 ? nArray2 : MatrixOperations.copy(nArray3);
        }
        int n = nArray4.length;
        int n2 = nArray3.length;
        int n3 = nArray3[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray6 = nArray5[i];
            int[] nArray7 = nArray3[i];
            for (int j = 0; j < n3; ++j) {
                int n4 = 0;
                for (int k = 0; k < n; ++k) {
                    n4 += nArray6[k] * nArray4[k][j];
                }
                nArray7[j] = n4;
            }
        }
    }

    public static final void times(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        double[][] dArray4;
        double[][] dArray5;
        if (dArray == dArray3) {
            dArray5 = MatrixOperations.copy(dArray3);
            dArray4 = dArray2 != dArray3 ? dArray2 : dArray5;
        } else {
            dArray5 = dArray;
            dArray4 = dArray2 != dArray3 ? dArray2 : MatrixOperations.copy(dArray3);
        }
        int n = dArray4.length;
        int n2 = dArray3.length;
        int n3 = dArray3[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray6 = dArray5[i];
            double[] dArray7 = dArray3[i];
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray6[k] * dArray4[k][j];
                }
                dArray7[j] = d;
            }
        }
    }

    public static final void times(int[][] nArray, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = dArray != dArray2 ? dArray : MatrixOperations.copy(dArray2);
        int n = dArray3.length;
        int n2 = dArray2.length;
        int n3 = dArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += (double)nArray2[k] * dArray3[k][j];
                }
                dArray4[j] = d;
            }
        }
    }

    public static final void times(double[][] dArray, int[][] nArray, double[][] dArray2) {
        double[][] dArray3 = dArray != dArray2 ? dArray : MatrixOperations.copy(dArray2);
        int n = nArray.length;
        int n2 = dArray2.length;
        int n3 = dArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray4 = dArray3[i];
            double[] dArray5 = dArray2[i];
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray4[k] * (double)nArray[k][j];
                }
                dArray5[j] = d;
            }
        }
    }

    public static final void times(int[][] nArray, int[][] nArray2, double[][] dArray) {
        int n = nArray2.length;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += (double)(nArray3[k] * nArray2[k][j]);
                }
                dArray2[j] = d;
            }
        }
    }

    public static final void divide(double[][] dArray, double[][] dArray2, double d, double d2, double[][] dArray3, double[][] dArray4) {
        double d3 = d * d + d2 * d2;
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray5 = dArray[i];
            double[] dArray6 = dArray3[i];
            double[] dArray7 = dArray2[i];
            double[] dArray8 = dArray4[i];
            for (int j = 0; j < n2; ++j) {
                double d4 = dArray5[j];
                double d5 = dArray7[j];
                dArray6[j] = (d4 * d + d5 * d2) / d3;
                dArray8[j] = (d5 * d - d4 * d2) / d3;
            }
        }
    }

    public static final void times(double[][] dArray, double[][] dArray2, double d, double d2, double[][] dArray3, double[][] dArray4) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray5 = dArray3[i];
            double[] dArray6 = dArray4[i];
            double[] dArray7 = dArray[i];
            double[] dArray8 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                double d3 = dArray7[j];
                double d4 = dArray8[j];
                dArray5[j] = d3 * d - d4 * d2;
                dArray6[j] = d3 * d2 + d4 * d;
            }
        }
    }

    public static final void times(int[][] nArray, int n, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = nArray3[j] * n;
            }
        }
    }

    public static final void divide(int[][] nArray, int n, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = nArray3[j] / n;
            }
        }
    }

    public static final void divide(int[][] nArray, double d, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = (double)nArray2[j] / d;
            }
        }
    }

    public static final void divide(int n, int[][] nArray, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = n / nArray3[j];
            }
        }
    }

    public static final void divide(double d, double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = d / dArray3[j];
            }
        }
    }

    public static final void divide(double d, double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray5 = dArray[i];
            double[] dArray6 = dArray3[i];
            double[] dArray7 = dArray2[i];
            double[] dArray8 = dArray4[i];
            for (int j = 0; j < n2; ++j) {
                double d2 = dArray5[j];
                double d3 = dArray7[j];
                double d4 = d2 * d2 + d3 * d3;
                if (d4 == 0.0) {
                    dArray6[j] = d / d4;
                    dArray8[j] = 0.0;
                    continue;
                }
                dArray6[j] = d * d2 / d4;
                dArray8[j] = -d * d3 / d4;
            }
        }
    }

    public static final void divide(double d, int[][] nArray, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = d / (double)nArray2[j];
            }
        }
    }

    public static final void divide(double[][] dArray, double d, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] / d;
            }
        }
    }

    public static final void times(double[][] dArray, double d, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] * d;
            }
        }
    }

    public static final void times(int[][] nArray, double d, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = (double)nArray2[j] * d;
            }
        }
    }

    public static final void times(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        double[] dArray7 = dArray3 == dArray5 || dArray3 == dArray6 ? (double[])dArray3.clone() : dArray3;
        double[] dArray8 = dArray4 == dArray5 || dArray4 == dArray6 ? (double[])dArray4.clone() : dArray4;
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray9 = dArray[i];
            double[] dArray10 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                d += dArray9[j] * dArray7[j] - dArray10[j] * dArray8[j];
                d2 += dArray9[j] * dArray8[j] + dArray10[j] * dArray7[j];
            }
            dArray5[i] = d;
            dArray6[i] = d2;
        }
    }

    public static final void times(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray3[j][i] * dArray[j] - dArray4[j][i] * dArray2[j];
                d2 += dArray3[j][i] * dArray2[j] + dArray4[j][i] * dArray[j];
            }
            dArray5[i] = d;
            dArray6[i] = d2;
        }
    }

    public static final void times(int[][] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = nArray2 != nArray3 ? nArray2 : VectorOperations.copy(nArray3);
        int n = nArray2.length;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray5 = nArray[i];
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                n3 += nArray5[j] * nArray4[j];
            }
            nArray3[i] = n3;
        }
    }

    public static final void times(int[][] nArray, int[] nArray2, double[] dArray) {
        int n = nArray2.length;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                n3 += nArray3[j] * nArray2[j];
            }
            dArray[i] = n3;
        }
    }

    public static final void times(double[][] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = dArray2 != dArray3 ? dArray2 : VectorOperations.copy(dArray3);
        int n = dArray2.length;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray5 = dArray[i];
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray5[j] * dArray4[j];
            }
            dArray3[i] = d;
        }
    }

    public static final void times(int[][] nArray, double[] dArray, double[] dArray2) {
        double[] dArray3 = dArray != dArray2 ? dArray : VectorOperations.copy(dArray2);
        int n = dArray.length;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = nArray[i];
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += (double)nArray2[j] * dArray3[j];
            }
            dArray2[i] = d;
        }
    }

    public static final void times(double[][] dArray, int[] nArray, double[] dArray2) {
        int n = nArray.length;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray[i];
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray3[j] * (double)nArray[j];
            }
            dArray2[i] = d;
        }
    }

    public static final void times(int[] nArray, int[][] nArray2, int[] nArray3) {
        int[] nArray4 = nArray != nArray3 ? nArray : VectorOperations.copy(nArray3);
        int n = nArray.length;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                n3 += nArray4[j] * nArray2[j][i];
            }
            nArray3[i] = n3;
        }
    }

    public static final void times(int[] nArray, int[][] nArray2, double[] dArray) {
        int n = nArray.length;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                n3 += nArray[j] * nArray2[j][i];
            }
            dArray[i] = n3;
        }
    }

    public static final void times(double[] dArray, double[][] dArray2, double[] dArray3) {
        double[] dArray4 = dArray != dArray3 ? dArray : VectorOperations.copy(dArray3);
        int n = dArray.length;
        int n2 = dArray3.length;
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray4[j] * dArray2[j][i];
            }
            dArray3[i] = d;
        }
    }

    public static final void times(int[] nArray, double[][] dArray, double[] dArray2) {
        int n = nArray.length;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += (double)nArray[j] * dArray[j][i];
            }
            dArray2[i] = d;
        }
    }

    public static final void times(double[] dArray, int[][] nArray, double[] dArray2) {
        double[] dArray3 = dArray != dArray2 ? dArray : VectorOperations.copy(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray3[j] * (double)nArray[j][i];
            }
            dArray2[i] = d;
        }
    }

    public static final void times(int[] nArray, int[] nArray2, int[][] nArray3) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray3[i][j] = nArray[i] * nArray2[j];
            }
        }
    }

    public static final void times(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = dArray[i] * dArray2[j];
            }
        }
    }

    public static final void times(int[] nArray, double[] dArray, double[][] dArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = (double)nArray[i] * dArray[j];
            }
        }
    }

    public static final void times(double[] dArray, int[] nArray, double[][] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i] * (double)nArray[j];
            }
        }
    }

    public static final void plus(int[][] nArray, int[][] nArray2, int[][] nArray3) {
        int n = nArray3.length;
        int n2 = nArray3[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray4 = nArray[i];
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                nArray6[j] = nArray4[j] + nArray5[j];
            }
        }
    }

    public static final void plus(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray2[i];
            double[] dArray6 = dArray3[i];
            for (int j = 0; j < n2; ++j) {
                dArray6[j] = dArray4[j] + dArray5[j];
            }
        }
    }

    public static final void plus(double[][] dArray, int[][] nArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            int[] nArray2 = nArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] + (double)nArray2[j];
            }
        }
    }

    public static final void plus(int[][] nArray, double[][] dArray, double[][] dArray2) {
        MatrixOperations.plus(dArray, nArray, dArray2);
    }

    public static final void plus(int[][] nArray, int n, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = nArray3[j] + n;
            }
        }
    }

    public static final void plus(double[][] dArray, double d, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] + d;
            }
        }
    }

    public static final void plus(int[][] nArray, double d, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = (double)nArray2[j] + d;
            }
        }
    }

    public static final void minus(int[][] nArray, int[][] nArray2, int[][] nArray3) {
        int n = nArray3.length;
        int n2 = nArray3[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray4 = nArray[i];
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                nArray6[j] = nArray4[j] - nArray5[j];
            }
        }
    }

    public static final void minus(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray2[i];
            double[] dArray6 = dArray3[i];
            for (int j = 0; j < n2; ++j) {
                dArray6[j] = dArray4[j] - dArray5[j];
            }
        }
    }

    public static final void minus(double[][] dArray, int[][] nArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            int[] nArray2 = nArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] - (double)nArray2[j];
            }
        }
    }

    public static final void minus(int[][] nArray, double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = (double)nArray2[j] - dArray3[j];
            }
        }
    }

    public static final void minus(int[][] nArray, int n, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = nArray3[j] - n;
            }
        }
    }

    public static final void minus(int n, int[][] nArray, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = n - nArray3[j];
            }
        }
    }

    public static final void minus(double[][] dArray, double d, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[j] - d;
            }
        }
    }

    public static final void minus(double d, double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = d - dArray3[j];
            }
        }
    }

    public static final void minus(int[][] nArray, double d, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = (double)nArray2[j] - d;
            }
        }
    }

    public static final void minus(int n, double[][] dArray, double[][] dArray2) {
        int n2 = dArray2.length;
        int n3 = dArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n3; ++j) {
                dArray4[j] = (double)n - dArray3[j];
            }
        }
    }

    public static final void assign(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, n2);
        }
    }

    public static final void assign(int[][] nArray, int[][] nArray2) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(nArray[i], 0, nArray2[i], 0, n2);
        }
    }

    public static final void assign(int[][] nArray, double[][] dArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = nArray2[j];
            }
        }
    }

    public static final int[][] copy(int[][] nArray) {
        int[][] nArray2 = new int[nArray.length][nArray[0].length];
        MatrixOperations.assign(nArray, nArray2);
        return nArray2;
    }

    public static final double[][] copy(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        MatrixOperations.assign(dArray, dArray2);
        return dArray2;
    }

    public static final void assign(double[][] dArray, double d) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = dArray[0];
        for (n = 0; n < n3; ++n) {
            dArray2[n] = d;
        }
        for (n = 1; n < n2; ++n) {
            System.arraycopy(dArray2, 0, dArray[n], 0, n3);
        }
    }

    public static final void assign(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        int[] nArray2 = nArray[0];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = n;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            System.arraycopy(nArray2, 0, nArray[n2], 0, n4);
        }
    }

    public static final void assignId(int[][] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2 = nArray[i];
                nArray2[j] = i == j ? 1 : 0;
            }
        }
    }

    public static final void assignId(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2 = dArray[i];
                dArray2[j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public static final void assignZero(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int[] nArray2 = nArray[0];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = 0;
        }
        for (n = 1; n < n2; ++n) {
            System.arraycopy(nArray2, 0, nArray[n], 0, n3);
        }
    }

    public static final void assignZero(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = dArray[0];
        for (n = 0; n < n3; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 1; n < n2; ++n) {
            System.arraycopy(dArray2, 0, dArray[n], 0, n3);
        }
    }

    public static final void getDiagonal(int[][] nArray, int[] nArray2) {
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i][i];
        }
    }

    public static final void assignDiagonal(int[][] nArray, int[] nArray2) {
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            nArray[i][i] = nArray2[i];
        }
    }

    public static final void assignDiagonal(int[][] nArray, int n) {
        int n2 = Math.min(nArray.length, nArray[0].length);
        for (int i = 0; i < n2; ++i) {
            nArray[i][i] = n;
        }
    }

    public static final void assignDiagonal(double[][] dArray, double d) {
        int n = Math.min(dArray.length, dArray[0].length);
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = d;
        }
    }

    public static final void assignDiagonal(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = dArray2[i];
        }
    }

    public static final void getDiagonal(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i][i];
        }
    }

    public static final void assignDiagonal(double[][] dArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = nArray[i];
        }
    }

    public static final void assignRow(int[][] nArray, int[] nArray2, int n) {
        System.arraycopy(nArray2, 0, nArray[n], 0, nArray2.length);
    }

    public static final void getRow(int[][] nArray, int[] nArray2, int n) {
        System.arraycopy(nArray[n], 0, nArray2, 0, nArray2.length);
    }

    public static final void getRow(double[][] dArray, double[] dArray2, int n) {
        System.arraycopy(dArray[n], 0, dArray2, 0, dArray2.length);
    }

    public static final void assignRow(double[][] dArray, double[] dArray2, int n) {
        System.arraycopy(dArray2, 0, dArray[n], 0, dArray2.length);
    }

    public static final void assignRow(double[][] dArray, int[] nArray, int n) {
        int n2 = nArray.length;
        double[] dArray2 = dArray[n];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = nArray[i];
        }
    }

    public static final void assignCol(int[][] nArray, int[] nArray2, int n) {
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i][n] = nArray2[i];
        }
    }

    public static final void getCol(int[][] nArray, int[] nArray2, int n) {
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i][n];
        }
    }

    public static final void getCol(double[][] dArray, double[] dArray2, int n) {
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i][n];
        }
    }

    public static final void assignCol(double[][] dArray, double[] dArray2, int n) {
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i][n] = dArray2[i];
        }
    }

    public static final void assignCol(double[][] dArray, int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i][n] = nArray[i];
        }
    }

    public static final void round(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = Math.floor(dArray3[j] + 0.5);
            }
        }
    }

    public static final void round(double[][] dArray, int[][] nArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = (int)Math.floor(dArray2[j] + 0.5);
            }
        }
    }

    public static final void floor(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = Math.floor(dArray3[j]);
            }
        }
    }

    public static final void floor(double[][] dArray, int[][] nArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = (int)Math.floor(dArray2[j]);
            }
        }
    }

    public static final void neg(int[][] nArray, int[][] nArray2) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                nArray4[j] = -nArray3[j];
            }
        }
    }

    public static final void neg(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = -dArray3[j];
            }
        }
    }

    public static final void neg(int[][] nArray, double[][] dArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = -nArray2[j];
            }
        }
    }

    public static final void mod(int[][] nArray, int n, int[][] nArray2) {
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                nArray4[j] = nArray3[j] % n;
            }
        }
    }

    public static final double normSqr(int[][] nArray) {
        int n = 0;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                n += nArray2[j] * nArray2[j];
            }
        }
        return n;
    }

    public static final double normSqr(double[][] dArray) {
        double d = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                d += dArray2[j] * dArray2[j];
            }
        }
        return d;
    }

    public static final int[] maxAbs(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int[] nArray = new int[]{0, 0};
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = dArray[i][j] * dArray[i][j];
                if (!(d2 > d)) continue;
                d = d2;
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return nArray;
    }

    public static final int[] maxAbs(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int[] nArray = new int[]{0, 0};
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = dArray[i][j] * dArray[i][j] + dArray2[i][j] * dArray2[i][j];
                if (!(d2 > d)) continue;
                d = d2;
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return nArray;
    }

    public static final void transpose(int[][] nArray, int[][] nArray2) {
        int n = nArray2.length;
        if (nArray == nArray2) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    int n2 = nArray[i][j];
                    nArray[i][j] = nArray[j][i];
                    nArray[j][i] = n2;
                }
            }
        } else {
            int n3 = nArray2[0].length;
            for (int i = 0; i < n; ++i) {
                int[] nArray3 = nArray2[i];
                for (int j = 0; j < n3; ++j) {
                    nArray3[j] = nArray[j][i];
                }
            }
        }
    }

    public static final void transpose(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        if (dArray == dArray2) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d = dArray[i][j];
                    dArray[i][j] = dArray[j][i];
                    dArray[j][i] = d;
                }
            }
        } else {
            int n2 = dArray2[0].length;
            for (int i = 0; i < n; ++i) {
                double[] dArray3 = dArray2[i];
                for (int j = 0; j < n2; ++j) {
                    dArray3[j] = dArray[j][i];
                }
            }
        }
    }

    public static final void random(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = 2.0 * Math.random() - 1.0;
            }
        }
    }

    public static final void random(int[][] nArray, int n) {
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[i][j] = (int)Math.random() * n;
            }
        }
    }

    public static boolean isRectangular(int[][] nArray) {
        if (nArray.length == 0) {
            return true;
        }
        int n = nArray[0].length;
        int n2 = nArray.length;
        for (int i = 1; i < n2; ++i) {
            if (nArray[i] != null && nArray[i].length == n) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectangular(double[][] dArray) {
        if (dArray.length == 0) {
            return true;
        }
        int n = dArray[0].length;
        int n2 = dArray.length;
        for (int i = 1; i < n2; ++i) {
            if (dArray[i] != null && dArray[i].length == n) continue;
            return false;
        }
        return true;
    }
}

