/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

import de.jtem.numericalMethods.algebra.linear.decompose.Unmerge;

public class PLR {
    public static double decompose(int[] nArray, double[][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            double d2 = Math.abs(dArray[i][i]);
            int n3 = i;
            for (n2 = i + 1; n2 < n; ++n2) {
                double d3 = Math.abs(dArray[n2][i]);
                if (!(d3 > d2)) continue;
                n3 = n2;
                d2 = d3;
            }
            if (i != n3) {
                d *= -1.0;
                n2 = nArray[i];
                nArray[i] = nArray[n3];
                nArray[n3] = n2;
                double[] dArray2 = dArray[i];
                dArray[i] = dArray[n3];
                dArray[n3] = dArray2;
            }
            d *= dArray[i][i];
            for (n2 = i + 1; n2 < n; ++n2) {
                if (d2 != 0.0) {
                    double[] dArray3 = dArray[n2];
                    int n4 = i;
                    dArray3[n4] = dArray3[n4] / dArray[i][i];
                } else {
                    dArray[n2][i] = 0.0;
                }
                for (int j = i + 1; j < n; ++j) {
                    double[] dArray4 = dArray[n2];
                    int n5 = j;
                    dArray4[n5] = dArray4[n5] - dArray[n2][i] * dArray[i][j];
                }
            }
        }
        return d;
    }

    public static double decompose(int[][] nArray, double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        int[] nArray2 = new int[n];
        double d = PLR.decompose(nArray2, dArray2);
        Unmerge.triangular(dArray2, dArray3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i][j] = 0;
            }
            nArray[i][nArray2[i]] = 1;
        }
        return d;
    }

    public static double[] decompose(int[] nArray, double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        double[] dArray3 = new double[]{1.0, 0.0};
        for (int i = 0; i < n; ++i) {
            double d;
            int n2;
            int n3 = i;
            double d2 = dArray[n3][i];
            double d3 = dArray2[n3][i];
            double d4 = d2 * d2 + d3 * d3;
            for (n2 = i + 1; n2 < n; ++n2) {
                double d5 = dArray[n2][i];
                double d6 = dArray2[n2][i];
                d = d5 * d5 + d6 * d6;
                if (!(d > d4)) continue;
                n3 = n2;
                d4 = d;
            }
            if (i != n3) {
                dArray3[0] = dArray3[0] * -1.0;
                dArray3[1] = dArray3[1] * -1.0;
                n2 = nArray[i];
                nArray[i] = nArray[n3];
                nArray[n3] = n2;
                double[] dArray4 = dArray[i];
                dArray[i] = dArray[n3];
                dArray[n3] = dArray4;
                dArray4 = dArray2[i];
                dArray2[i] = dArray2[n3];
                dArray2[n3] = dArray4;
            }
            double d7 = dArray3[0] * dArray[i][i] - dArray3[1] * dArray2[i][i];
            dArray3[1] = dArray3[0] * dArray2[i][i] + dArray3[1] * dArray[i][i];
            dArray3[0] = d7;
            for (int j = i + 1; j < n; ++j) {
                if (d4 != 0.0) {
                    double d8 = dArray[j][i];
                    d = dArray2[j][i];
                    double d9 = dArray[i][i];
                    double d10 = -dArray2[i][i];
                    double d11 = d9 * d9 + d10 * d10;
                    dArray[j][i] = (d8 * d9 - d * d10) / d11;
                    dArray2[j][i] = (d * d9 + d8 * d10) / d11;
                } else {
                    dArray[j][i] = 0.0;
                    dArray2[j][i] = 0.0;
                }
                int n4 = i + 1;
                while (n4 < n) {
                    double d12 = dArray[j][i];
                    double d13 = dArray2[j][i];
                    double d14 = dArray[i][n4];
                    double d15 = dArray2[i][n4];
                    double[] dArray5 = dArray[j];
                    int n5 = n4;
                    dArray5[n5] = dArray5[n5] - (d12 * d14 - d13 * d15);
                    double[] dArray6 = dArray2[j];
                    int n6 = n4++;
                    dArray6[n6] = dArray6[n6] - (d13 * d14 + d12 * d15);
                }
            }
        }
        return dArray3;
    }

    public static double[] decompose(int[][] nArray, double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = dArray[i][j];
                dArray4[i][j] = dArray2[i][j];
            }
        }
        int[] nArray2 = new int[n];
        double[] dArray7 = PLR.decompose(nArray2, dArray3, dArray4);
        Unmerge.triangular(dArray3, dArray4, dArray5, dArray6);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i][j] = 0;
            }
            nArray[i][nArray2[i]] = 1;
        }
        return dArray7;
    }
}

