/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import java.io.Serializable;

public final class Brent
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static final double ZEPS = 1.0E-17;
    static int ITMAX = 100;

    public static double getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int n) {
        ITMAX = n;
    }

    private static final double sign(double d, double d2) {
        return d2 > 0.0 ? Math.abs(d) : -Math.abs(d);
    }

    public static final void search(double[] dArray, double[] dArray2, RealFunctionOfOneVariable realFunctionOfOneVariable, double d) {
        Brent.search(dArray[0], dArray[1], dArray[2], dArray2, realFunctionOfOneVariable, d);
    }

    public static final void search(double d, double d2, double d3, double[] dArray, RealFunctionOfOneVariable realFunctionOfOneVariable, double d4) {
        Brent.search(d, d2, d3, dArray, realFunctionOfOneVariable, d4, null);
    }

    public static final void search(double d, double d2, double d3, double[] dArray, RealFunctionOfOneVariable realFunctionOfOneVariable, double d4, Info info) {
        double d5;
        double d6;
        double d7;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = d < d3 ? d : d3;
        double d11 = d > d3 ? d : d3;
        double d12 = d7 = d2;
        double d13 = d7;
        double d14 = d6 = realFunctionOfOneVariable.eval(d13);
        double d15 = d5 = d6;
        if (info != null) {
            info.setMaxIter(ITMAX);
        }
        for (int i = 1; i <= ITMAX; ++i) {
            double d16;
            double d17 = 0.5 * (d10 + d11);
            double d18 = d4 * Math.abs(d13) + 1.0E-17;
            double d19 = 2.0 * d18;
            if (Math.abs(d13 - d17) <= d19 - 0.5 * (d11 - d10)) {
                dArray[0] = d13;
                dArray[1] = d6;
                if (info != null) {
                    info.setCurrentIter(i);
                }
                return;
            }
            if (Math.abs(d9) > d18) {
                double d20 = (d13 - d12) * (d6 - d14);
                double d21 = (d13 - d7) * (d6 - d5);
                double d22 = (d13 - d7) * d21 - (d13 - d12) * d20;
                if ((d21 = 2.0 * (d21 - d20)) > 0.0) {
                    d22 = -d22;
                }
                d21 = Math.abs(d21);
                double d23 = d9;
                d9 = d8;
                if (Math.abs(d22) >= Math.abs(0.5 * d21 * d23) || d22 < d21 * (d10 - d13) || d22 >= d21 * (d11 - d13)) {
                    d9 = d13 >= d17 ? d10 - d13 : d11 - d13;
                    d8 = 0.381966 * d9;
                } else {
                    d8 = d22 / d21;
                    d16 = d13 + d8;
                    if (d16 - d10 < d19 || d11 - d16 < d19) {
                        d8 = Brent.sign(d18, d17 - d13);
                    }
                }
            } else {
                d9 = d13 >= d17 ? d10 - d13 : d11 - d13;
                d8 = 0.381966 * d9;
            }
            d16 = Math.abs(d8) >= d18 ? d13 + d8 : d13 + Brent.sign(d18, d8);
            double d24 = realFunctionOfOneVariable.eval(d16);
            if (d24 <= d6) {
                if (d16 >= d13) {
                    d10 = d13;
                } else {
                    d11 = d13;
                }
                d7 = d12;
                d12 = d13;
                d13 = d16;
                d14 = d5;
                d5 = d6;
                d6 = d24;
                continue;
            }
            if (d16 < d13) {
                d10 = d16;
            } else {
                d11 = d16;
            }
            if (d24 <= d5 || d12 == d13) {
                d7 = d12;
                d12 = d16;
                d14 = d5;
                d5 = d24;
                continue;
            }
            if (!(d24 <= d14) && d7 != d13 && d7 != d12) continue;
            d7 = d16;
            d14 = d24;
        }
        dArray[0] = d13;
        dArray[1] = d6;
        if (info != null) {
            String string = "Too many iteration in BRENT\n";
            if (d6 > d15) {
                string = string + " proc Brent failed to decrease center value! " + d + " " + d2 + " " + d3;
            }
            info.setMessage(string);
            info.printDebug();
        }
    }
}

