/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.DBrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import de.jtem.numericalMethods.calculus.minimizing.MinimizingOnLine;
import java.io.Serializable;

public final class SteepestDescent
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static int ITMAX = 100;
    static final double EPS = 1.0E-10;
    static int iter;
    private static boolean useDBrent;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int n) {
        ITMAX = n;
    }

    public static int getIter() {
        return iter;
    }

    public static boolean getUseDBrent() {
        return useDBrent;
    }

    public static void setUseDBrent(boolean bl) {
        useDBrent = bl;
    }

    public static double search(double[] dArray, double d, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient) {
        return SteepestDescent.search(dArray, d, realFunctionOfSeveralVariablesWithGradient, ITMAX, null);
    }

    public static double search(double[] dArray, double d, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient, int n, Info info) {
        if (n < 1) {
            throw new IllegalArgumentException("itMax must be positive!");
        }
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        MinimizingOnLine minimizingOnLine = useDBrent ? new DBrentOnLine(dArray, dArray3, realFunctionOfSeveralVariablesWithGradient) : new BrentOnLine(dArray, dArray3, realFunctionOfSeveralVariablesWithGradient);
        if (info != null) {
            info.setMaxIter(n);
        }
        double d2 = -1.0;
        for (int i = 0; i < n; ++i) {
            double d3;
            iter = i;
            d2 = d3 = realFunctionOfSeveralVariablesWithGradient.eval(dArray, dArray2);
            double d4 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d4 += dArray2[j] * dArray2[j];
            }
            if (d4 == 0.0) {
                if (info != null) {
                    info.setCurrentIter(iter);
                }
                return d2;
            }
            double d5 = Math.sqrt(d4);
            for (int j = 0; j < n2; ++j) {
                dArray3[j] = -dArray2[j] / d5;
            }
            d2 = minimizingOnLine.search(2.0E-8);
            if (!(2.0 * Math.abs(d2 - d3) <= d * (Math.abs(d2) + Math.abs(d3) + 1.0E-10))) continue;
            if (info != null) {
                String string = new String("iter = " + iter + ", fret = " + d2 + ", fp = " + d3 + ", p = ");
                for (int j = 0; j < n2; ++j) {
                    string = string + dArray[j] + " ";
                }
                info.addMessage(string);
                info.setCurrentIter(iter);
                info.printDebug();
            }
            return d2;
        }
        if (info != null) {
            info.setMessage("Too many iterations in FRPRMN\n");
            info.setCurrentIter(n);
            info.printDebug();
        }
        return d2;
    }

    static {
        useDBrent = false;
    }
}

