/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.phylip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.FlexibleAlignment;
import org.biojava.bio.alignment.SimpleAlignmentElement;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojavax.bio.phylo.io.phylip.PHYLIPFileListener;

public class PHYLIPFileBuilder
implements PHYLIPFileListener {
    private LinkedHashMap sequences;
    private int sequenceCount;
    private int sitesCount;
    private String currentSequenceName;
    private Alignment alignment;

    public void startFile() {
        this.sequences = new LinkedHashMap();
    }

    public void endFile() throws ParseException {
        this.verifySequenceAndSitesCount();
        this.buildAlignment();
    }

    public void setSequenceCount(int count) {
        this.sequenceCount = count;
    }

    public void setSitesCount(int count) {
        this.sitesCount = count;
    }

    public void setCurrentSequenceName(String name) {
        if (!this.sequences.containsKey(name)) {
            this.sequences.put(name, new StringBuffer());
        }
        this.currentSequenceName = name;
    }

    public void receiveSequence(String sequence) {
        StringBuffer buffer = (StringBuffer)this.sequences.get(this.currentSequenceName);
        buffer.append(sequence);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    private void buildAlignment() throws ParseException {
        FlexibleAlignment newAlignment;
        List importedSequences = null;
        try {
            importedSequences = this.createSequences();
        }
        catch (IllegalSymbolException e) {
            throw new ParseException("Illegal symbol in sequence: " + e);
        }
        catch (BioException e) {
            throw new ParseException("Could not create sequences: " + e);
        }
        try {
            newAlignment = new FlexibleAlignment(importedSequences);
        }
        catch (BioException e) {
            throw new ParseException("Could not construct alignment object: " + e);
        }
        this.alignment = newAlignment;
    }

    private List createSequences() throws IllegalSymbolException, BioException {
        ArrayList<SimpleAlignmentElement> importedSequences = new ArrayList<SimpleAlignmentElement>();
        boolean checkedType = false;
        boolean isDNA = true;
        Location loc = LocationTools.makeLocation(0, this.sitesCount - 1);
        for (Map.Entry sequenceEntry : this.sequences.entrySet()) {
            String name = (String)sequenceEntry.getKey();
            String sequence = ((StringBuffer)sequenceEntry.getValue()).toString();
            GappedSequence symbolList = null;
            if (!checkedType) {
                try {
                    DNATools.createGappedDNASequence(sequence, name);
                }
                catch (IllegalSymbolException e) {
                    isDNA = false;
                }
                checkedType = true;
            }
            symbolList = isDNA ? DNATools.createGappedDNASequence(sequence, name) : ProteinTools.createGappedProteinSequence(sequence, name);
            importedSequences.add(new SimpleAlignmentElement(name, symbolList, loc));
        }
        return importedSequences;
    }

    private void verifySequenceAndSitesCount() throws ParseException {
        if (this.sequences.size() != this.sequenceCount) {
            throw new ParseException("Number of sequences does not match header.");
        }
        Iterator i = this.sequences.values().iterator();
        while (i.hasNext()) {
            String currentSequence = ((StringBuffer)i.next()).toString();
            if (currentSequence.length() == this.sitesCount) continue;
            throw new ParseException("Number of sites does not match header.");
        }
    }
}

