/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;

public class REXPList
extends REXPVector {
    private RList payload;

    public REXPList(RList list) {
        this.payload = list == null ? new RList() : list;
    }

    public REXPList(RList list, REXPList attr) {
        super(attr);
        this.payload = list == null ? new RList() : list;
    }

    public REXPList(REXP value, String name) {
        this.payload = new RList(new REXP[]{value}, new String[]{name});
    }

    @Override
    public int length() {
        return this.payload.size();
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isPairList() {
        return true;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public RList asList() {
        return this.payload;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + (this.asList().isNamed() ? "named" : "");
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer(String.valueOf(super.toDebugString()) + "{");
        int i = 0;
        while (i < this.payload.size() && i < maxDebugItems) {
            String name;
            if (i > 0) {
                sb.append(",\n");
            }
            if ((name = this.payload.keyAt(i)) != null) {
                sb.append(String.valueOf(name) + "=");
            }
            sb.append(this.payload.at(i).toDebugString());
            ++i;
        }
        if (i < this.payload.size()) {
            sb.append(",..");
        }
        return String.valueOf(sb.toString()) + "}";
    }
}

