/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.KorobovLattice;

public class KorobovLatticeSequence
extends KorobovLattice {
    int base;
    int inverse;
    int n;

    public KorobovLatticeSequence(int b, int a) {
        super(2, 3, 1);
        if (a <= 1) {
            throw new IllegalArgumentException("KorobovLatticeSequence:   Multiplier a must be > 1");
        }
        this.a = a;
        this.base = b;
    }

    public double getCoordinate(int i, int j) {
        if (i == 0) {
            return 0.0;
        }
        if (j == 0) {
            return this.radicalInverse(this.base, i);
        }
        int n = 1;
        int inverse = 0;
        while (i > 0) {
            inverse = inverse * this.base + i % this.base;
            n *= this.base;
            i /= this.base;
        }
        return (double)((long)inverse * this.modPower(this.a, j, n) % (long)n) / (double)n;
    }

    private void integerRadicalInverse(int i) {
        this.n = 1;
        this.inverse = 0;
        while (i > 0) {
            this.inverse = this.inverse * this.base + i % this.base;
            this.n *= this.base;
            i /= this.base;
        }
    }
}

