/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.randvar.BinomialGen;
import umontreal.iro.lecuyer.randvar.ChiSquareGen;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.ExtremeValueGen;
import umontreal.iro.lecuyer.randvar.GeometricGen;
import umontreal.iro.lecuyer.randvar.LogisticGen;
import umontreal.iro.lecuyer.randvar.LognormalGen;
import umontreal.iro.lecuyer.randvar.NegativeBinomialGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.ParetoGen;
import umontreal.iro.lecuyer.randvar.PoissonGen;
import umontreal.iro.lecuyer.randvar.StudentGen;
import umontreal.iro.lecuyer.randvar.UniformGen;
import umontreal.iro.lecuyer.randvar.WeibullGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Rand1 {
    private Rand1() {
    }

    public static double uniform(RandomStream s, double a, double b) {
        return UniformGen.nextDouble(s, a, b);
    }

    public static double expon(RandomStream s, double mean) {
        return ExponentialGen.nextDouble(s, 1.0 / mean);
    }

    public static double erlang(RandomStream s, int k, double mu) {
        return ErlangGen.nextDouble(s, k, 1.0 / mu);
    }

    public static double weibull(RandomStream s, double alpha, double lambda, double delta) {
        return WeibullGen.nextDouble(s, alpha, lambda, delta);
    }

    public static double normal(RandomStream s, double mean, double sigma) {
        return NormalGen.nextDouble(s, mean, sigma);
    }

    public static double Logistic(RandomStream s, double alpha, double lambda) {
        return LogisticGen.nextDouble(s, alpha, lambda);
    }

    public static double student(RandomStream s, int n) {
        return StudentGen.nextDouble(s, n);
    }

    public static double invStudentDist(int n, double u) {
        return StudentDist.inverseF(n, u);
    }

    public static double lognormal(RandomStream s, double mu, double sigma) {
        return LognormalGen.nextDouble(s, mu, sigma);
    }

    public static double chiSquare(RandomStream s, int n) {
        return ChiSquareGen.nextDouble(s, n);
    }

    public static double gumbel(RandomStream s, double alpha, double lambda) {
        return ExtremeValueGen.nextDouble(s, alpha, lambda);
    }

    public static double pareto(RandomStream s, double alpha, double beta) {
        return ParetoGen.nextDouble(s, alpha, beta);
    }

    public static int binomial(RandomStream s, int n, double p) {
        return BinomialGen.nextInt(s, n, p);
    }

    public static int negativeBinomial(RandomStream s, int n, double p) {
        return NegativeBinomialGen.nextInt(s, n, p);
    }

    public static int geometric(RandomStream s, double p) {
        return GeometricGen.nextInt(s, p);
    }

    public static int poisson(RandomStream s, double lambda) {
        return PoissonGen.nextInt(s, lambda);
    }
}

