/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;

public class SimProcess {
    public static final int INITIAL = 0;
    public static final int EXECUTING = 1;
    public static final int DELAYED = 2;
    public static final int SUSPENDED = 3;
    public static final int DEAD = 4;
    public static final double STARTING = -20.0;
    public static final double WAITING = -10.0;
    protected ProcessSimulator sim;
    protected Event scheduledEvent = null;

    public SimProcess() {
        this((ProcessSimulator)Simulator.getDefaultSimulator());
    }

    public SimProcess(ProcessSimulator sim) {
        this.sim = sim;
        this.scheduledEvent = sim.createControlEvent(this);
    }

    public void schedule(double delay) {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Cannot schedule a dead process");
        }
        if (this.scheduledEvent.time() != -20.0) {
            throw new IllegalStateException("Only a process in INITIAL state can call schedule");
        }
        this.scheduledEvent.schedule(delay);
    }

    public void scheduleNext() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Cannot schedule a dead process");
        }
        if (this.scheduledEvent.time() != -20.0) {
            throw new IllegalStateException("Only a process in INITIAL state can call scheduleNext");
        }
        this.scheduledEvent.scheduleNext();
    }

    public Event scheduledEvent() {
        return this.scheduledEvent;
    }

    public void setScheduledEvent(Event scheduledEvent) {
        this.scheduledEvent = scheduledEvent;
    }

    public double priority() {
        return this.scheduledEvent.priority();
    }

    public void setPriority(double priority) {
        this.scheduledEvent.setPriority(priority);
    }

    public final boolean isAlive() {
        return this.scheduledEvent != null;
    }

    public int getState() {
        if (this.scheduledEvent == null) {
            return 4;
        }
        if (this.sim.currentProcess() == this) {
            return 1;
        }
        if (this.scheduledEvent.time() >= 0.0) {
            return 2;
        }
        if (this.scheduledEvent.time() == -20.0) {
            return 0;
        }
        return 3;
    }

    public double getDelay() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Trying to getDelay() on a dead process");
        }
        if (this.scheduledEvent.time() < 0.0) {
            throw new IllegalStateException("Calling getDelay for a process not in DELAYED state");
        }
        return this.scheduledEvent.time() - this.sim.time();
    }

    public void reschedule(double delay) {
        if (this.sim.currentProcess() == this) {
            throw new IllegalStateException("reschedule() for a process in EXECUTING state");
        }
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("reschedule() for a dead process ");
        }
        if (delay < 0.0) {
            throw new IllegalArgumentException("Calling reschedule() with negative delay");
        }
        this.scheduledEvent.reschedule(delay);
    }

    public void resume() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("calling resume() for a dead process");
        }
        if (this.scheduledEvent.time() >= 0.0) {
            this.scheduledEvent.cancel();
        }
        this.scheduledEvent.scheduleNext();
    }

    public boolean cancel() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("calling cancel() for a dead process");
        }
        if (this.scheduledEvent.time() < 0.0) {
            throw new IllegalStateException("cancel() for a process not in DELAYED state");
        }
        boolean removed = this.scheduledEvent.cancel();
        this.scheduledEvent.setTime(-10.0);
        return removed;
    }

    public void delay(double delay) {
        this.sim.delay(this, delay);
    }

    public void suspend() {
        this.sim.suspend(this);
    }

    public void kill() {
        this.sim.kill(this);
    }

    public void actions() {
    }

    @Deprecated
    public static void init() {
        ProcessSimulator.initDefault();
    }
}

