/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public final class MixtureEmission
implements Emission {
    private Emission[] emission;
    private double[] hyper;
    private double[] logProb;
    private double[] help;
    private double[] statistic;
    private static final String XML_TAG = "MixtureEmission";

    public MixtureEmission(Emission[] emission, double[] hyperParameters) throws CloneNotSupportedException {
        if (hyperParameters != null && emission.length != hyperParameters.length) {
            throw new IllegalArgumentException("The number of emissions and the number of hyper-parameters has to be equal.");
        }
        AlphabetContainer con = emission[0].getAlphabetContainer();
        int e = 1;
        while (e < emission.length) {
            if (!con.checkConsistency(emission[e].getAlphabetContainer())) {
                throw new IllegalArgumentException("The emissions must work on the same AlphabetContainer.");
            }
            if (hyperParameters != null && hyperParameters[e] < 0.0) {
                throw new IllegalArgumentException("The hyper-parameters have to be non-negative.");
            }
            ++e;
        }
        this.emission = (Emission[])ArrayHandler.clone((Cloneable[])emission);
        this.hyper = hyperParameters == null ? new double[emission.length] : (double[])hyperParameters.clone();
        this.logProb = new double[emission.length];
        Arrays.fill(this.logProb, -Math.log(emission.length));
        this.init();
    }

    public MixtureEmission(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.emission = (Emission[])XMLParser.extractObjectForTags(xml, "emissions");
        this.hyper = (double[])XMLParser.extractObjectForTags(xml, "hyper");
        this.logProb = (double[])XMLParser.extractObjectForTags(xml, "logProb");
        this.init();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.emission, "emissions");
        XMLParser.appendObjectWithTags(xml, this.hyper, "hyper");
        XMLParser.appendObjectWithTags(xml, this.logProb, "logProb");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    private void init() {
        this.help = new double[this.emission.length];
        this.statistic = new double[this.emission.length];
    }

    public MixtureEmission clone() throws CloneNotSupportedException {
        MixtureEmission clone = (MixtureEmission)super.clone();
        clone.emission = (Emission[])ArrayHandler.clone((Cloneable[])this.emission);
        clone.help = (double[])this.help.clone();
        clone.hyper = (double[])this.hyper.clone();
        clone.logProb = (double[])this.logProb.clone();
        clone.statistic = (double[])this.statistic.clone();
        return clone;
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        int j;
        Emission[] temp = new Emission[emissions.length];
        int i = 0;
        while (i < this.emission.length) {
            j = 0;
            while (j < emissions.length) {
                temp[j] = ((MixtureEmission)emissions[j]).emission[j];
                ++j;
            }
            this.emission[i].joinStatistics(temp);
            ++i;
        }
        i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                j = 0;
                while (j < this.statistic.length) {
                    int n = j;
                    this.statistic[n] = this.statistic[n] + ((MixtureEmission)emissions[i]).statistic[j];
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                System.arraycopy(this.statistic, 0, ((MixtureEmission)emissions[i]).statistic, 0, this.statistic.length);
            }
            ++i;
        }
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e = 0;
        while (e < this.emission.length) {
            this.help[e] = this.logProb[e] - this.emission[e].getLogProbFor(forward, startPos, endPos, seq);
            ++e;
        }
        Normalisation.logSumNormalisation(this.help);
        e = 0;
        while (e < this.emission.length) {
            this.emission[e].addToStatistic(forward, startPos, endPos, weight * this.help[e], seq);
            int n = e;
            this.statistic[n] = this.statistic[n] + this.help[e];
            ++e;
        }
    }

    @Override
    public void estimateFromStatistic() {
        double sum = 0.0;
        int e = 0;
        while (e < this.emission.length) {
            this.emission[e].estimateFromStatistic();
            int n = e;
            this.statistic[n] = this.statistic[n] + this.hyper[e];
            sum += this.statistic[e];
            ++e;
        }
        sum = Math.log(sum);
        e = 0;
        while (e < this.emission.length) {
            this.logProb[e] = Math.log(this.statistic[e]) - sum;
            ++e;
        }
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.emission[0].getAlphabetContainer();
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        int e = 0;
        while (e < this.emission.length) {
            lp += this.emission[e].getLogPriorTerm();
            lp += this.logProb[e] * this.hyper[e];
            ++e;
        }
        return lp;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        int e = 0;
        while (e < this.emission.length) {
            this.help[e] = this.logProb[e] - this.emission[e].getLogProbFor(forward, startPos, endPos, seq);
            ++e;
        }
        return Normalisation.getLogSum(0, this.emission.length, this.help);
    }

    @Override
    public void initializeFunctionRandomly() {
        DiMRGParams p;
        int zero = 0;
        int e = 0;
        while (e < this.emission.length) {
            if (this.hyper[e] == 0.0) {
                ++zero;
            }
            ++e;
        }
        if (zero == this.emission.length) {
            p = new FastDirichletMRGParams(1.0);
        } else if (zero == 0) {
            p = new DirichletMRGParams(this.hyper);
        } else {
            throw new IllegalArgumentException();
        }
        DirichletMRG.DEFAULT_INSTANCE.generateLog(this.logProb, 0, this.emission.length, p);
        int e2 = 0;
        while (e2 < this.emission.length) {
            this.emission[e2].initializeFunctionRandomly();
            ++e2;
        }
    }

    @Override
    public void resetStatistic() {
        int e = 0;
        while (e < this.emission.length) {
            this.emission[e].resetStatistic();
            ++e;
        }
    }

    @Override
    public String getNodeShape(boolean forward) {
        String res = "";
        if (this.getAlphabetContainer().isReverseComplementable()) {
            res = String.valueOf(res) + "\"house\", orientation=";
            if (forward) {
                res = String.valueOf(res) + "-";
            }
            res = String.valueOf(res) + "90";
        } else {
            res = String.valueOf(res) + "\"box\"";
        }
        return res;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        return "\"" + name + "\"";
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("The emissions are not comparable.");
        }
        MixtureEmission tt = (MixtureEmission)t;
        int i = 0;
        while (i < this.emission.length) {
            this.emission[i].setParameters(tt.emission[i]);
            ++i;
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer(this.emission.length * 100000);
        int i = 0;
        while (i < this.emission.length) {
            sb.append(String.valueOf(nf.format(Math.exp(this.logProb[i]))) + "\n" + this.emission[i].toString(nf));
            ++i;
        }
        return null;
    }
}

