/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.DiMRGParams;
import java.util.Arrays;

public class DirichletMRGParams
extends DiMRGParams {
    private double[] alpha;
    private double sum;

    public DirichletMRGParams(double alpha, int n) throws IllegalArgumentException {
        if (n < 2) {
            throw new IllegalArgumentException("The parameter n has to be at least 2.");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The parameter alpha has to be positive.");
        }
        this.alpha = new double[n];
        Arrays.fill(this.alpha, alpha);
        this.sum = (double)n * alpha;
    }

    public DirichletMRGParams(double ... alpha) throws IllegalArgumentException {
        this(0, alpha.length, alpha);
    }

    public DirichletMRGParams(int start, int end, double ... alpha) throws IllegalArgumentException {
        this.alpha = new double[end - start];
        this.sum = 0.0;
        int i = 0;
        while (start < end) {
            if (alpha[start] <= 0.0) {
                throw new IllegalArgumentException("Each parameter alpha[" + start + "] has to be positive.");
            }
            this.alpha[i] = alpha[start];
            this.sum += this.alpha[i];
            ++start;
            ++i;
        }
    }

    @Override
    public int getDimension() {
        return this.alpha.length;
    }

    @Override
    public double getHyperparameter(int i) {
        return this.alpha[i];
    }

    public double getSumOfHyperparameter() {
        return this.sum;
    }
}

