/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;
import de.jtem.numericalMethods.calculus.rootFinding.Newton;

public class Broyden {
    static final double DEFAULT_MAX_STEPSIZE = 1.0;
    static final double EPS = 1.0E-15;

    Broyden() {
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray) {
        Broyden.search(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray, 200, 1.0E-8, 1.0E-10, 1.0E-15, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray, int n, double d, double d2) {
        Broyden.search(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray, n, d, d / 100.0, d2, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray, int n, double d, double d2, double d3, double d4) {
        int n2 = realVectorValuedFunctionOfSeveralVariablesWithJacobien.getDimensionOfTargetSpace();
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[][] dArray6 = new double[n2][n2];
        double[][] dArray7 = new double[n2][n2];
        double[][] dArray8 = new double[n2][n2];
        double[][] dArray9 = new double[n2][n2];
        double[] dArray10 = new double[n2];
        double[] dArray11 = new double[n2];
        double[] dArray12 = new double[n2];
        double[] dArray13 = new double[n2];
        double[] dArray14 = new double[n2];
        double[] dArray15 = new double[n2];
        double[] dArray16 = new double[n2];
        boolean[] blArray = new boolean[1];
        RealFunctionOfSeveralVariables realFunctionOfSeveralVariables = Newton.normSqr(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray14);
        double d5 = realFunctionOfSeveralVariables.eval(dArray);
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!(Math.abs(dArray14[i]) > d6)) continue;
            d6 = Math.abs(dArray14[i]);
        }
        if (d6 < 0.01 * d) {
            return;
        }
        double d7 = d4 * Math.max(Math.sqrt(VectorOperations.normSqr(dArray)), (double)n2);
        boolean bl = true;
        for (int i = 1; i <= n; ++i) {
            int n3;
            if (bl) {
                realVectorValuedFunctionOfSeveralVariablesWithJacobien.eval(dArray, dArray14, 0, dArray7);
                double d8 = Householder.decompose(dArray7, dArray9, dArray15, dArray16);
                if (d8 == 0.0) {
                    new RuntimeException("singular Jacobian in broydn");
                }
            } else {
                VectorOperations.minus(dArray, dArray13, dArray10);
                MatrixOperations.times(dArray7, dArray10, dArray11);
                boolean bl2 = true;
                for (int j = 0; j < n2; ++j) {
                    double d9 = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        d9 += dArray9[j][k] * dArray11[k];
                    }
                    dArray12[j] = dArray14[j] - dArray3[j] - d9;
                    if (Math.abs(dArray12[j]) >= 1.0E-15 * (Math.abs(dArray14[j]) + Math.abs(dArray3[j]))) {
                        bl2 = false;
                        continue;
                    }
                    dArray12[j] = 0.0;
                }
                if (!bl2) {
                    MatrixOperations.times(dArray12, dArray9, dArray11);
                    VectorOperations.divide(dArray10, VectorOperations.normSqr(dArray10), dArray10);
                    MatrixOperations.times(dArray11, dArray10, dArray6);
                    MatrixOperations.plus(dArray7, dArray6, dArray8);
                    MatrixOperations.times(dArray9, dArray8, dArray7);
                    double d10 = Householder.decompose(dArray7, dArray9, dArray15, dArray16);
                    if (d10 == 0.0) {
                        throw new RuntimeException("r singular");
                    }
                }
            }
            MatrixOperations.times(dArray14, dArray9, dArray15);
            MatrixOperations.times(dArray15, dArray7, dArray4);
            VectorOperations.assign(dArray, dArray13);
            VectorOperations.assign(dArray14, dArray3);
            MatrixOperations.times(dArray14, dArray9, dArray5);
            VectorOperations.neg(dArray5, dArray5);
            RXB.solve(dArray7, dArray5);
            d5 = Newton.lnsrch(dArray13, d5, dArray4, dArray5, dArray, d3, d7, blArray, realFunctionOfSeveralVariables);
            d6 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(Math.abs(dArray14[n3]) > d6)) continue;
                d6 = Math.abs(dArray14[n3]);
            }
            if (d6 < d) {
                return;
            }
            if (blArray[0]) {
                if (bl) {
                    throw new HitLocalMinimumException();
                }
                d6 = 0.0;
                double d11 = Math.max(d5, 0.5 * (double)n2);
                for (int j = 0; j < n2; ++j) {
                    double d12 = Math.abs(dArray4[j]) * Math.max(Math.abs(dArray[j]), 1.0) / d11;
                    if (!(d12 > d6)) continue;
                    d6 = d12;
                }
                if (d6 < d2) {
                    return;
                }
                bl = true;
                continue;
            }
            bl = false;
            d6 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                double d13 = Math.abs(dArray[n3] - dArray13[n3]) / Math.max(Math.abs(dArray[n3]), 1.0);
                if (!(d13 > d6)) continue;
                d6 = d13;
            }
            if (!(d6 < d3)) continue;
            return;
        }
        throw new RuntimeException("exeeded maximal number of iterations");
    }

    public static class HitLocalMinimumException
    extends RuntimeException {
        public HitLocalMinimumException() {
        }

        public HitLocalMinimumException(String string) {
        }
    }
}

