/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

public class MarchingTriangles {
    final int START_CAPACITY = 100;
    double[] point;
    int[] index = new int[200];
    int dimension;
    int numOfPoints = 0;
    int numOfEdges = 0;
    int maxNumOfPoints = 100;
    int maxNumOfEdges = 100;

    MarchingTriangles(int n) {
        this.dimension = n;
        this.point = new double[n * 100];
    }

    public double[] getPoints() {
        return this.point;
    }

    public int[] getIndices() {
        return this.index;
    }

    public int getNumOfPonits() {
        return this.numOfPoints;
    }

    public int getNumOfPoints() {
        return this.numOfPoints;
    }

    public int getNumOfEdges() {
        return this.numOfEdges;
    }

    void setMaxNumOfPoints(int n) {
        if (n == this.maxNumOfPoints) {
            return;
        }
        this.maxNumOfPoints = n;
        this.numOfPoints = Math.min(this.numOfPoints, n);
        double[] dArray = new double[n * this.dimension];
        System.arraycopy(this.point, 0, dArray, 0, this.numOfPoints * this.dimension);
        this.point = dArray;
    }

    void setMaxNumOfEdges(int n) {
        if (n == this.maxNumOfEdges) {
            return;
        }
        this.maxNumOfEdges = n;
        this.numOfEdges = Math.min(this.numOfEdges, n);
        int[] nArray = new int[n * 2];
        System.arraycopy(this.index, 0, nArray, 0, this.numOfEdges * 2);
        this.index = nArray;
    }

    void addPointOnEdge(double[] dArray, int n, int n2, double d) {
        if (this.numOfPoints >= this.maxNumOfPoints) {
            this.setMaxNumOfPoints(3 * this.maxNumOfPoints / 2 + 1);
        }
        int n3 = this.dimension * n;
        int n4 = this.dimension * n2;
        int n5 = 0;
        int n6 = this.numOfPoints * this.dimension;
        while (n5 < this.dimension) {
            this.point[n6] = (1.0 - d) * dArray[n3] + d * dArray[n4];
            ++n5;
            ++n6;
            ++n3;
            ++n4;
        }
        ++this.numOfPoints;
    }

    void addEdge(int n, int n2) {
        if (this.numOfEdges >= this.maxNumOfEdges) {
            this.setMaxNumOfEdges(3 * this.maxNumOfEdges / 2 + 1);
        }
        this.index[2 * this.numOfEdges] = n;
        this.index[2 * this.numOfEdges + 1] = n2;
        ++this.numOfEdges;
    }

    public static MarchingTriangles compute(double[] dArray, int n, int[] nArray, int[] nArray2, double[] dArray2, double d) {
        int n2;
        int n3;
        MarchingTriangles marchingTriangles = new MarchingTriangles(n);
        int n4 = nArray.length / 3;
        int[] nArray3 = new int[nArray.length];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n4) {
            n3 = 0;
            while (n3 < 3) {
                int n8;
                if (nArray2 != null && nArray2[n7] != -1 && nArray2[n7] < n5) {
                    n2 = 3 * nArray2[n7];
                    for (n8 = 0; n8 < 3; ++n8) {
                        if (nArray2[n2 + n8] == n5) {
                            nArray3[n7] = nArray3[n2 + n8];
                            break;
                        }
                        if (n8 != 2) continue;
                        throw new RuntimeException("wrong connectivity");
                    }
                } else {
                    n2 = nArray[n6 + (n3 + 1) % 3];
                    double d2 = dArray2[n2] - d;
                    n8 = nArray[n6 + (n3 + 2) % 3];
                    double d3 = dArray2[n8] - d;
                    if (d2 * d3 < 0.0 && d2 != d3) {
                        double d4 = d2 / (d2 - d3);
                        nArray3[n7] = marchingTriangles.numOfPoints;
                        marchingTriangles.addPointOnEdge(dArray, n2, n8, d4);
                    } else {
                        nArray3[n7] = -1;
                    }
                }
                ++n3;
                ++n7;
            }
            ++n5;
            n6 += 3;
        }
        marchingTriangles.setMaxNumOfPoints(marchingTriangles.numOfPoints);
        n5 = 0;
        n6 = 0;
        while (n5 < n4) {
            for (n7 = 0; n7 < 3; ++n7) {
                n3 = nArray3[n6 + (n7 + 1) % 3];
                n2 = nArray3[n6 + (n7 + 2) % 3];
                if (n3 == -1 || n2 == -1) continue;
                marchingTriangles.addEdge(n3, n2);
            }
            ++n5;
            n6 += 3;
        }
        marchingTriangles.setMaxNumOfEdges(marchingTriangles.numOfEdges);
        return marchingTriangles;
    }
}

