/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.util;

public class WeightFactory {
    WeightFactory() {
    }

    final double areaOfTriangle2D(double[] dArray, int[] nArray, int n) {
        int n2 = 2 * nArray[3 * n];
        int n3 = 2 * nArray[3 * n + 1];
        int n4 = 2 * nArray[3 * n + 2];
        double d = dArray[n2];
        double d2 = dArray[n2 + 1];
        double d3 = dArray[n3] - d;
        double d4 = dArray[n3 + 1] - d2;
        double d5 = dArray[n4] - d;
        double d6 = dArray[n4 + 1] - d2;
        double d7 = d3 * d3 + d4 * d4;
        double d8 = d3 * d5 + d4 * d6;
        double d9 = d5 * d5 + d6 * d6;
        return 0.5 * Math.sqrt(d7 * d9 - d8 * d8);
    }

    final double areaOfTriangle3D(double[] dArray, int[] nArray, int n) {
        int n2 = 3 * nArray[3 * n];
        int n3 = 3 * nArray[3 * n + 1];
        int n4 = 3 * nArray[3 * n + 2];
        double d = dArray[n2];
        double d2 = dArray[n2 + 1];
        double d3 = dArray[n2 + 2];
        double d4 = dArray[n3] - d;
        double d5 = dArray[n3 + 1] - d2;
        double d6 = dArray[n3 + 2] - d3;
        double d7 = dArray[n4] - d;
        double d8 = dArray[n4 + 1] - d2;
        double d9 = dArray[n4 + 2] - d3;
        double d10 = d4 * d4 + d5 * d5 + d6 * d6;
        double d11 = d4 * d7 + d5 * d8 + d6 * d9;
        double d12 = d7 * d7 + d8 * d8 + d9 * d9;
        return 0.5 * Math.sqrt(d10 * d12 - d11 * d11);
    }

    public double[] createByAreaRatio(double[] dArray, double[] dArray2, int[] nArray) {
        double[] dArray3 = new double[dArray.length / 3];
        this.computeByAreaRatio(dArray, dArray2, nArray, dArray3, new double[dArray.length / 3]);
        return dArray3;
    }

    public void computeByAreaRatio(double[] dArray, double[] dArray2, int[] nArray, double[] dArray3, double[] dArray4) {
        int n;
        int n2 = dArray2.length / 3;
        int n3 = nArray.length / 3;
        for (n = 0; n < dArray3.length; ++n) {
            dArray4[n] = 0.0;
            dArray3[n] = 0.0;
        }
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            double d = this.areaOfTriangle2D(dArray2, nArray, n);
            double d2 = this.areaOfTriangle3D(dArray, nArray, n);
            for (int i = 0; i < 3; ++i) {
                int n5 = nArray[n4];
                dArray3[n5] = dArray3[n5] + d2;
                int n6 = nArray[n4];
                dArray4[n6] = dArray4[n6] + d;
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            int n7 = n;
            dArray3[n7] = dArray3[n7] / dArray4[n];
        }
    }
}

