/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.agave.AGAVEAssemblyHandler;
import org.biojava.bio.seq.io.agave.AGAVECallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEChromosomeCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEContigCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEDbIdPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEFragmentOrderHandler;
import org.biojava.bio.seq.io.agave.AGAVEMapLocationPropHandler;
import org.biojava.bio.seq.io.agave.AGAVENotePropHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqMapHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEUnorderedFragmentsHandler;
import org.biojava.bio.seq.io.agave.AGAVEViewPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.SequenceHandler;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.seq.io.agave.UtilHelper;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEContigHandler
extends StAXFeatureHandler
implements AGAVEContigCallbackItf,
SequenceHandler {
    public static final StAXHandlerFactory AGAVE_CONTIG_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEContigHandler(staxenv);
        }
    };
    protected Sequence sequence;
    private List sequenceSet;
    private SymbolList dna;

    AGAVEContigHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("contig", true);
        this.sequenceSet = new ArrayList(1);
        super.addHandler(new ElementRecognizer.ByLocalName("db_id"), AGAVEDbIdPropHandler.AGAVE_DBID_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("view"), AGAVEViewPropHandler.AGAVE_VIEW_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("note"), AGAVENotePropHandler.AGAVE_NOTE_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("fragment_order"), AGAVEFragmentOrderHandler.AGAVE_FRAGMENT_ORDER_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("unordered_fragments"), AGAVEUnorderedFragmentsHandler.AGAVE_UNORDERED_FRAGMENTS_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("assembly"), AGAVEAssemblyHandler.AGAVE_ASSEMBLY_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("sequence"), AGAVESeqPropHandler.AGAVE_SEQ_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("sequence_map"), AGAVESeqMapHandler.AGAVE_SEQ_MAP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("map_location"), AGAVEMapLocationPropHandler.AGAVE_MAP_LOCATION_PROP_HANDLER_FACTORY);
    }

    public void reportSequence(Sequence sequence) {
        this.sequenceSet.add(sequence);
    }

    public void reportDna(String dna) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dna.length(); ++i) {
                char c = dna.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t') continue;
                sb.append(c);
            }
            this.dna = DNATools.createDNA(sb.substring(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.featureListener.startSequence();
            boolean forFeature = true;
            this.setProperty("length", attrs.getValue("length"), forFeature);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        try {
            if (this.sequenceSet.size() == 0) {
                if (this.dna == null) {
                    throw new SAXException("dna sequence must offered ");
                }
                this.sequence = new SimpleSequence(this.dna, " ", "simple_sequence ", this.annot);
                this.addFeatureToSequence(this.sequence);
            } else {
                int contig_len = new Integer((String)UtilHelper.getProperty(this.featureTemplate.annotation, "length"));
                this.sequence = new SimpleAssembly(contig_len, "contig", "contig");
                ComponentFeature.Template cft = new ComponentFeature.Template();
                int global_start = 1;
                ListIterator i = this.sequenceSet.listIterator();
                while (i.hasNext()) {
                    Sequence seq = (Sequence)i.next();
                    cft.type = "fragment";
                    cft.source = "contig";
                    cft.annotation = Annotation.EMPTY_ANNOTATION;
                    cft.strand = StrandedFeature.POSITIVE;
                    cft.location = new RangeLocation(global_start, global_start + seq.length() - 1);
                    cft.componentSequence = seq;
                    cft.componentLocation = new RangeLocation(1, seq.length());
                    this.sequence.createFeature(cft);
                    global_start += seq.length();
                }
            }
            this.appendToTop(this.sequence, this.staxenv);
            this.featureListener.endSequence();
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void appendToTop(Sequence sequence, StAXFeatureHandler staxenv) {
        if (staxenv instanceof AGAVEChromosomeCallbackItf) {
            ((AGAVEChromosomeCallbackItf)((Object)staxenv)).reportSequence(sequence);
            return;
        }
        if (staxenv instanceof AGAVECallbackItf) {
            ((AGAVECallbackItf)((Object)staxenv)).reportSequence(sequence);
            return;
        }
        this.appendToTop(sequence, staxenv.staxenv);
    }
}

